/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class CompositePsiElement
extends CompositeElement
implements PsiElement,
NavigationItem {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.CompositePsiElement");
    protected static int ourHC = 0;

    protected CompositePsiElement(IElementType type2) {
        super(type2);
        this.setPsi(this);
    }

    @Override
    @NotNull
    public CompositePsiElement clone() {
        CompositePsiElement clone = (CompositePsiElement)super.clone();
        clone.setPsi(clone);
        CompositePsiElement compositePsiElement = clone;
        if (compositePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "clone"));
        }
        return compositePsiElement;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        TreeElement node = this.getFirstChildNode();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement getLastChild() {
        TreeElement node = this.getLastChildNode();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/CompositePsiElement", "acceptChildren"));
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor);
        }
    }

    @Override
    public PsiElement getParent() {
        CompositeElement parentNode = this.getTreeParent();
        return parentNode != null ? parentNode.getPsi() : null;
    }

    @Override
    public PsiElement getNextSibling() {
        TreeElement node = this.getTreeNext();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement getPrevSibling() {
        TreeElement node = this.getTreePrev();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file = SharedImplUtil.getContainingFile(this);
        if (file == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        LeafElement leaf = this.findLeafElementAt(offset);
        return SourceTreeToPsiMap.treeElementToPsi(leaf);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset);
    }

    @Override
    public PsiElement copy() {
        ASTNode elementCopy = this.copyElement();
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public boolean isValid() {
        return SharedImplUtil.isValid(this);
    }

    @Override
    public boolean isWritable() {
        return SharedImplUtil.isWritable(this);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/CompositePsiElement", "add"));
        }
        return this.addInnerBefore(element, null);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/CompositePsiElement", "addBefore"));
        }
        return this.addInnerBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/CompositePsiElement", "addAfter"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        return ChangeUtil.decodeInformation(treeElement).getPsi();
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/CompositePsiElement", "checkAdd"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public final PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public final PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/CompositePsiElement", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/tree/CompositePsiElement", "addRangeBefore"));
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public final PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        LOG.assertTrue(this.getTreeParent() != null, "Parent not found for " + this);
        CheckUtil.checkWritable(this);
        this.getTreeParent().deleteChildInternal(this);
        this.invalidate();
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        ASTNode firstElement = first.getNode();
        ASTNode lastElement = last.getNode();
        LOG.assertTrue(firstElement.getTreeParent() == this);
        LOG.assertTrue(lastElement.getTreeParent() == this);
        CodeEditUtil.removeChildren(this, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/tree/CompositePsiElement", "replace"));
        }
        return SharedImplUtil.doReplace(this, this, newElement);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/CompositePsiElement", "accept"));
        }
        visitor.visitElement(this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/CompositePsiElement", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/CompositePsiElement", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/CompositePsiElement", "processDeclarations"));
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiElement(" + this.getElementType().toString() + ")";
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        CompositePsiElement compositePsiElement = this;
        if (compositePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getNavigationElement"));
        }
        return compositePsiElement;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor = PsiNavigationSupport.getInstance().getDescriptor(this);
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getProject"));
            }
            return project2;
        }
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project3 = manager.getProject();
        if (project3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getProject"));
        }
        return project3;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        CompositePsiElement compositePsiElement = this;
        if (compositePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/CompositePsiElement", "getNode"));
        }
        return compositePsiElement;
    }

    private PsiElement addInnerBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        TreeElement treeElement = this.addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        if (treeElement != null) {
            return ChangeUtil.decodeInformation(treeElement).getPsi();
        }
        throw new IncorrectOperationException("Element cannot be added");
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

