/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLambdaExpressionImpl
extends JavaStubPsiElement<FunctionalExpressionStub<PsiLambdaExpression>>
implements PsiLambdaExpression {
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        @Nullable
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl$1", "getUsedVariable"));
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            if (psiParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl$1", "isParameterAccepted"));
            }
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            if (psiVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl$1", "isLocalVariableAccepted"));
            }
            return true;
        }
    };

    public PsiLambdaExpressionImpl(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.LAMBDA_EXPRESSION);
    }

    public PsiLambdaExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = PsiTreeUtil.getRequiredChildOfType(this, PsiParameterList.class);
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "getParameterList"));
        }
        return psiParameterList;
    }

    @Override
    public PsiElement getBody() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiExpression || element instanceof PsiCodeBlock ? element : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true), this);
    }

    @Override
    public boolean isVoidCompatible() {
        PsiElement body2 = this.getBody();
        if (body2 instanceof PsiCodeBlock) {
            for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiCodeBlock)body2)) {
                if (statement.getReturnValue() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValueCompatible() {
        Boolean result = MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(this, false, () -> this.isValueCompatibleNoCache());
        return result != null && result != false;
    }

    private boolean isValueCompatibleNoCache() {
        PsiElement body2 = this.getBody();
        if (body2 instanceof PsiCodeBlock) {
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow(body2, ourPolicy, false, false);
                int startOffset = controlFlow.getStartOffset(body2);
                int endOffset = controlFlow.getEndOffset(body2);
                if (startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset)) {
                    return false;
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
            for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiCodeBlock)body2)) {
                if (statement.getReturnValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PsiType getType() {
        return new PsiLambdaExpressionType(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLambdaExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        return PsiImplUtil.processDeclarationsInLambda(this, processor, state, lastParent, place);
    }

    @Override
    public String toString() {
        return "PsiLambdaExpression";
    }

    @Override
    public boolean hasFormalParameterTypes() {
        PsiParameter[] parameters2;
        for (PsiParameter parameter : parameters2 = this.getParameterList().getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcceptable(PsiType leftType) {
        PsiType methodReturnType;
        MethodCandidateInfo.CurrentCandidateProperties candidateProperties;
        if (leftType instanceof PsiIntersectionType) {
            for (PsiType conjunctType : ((PsiIntersectionType)leftType).getConjuncts()) {
                if (!this.isAcceptable(conjunctType)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && (candidateProperties = MethodCandidateInfo.getCurrentMethod(argsList)) != null) {
            PsiMethod method = candidateProperties.getMethod();
            if (this.hasFormalParameterTypes() && !InferenceSession.isPertinentToApplicability(this, method)) {
                return true;
            }
            if (LambdaUtil.isPotentiallyCompatibleWithTypeParameter(this, argsList, method)) {
                return true;
            }
        }
        if (!this.isPotentiallyCompatible(leftType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(leftType, this))) {
            return false;
        }
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && !this.hasFormalParameterTypes()) {
            return true;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(leftType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        if (interfaceMethod.hasTypeParameters()) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        if (this.hasFormalParameterTypes()) {
            PsiParameter[] lambdaParameters = this.getParameterList().getParameters();
            PsiType[] parameterTypes = interfaceMethod.getSignature(substitutor).getParameterTypes();
            int length = lambdaParameters.length;
            for (int lambdaParamIdx = 0; lambdaParamIdx < length; ++lambdaParamIdx) {
                PsiType methodParameterType;
                PsiType lambdaFormalType;
                PsiParameter parameter = lambdaParameters[lambdaParamIdx];
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null || (lambdaFormalType = PsiLambdaExpressionImpl.toArray(parameter.getType())).equals(methodParameterType = PsiLambdaExpressionImpl.toArray(parameterTypes[lambdaParamIdx]))) continue;
                return false;
            }
        }
        if ((methodReturnType = interfaceMethod.getReturnType()) != null && !PsiType.VOID.equals(methodReturnType)) {
            Map<PsiElement, PsiType> map2 = LambdaUtil.getFunctionalTypeMap();
            try {
                boolean bl;
                if (map2.put(this, leftType) != null) {
                    bl = false;
                    return bl;
                }
                bl = LambdaUtil.checkReturnTypeCompatible(this, substitutor.substitute(methodReturnType)) == null;
                return bl;
            }
            finally {
                map2.remove(this);
            }
        }
        return true;
    }

    @Override
    public boolean isPotentiallyCompatible(PsiType left) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(left);
        if (interfaceMethod == null) {
            return false;
        }
        if (this.getParameterList().getParametersCount() != interfaceMethod.getParameterList().getParametersCount()) {
            return false;
        }
        PsiType methodReturnType = interfaceMethod.getReturnType();
        PsiElement body2 = this.getBody();
        if (PsiType.VOID.equals(methodReturnType)) {
            if (body2 instanceof PsiCodeBlock) {
                return this.isVoidCompatible();
            }
            return LambdaUtil.isExpressionStatementExpression(body2);
        }
        return body2 instanceof PsiCodeBlock && this.isValueCompatible() || body2 instanceof PsiExpression;
    }

    private static PsiType toArray(PsiType paramType) {
        if (paramType instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)paramType).toArrayType();
        }
        return paramType;
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Function;
    }
}

