/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.JBComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class JBPanel<T extends JBPanel>
extends JPanel
implements JBComponent<T> {
    private Integer myPreferredWidth;
    private Integer myPreferredHeight;
    private Integer myMaximumWidth;
    private Integer myMaximumHeight;
    private Integer myMinimumWidth;
    private Integer myMinimumHeight;

    public JBPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public JBPanel(LayoutManager layout) {
        super(layout);
    }

    public JBPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JBPanel() {
    }

    @Override
    public T withBorder(Border border) {
        this.setBorder(border);
        return (T)this;
    }

    @Override
    public T withFont(JBFont font) {
        this.setFont(font);
        return (T)this;
    }

    @Override
    public T andTransparent() {
        this.setOpaque(false);
        return (T)this;
    }

    @Override
    public T andOpaque() {
        this.setOpaque(true);
        return (T)this;
    }

    public T withBackground(@Nullable Color background) {
        this.setBackground(background);
        return (T)this;
    }

    public T withPreferredWidth(int width) {
        this.myPreferredWidth = width;
        return (T)this;
    }

    public T withPreferredHeight(int height) {
        this.myPreferredHeight = height;
        return (T)this;
    }

    public T withMaximumWidth(int width) {
        this.myMaximumWidth = width;
        return (T)this;
    }

    public T withMaximumHeight(int height) {
        this.myMaximumHeight = height;
        return (T)this;
    }

    public T withMinimumWidth(int width) {
        this.myMinimumWidth = width;
        return (T)this;
    }

    public T withMinimumHeight(int height) {
        this.myMinimumHeight = height;
        return (T)this;
    }

    @Override
    public Dimension getPreferredSize() {
        return JBPanel.getSize(super.getPreferredSize(), this.myPreferredWidth, this.myPreferredHeight, this.isPreferredSizeSet());
    }

    @Override
    public Dimension getMaximumSize() {
        return JBPanel.getSize(super.getMaximumSize(), this.myMaximumWidth, this.myMaximumHeight, this.isMaximumSizeSet());
    }

    @Override
    public Dimension getMinimumSize() {
        return JBPanel.getSize(super.getMinimumSize(), this.myMinimumWidth, this.myMinimumHeight, this.isMinimumSizeSet());
    }

    private static Dimension getSize(Dimension size, Integer width, Integer height, boolean isSet) {
        if (!isSet && size != null) {
            if (width != null) {
                size.width = JBUI.scale(width);
            }
            if (height != null) {
                size.height = JBUI.scale(height);
            }
        }
        return size;
    }
}

