/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/util/ConcurrencyUtil", "invokeAll"));
        }
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future2 = executorService.submit(callable);
                futures.add(future2);
            }
            for (Future future : futures) {
                ((Runnable)((Object)future)).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException future2) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map2, @NotNull K key, @NotNull V defaultValue) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        Object v = map2.get(key);
        if (v != null) {
            Object v2 = v;
            if (v2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
            }
            return v2;
        }
        V prev = map2.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        return v3;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor(name, 5);
        if (threadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String name, int priority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
        if (threadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleThreadExecutor"));
        }
        return threadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor(name, 5);
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String name, int priority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String name, final boolean isDaemon, final int priority) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/ConcurrencyUtil$1", "newThread"));
                }
                Thread thread = new Thread(r, name);
                thread.setDaemon(isDaemon);
                thread.setPriority(priority);
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil$1", "newThread"));
                }
                return thread2;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        return threadFactory;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/ConcurrencyUtil$2", "newThread"));
                }
                Thread thread = new Thread(r, name);
                if (thread == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil$2", "newThread"));
                }
                return thread;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        return threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void awaitQuiescence(@NotNull ThreadPoolExecutor executor, long timeout, @NotNull TimeUnit timeUnit) {
        HashSet workers;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/util/ConcurrencyUtil", "awaitQuiescence"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/ConcurrencyUtil", "awaitQuiescence"));
        }
        executor.setKeepAliveTime(1L, TimeUnit.NANOSECONDS);
        executor.setCorePoolSize(0);
        ReentrantLock mainLock = ReflectionUtil.getField(executor.getClass(), executor, ReentrantLock.class, "mainLock");
        mainLock.lock();
        try {
            HashSet workersField = ReflectionUtil.getField(executor.getClass(), executor, HashSet.class, "workers");
            workers = new HashSet(workersField);
        }
        finally {
            mainLock.unlock();
        }
        for (Object worker : workers) {
            void unit;
            Thread thread = ReflectionUtil.getField(worker.getClass(), worker, Thread.class, "thread");
            try {
                thread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                System.err.println("Executor " + executor + " is still active after " + unit.toSeconds(timeout) + " seconds://///\nThread " + thread + " dump:\n" + trace + "all thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n/////");
                break;
            }
        }
    }
}

