/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static String rightArrow(@NotNull Font font) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/util/FontUtil", "rightArrow"));
        }
        String string = FontUtil.canDisplay(font, '\u2192', "->");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FontUtil", "rightArrow"));
        }
        return string;
    }

    @NotNull
    public static String upArrow(@NotNull Font font, @NotNull String defaultValue) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/util/FontUtil", "upArrow"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/util/FontUtil", "upArrow"));
        }
        String string = FontUtil.canDisplay(font, '\u2191', defaultValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FontUtil", "upArrow"));
        }
        return string;
    }

    @NotNull
    public static String canDisplay(@NotNull Font font, char value2, @NotNull String defaultValue) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/util/FontUtil", "canDisplay"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/util/FontUtil", "canDisplay"));
        }
        String string = font.canDisplay(value2) ? String.valueOf(value2) : defaultValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FontUtil", "canDisplay"));
        }
        return string;
    }

    @NotNull
    public static String spaceAndThinSpace() {
        String string = " " + FontUtil.canDisplay(UIUtil.getLabelFont(), '\u2009', " ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FontUtil", "spaceAndThinSpace"));
        }
        return string;
    }

    @NotNull
    public static Font minusOne(@NotNull Font font) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/util/FontUtil", "minusOne"));
        }
        Font font2 = font.deriveFont((float)font.getSize() - 1.0f);
        if (font2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FontUtil", "minusOne"));
        }
        return font2;
    }
}

