/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, ValueReference<K, V>> myMap;
    protected final ReferenceQueue<V> myQueue;

    public ConcurrentRefValueHashMap(@NotNull Map<K, V> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ConcurrentRefValueHashMap", "<init>"));
        }
        this();
        this.putAll(map2);
    }

    public ConcurrentRefValueHashMap() {
        this.myQueue = new ReferenceQueue();
        this.myMap = ContainerUtil.newConcurrentMap();
    }

    public ConcurrentRefValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.myQueue = new ReferenceQueue();
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentRefValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ConcurrentRefValueHashMap", "<init>"));
        }
        this.myQueue = new ReferenceQueue();
        this.myMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    boolean processQueue() {
        ValueReference ref;
        boolean processed = false;
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            this.myMap.remove(ref.getKey(), ref);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "get"));
        }
        ValueReference ref = (ValueReference)this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(@NotNull K key, @NotNull V value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "put"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "put"));
        }
        this.processQueue();
        ValueReference<K, V> oldRef = this.myMap.put(key, this.createValueReference(key, value2));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @NotNull
    protected abstract ValueReference<K, V> createValueReference(@NotNull K var1, @NotNull V var2);

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value2) {
        V oldVal;
        block4: {
            ValueReference<K, V> oldRef;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putIfAbsent"));
            }
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putIfAbsent"));
            }
            ValueReference<K, V> newRef = this.createValueReference(key, value2);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block4;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(key, this.createValueReference(key, value2));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(key, this.createValueReference(key, oldValue), this.createValueReference(key, newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.replace(key, this.createValueReference(key, value2));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        this.processQueue();
        ValueReference ref = (ValueReference)this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putAll"));
        }
        this.processQueue();
        for (Map.Entry<K, V> entry : t.entrySet()) {
            V v = entry.getValue();
            if (v == null) continue;
            K key = entry.getKey();
            this.put(key, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "containsKey"));
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull Object value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "containsValue"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value2 = ref.get();
            if (value2 == null) continue;
            result.add(value2);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value2 = this.get(key);
            if (value2 == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value2;
                }

                @Override
                public V setValue(@NotNull V value22) {
                    if (value22 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap$1", "setValue"));
                    }
                    throw new UnsupportedOperationException("setValue is not implemented");
                }

                public String toString() {
                    return "(" + this.getKey() + " : " + this.getValue() + ")";
                }
            });
        }
        HashSet<Map.Entry<K, V>> hashSet = entries;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "entrySet"));
        }
        return hashSet;
    }

    public String toString() {
        return "map size:" + this.size() + " [" + StringUtil.join(this.entrySet(), ",") + "]";
    }

    protected static interface ValueReference<K, V> {
        @NotNull
        public K getKey();

        public V get();
    }
}

