/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;

public class IntToIntSetMap {
    private final TIntIntHashMap mySingle;
    private final TIntObjectHashMap<TIntHashSet> myMulti;

    public IntToIntSetMap(int initialCapacity, float loadfactor) {
        this.mySingle = new TIntIntHashMap(initialCapacity, loadfactor);
        this.myMulti = new TIntObjectHashMap(initialCapacity, loadfactor);
    }

    public void addOccurence(int key, int value2) {
        if (this.mySingle.containsKey(key)) {
            int old = this.mySingle.get(key);
            TIntHashSet items = new TIntHashSet(3);
            items.add(old);
            items.add(value2);
            this.mySingle.remove(key);
            this.myMulti.put(key, (Object)items);
            return;
        }
        TIntHashSet items = (TIntHashSet)this.myMulti.get(key);
        if (items != null) {
            items.add(value2);
            return;
        }
        this.mySingle.put(key, value2);
    }

    public void removeOccurence(int key, int value2) {
        if (this.mySingle.containsKey(key)) {
            this.mySingle.remove(key);
            return;
        }
        TIntHashSet items = (TIntHashSet)this.myMulti.get(key);
        if (items != null) {
            items.remove(value2);
            if (items.size() == 1) {
                this.mySingle.put(key, items.toArray()[0]);
                this.myMulti.remove(key);
            }
        }
    }

    public int[] get(int key) {
        if (this.mySingle.containsKey(key)) {
            return new int[]{this.mySingle.get(key)};
        }
        TIntHashSet items = (TIntHashSet)this.myMulti.get(key);
        if (items == null) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        return items.toArray();
    }
}

