/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = this.createMap();
    }

    public MultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
        if (toCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCopy", "com/intellij/util/containers/MultiMap", "<init>"));
        }
        this();
        this.putAllValues(toCopy);
    }

    @NotNull
    public MultiMap<K, V> copy() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>(this);
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "copy"));
        }
        return multiMap;
    }

    public MultiMap(int initialCapacity, float loadFactor) {
        this.myMap = this.createMap(initialCapacity, loadFactor);
    }

    @NotNull
    protected Map<K, Collection<V>> createMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createMap"));
        }
        return hashMap;
    }

    @NotNull
    protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
        HashMap hashMap = new HashMap(initialCapacity, loadFactor);
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createMap"));
        }
        return hashMap;
    }

    @NotNull
    protected Collection<V> createCollection() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createCollection"));
        }
        return smartList;
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createEmptyCollection"));
        }
        return list;
    }

    public <Kk extends K, Vv extends V> void putAllValues(@NotNull MultiMap<Kk, Vv> from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/containers/MultiMap", "putAllValues"));
        }
        for (Map.Entry<Kk, Collection<Vv>> entry : from.entrySet()) {
            this.putValues(entry.getKey(), entry.getValue());
        }
    }

    public void putValues(K key, @NotNull Collection<? extends V> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/MultiMap", "putValues"));
        }
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.addAll(values);
    }

    public void putValue(@Nullable K key, V value2) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value2);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "entrySet"));
        }
        return set;
    }

    public boolean isEmpty() {
        if (this.myMap.isEmpty()) {
            return true;
        }
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsScalarValue(V value2) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "get"));
        }
        return collection2;
    }

    @NotNull
    public Collection<V> getModifiable(K key) {
        Collection<V> collection = this.myMap.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.myMap.put(key, collection);
        }
        Collection<V> collection2 = collection;
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "getModifiable"));
        }
        return collection2;
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "keySet"));
        }
        return set;
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    public void removeValue(K key, V value2) {
        this.remove(key, value2);
    }

    public boolean remove(K key, V value2) {
        Collection<V> values = this.myMap.get(key);
        if (values != null) {
            boolean removed = values.remove(value2);
            if (values.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }
        return false;
    }

    @NotNull
    public Collection<? extends V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    Iterator iterator = new Iterator<V>(){
                        private final Iterator<Collection<V>> mapIterator;
                        private Iterator<V> itr;
                        {
                            this.mapIterator = MultiMap.this.myMap.values().iterator();
                            this.itr = EmptyIterator.getInstance();
                        }

                        @Override
                        public boolean hasNext() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    return false;
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return true;
                        }

                        @Override
                        public V next() {
                            while (!this.itr.hasNext()) {
                                if (!this.mapIterator.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                this.itr = this.mapIterator.next().iterator();
                            }
                            return this.itr.next();
                        }

                        @Override
                        public void remove() {
                            this.itr.remove();
                        }
                    };
                    if (iterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$1", "iterator"));
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    int res = 0;
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        res += vs.size();
                    }
                    return res;
                }

                @Override
                public boolean contains(Object o) {
                    for (Collection vs : MultiMap.this.myMap.values()) {
                        if (!vs.contains(o)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        Collection<V> collection = this.values;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "values"));
        }
        return collection;
    }

    public void clear() {
        this.myMap.clear();
    }

    @Nullable
    public Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> emptyInstance() {
        MultiMap empty;
        MultiMap multiMap = empty = EMPTY;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "emptyInstance"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "create"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create(final @NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/MultiMap", "create"));
        }
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap(strategy);
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$2", "createMap"));
                }
                return tHashMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "create"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap();
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createLinked"));
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$3", "createCollection"));
                }
                return linkedHashSet;
            }
        };
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createLinkedSet"));
        }
        return linkedMultiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createOrderedSet() {
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                OrderedSet orderedSet = new OrderedSet();
                if (orderedSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$4", "createCollection"));
                }
                return orderedSet;
            }
        };
        if (linkedMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createOrderedSet"));
        }
        return linkedMultiMap;
    }

    @Deprecated
    @NotNull
    public static <K, V> MultiMap<K, V> createSmartList() {
        MultiMap<K, V> multiMap = MultiMap.createSmart();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createSmartList"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSmart() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap();
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$5", "createMap"));
                }
                return tHashMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createSmart"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createConcurrentSet() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                Set set = ContainerUtil.newConcurrentSet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$6", "createCollection"));
                }
                return set;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$6", "createEmptyCollection"));
                }
                return set;
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
                if (concurrentMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$6", "createMap"));
                }
                return concurrentMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createConcurrentSet"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        MultiMap<K, V> multiMap = MultiMap.createSet(TObjectHashingStrategy.CANONICAL);
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createSet"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet(final TObjectHashingStrategy strategy) {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                SmartHashSet smartHashSet = new SmartHashSet();
                if (smartHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$7", "createCollection"));
                }
                return smartHashSet;
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$7", "createEmptyCollection"));
                }
                return set;
            }

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                THashMap tHashMap = new THashMap(strategy);
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$7", "createMap"));
                }
                return tHashMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createSet"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createWeakKey() {
        MultiMap multiMap = new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Map<K, Collection<V>> createMap() {
                WeakHashMap weakHashMap = new WeakHashMap();
                if (weakHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$8", "createMap"));
                }
                return weakHashMap;
            }
        };
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap", "createWeakKey"));
        }
        return multiMap;
    }

    public static <K, V> MultiMap<K, V> create(int initialCapacity, float loadFactor) {
        return new MultiMap<K, V>(initialCapacity, loadFactor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        return this.myMap.equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }

    public static <K, V> MultiMap<K, V> empty() {
        return EMPTY;
    }

    private static class EmptyMap
    extends MultiMap {
        private EmptyMap() {
        }

        @NotNull
        protected Map createMap() {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$EmptyMap", "createMap"));
            }
            return map2;
        }
    }
}

