/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.SLRUCache;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class RecentStringInterner {
    private final int myStripeMask;
    private final SLRUCache<String, String>[] myInterns;
    private final Lock[] myStripeLocks;

    public RecentStringInterner(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/containers/RecentStringInterner", "<init>"));
        }
        int stripes = 16;
        this.myInterns = new SLRUCache[16];
        this.myStripeLocks = new Lock[this.myInterns.length];
        int capacity = 8192;
        for (int i = 0; i < this.myInterns.length; ++i) {
            this.myInterns[i] = new SLRUCache<String, String>(capacity / 16, capacity / 16){

                @Override
                @NotNull
                public String createValue(String key) {
                    String string = key;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RecentStringInterner$1", "createValue"));
                    }
                    return string;
                }

                @Override
                protected void putToProtectedQueue(String key, String value2) {
                    super.putToProtectedQueue(value2, value2);
                }
            };
            this.myStripeLocks[i] = new ReentrantLock();
        }
        assert (Integer.highestOneBit(16) == 16);
        this.myStripeMask = 15;
        LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                RecentStringInterner.this.clear();
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String s) {
        if (s == null) {
            return null;
        }
        int stripe = Math.abs(s.hashCode()) & this.myStripeMask;
        try {
            this.myStripeLocks[stripe].lock();
            String string = this.myInterns[stripe].get(s);
            return string;
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
    }

    public void clear() {
        for (int i = 0; i < this.myInterns.length; ++i) {
            try {
                this.myStripeLocks[i].lock();
                this.myInterns[i].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i].unlock();
            }
        }
    }
}

