/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefKeyRefValueHashMap<K, V>
implements Map<K, V> {
    private final RefHashMap<K, ValueReference<K, V>> myWeakKeyMap;
    private final ReferenceQueue<V> myQueue;

    public RefKeyRefValueHashMap(@NotNull RefHashMap<K, ValueReference<K, V>> weakKeyMap) {
        if (weakKeyMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weakKeyMap", "com/intellij/util/containers/RefKeyRefValueHashMap", "<init>"));
        }
        this.myQueue = new ReferenceQueue();
        this.myWeakKeyMap = weakKeyMap;
    }

    protected V dereference(ValueReference<K, V> reference) {
        return reference == null ? null : (V)reference.get();
    }

    protected abstract ValueReference<K, V> createValueReference(@NotNull RefHashMap.Key<K> var1, V var2, ReferenceQueue<? super V> var3);

    boolean processQueue() {
        ValueReference ref;
        boolean processed = this.myWeakKeyMap.processQueue();
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            RefHashMap.Key weakKey = ref.getKey();
            this.myWeakKeyMap.removeKey(weakKey);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference<K, V> ref = this.myWeakKeyMap.get(key);
        return this.dereference(ref);
    }

    @Override
    public V put(K key, V value2) {
        this.processQueue();
        RefHashMap.Key<K> weakKey = this.myWeakKeyMap.createKey(key);
        ValueReference<K, V> reference = this.createValueReference(weakKey, value2, this.myQueue);
        ValueReference<K, V> oldRef = this.myWeakKeyMap.putKey(weakKey, reference);
        return this.dereference(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference<K, V> ref = this.myWeakKeyMap.remove(key);
        return this.dereference(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/RefKeyRefValueHashMap", "putAll"));
        }
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.myWeakKeyMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myWeakKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myWeakKeyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myWeakKeyMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefKeyRefValueHashMap", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myWeakKeyMap.values();
        for (ValueReference ref : refs) {
            Object value2 = ref.get();
            if (value2 == null) continue;
            result.add(value2);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RefKeyRefValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    protected static interface ValueReference<K, V> {
        @NotNull
        public RefHashMap.Key<K> getKey();

        public V get();
    }
}

