/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.SoftHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SoftKeySoftValueHashMap<K, V>
implements Map<K, V> {
    private final SoftHashMap<K, ValueReference<K, V>> mySoftKeyMap = new SoftHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    boolean processQueue() {
        ValueReference ref;
        boolean processed = this.mySoftKeyMap.processQueue();
        while ((ref = (ValueReference)this.myQueue.poll()) != null) {
            RefHashMap.Key key = ref.key;
            this.mySoftKeyMap.removeKey(key);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference ref = (ValueReference)this.mySoftKeyMap.get(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public V put(K key, V value2) {
        this.processQueue();
        RefHashMap.Key<K> softKey = this.mySoftKeyMap.createKey(key);
        ValueReference reference = new ValueReference(softKey, value2, this.myQueue);
        ValueReference oldRef = this.mySoftKeyMap.putKey(softKey, reference);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference ref = (ValueReference)this.mySoftKeyMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/SoftKeySoftValueHashMap", "putAll"));
        }
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.mySoftKeyMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.mySoftKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mySoftKeyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.mySoftKeyMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SoftKeySoftValueHashMap", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.mySoftKeyMap.values();
        for (ValueReference ref : refs) {
            Object value2 = ref.get();
            if (value2 == null) continue;
            result.add(value2);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SoftKeySoftValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    private static class ValueReference<K, V>
    extends java.lang.ref.SoftReference<V> {
        private final RefHashMap.Key<K> key;

        private ValueReference(RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

