/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefKeyRefValueHashMap;
import com.intellij.util.containers.WeakHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class WeakKeyWeakValueHashMap<K, V>
extends RefKeyRefValueHashMap<K, V>
implements Map<K, V> {
    public WeakKeyWeakValueHashMap() {
        super(new WeakHashMap());
    }

    @Override
    protected RefKeyRefValueHashMap.ValueReference<K, V> createValueReference(@NotNull RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/WeakKeyWeakValueHashMap", "createValueReference"));
        }
        return new WeakValueReference(key, referent, q);
    }

    private static class WeakValueReference<K, V>
    extends WeakReference<V>
    implements RefKeyRefValueHashMap.ValueReference<K, V> {
        @NotNull
        private final RefHashMap.Key<K> key;

        private WeakValueReference(@NotNull RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/WeakKeyWeakValueHashMap$WeakValueReference", "<init>"));
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public RefHashMap.Key<K> getKey() {
            RefHashMap.Key<K> key = this.key;
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakKeyWeakValueHashMap$WeakValueReference", "getKey"));
            }
            return key;
        }
    }
}

