/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueContainer<Value> {
    @NotNull
    public abstract ValueIterator<Value> getValueIterator();

    public abstract int size();

    public final boolean forEach(@NotNull ContainerAction<Value> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/ValueContainer", "forEach"));
        }
        ValueIterator<Value> valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value2 = valueIterator.next();
            IntIterator intIterator = valueIterator.getInputIdsIterator();
            while (intIterator.hasNext()) {
                if (action.perform(intIterator.next(), value2)) continue;
                return false;
            }
        }
        return true;
    }

    public static interface ContainerAction<T> {
        public boolean perform(int var1, T var2);
    }

    public static interface ValueIterator<Value>
    extends Iterator<Value> {
        @NotNull
        public IntIterator getInputIdsIterator();

        @Nullable
        public IntPredicate getValueAssociationPredicate();
    }

    public static interface IntPredicate {
        public boolean contains(int var1);
    }

    public static interface IntIterator {
        public boolean hasNext();

        public int next();

        public int size();
    }
}

