/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CollectionInputDataDiffBuilder<Key, Value>
extends InputDataDiffBuilder<Key, Value> {
    private final Collection<Key> mySeq;

    public CollectionInputDataDiffBuilder(int inputId, @Nullable Collection<Key> seq) {
        super(inputId);
        this.mySeq = seq == null ? Collections.emptySet() : seq;
    }

    @Override
    public void differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<Key, Value> addProcessor, @NotNull KeyValueUpdateProcessor<Key, Value> updateProcessor, @NotNull RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiate"));
        }
        if (addProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addProcessor", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiate"));
        }
        if (updateProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProcessor", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiate"));
        }
        if (removeProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removeProcessor", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiate"));
        }
        CollectionInputDataDiffBuilder.differentiateWithKeySeq(this.mySeq, newData, this.myInputId, addProcessor, removeProcessor);
    }

    public Collection<Key> getSeq() {
        return this.mySeq;
    }

    static <Key, Value> void differentiateWithKeySeq(@NotNull Collection<Key> currentData, @NotNull Map<Key, Value> newData, int inputId, @NotNull KeyValueUpdateProcessor<Key, Value> addProcessor, @NotNull RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        if (currentData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentData", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiateWithKeySeq"));
        }
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiateWithKeySeq"));
        }
        if (addProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addProcessor", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiateWithKeySeq"));
        }
        if (removeProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removeProcessor", "com/intellij/util/indexing/impl/CollectionInputDataDiffBuilder", "differentiateWithKeySeq"));
        }
        for (Key key : currentData) {
            removeProcessor.process(key, inputId);
        }
        EmptyInputDataDiffBuilder.processKeys(newData, addProcessor, inputId);
    }
}

