/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InputIndexDataExternalizer<K>
implements DataExternalizer<Collection<K>> {
    private final KeyDescriptor<K> myKeyDescriptor;
    private final ID<K, ?> myIndexId;

    public InputIndexDataExternalizer(KeyDescriptor<K> keyDescriptor, ID<K, ?> indexId) {
        this.myKeyDescriptor = keyDescriptor;
        this.myIndexId = indexId;
    }

    @Override
    public void save(@NotNull DataOutput out, @NotNull Collection<K> value2) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/impl/InputIndexDataExternalizer", "save"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/indexing/impl/InputIndexDataExternalizer", "save"));
        }
        try {
            DataInputOutputUtil.writeINT(out, value2.size());
            for (K key : value2) {
                this.myKeyDescriptor.save(out, key);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error saving data for index " + this.myIndexId, e);
        }
    }

    @Override
    @NotNull
    public Collection<K> read(@NotNull DataInput in) throws IOException {
        ArrayList arrayList;
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/impl/InputIndexDataExternalizer", "read"));
        }
        try {
            int size = DataInputOutputUtil.readINT(in);
            ArrayList list = new ArrayList(size);
            for (int idx = 0; idx < size; ++idx) {
                list.add(this.myKeyDescriptor.read(in));
            }
            arrayList = list;
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error reading data for index " + this.myIndexId, e);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/InputIndexDataExternalizer", "read"));
        }
        return arrayList;
    }
}

