/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentStringEnumerator
extends PersistentEnumeratorDelegate<String>
implements AbstractStringEnumerator {
    @Nullable
    private final CachingEnumerator<String> myCache;

    public PersistentStringEnumerator(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, null);
    }

    public PersistentStringEnumerator(@NotNull File file, @Nullable PagedFileStorage.StorageLockContext storageLockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, 4096, storageLockContext);
    }

    public PersistentStringEnumerator(@NotNull File file, boolean cacheLastMappings) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, 4096, cacheLastMappings, null);
    }

    public PersistentStringEnumerator(@NotNull File file, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, initialSize, null);
    }

    public PersistentStringEnumerator(@NotNull File file, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        this(file, initialSize, false, lockContext);
    }

    private PersistentStringEnumerator(@NotNull File file, int initialSize, boolean cacheLastMappings, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentStringEnumerator", "<init>"));
        }
        super(file, EnumeratorStringDescriptor.INSTANCE, initialSize, lockContext);
        this.myCache = cacheLastMappings ? new CachingEnumerator<String>(new DataEnumerator<String>(){

            @Override
            public int enumerate(@Nullable String value2) throws IOException {
                return PersistentStringEnumerator.super.enumerate(value2);
            }

            @Override
            @Nullable
            public String valueOf(int idx) throws IOException {
                return (String)PersistentStringEnumerator.super.valueOf(idx);
            }
        }, EnumeratorStringDescriptor.INSTANCE) : null;
    }

    @Override
    public int enumerate(@Nullable String value2) throws IOException {
        return this.myCache != null ? this.myCache.enumerate(value2) : super.enumerate(value2);
    }

    @Override
    @Nullable
    public String valueOf(int idx) throws IOException {
        return this.myCache != null ? this.myCache.valueOf(idx) : (String)super.valueOf(idx);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myCache != null) {
            this.myCache.close();
        }
    }
}

