/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.Bits;
import com.intellij.util.io.OpenChannelsCache;
import com.intellij.util.io.Page;
import com.intellij.util.io.PagePool;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class RandomAccessDataFile
implements Forceable,
Closeable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.RandomAccessDataFile");
    private static final OpenChannelsCache ourCache = new OpenChannelsCache(150, "rw");
    private static int ourFilesCount;
    private final int myCount;
    private final File myFile;
    private final PagePool myPool;
    private long lastSeek;
    private final byte[] myTypedIOBuffer;
    private final FileWriter log;
    private volatile long mySize;
    private volatile boolean myIsDirty;
    private volatile boolean myIsDisposed;
    private static final boolean DEBUG = false;
    public static int totalReads;
    public static long totalReadBytes;
    public static int seekcount;
    public static int totalWrites;
    public static long totalWriteBytes;

    public RandomAccessDataFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/RandomAccessDataFile", "<init>"));
        }
        this(file, PagePool.SHARED);
    }

    public RandomAccessDataFile(@NotNull File file, @NotNull PagePool pool) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/RandomAccessDataFile", "<init>"));
        }
        if (pool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pool", "com/intellij/util/io/RandomAccessDataFile", "<init>"));
        }
        this.myCount = ourFilesCount++;
        this.lastSeek = -1L;
        this.myTypedIOBuffer = new byte[8];
        this.myPool = pool;
        this.myFile = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath() + " does not exist");
        }
        this.mySize = file.length();
        this.log = null;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RandomAccessDataFile", "getFile"));
        }
        return file;
    }

    public void put(long addr, byte[] bytes, int off, int len) {
        this.assertNotDisposed();
        this.myIsDirty = true;
        this.mySize = Math.max(this.mySize, addr + (long)len);
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int written = page.put(addr, bytes, off, len);
            len -= written;
            addr += (long)written;
            off += written;
        }
    }

    public void get(long addr, byte[] bytes, int off, int len) {
        this.assertNotDisposed();
        while (len > 0) {
            Page page = this.myPool.alloc(this, addr);
            int read = page.get(addr, bytes, off, len);
            len -= read;
            addr += (long)read;
            off += read;
        }
    }

    private void releaseFile() {
        ourCache.releaseChannel(this.myFile);
    }

    private RandomAccessFile getRandomAccessFile() throws FileNotFoundException {
        return ourCache.getChannel(this.myFile);
    }

    public void putInt(long addr, int value2) {
        Bits.putInt(this.myTypedIOBuffer, 0, value2);
        this.put(addr, this.myTypedIOBuffer, 0, 4);
    }

    public int getInt(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 4);
        return Bits.getInt(this.myTypedIOBuffer, 0);
    }

    public void putLong(long addr, long value2) {
        Bits.putLong(this.myTypedIOBuffer, 0, value2);
        this.put(addr, this.myTypedIOBuffer, 0, 8);
    }

    public void putByte(long addr, byte b) {
        this.myTypedIOBuffer[0] = b;
        this.put(addr, this.myTypedIOBuffer, 0, 1);
    }

    public byte getByte(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 1);
        return this.myTypedIOBuffer[0];
    }

    public long getLong(long addr) {
        this.get(addr, this.myTypedIOBuffer, 0, 8);
        return Bits.getLong(this.myTypedIOBuffer, 0);
    }

    public String getUTF(long addr) {
        int len = this.getInt(addr);
        byte[] bytes = new byte[len];
        this.get(addr + 4L, bytes, 0, len);
        return new String(bytes, CharsetToolkit.UTF8_CHARSET);
    }

    public void putUTF(long addr, String value2) {
        byte[] bytes = value2.getBytes(CharsetToolkit.UTF8_CHARSET);
        this.putInt(addr, bytes.length);
        this.put(addr + 4L, bytes, 0, bytes.length);
    }

    public long length() {
        this.assertNotDisposed();
        return this.mySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long physicalLength() {
        long res;
        this.assertNotDisposed();
        try {
            RandomAccessFile file = this.getRandomAccessFile();
            try {
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    res = file.length();
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return res;
    }

    public void dispose() {
        if (this.myIsDisposed) {
            return;
        }
        this.myPool.flushPages(this);
        ourCache.closeChannel(this.myFile);
        this.myIsDisposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void force() {
        this.assertNotDisposed();
        if (this.isDirty()) {
            this.myPool.flushPages(this);
            this.myIsDirty = false;
        }
    }

    public void sync() {
        this.force();
        try {
            RandomAccessFile file = this.getRandomAccessFile();
            file.getChannel().force(true);
        }
        catch (IOException iOException) {
        }
        finally {
            this.releaseFile();
        }
    }

    public void flushSomePages(int maxPagesToFlush) {
        this.assertNotDisposed();
        if (this.isDirty()) {
            this.myIsDirty = !this.myPool.flushPages(this, maxPagesToFlush);
        }
    }

    @Override
    public boolean isDirty() {
        this.assertNotDisposed();
        return this.myIsDirty;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    private void assertNotDisposed() {
        if (this.myIsDisposed) {
            LOG.error("storage file is disposed: " + this.myFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadPage(Page page) {
        this.assertNotDisposed();
        try {
            RandomAccessFile file = this.getRandomAccessFile();
            try {
                RandomAccessFile randomAccessFile = file;
                synchronized (randomAccessFile) {
                    this.seek(file, page.getOffset());
                    ByteBuffer buf = page.getBuf();
                    ++totalReads;
                    totalReadBytes += (long)Page.PAGE_SIZE;
                    file.read(buf.array(), 0, Page.PAGE_SIZE);
                    this.lastSeek += (long)Page.PAGE_SIZE;
                }
            }
            finally {
                this.releaseFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void flushPage(Page page, int start, int end) {
        this.assertNotDisposed();
        try {
            this.flush(page.getBuf(), page.getOffset() + (long)start, start, end - start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ByteBuffer buf, long fileOffset, int bufOffset, int length) throws IOException {
        if (fileOffset + (long)length > this.mySize) {
            length = (int)(this.mySize - fileOffset);
        }
        RandomAccessFile file = this.getRandomAccessFile();
        try {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                this.seek(file, fileOffset);
                ++totalWrites;
                totalWriteBytes += (long)length;
                file.write(buf.array(), bufOffset, length);
                this.lastSeek += (long)length;
            }
        }
        finally {
            this.releaseFile();
        }
    }

    private void seek(RandomAccessFile file, long fileOffset) throws IOException {
        file.seek(fileOffset);
    }

    public int hashCode() {
        return this.myCount;
    }

    public synchronized String toString() {
        return "RandomAccessFile[" + this.myFile + ", dirty=" + this.myIsDirty + "]";
    }
}

