/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.HeavyProcessLatch");
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final EventDispatcher<HeavyProcessListener> myUIProcessDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private volatile Thread myUiActivityThread;
    private static final int MAX_PRIORITIZATION_MILLIS = 12000;
    private volatile long myPrioritizingStarted;
    private final List<Runnable> toExecuteOutOfHeavyActivity = new ArrayList<Runnable>();

    private HeavyProcessLatch() {
    }

    @Deprecated
    public void processStarted() {
        this.processStarted("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AccessToken processStarted(final @NotNull String operationName) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "com/intellij/util/io/storage/HeavyProcessLatch", "processStarted"));
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.add(operationName);
        }
        this.myEventDispatcher.getMulticaster().processStarted();
        AccessToken accessToken = new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/storage/HeavyProcessLatch", "processStarted"));
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinished(@NotNull String operationName) {
        List<Runnable> toRunNow;
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "com/intellij/util/io/storage/HeavyProcessLatch", "processFinished"));
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.remove(operationName);
        }
        this.myEventDispatcher.getMulticaster().processFinished();
        Set<String> set2 = this.myHeavyProcesses;
        synchronized (set2) {
            if (this.isRunning()) {
                toRunNow = Collections.emptyList();
            } else {
                toRunNow = new ArrayList<Runnable>(this.toExecuteOutOfHeavyActivity);
                this.toExecuteOutOfHeavyActivity.clear();
            }
        }
        for (Runnable runnable : toRunNow) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return !this.myHeavyProcesses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunningOperationName() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return this.myHeavyProcesses.isEmpty() ? null : this.myHeavyProcesses.iterator().next();
        }
    }

    public void addListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/io/storage/HeavyProcessLatch", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/io/storage/HeavyProcessLatch", "addListener"));
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public void addUIActivityListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/io/storage/HeavyProcessLatch", "addUIActivityListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/io/storage/HeavyProcessLatch", "addUIActivityListener"));
        }
        this.myUIProcessDispatcher.addListener(listener, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOutOfHeavyProcess(@NotNull Runnable runnable) {
        boolean runNow;
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/io/storage/HeavyProcessLatch", "executeOutOfHeavyProcess"));
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            if (this.isRunning()) {
                runNow = false;
                this.toExecuteOutOfHeavyActivity.add(runnable);
            } else {
                runNow = true;
            }
        }
        if (runNow) {
            runnable.run();
        }
    }

    public void prioritizeUiActivity() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        if (!Registry.is("ide.prioritize.ui.thread", false)) {
            return;
        }
        this.myPrioritizingStarted = System.currentTimeMillis();
        this.myUiActivityThread = Thread.currentThread();
        this.myUIProcessDispatcher.getMulticaster().processStarted();
    }

    public void stopThreadPrioritizing() {
        if (this.myUiActivityThread == null) {
            return;
        }
        this.myUiActivityThread = null;
        this.myUIProcessDispatcher.getMulticaster().processFinished();
    }

    public boolean isInsideLowPriorityThread() {
        Thread uiThread = this.myUiActivityThread;
        if (uiThread != null && uiThread != Thread.currentThread()) {
            Thread.State state = uiThread.getState();
            if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING || state == Thread.State.BLOCKED) {
                return false;
            }
            long time = System.currentTimeMillis() - this.myPrioritizingStarted;
            if (time < 5L) {
                return false;
            }
            if (time > 12000L) {
                this.stopThreadPrioritizing();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasPrioritizedThread() {
        return this.myUiActivityThread != null;
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

