/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

public final class ZipLong
implements Cloneable {
    private static final int WORD = 4;
    private static final int BYTE_BIT_SIZE = 8;
    private static final int BYTE_MASK = 255;
    private static final int BYTE_1 = 1;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private static final int BYTE_2 = 2;
    private static final int BYTE_2_MASK = 0xFF0000;
    private static final int BYTE_2_SHIFT = 16;
    private static final int BYTE_3 = 3;
    private static final long BYTE_3_MASK = 0xFF000000L;
    private static final int BYTE_3_SHIFT = 24;
    private long value;

    public ZipLong(long value2) {
        this.value = value2;
    }

    public ZipLong(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipLong(byte[] bytes, int offset) {
        this.value = ZipLong.getValue(bytes, offset);
    }

    public byte[] getBytes() {
        return ZipLong.getBytes(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public static byte[] getBytes(long value2) {
        byte[] result = new byte[]{(byte)(value2 & 0xFFL), (byte)((value2 & 0xFF00L) >> 8), (byte)((value2 & 0xFF0000L) >> 16), (byte)((value2 & 0xFF000000L) >> 24)};
        return result;
    }

    public static long getValue(byte[] bytes, int offset) {
        long value2 = (long)(bytes[offset + 3] << 24) & 0xFF000000L;
        value2 += (long)(bytes[offset + 2] << 16 & 0xFF0000);
        value2 += (long)(bytes[offset + 1] << 8 & 0xFF00);
        return value2 += (long)(bytes[offset] & 0xFF);
    }

    public static long getValue(byte[] bytes) {
        return ZipLong.getValue(bytes, 0);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)o).getValue();
    }

    public int hashCode() {
        return (int)this.value;
    }
}

