/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownUtil {
    private MarkdownUtil() {
    }

    public static void replaceHeaders(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/text/MarkdownUtil", "replaceHeaders"));
        }
        for (int i = 0; i < lines.size(); ++i) {
            int endInd;
            int ind;
            String line = lines.get(i);
            for (ind = 0; ind < line.length() && line.charAt(ind) == '#'; ++ind) {
            }
            if (ind >= line.length() || line.charAt(ind) != ' ' || 0 >= ind || ind > 9) continue;
            for (endInd = line.length() - 1; endInd >= 0 && line.charAt(endInd) == '#'; --endInd) {
            }
            line = line.substring(ind + 1, endInd + 1);
            line = "<h" + ind + ">" + line + "</h" + ind + ">";
            lines.set(i, line);
        }
    }

    public static void removeImages(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/text/MarkdownUtil", "removeImages"));
        }
        for (int i = 0; i < lines.size(); ++i) {
            String newText = MarkdownUtil.removeAllImages(lines.get(i));
            lines.set(i, newText);
        }
    }

    @NotNull
    private static String removeAllImages(@NotNull String text) {
        TextRange range;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/MarkdownUtil", "removeAllImages"));
        }
        int n = text.length();
        ArrayList<TextRange> intervals = null;
        for (int i = 0; i < n; ++i) {
            int imageEndIndex = MarkdownUtil.findImageEndIndexInclusive(text, i);
            if (imageEndIndex == -1) continue;
            TextRange linkRange = MarkdownUtil.findEnclosingLink(text, i, imageEndIndex);
            if (intervals == null) {
                intervals = new ArrayList<TextRange>(1);
            }
            range = linkRange != null ? linkRange : new TextRange(i, imageEndIndex);
            intervals.add(range);
            i = range.getEndOffset();
        }
        if (intervals == null) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/MarkdownUtil", "removeAllImages"));
            }
            return string;
        }
        StringBuilder buf = new StringBuilder(text);
        for (int intervalInd = intervals.size() - 1; intervalInd >= 0; --intervalInd) {
            range = (TextRange)intervals.get(intervalInd);
            buf.delete(range.getStartOffset(), range.getEndOffset() + 1);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/MarkdownUtil", "removeAllImages"));
        }
        return string;
    }

    private static int findImageEndIndexInclusive(@NotNull String text, int imageStartIndex) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/MarkdownUtil", "findImageEndIndexInclusive"));
        }
        int n = text.length();
        if (text.charAt(imageStartIndex) == '!' && imageStartIndex + 1 < n && text.charAt(imageStartIndex + 1) == '[') {
            int i;
            for (i = imageStartIndex + 2; i < n && text.charAt(i) != ']'; ++i) {
            }
            if (i < n && i + 1 < n && text.charAt(i + 1) == '(') {
                i += 2;
                while (i < n && text.charAt(i) != ')') {
                    ++i;
                }
                if (i < n) {
                    return i;
                }
            }
        }
        return -1;
    }

    @Nullable
    private static TextRange findEnclosingLink(@NotNull String text, int imageStartIndInc, int imageEndIndInc) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/MarkdownUtil", "findEnclosingLink"));
        }
        int linkStartIndInc = imageStartIndInc - 1;
        if (linkStartIndInc >= 0 && text.charAt(linkStartIndInc) == '[') {
            int n = text.length();
            int i = imageEndIndInc + 1;
            if (text.charAt(i) == ']' && i + 1 < n && text.charAt(i + 1) == '(') {
                i += 2;
                while (i < n && text.charAt(i) != ')') {
                    ++i;
                }
                if (i < n) {
                    return new TextRange(linkStartIndInc, i);
                }
            }
        }
        return null;
    }

    public static void replaceCodeBlock(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/text/MarkdownUtil", "replaceCodeBlock"));
        }
        new CodeBlockProcessor(lines).process();
    }

    public static void generateLists(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/text/MarkdownUtil", "generateLists"));
        }
        new ListItemProcessor(lines).process();
    }

    @Nullable
    private static ListItem toListItem(@NotNull String line) {
        int i;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/util/text/MarkdownUtil", "toListItem"));
        }
        if ((line = StringUtil.trimLeading(line)).length() >= 2) {
            char firstChar = line.charAt(0);
            char secondChar = line.charAt(1);
            if ((firstChar == '*' || firstChar == '+' || firstChar == '-') && Character.isWhitespace(secondChar)) {
                return new ListItem(true, StringUtil.trimLeading(line.substring(1)));
            }
        }
        for (i = 0; i < line.length() && Character.isDigit(line.charAt(i)); ++i) {
        }
        if (i > 0 && i < line.length() - 1 && line.charAt(i) == '.' && Character.isWhitespace(line.charAt(i + 1))) {
            return new ListItem(false, StringUtil.trimLeading(line.substring(i + 1)));
        }
        return null;
    }

    private static class ListItem {
        private final boolean myUnordered;
        private final String myBody;

        private ListItem(boolean unordered, @NotNull String body2) {
            if (body2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/util/text/MarkdownUtil$ListItem", "<init>"));
            }
            this.myUnordered = unordered;
            this.myBody = body2;
        }

        private boolean isUnordered() {
            return this.myUnordered;
        }

        @NotNull
        private String getBody() {
            String string = this.myBody;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/MarkdownUtil$ListItem", "getBody"));
            }
            return string;
        }
    }

    private static class ListItemProcessor {
        private final List<String> myLines;
        private boolean myInsideBlockQuote;
        private ListItem myFirstListItem;
        private int myLastListItemLineInd;

        private ListItemProcessor(@NotNull List<String> lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/text/MarkdownUtil$ListItemProcessor", "<init>"));
            }
            this.myInsideBlockQuote = false;
            this.myFirstListItem = null;
            this.myLastListItemLineInd = -1;
            this.myLines = lines;
        }

        public void process() {
            for (int i = 0; i < this.myLines.size(); ++i) {
                String line = this.myLines.get(i);
                if (line.startsWith("```")) {
                    boolean bl = this.myInsideBlockQuote = !this.myInsideBlockQuote;
                }
                if (this.myInsideBlockQuote) continue;
                this.handle(i, line);
            }
            this.finishLastListItem(true);
        }

        private void handle(int ind, @NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/util/text/MarkdownUtil$ListItemProcessor", "handle"));
            }
            ListItem listItem = MarkdownUtil.toListItem(line);
            if (listItem != null) {
                this.finishLastListItem(false);
                String out = "<li>" + listItem.getBody();
                if (this.myFirstListItem == null) {
                    this.myFirstListItem = listItem;
                    out = listItem.isUnordered() ? "<ul>" + out : "<ol>" + out;
                }
                this.myLines.set(ind, out);
                this.myLastListItemLineInd = ind;
            } else if (this.myFirstListItem != null && !line.isEmpty() && !StringUtil.isEmptyOrSpaces(line)) {
                if (ind - 1 >= 0 && StringUtil.isEmptyOrSpaces(this.myLines.get(ind - 1)) && !Character.isWhitespace(line.charAt(0))) {
                    this.finishLastListItem(true);
                } else {
                    String m = StringUtil.trimLeading(line);
                    this.myLines.set(ind, m);
                    this.myLastListItemLineInd = ind;
                }
            }
        }

        private void finishLastListItem(boolean finishList) {
            if (this.myLastListItemLineInd != -1) {
                String l = this.myLines.get(this.myLastListItemLineInd);
                l = l + "</li>";
                if (finishList) {
                    l = this.myFirstListItem.isUnordered() ? l + "</ul>" : l + "</ol>";
                    this.myFirstListItem = null;
                }
                this.myLines.set(this.myLastListItemLineInd, l);
                this.myLastListItemLineInd = -1;
            }
        }
    }

    private static class CodeBlockProcessor {
        private static final String START_TAGS = "<pre><code>";
        private static final String END_TAGS = "</code></pre>";
        private final List<String> myLines;
        private boolean myGlobalCodeBlockStarted;
        private boolean myCodeBlockStarted;

        private CodeBlockProcessor(@NotNull List<String> lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/text/MarkdownUtil$CodeBlockProcessor", "<init>"));
            }
            this.myGlobalCodeBlockStarted = false;
            this.myCodeBlockStarted = false;
            this.myLines = lines;
        }

        public void process() {
            for (int i = 0; i < this.myLines.size(); ++i) {
                String line = this.myLines.get(i);
                if (line.startsWith("```")) {
                    this.finishCodeBlock(i - 1);
                    this.myGlobalCodeBlockStarted = !this.myGlobalCodeBlockStarted;
                    String out = this.myGlobalCodeBlockStarted ? START_TAGS : END_TAGS;
                    this.myLines.set(i, out);
                    continue;
                }
                if (this.myGlobalCodeBlockStarted) continue;
                this.handleLocalCodeBlock(i, line);
            }
            this.finishCodeBlock(this.myLines.size() - 1);
        }

        private void handleLocalCodeBlock(int ind, @NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/util/text/MarkdownUtil$CodeBlockProcessor", "handleLocalCodeBlock"));
            }
            boolean codeBlock = false;
            if (line.startsWith("    ")) {
                line = line.substring(4);
                codeBlock = true;
            } else if (line.startsWith("\t")) {
                line = line.substring(1);
                codeBlock = true;
            }
            if (!this.myCodeBlockStarted) {
                if (codeBlock) {
                    this.myCodeBlockStarted = true;
                    this.myLines.set(ind, START_TAGS + line);
                }
            } else if (codeBlock) {
                this.myLines.set(ind, line);
            } else {
                this.finishCodeBlock(ind - 1);
            }
        }

        private void finishCodeBlock(int lastCodeBlockLineInd) {
            if (this.myCodeBlockStarted) {
                this.myLines.set(lastCodeBlockLineInd, this.myLines.get(lastCodeBlockLineInd) + END_TAGS);
                this.myCodeBlockStarted = false;
            }
        }
    }
}

