/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ThreeStateCheckBox
extends JCheckBox {
    private State myState;
    private boolean myThirdStateEnabled = true;

    public ThreeStateCheckBox() {
        this(null, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(State initial) {
        this(null, null, initial);
    }

    public ThreeStateCheckBox(String text) {
        this(text, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public ThreeStateCheckBox(String text, Icon icon) {
        this(text, icon, State.DONT_CARE);
    }

    public ThreeStateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean selected) {
                ThreeStateCheckBox.this.setState(ThreeStateCheckBox.this.nextState());
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            }

            @Override
            public boolean isSelected() {
                return ThreeStateCheckBox.this.myState == State.SELECTED || UIUtil.isUnderAquaLookAndFeel() && ThreeStateCheckBox.this.myState == State.DONT_CARE;
            }
        });
        this.setState(initial);
    }

    private State nextState() {
        switch (this.myState) {
            case SELECTED: {
                return State.NOT_SELECTED;
            }
            case NOT_SELECTED: {
                if (this.myThirdStateEnabled) {
                    return State.DONT_CARE;
                }
                return State.SELECTED;
            }
        }
        return State.SELECTED;
    }

    public boolean isThirdStateEnabled() {
        return this.myThirdStateEnabled;
    }

    public void setThirdStateEnabled(boolean thirdStateEnabled) {
        this.myThirdStateEnabled = thirdStateEnabled;
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? State.SELECTED : State.NOT_SELECTED);
    }

    public void setState(State state) {
        this.myState = state;
        String value2 = state == State.DONT_CARE ? "indeterminate" : null;
        this.putClientProperty("JButton.selectedState", value2);
        this.repaint();
    }

    public State getState() {
        return this.myState;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            return;
        }
        switch (this.getState()) {
            case DONT_CARE: {
                Icon icon = this.getIcon();
                if (icon == null) {
                    icon = UIManager.getIcon("CheckBox.icon");
                }
                if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                    icon = JBUI.scale(EmptyIcon.create(20, 18));
                }
                if (icon == null) break;
                Insets i = this.getInsets();
                Rectangle r = this.getBounds();
                Rectangle r1 = new Rectangle();
                r1.x = i.left;
                r1.y = i.top;
                r1.width = r.width - (i.right + r1.x);
                r1.height = r.height - (i.bottom + r1.y);
                Rectangle r2 = new Rectangle();
                Rectangle r3 = new Rectangle();
                SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), r1, r2, r3, this.getText() == null ? 0 : this.getIconTextGap());
                g.setColor(UIUtil.getTreeForeground());
                int height = r2.height / 10;
                int width = r2.width / 3;
                g.fillRect(r2.x + r2.width / 2 - width / 2, r2.y + r2.height / 2 - height / 2, width, height);
                break;
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleThreeStateCheckBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleThreeStateCheckBox
    extends JCheckBox.AccessibleJCheckBox {
        protected AccessibleThreeStateCheckBox() {
            super(ThreeStateCheckBox.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                return AccessibleRole.TOGGLE_BUTTON;
            }
            return super.getAccessibleRole();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                AccessibleStateSet set = super.getAccessibleStateSet();
                set.remove(AccessibleState.CHECKED);
                return set;
            }
            return super.getAccessibleStateSet();
        }

        @Override
        public String getAccessibleName() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                return this.addStateDescription(super.getAccessibleName());
            }
            return super.getAccessibleName();
        }

        private String addStateDescription(String name) {
            switch (ThreeStateCheckBox.this.getState()) {
                case SELECTED: {
                    return AccessibleContextUtil.combineAccessibleStrings(name, " ", "checked");
                }
                case NOT_SELECTED: {
                    return AccessibleContextUtil.combineAccessibleStrings(name, " ", "not checked");
                }
                case DONT_CARE: {
                    return AccessibleContextUtil.combineAccessibleStrings(name, " ", "partially checked");
                }
            }
            return name;
        }
    }

    public static enum State {
        SELECTED,
        NOT_SELECTED,
        DONT_CARE;

    }
}

