/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.lang.ref.Reference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlSerializerImpl {
    static final XmlSerializer serializer = new XmlSerializer();

    @NotNull
    static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter) throws XmlSerializationException {
        Element element;
        Binding binding;
        block7: {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            Class<?> aClass = object.getClass();
            binding = serializer.getClassBinding(aClass);
            if (!(binding instanceof BeanBinding)) break block7;
            Element element2 = ((BeanBinding)binding).serialize(object, true, filter);
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            return element2;
        }
        try {
            element = (Element)binding.serialize(object, null, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
        }
        return element;
    }

    @NotNull
    static Class<?> typeToClass(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type2 instanceof TypeVariable) {
            Type bound = ((TypeVariable)type2).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type2 instanceof WildcardType) {
            Class clazz = (Class)((WildcardType)type2).getUpperBounds()[0];
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type2).getRawType();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        return clazz;
    }

    private static boolean isPrimitive(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "isPrimitive"));
        }
        return aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass);
    }

    @Nullable
    static Object convert(@Nullable String value2, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/XmlSerializerImpl", "convert"));
        }
        if (value2 == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value2;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value2);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value2);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value2);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value2);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value2)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value2));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value2;
    }

    static void doSet(@NotNull Object host, @Nullable String value2, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (value2 == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value2);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value2));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value2));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value2));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value2));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value2));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value2));
        } else if (valueClass.isEnum()) {
            Object deserializedValue = null;
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value2)) continue;
                deserializedValue = enumConstant;
            }
            accessor.set(host, deserializedValue);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value2)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value2;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value2);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value2);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value2);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value2);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value2);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value2));
            }
            accessor.set(host, deserializedValue);
        }
    }

    @NotNull
    static String convertToString(@NotNull Object value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/xmlb/XmlSerializerImpl", "convertToString"));
        }
        if (value2 instanceof Date) {
            String string = Long.toString(((Date)value2).getTime());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "convertToString"));
            }
            return string;
        }
        String string = value2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "convertToString"));
        }
        return string;
    }

    @NotNull
    static String getTextValue(@NotNull Element element, @NotNull String defaultText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        if (defaultText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultText", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        List content = element.getContent();
        int size = content.size();
        StringBuilder builder = null;
        for (int i = 0; i < size; ++i) {
            Content child = (Content)content.get(i);
            if (!(child instanceof Text)) continue;
            String value2 = child.getValue();
            if (builder == null && i == size - 1) {
                String string = value2;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
                }
                return string;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(value2);
        }
        String string = builder == null ? defaultText : builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        return string;
    }

    static class XmlSerializer
    extends XmlSerializerBase {
        private Reference<Map<Pair<Type, MutableAccessor>, Binding>> ourBindings;

        XmlSerializer() {
        }

        @NotNull
        private Map<Pair<Type, MutableAccessor>, Binding> getBindingCacheMap() {
            Map<Pair<Type, MutableAccessor>, Binding> map2 = SoftReference.dereference(this.ourBindings);
            if (map2 == null) {
                map2 = ContainerUtil.newConcurrentMap();
                this.ourBindings = new java.lang.ref.SoftReference<Map<Pair<Type, MutableAccessor>, Binding>>(map2);
            }
            Map<Pair<Type, MutableAccessor>, Binding> map3 = map2;
            if (map3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer", "getBindingCacheMap"));
            }
            return map3;
        }

        @Override
        @NotNull
        public synchronized Binding getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer", "getClassBinding"));
            }
            if (originalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer", "getClassBinding"));
            }
            Pair<Type, MutableAccessor> key = Pair.create(originalType, accessor);
            Map<Pair<Type, MutableAccessor>, Binding> map2 = this.getBindingCacheMap();
            Binding binding = map2.get(key);
            if (binding == null) {
                binding = XmlSerializer.createClassBinding(aClass, accessor, originalType);
                if (binding == null) {
                    binding = new BeanBinding(aClass, accessor);
                }
                map2.put(key, binding);
                try {
                    binding.init(originalType, this);
                }
                catch (XmlSerializationException e) {
                    map2.remove(key);
                    throw e;
                }
            }
            Binding binding2 = binding;
            if (binding2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializer", "getClassBinding"));
            }
            return binding2;
        }
    }

    public static abstract class XmlSerializerBase
    implements Serializer {
        @Override
        @Nullable
        public final Binding getBinding(@NotNull Type type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getBinding"));
            }
            return this.getBinding(XmlSerializerImpl.typeToClass(type2), type2, null);
        }

        @Nullable
        protected final Binding getBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getBinding"));
            }
            if (originalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getBinding"));
            }
            return XmlSerializerImpl.isPrimitive(aClass) ? null : this.getClassBinding(aClass, originalType, accessor);
        }

        @Override
        @Nullable
        public final Binding getBinding(@NotNull Class<?> aClass, @NotNull Type type2) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getBinding"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getBinding"));
            }
            return this.getBinding(aClass, type2, null);
        }

        @Override
        @Nullable
        public final Binding getBinding(@NotNull MutableAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getBinding"));
            }
            Type type2 = accessor.getGenericType();
            return this.getBinding(XmlSerializerImpl.typeToClass(type2), type2, accessor);
        }

        @Override
        @NotNull
        public final Binding getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getClassBinding"));
            }
            if (originalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getClassBinding"));
            }
            Binding binding = this.getClassBinding(aClass, originalType, null);
            if (binding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getClassBinding"));
            }
            return binding;
        }

        @Override
        public final Binding getClassBinding(@NotNull Class<?> aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "getClassBinding"));
            }
            return this.getClassBinding(aClass, aClass, null);
        }

        @Nullable
        protected static Binding createClassBinding(@NotNull Class<?> aClass, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "createClassBinding"));
            }
            if (originalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl$XmlSerializerBase", "createClassBinding"));
            }
            if (aClass.isArray()) {
                if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                    assert (accessor != null);
                    return new JDOMElementBinding(accessor);
                }
                return new ArrayBinding(aClass, accessor);
            }
            if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                CollectionBean listBean;
                if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                    return new CompactCollectionBinding(accessor);
                }
                return new CollectionBinding((ParameterizedType)originalType, accessor);
            }
            if (accessor != null) {
                if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                    return new MapBinding(accessor);
                }
                if (Element.class.isAssignableFrom(aClass)) {
                    return new JDOMElementBinding(accessor);
                }
                if (JDOMExternalizableStringList.class == aClass) {
                    return new CompactCollectionBinding(accessor);
                }
            }
            return null;
        }
    }
}

