/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.optimizer;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.optimizer.ConstantPool;

public class AnnotationConstantsCollector
extends AnnotationVisitor {
    private final ConstantPool cp;

    public AnnotationConstantsCollector(AnnotationVisitor av, ConstantPool cp) {
        super(393216, av);
        this.cp = cp;
    }

    public void visit(String name, Object value2) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        if (value2 instanceof Byte) {
            this.cp.newInteger(((Byte)value2).byteValue());
        } else if (value2 instanceof Boolean) {
            this.cp.newInteger((Boolean)value2 != false ? 1 : 0);
        } else if (value2 instanceof Character) {
            this.cp.newInteger(((Character)value2).charValue());
        } else if (value2 instanceof Short) {
            this.cp.newInteger(((Short)value2).shortValue());
        } else if (value2 instanceof Type) {
            this.cp.newUTF8(((Type)value2).getDescriptor());
        } else if (value2 instanceof byte[]) {
            byte[] v = (byte[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value2 instanceof boolean[]) {
            boolean[] v = (boolean[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i] ? 1 : 0);
            }
        } else if (value2 instanceof short[]) {
            short[] v = (short[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value2 instanceof char[]) {
            char[] v = (char[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value2 instanceof int[]) {
            int[] v = (int[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newInteger(v[i]);
            }
        } else if (value2 instanceof long[]) {
            long[] v = (long[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newLong(v[i]);
            }
        } else if (value2 instanceof float[]) {
            float[] v = (float[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newFloat(v[i]);
            }
        } else if (value2 instanceof double[]) {
            double[] v = (double[])value2;
            for (int i = 0; i < v.length; ++i) {
                this.cp.newDouble(v[i]);
            }
        } else {
            this.cp.newConst(value2);
        }
        this.av.visit(name, value2);
    }

    public void visitEnum(String name, String desc, String value2) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        this.cp.newUTF8(desc);
        this.cp.newUTF8(value2);
        this.av.visitEnum(name, desc, value2);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        this.cp.newUTF8(desc);
        return new AnnotationConstantsCollector(this.av.visitAnnotation(name, desc), this.cp);
    }

    public AnnotationVisitor visitArray(String name) {
        if (name != null) {
            this.cp.newUTF8(name);
        }
        return new AnnotationConstantsCollector(this.av.visitArray(name), this.cp);
    }

    public void visitEnd() {
        this.av.visitEnd();
    }
}

