/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleManager;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.LifecycleStrategy;

public class DecoratingComponentAdapter
implements ComponentAdapter,
ComponentMonitorStrategy,
LifecycleManager,
LifecycleStrategy,
Serializable {
    private ComponentAdapter delegate;

    public DecoratingComponentAdapter(ComponentAdapter delegate) {
        this.delegate = delegate;
    }

    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    public Class getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        return this.delegate.getComponentInstance(container);
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
        this.delegate.verify(container);
    }

    public ComponentAdapter getDelegate() {
        return this.delegate;
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
        this.delegate.accept(visitor);
    }

    public void changeMonitor(ComponentMonitor monitor) {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
        }
    }

    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in delegate");
    }

    public void start(PicoContainer container) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).start(container);
        }
    }

    public void stop(PicoContainer container) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).stop(container);
        }
    }

    public void dispose(PicoContainer container) {
        if (this.delegate instanceof LifecycleManager) {
            ((LifecycleManager)((Object)this.delegate)).dispose(container);
        }
    }

    public boolean hasLifecycle() {
        if (this.delegate instanceof LifecycleManager) {
            return ((LifecycleManager)((Object)this.delegate)).hasLifecycle();
        }
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(this.delegate.getComponentImplementation());
        }
        return false;
    }

    public void start(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).start(component);
        }
    }

    public void stop(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).stop(component);
        }
    }

    public void dispose(Object component) {
        if (this.delegate instanceof LifecycleStrategy) {
            ((LifecycleStrategy)((Object)this.delegate)).dispose(component);
        }
    }

    public boolean hasLifecycle(Class type2) {
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(type2);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getPrintableClassName());
        buffer.append(" delegate=");
        buffer.append(this.delegate);
        buffer.append("]");
        return buffer.toString();
    }

    private String getPrintableClassName() {
        String name = this.getClass().getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("ComponentAdapter")) {
            name = name.substring(0, name.length() - "ComponentAdapter".length()) + "CA";
        }
        return name;
    }
}

