/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ImplementationHidingComponentAdapter
extends DecoratingComponentAdapter {
    private final boolean strict;

    public ImplementationHidingComponentAdapter(ComponentAdapter delegate, boolean strict) {
        super(delegate);
        this.strict = strict;
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentKey = this.getDelegate().getComponentKey();
        Class[] classes2 = null;
        if (componentKey instanceof Class && ((Class)this.getDelegate().getComponentKey()).isInterface()) {
            classes2 = new Class[]{(Class)this.getDelegate().getComponentKey()};
        } else if (componentKey instanceof Class[]) {
            classes2 = (Class[])componentKey;
        } else {
            if (this.strict) {
                throw new PicoIntrospectionException("In strict mode, " + this.getClass().getName() + " only allows components registered with interface keys (java.lang.Class or java.lang.Class[])");
            }
            return this.getDelegate().getComponentInstance(container);
        }
        Class[] interfaces = this.verifyInterfacesOnly(classes2);
        return this.createProxy(interfaces, container, this.getDelegate().getComponentImplementation().getClassLoader());
    }

    private Object createProxy(Class[] interfaces, final PicoContainer container, ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object componentInstance = ImplementationHidingComponentAdapter.this.getDelegate().getComponentInstance(container);
                ComponentMonitor componentMonitor = ImplementationHidingComponentAdapter.this.currentMonitor();
                try {
                    componentMonitor.invoking(method, componentInstance);
                    long startTime = System.currentTimeMillis();
                    Object object = method.invoke(componentInstance, args);
                    componentMonitor.invoked(method, componentInstance, System.currentTimeMillis() - startTime);
                    return object;
                }
                catch (InvocationTargetException ite) {
                    componentMonitor.invocationFailed(method, componentInstance, ite);
                    throw ite.getTargetException();
                }
            }
        });
    }

    private Class[] verifyInterfacesOnly(Class[] classes2) {
        for (int i = 0; i < classes2.length; ++i) {
            if (classes2[i].isInterface()) continue;
            throw new PicoIntrospectionException("Class keys must be interfaces. " + classes2[i] + " is not an interface.");
        }
        return classes2;
    }
}

