/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class SetterInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient InstantiatingComponentAdapter.Guard instantiationGuard;
    private transient List setters;
    private transient List setterNames;
    private transient Class[] setterTypes;

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses, monitor, lifecycleStrategy);
    }

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses, ComponentMonitor monitor) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses, monitor);
    }

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses);
    }

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, parameters2, false);
    }

    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getConstructor();
        this.getMatchingParameterListForSetters(container);
        return constructor;
    }

    private Constructor getConstructor() throws PicoInvocationTargetInitializationException {
        Object retVal = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return SetterInjectionComponentAdapter.this.getComponentImplementation().getConstructor(null);
                }
                catch (NoSuchMethodException e) {
                    return new PicoInvocationTargetInitializationException(e);
                }
                catch (SecurityException e) {
                    return new PicoInvocationTargetInitializationException(e);
                }
            }
        });
        if (retVal instanceof Constructor) {
            return (Constructor)retVal;
        }
        throw (PicoInitializationException)retVal;
    }

    private Parameter[] getMatchingParameterListForSetters(PicoContainer container) throws PicoInitializationException, UnsatisfiableDependenciesException {
        if (this.setters == null) {
            this.initializeSetterAndTypeLists();
        }
        ArrayList<Object> matchingParameterList = new ArrayList<Object>(Collections.nCopies(this.setters.size(), null));
        HashSet<Integer> nonMatchingParameterPositions = new HashSet<Integer>();
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(this.setterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            Parameter parameter = currentParameters[i];
            boolean failedDependency = true;
            for (int j = 0; j < this.setterTypes.length; ++j) {
                if (matchingParameterList.get(j) != null || !parameter.isResolvable(container, this, this.setterTypes[j])) continue;
                matchingParameterList.set(j, parameter);
                failedDependency = false;
                break;
            }
            if (!failedDependency) continue;
            nonMatchingParameterPositions.add(new Integer(i));
        }
        HashSet<Class> unsatisfiableDependencyTypes = new HashSet<Class>();
        for (int i = 0; i < matchingParameterList.size(); ++i) {
            if (matchingParameterList.get(i) != null) continue;
            unsatisfiableDependencyTypes.add(this.setterTypes[i]);
        }
        if (unsatisfiableDependencyTypes.size() > 0) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiableDependencyTypes, container);
        }
        if (nonMatchingParameterPositions.size() > 0) {
            throw new PicoInitializationException("Following parameters do not match any of the setters for " + this.getComponentImplementation() + ": " + ((Object)nonMatchingParameterPositions).toString());
        }
        return matchingParameterList.toArray(new Parameter[matchingParameterList.size()]);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        final Constructor constructor = this.getConstructor();
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new InstantiatingComponentAdapter.Guard(){

                public Object run() {
                    Object componentInstance;
                    Parameter[] matchingParameters = SetterInjectionComponentAdapter.this.getMatchingParameterListForSetters(this.guardedContainer);
                    ComponentMonitor componentMonitor = SetterInjectionComponentAdapter.this.currentMonitor();
                    try {
                        long startTime = System.currentTimeMillis();
                        componentMonitor.instantiating(constructor);
                        componentInstance = SetterInjectionComponentAdapter.this.newInstance(constructor, null);
                        componentMonitor.instantiated(constructor, System.currentTimeMillis() - startTime);
                    }
                    catch (InvocationTargetException e) {
                        componentMonitor.instantiationFailed(constructor, e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        componentMonitor.instantiationFailed(constructor, e);
                        throw new PicoInitializationException("Should never get here");
                    }
                    catch (IllegalAccessException e) {
                        componentMonitor.instantiationFailed(constructor, e);
                        throw new PicoInitializationException(e);
                    }
                    Method setter = null;
                    try {
                        for (int i = 0; i < SetterInjectionComponentAdapter.this.setters.size(); ++i) {
                            setter = (Method)SetterInjectionComponentAdapter.this.setters.get(i);
                            componentMonitor.invoking(setter, componentInstance);
                            long startTime = System.currentTimeMillis();
                            setter.invoke(componentInstance, matchingParameters[i].resolveInstance(this.guardedContainer, SetterInjectionComponentAdapter.this, SetterInjectionComponentAdapter.this.setterTypes[i]));
                            componentMonitor.invoked(setter, componentInstance, System.currentTimeMillis() - startTime);
                        }
                        return componentInstance;
                    }
                    catch (InvocationTargetException e) {
                        componentMonitor.invocationFailed(setter, componentInstance, e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(e.getTargetException());
                    }
                    catch (IllegalAccessException e) {
                        componentMonitor.invocationFailed(setter, componentInstance, e);
                        throw new PicoInvocationTargetInitializationException(e);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    public void verify(final PicoContainer container) throws PicoIntrospectionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new InstantiatingComponentAdapter.Guard(){

                public Object run() {
                    Parameter[] currentParameters = SetterInjectionComponentAdapter.this.getMatchingParameterListForSetters(this.guardedContainer);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, SetterInjectionComponentAdapter.this, SetterInjectionComponentAdapter.this.setterTypes[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setArguments(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    private void initializeSetterAndTypeLists() {
        this.setters = new ArrayList();
        this.setterNames = new ArrayList();
        ArrayList typeList = new ArrayList();
        Method[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean isBeanStyle;
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            String methodName = method.getName();
            boolean bl = isBeanStyle = methodName.length() >= 4 && methodName.startsWith("set") && Character.isUpperCase(methodName.charAt(3));
            if (!isBeanStyle) continue;
            String attribute = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            this.setters.add(method);
            this.setterNames.add(attribute);
            typeList.add(parameterTypes[0]);
        }
        this.setterTypes = typeList.toArray(new Class[0]);
    }

    private Method[] getMethods() {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SetterInjectionComponentAdapter.this.getComponentImplementation().getMethods();
            }
        });
    }
}

