/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.java.generate;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.java.generate.JavaUastCodeGenerationPluginKt;
import org.jetbrains.uast.java.generate.JavaUastElementFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J7\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u0002H\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/uast/java/generate/JavaUastCodeGenerationPlugin;", "Lorg/jetbrains/uast/generate/UastCodeGenerationPlugin;", "()V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "adjustChainStyleToMethodCalls", "", "oldPsi", "Lcom/intellij/psi/PsiElement;", "newPsi", "cleanupMethodCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "methodCall", "getElementFactory", "Lorg/jetbrains/uast/generate/UastElementFactory;", "project", "Lcom/intellij/openapi/project/Project;", "replace", "T", "Lorg/jetbrains/uast/UElement;", "oldElement", "newElement", "elementType", "Ljava/lang/Class;", "(Lorg/jetbrains/uast/UElement;Lorg/jetbrains/uast/UElement;Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "intellij.java.uast"})
public final class JavaUastCodeGenerationPlugin
implements UastCodeGenerationPlugin {
    @Override
    @NotNull
    public UastElementFactory getElementFactory(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new JavaUastElementFactory(project);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaLanguage, (String)"JavaLanguage.INSTANCE");
        return (Language)javaLanguage;
    }

    private final PsiMethodCallExpression cleanupMethodCall(PsiMethodCallExpression methodCall) {
        PsiType[] psiTypeArray = methodCall.getTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"methodCall.typeArguments");
        PsiType[] psiTypeArray2 = psiTypeArray;
        boolean bl = false;
        PsiType[] psiTypeArray3 = psiTypeArray2;
        boolean bl2 = false;
        if (!(psiTypeArray3.length == 0)) {
            PsiMethod psiMethod = methodCall.resolveMethod();
            if (psiMethod == null) {
                return methodCall;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"methodCall.resolveMethod() ?: return methodCall");
            PsiMethod resolved2 = psiMethod;
            if (methodCall.getTypeArguments().length == resolved2.getTypeParameters().length && PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])methodCall.getTypeArguments(), (PsiExpression)((PsiExpression)methodCall), (boolean)false, (PsiMethod)resolved2, (PsiTypeParameter[])resolved2.getTypeParameters())) {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)methodCall.getProject()).createExpressionFromText("foo()", null);
                if (psiExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
                }
                PsiMethodCallExpression emptyTypeArgumentsMethodCall = (PsiMethodCallExpression)psiExpression;
                methodCall.getTypeArgumentList().replace((PsiElement)emptyTypeArgumentsMethodCall.getTypeArgumentList());
            }
        }
        PsiElement psiElement = JavaCodeStyleManager.getInstance((Project)methodCall.getProject()).shortenClassReferences((PsiElement)methodCall);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        return (PsiMethodCallExpression)psiElement;
    }

    private final void adjustChainStyleToMethodCalls(PsiElement oldPsi, PsiElement newPsi) {
        if (oldPsi instanceof PsiMethodCallExpression && newPsi instanceof PsiMethodCallExpression) {
            PsiReferenceExpression psiReferenceExpression = ((PsiMethodCallExpression)oldPsi).getMethodExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"oldPsi.methodExpression");
            if (psiReferenceExpression.getQualifierExpression() != null) {
                PsiReferenceExpression psiReferenceExpression2 = ((PsiMethodCallExpression)newPsi).getMethodExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression2, (String)"newPsi.methodExpression");
                if (psiReferenceExpression2.getQualifier() != null) {
                    PsiReferenceExpression psiReferenceExpression3 = ((PsiMethodCallExpression)oldPsi).getMethodExpression();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression3, (String)"oldPsi.methodExpression");
                    Object[] objectArray = psiReferenceExpression3.getChildren();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"oldPsi.methodExpression.children");
                    if (ArraysKt.getOrNull((Object[])objectArray, (int)1) instanceof PsiWhiteSpace) {
                        PsiReferenceExpression psiReferenceExpression4 = ((PsiMethodCallExpression)newPsi).getMethodExpression();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression4, (String)"newPsi.methodExpression");
                        Object[] objectArray2 = psiReferenceExpression4.getChildren();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"newPsi.methodExpression.children");
                        if (!(ArraysKt.getOrNull((Object[])objectArray2, (int)1) instanceof PsiWhiteSpace)) {
                            PsiReferenceExpression psiReferenceExpression5 = ((PsiMethodCallExpression)newPsi).getMethodExpression();
                            PsiReferenceExpression psiReferenceExpression6 = ((PsiMethodCallExpression)oldPsi).getMethodExpression();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression6, (String)"oldPsi.methodExpression");
                            PsiElement psiElement = psiReferenceExpression6.getChildren()[1];
                            PsiReferenceExpression psiReferenceExpression7 = ((PsiMethodCallExpression)newPsi).getMethodExpression();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression7, (String)"newPsi.methodExpression");
                            psiReferenceExpression5.addAfter(psiElement, psiReferenceExpression7.getChildren()[0]);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public <T extends UElement> T replace(@NotNull UElement oldElement, @NotNull T newElement, @NotNull Class<T> elementType) {
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)oldElement, (String)"oldElement");
        Intrinsics.checkParameterIsNotNull(newElement, (String)"newElement");
        Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
        PsiElement psiElement2 = oldElement.getSourcePsi();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement oldPsi = psiElement2;
        PsiElement psiElement3 = newElement.getSourcePsi();
        if (psiElement3 == null) {
            return null;
        }
        PsiElement newPsi = psiElement3;
        this.adjustChainStyleToMethodCalls(oldPsi, newPsi);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)oldPsi.getProject());
        PsiElement updOldPsi = (newPsi instanceof PsiBlockStatement || newPsi instanceof PsiCodeBlock) && oldPsi.getParent() instanceof PsiExpressionStatement ? oldPsi.getParent() : oldPsi;
        if (updOldPsi instanceof PsiStatement && newPsi instanceof PsiExpression) {
            PsiElementFactory psiElementFactory = factory;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementFactory, (String)"factory");
            PsiStatement psiStatement = JavaUastCodeGenerationPluginKt.access$createExpresionStatement(psiElementFactory, (PsiExpression)newPsi);
            if (psiStatement == null) return null;
            psiElement = (PsiElement)psiStatement;
        } else if (updOldPsi instanceof PsiCodeBlock && newPsi instanceof PsiBlockStatement) {
            PsiCodeBlock psiCodeBlock = ((PsiBlockStatement)newPsi).getCodeBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiCodeBlock, (String)"newPsi.codeBlock");
            psiElement = (PsiElement)psiCodeBlock;
        } else {
            psiElement = newPsi;
        }
        PsiElement updNewPsi = psiElement;
        PsiElement replaced = updOldPsi.replace(updNewPsi);
        return replaced instanceof PsiExpressionStatement ? UastContextKt.toUElementOfExpectedTypes((PsiElement)((PsiExpressionStatement)replaced).getExpression(), elementType) : (replaced instanceof PsiMethodCallExpression ? UastContextKt.toUElementOfExpectedTypes((PsiElement)this.cleanupMethodCall((PsiMethodCallExpression)replaced), elementType) : UastContextKt.toUElementOfExpectedTypes(replaced, elementType));
    }
}

