/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.evaluation;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.evaluation.TreeBasedEvaluator;
import org.jetbrains.uast.evaluation.UEvaluationContext;
import org.jetbrains.uast.evaluation.UEvaluationState;
import org.jetbrains.uast.evaluation.UEvaluationStateKt;
import org.jetbrains.uast.evaluation.UEvaluator;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.evaluation.UEvaluatorKt;
import org.jetbrains.uast.values.UUndeterminedValue;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001!B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/uast/evaluation/MapBasedEvaluationContext;", "Lorg/jetbrains/uast/evaluation/UEvaluationContext;", "uastContext", "Lorg/jetbrains/uast/UastLanguagePlugin;", "extensions", "", "Lorg/jetbrains/uast/evaluation/UEvaluatorExtension;", "(Lorg/jetbrains/uast/UastLanguagePlugin;Ljava/util/List;)V", "evaluators", "Ljava/util/WeakHashMap;", "Lorg/jetbrains/uast/UDeclaration;", "Ljava/lang/ref/SoftReference;", "Lorg/jetbrains/uast/evaluation/MapBasedEvaluationContext$UEvaluatorWithStamp;", "getExtensions", "()Ljava/util/List;", "getUastContext", "()Lorg/jetbrains/uast/UastLanguagePlugin;", "analyze", "Lorg/jetbrains/uast/evaluation/UEvaluator;", "declaration", "state", "Lorg/jetbrains/uast/evaluation/UEvaluationState;", "analyzeAll", "file", "Lorg/jetbrains/uast/UFile;", "cachedValueOf", "Lorg/jetbrains/uast/values/UValue;", "expression", "Lorg/jetbrains/uast/UExpression;", "getEvaluator", "getOrCreateEvaluator", "valueOf", "valueOfIfAny", "UEvaluatorWithStamp", "intellij.platform.uast"})
public final class MapBasedEvaluationContext
implements UEvaluationContext {
    @NotNull
    private final UastLanguagePlugin uastContext;
    @NotNull
    private final List<UEvaluatorExtension> extensions;
    @NotNull
    private final WeakHashMap<UDeclaration, SoftReference<UEvaluatorWithStamp>> evaluators;

    public MapBasedEvaluationContext(@NotNull UastLanguagePlugin uastContext, @NotNull List<? extends UEvaluatorExtension> extensions) {
        Intrinsics.checkNotNullParameter((Object)uastContext, (String)"uastContext");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.uastContext = uastContext;
        this.extensions = extensions;
        this.evaluators = new WeakHashMap();
    }

    @Override
    @NotNull
    public UastLanguagePlugin getUastContext() {
        return this.uastContext;
    }

    @Override
    @NotNull
    public List<UEvaluatorExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    @NotNull
    public UEvaluationContext analyzeAll(@NotNull UFile file, @NotNull UEvaluationState state) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        file.accept(new UastVisitor(this, state){
            final /* synthetic */ MapBasedEvaluationContext this$0;
            final /* synthetic */ UEvaluationState $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
            }

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            public boolean visitMethod(@NotNull UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.this$0.analyze(node, this.$state);
                return true;
            }

            public boolean visitVariable(@NotNull UVariable node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof UField) {
                    this.this$0.analyze(node, this.$state);
                    return true;
                }
                return false;
            }
        });
        return this;
    }

    private final UEvaluator getOrCreateEvaluator(UDeclaration declaration2, UEvaluationState state) throws ProcessCanceledException {
        UEvaluator uEvaluator;
        UEvaluatorWithStamp evaluatorWithStamp;
        UFile containingFile = UastUtils.getContainingUFile(declaration2);
        UFile uFile = containingFile;
        long modificationStamp = uFile != null && (uFile = uFile.getSourcePsi()) != null ? uFile.getModificationStamp() : -1L;
        SoftReference<UEvaluatorWithStamp> softReference = this.evaluators.get(declaration2);
        UEvaluatorWithStamp uEvaluatorWithStamp = evaluatorWithStamp = softReference != null ? softReference.get() : null;
        if (evaluatorWithStamp != null && evaluatorWithStamp.getStamp() == modificationStamp) {
            return evaluatorWithStamp.getEvaluator();
        }
        UEvaluator $this$getOrCreateEvaluator_u24lambda_u240 = uEvaluator = UEvaluatorKt.createEvaluator(this.getUastContext(), this.getExtensions());
        boolean bl = false;
        UDeclaration uDeclaration = declaration2;
        if (uDeclaration instanceof UMethod) {
            UMethod uMethod = (UMethod)declaration2;
            UEvaluationState uEvaluationState = state;
            if (uEvaluationState == null) {
                uEvaluationState = UEvaluationStateKt.createEmptyState(declaration2);
            }
            $this$getOrCreateEvaluator_u24lambda_u240.analyze(uMethod, uEvaluationState);
        } else if (uDeclaration instanceof UField) {
            UField uField = (UField)declaration2;
            UEvaluationState uEvaluationState = state;
            if (uEvaluationState == null) {
                uEvaluationState = UEvaluationStateKt.createEmptyState(declaration2);
            }
            $this$getOrCreateEvaluator_u24lambda_u240.analyze(uField, uEvaluationState);
        }
        ((Map)this.evaluators).put(declaration2, new SoftReference<UEvaluatorWithStamp>(new UEvaluatorWithStamp($this$getOrCreateEvaluator_u24lambda_u240, modificationStamp)));
        return uEvaluator;
    }

    static /* synthetic */ UEvaluator getOrCreateEvaluator$default(MapBasedEvaluationContext mapBasedEvaluationContext, UDeclaration uDeclaration, UEvaluationState uEvaluationState, int n, Object object) throws ProcessCanceledException {
        if ((n & 2) != 0) {
            uEvaluationState = null;
        }
        return mapBasedEvaluationContext.getOrCreateEvaluator(uDeclaration, uEvaluationState);
    }

    @Override
    @NotNull
    public UEvaluator analyze(@NotNull UDeclaration declaration2, @NotNull UEvaluationState state) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.getOrCreateEvaluator(declaration2, state);
    }

    @Override
    @NotNull
    public UEvaluator getEvaluator(@NotNull UDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return MapBasedEvaluationContext.getOrCreateEvaluator$default(this, declaration2, null, 2, null);
    }

    private final UEvaluator getEvaluator(UExpression expression2) {
        for (UElement containingElement = expression2.getUastParent(); containingElement != null; containingElement = containingElement.getUastParent()) {
            UEvaluator evaluator;
            if (!(containingElement instanceof UDeclaration)) continue;
            SoftReference<UEvaluatorWithStamp> softReference = this.evaluators.get(containingElement);
            UEvaluator uEvaluator = softReference != null && (softReference = softReference.get()) != null ? ((UEvaluatorWithStamp)((Object)softReference)).getEvaluator() : (evaluator = null);
            if (evaluator == null) continue;
            return evaluator;
        }
        return null;
    }

    @Nullable
    public final UValue cachedValueOf(@NotNull UExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        UEvaluator uEvaluator = this.getEvaluator(expression2);
        TreeBasedEvaluator treeBasedEvaluator = uEvaluator instanceof TreeBasedEvaluator ? (TreeBasedEvaluator)uEvaluator : null;
        return treeBasedEvaluator != null ? treeBasedEvaluator.getCached$intellij_platform_uast(expression2) : null;
    }

    @Override
    @NotNull
    public UValue valueOf(@NotNull UExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        UValue uValue = this.valueOfIfAny(expression2);
        if (uValue == null) {
            uValue = UUndeterminedValue.INSTANCE;
        }
        return uValue;
    }

    @Override
    @Nullable
    public UValue valueOfIfAny(@NotNull UExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        UEvaluator uEvaluator = this.getEvaluator(expression2);
        return uEvaluator != null ? UEvaluator.evaluate$default(uEvaluator, expression2, null, 2, null) : null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/uast/evaluation/MapBasedEvaluationContext$UEvaluatorWithStamp;", "", "evaluator", "Lorg/jetbrains/uast/evaluation/UEvaluator;", "stamp", "", "(Lorg/jetbrains/uast/evaluation/UEvaluator;J)V", "getEvaluator", "()Lorg/jetbrains/uast/evaluation/UEvaluator;", "getStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.uast"})
    public static final class UEvaluatorWithStamp {
        @NotNull
        private final UEvaluator evaluator;
        private final long stamp;

        public UEvaluatorWithStamp(@NotNull UEvaluator evaluator, long stamp) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            this.evaluator = evaluator;
            this.stamp = stamp;
        }

        @NotNull
        public final UEvaluator getEvaluator() {
            return this.evaluator;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final UEvaluator component1() {
            return this.evaluator;
        }

        public final long component2() {
            return this.stamp;
        }

        @NotNull
        public final UEvaluatorWithStamp copy(@NotNull UEvaluator evaluator, long stamp) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            return new UEvaluatorWithStamp(evaluator, stamp);
        }

        public static /* synthetic */ UEvaluatorWithStamp copy$default(UEvaluatorWithStamp uEvaluatorWithStamp, UEvaluator uEvaluator, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uEvaluator = uEvaluatorWithStamp.evaluator;
            }
            if ((n & 2) != 0) {
                l = uEvaluatorWithStamp.stamp;
            }
            return uEvaluatorWithStamp.copy(uEvaluator, l);
        }

        @NotNull
        public String toString() {
            return "UEvaluatorWithStamp(evaluator=" + this.evaluator + ", stamp=" + this.stamp + ")";
        }

        public int hashCode() {
            int result = this.evaluator.hashCode();
            result = result * 31 + Long.hashCode(this.stamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UEvaluatorWithStamp)) {
                return false;
            }
            UEvaluatorWithStamp uEvaluatorWithStamp = (UEvaluatorWithStamp)other;
            if (!Intrinsics.areEqual((Object)this.evaluator, (Object)uEvaluatorWithStamp.evaluator)) {
                return false;
            }
            return this.stamp == uEvaluatorWithStamp.stamp;
        }
    }
}

