/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayResourceValue
extends ResourceValue
implements Iterable<String> {
    private final List<String> mItems = new ArrayList<String>();

    public ArrayResourceValue(ResourceUrl url, String libraryName) {
        super(url, null, libraryName);
        assert (url.type == ResourceType.ARRAY);
    }

    public void addElement(String value) {
        this.mItems.add(value);
    }

    public int getElementCount() {
        return this.mItems.size();
    }

    public String getElement(int index) {
        return this.mItems.get(index);
    }

    @Override
    public Iterator<String> iterator() {
        return this.mItems.iterator();
    }

    protected int getDefaultIndex() {
        return 0;
    }

    @Override
    public String getValue() {
        if (this.mValue == null && !this.mItems.isEmpty()) {
            return this.mItems.get(this.getDefaultIndex());
        }
        return this.mValue;
    }
}

