/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AttrResourceValueImpl
extends ResourceValueImpl
implements AttrResourceValue {
    private Map<String, Integer> mValueMap;
    private Map<String, String> mValueDescriptionMap;
    private String mDescription;
    private String mGroupName;
    private Set<AttributeFormat> mFormats = EnumSet.noneOf(AttributeFormat.class);

    public AttrResourceValueImpl(ResourceReference reference, String libraryName) {
        super(reference, null, libraryName);
    }

    public AttrResourceValueImpl(ResourceNamespace namespace, ResourceType type, String name, String libraryName) {
        super(namespace, type, name, null, libraryName);
    }

    @Override
    public Map<String, Integer> getAttributeValues() {
        return this.mValueMap;
    }

    @Override
    public String getValueDescription(String valueName) {
        return this.mValueDescriptionMap == null ? null : this.mValueDescriptionMap.get(valueName);
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public String getGroupName() {
        return this.mGroupName;
    }

    @Override
    public Set<AttributeFormat> getFormats() {
        return this.mFormats;
    }

    public void addValue(String valueName, Integer numericValue, String description) {
        if (this.mValueMap == null) {
            this.mValueMap = new LinkedHashMap<String, Integer>();
        }
        this.mValueMap.put(valueName, numericValue);
        if (description != null) {
            if (this.mValueDescriptionMap == null) {
                this.mValueDescriptionMap = new HashMap<String, String>();
            }
            this.mValueDescriptionMap.put(valueName, description);
        }
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setGroupName(String groupName) {
        this.mGroupName = groupName;
    }

    public void setFormats(Collection<AttributeFormat> formats) {
        this.mFormats = EnumSet.copyOf(formats);
    }
}

