/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.List;

public class PluralsResourceValueImpl
extends ResourceValueImpl
implements PluralsResourceValue {
    private final List<String> mQuantities = new ArrayList<String>();
    private final List<String> mValues = new ArrayList<String>();

    public PluralsResourceValueImpl(ResourceReference reference, String value, String libraryName) {
        super(reference, value, libraryName);
        assert (reference.getResourceType() == ResourceType.PLURALS);
    }

    public PluralsResourceValueImpl(ResourceNamespace namespace, ResourceType type, String name, String value, String libraryName) {
        super(namespace, type, name, value, libraryName);
        assert (type == ResourceType.PLURALS);
    }

    public void addPlural(String quantity, String value) {
        this.mQuantities.add(quantity);
        this.mValues.add(value);
    }

    @Override
    public int getPluralsCount() {
        return this.mQuantities.size();
    }

    @Override
    public String getQuantity(int index) {
        return this.mQuantities.get(index);
    }

    @Override
    public String getValue(int index) {
        return this.mValues.get(index);
    }

    @Override
    public String getValue(String quantity) {
        assert (this.mQuantities.size() == this.mValues.size());
        int n = this.mQuantities.size();
        for (int i = 0; i < n; ++i) {
            if (!quantity.equals(this.mQuantities.get(i))) continue;
            return this.mValues.get(i);
        }
        return null;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && !this.mValues.isEmpty()) {
            return this.getValue(0);
        }
        return super.getValue();
    }
}

