/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public final class FolderTypeRelationship {
    private static final Map<ResourceType, List<ResourceFolderType>> mTypeToFolderMap = new EnumMap<ResourceType, List<ResourceFolderType>>(ResourceType.class);
    private static final Map<ResourceFolderType, List<ResourceType>> mFolderToTypeMap = new EnumMap<ResourceFolderType, List<ResourceType>>(ResourceFolderType.class);
    private static final EnumSet<ResourceFolderType> ID_PROVIDING_RESOURCE_TYPES;

    public static List<ResourceType> getRelatedResourceTypes(ResourceFolderType folderType) {
        List<ResourceType> list = mFolderToTypeMap.get((Object)folderType);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static ResourceType getNonIdRelatedResourceType(ResourceFolderType folderType) {
        List<ResourceType> resourceTypes = FolderTypeRelationship.getRelatedResourceTypes(folderType);
        if (resourceTypes.isEmpty()) {
            throw new IllegalArgumentException(String.format("No resource types defined for given folder type: %s", folderType.getName()));
        }
        ResourceType resourceType = resourceTypes.get(0);
        if (resourceTypes.size() > 1 && resourceType == ResourceType.ID) {
            resourceType = resourceTypes.get(1);
        }
        return resourceType;
    }

    public static List<ResourceFolderType> getRelatedFolders(ResourceType resType) {
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resType);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static ResourceFolderType getNonValuesRelatedFolder(ResourceType resType) {
        if (resType == ResourceType.ID) {
            return null;
        }
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resType);
        if (list != null) {
            for (ResourceFolderType type : list) {
                if (type == ResourceFolderType.VALUES) continue;
                return type;
            }
        }
        return null;
    }

    public static boolean isIdGeneratingFolderType(ResourceFolderType folderType) {
        return ID_PROVIDING_RESOURCE_TYPES.contains((Object)folderType);
    }

    public static Collection<ResourceFolderType> getIdGeneratingFolderTypes() {
        return ID_PROVIDING_RESOURCE_TYPES;
    }

    public static boolean match(ResourceType resType, ResourceFolderType folderType) {
        List<ResourceFolderType> list = mTypeToFolderMap.get((Object)resType);
        if (list != null) {
            return list.contains((Object)folderType);
        }
        return false;
    }

    private static void add(ResourceType type, ResourceFolderType folder) {
        List<ResourceType> typeList;
        List<ResourceFolderType> folderList = mTypeToFolderMap.get((Object)type);
        if (folderList == null) {
            folderList = new ArrayList<ResourceFolderType>();
            mTypeToFolderMap.put(type, folderList);
        }
        if (folderList.indexOf((Object)folder) == -1) {
            folderList.add(folder);
        }
        if ((typeList = mFolderToTypeMap.get((Object)folder)) == null) {
            typeList = new ArrayList<ResourceType>();
            mFolderToTypeMap.put(folder, typeList);
        }
        if (typeList.indexOf((Object)type) == -1) {
            typeList.add(type);
        }
    }

    private static void makeSafe() {
        List<Enum> list;
        for (ResourceType resourceType : ResourceType.values()) {
            list = mTypeToFolderMap.get((Object)resourceType);
            if (list == null) continue;
            assert (resourceType == ResourceType.ID || list.size() <= 2);
            mTypeToFolderMap.put(resourceType, Collections.unmodifiableList(list));
        }
        for (Enum enum_ : ResourceFolderType.values()) {
            list = mFolderToTypeMap.get(enum_);
            if (list == null) continue;
            mFolderToTypeMap.put((ResourceFolderType)enum_, Collections.unmodifiableList(list));
        }
    }

    static {
        FolderTypeRelationship.add(ResourceType.ANIM, ResourceFolderType.ANIM);
        FolderTypeRelationship.add(ResourceType.ANIMATOR, ResourceFolderType.ANIMATOR);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.COLOR);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.DRAWABLE);
        FolderTypeRelationship.add(ResourceType.FONT, ResourceFolderType.FONT);
        FolderTypeRelationship.add(ResourceType.INTERPOLATOR, ResourceFolderType.INTERPOLATOR);
        FolderTypeRelationship.add(ResourceType.LAYOUT, ResourceFolderType.LAYOUT);
        FolderTypeRelationship.add(ResourceType.MENU, ResourceFolderType.MENU);
        FolderTypeRelationship.add(ResourceType.MIPMAP, ResourceFolderType.MIPMAP);
        FolderTypeRelationship.add(ResourceType.RAW, ResourceFolderType.RAW);
        FolderTypeRelationship.add(ResourceType.TRANSITION, ResourceFolderType.TRANSITION);
        FolderTypeRelationship.add(ResourceType.XML, ResourceFolderType.XML);
        FolderTypeRelationship.add(ResourceType.NAVIGATION, ResourceFolderType.NAVIGATION);
        FolderTypeRelationship.add(ResourceType.ARRAY, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ATTR, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.BOOL, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.COLOR, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DIMEN, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.DRAWABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.FRACTION, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.INTEGER, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.PLURALS, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.PUBLIC, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STRING, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLE_ITEM, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.STYLEABLE, ResourceFolderType.VALUES);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.DRAWABLE);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.LAYOUT);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.MENU);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.NAVIGATION);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.TRANSITION);
        FolderTypeRelationship.add(ResourceType.ID, ResourceFolderType.XML);
        FolderTypeRelationship.makeSafe();
        ID_PROVIDING_RESOURCE_TYPES = EnumSet.of(ResourceFolderType.LAYOUT, new ResourceFolderType[]{ResourceFolderType.MENU, ResourceFolderType.DRAWABLE, ResourceFolderType.XML, ResourceFolderType.TRANSITION, ResourceFolderType.NAVIGATION});
    }
}

