/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class LintBaseline {
    public static final String TAG_ISSUES = "issues";
    private static final String TAG_ISSUE = "issue";
    private static final String TAG_LOCATION = "location";
    private static final String ATTR_ID = "id";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_LINE = "line";
    private static final String ATTR_COLUMN = "column";
    private final LintClient client;
    private int foundErrorCount;
    private int foundWarningCount;
    private int baselineIssueCount;
    private final Multimap<String, Entry> messageToEntry = ArrayListMultimap.create((int)100, (int)20);
    private boolean writeOnClose;
    private boolean removeFixed;
    private final File baselineFile;
    private List<ReportedEntry> entriesToWrite;

    public LintBaseline(LintClient client, File baselineFile) {
        this.client = client;
        this.baselineFile = baselineFile;
        this.readBaselineFile();
    }

    void reportBaselineIssues(LintDriver driver, Project project) {
        int fixedCount;
        if (this.foundErrorCount > 0 || this.foundWarningCount > 0) {
            LintClient client = driver.getClient();
            File baselineFile = this.getFile();
            String message = String.format("%1$s were filtered out because they were listed in the baseline file, %2$s", LintUtils.describeCounts(this.foundErrorCount, this.foundWarningCount, false, true), LintBaseline.getDisplayPath(project, baselineFile));
            client.report(new Context(driver, project, project, baselineFile, null), IssueRegistry.BASELINE, client.getConfiguration(project, driver).getSeverity(IssueRegistry.BASELINE), Location.create(baselineFile), message, TextFormat.RAW, null);
        }
        if (!((fixedCount = this.getFixedCount()) <= 0 || this.writeOnClose && this.removeFixed)) {
            LintClient client = driver.getClient();
            File baselineFile = this.getFile();
            HashMap ids = Maps.newHashMap();
            for (Entry entry : this.messageToEntry.values()) {
                Object count = (Integer)ids.get(entry.issueId);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf((Integer)count + 1);
                ids.put(entry.issueId, count);
            }
            ArrayList sorted = Lists.newArrayList(ids.keySet());
            Collections.sort(sorted);
            StringBuilder issueTypes = new StringBuilder();
            for (String id : sorted) {
                if (issueTypes.length() > 0) {
                    issueTypes.append(", ");
                }
                issueTypes.append(id);
                Integer count = (Integer)ids.get(id);
                if (count <= 1) continue;
                issueTypes.append(" (").append(Integer.toString(count)).append(")");
            }
            String message = String.format("%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?", fixedCount, LintBaseline.getDisplayPath(project, baselineFile));
            if (LintClient.Companion.isGradle() && project.getGradleProjectModel() != null && !project.getGradleProjectModel().getLintOptions().isCheckDependencies()) {
                message = message + " Another possible explanation is that lint recently stopped analyzing (and including results from) dependent projects by default. You can turn this back on with `android.lintOptions.checkDependencies=true`.";
            }
            message = message + " Unmatched issue types: " + issueTypes;
            client.report(new Context(driver, project, project, baselineFile, null), IssueRegistry.BASELINE, client.getConfiguration(project, driver).getSeverity(IssueRegistry.BASELINE), Location.create(baselineFile), message, TextFormat.RAW, null);
        }
    }

    public static boolean isFilteredMessage(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return errorMessage.contains("were filtered out");
    }

    public static boolean isFixedMessage(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return errorMessage.contains("perhaps they have been fixed");
    }

    public boolean findAndMark(Issue issue, Location location, String message, Severity severity, Project project) {
        boolean found = this.findAndMark(issue, location, message, severity);
        if (this.writeOnClose && (!this.removeFixed || found) && this.entriesToWrite != null) {
            this.entriesToWrite.add(new ReportedEntry(issue, project, location, message));
        }
        return found;
    }

    private boolean findAndMark(Issue issue, Location location, String message, Severity severity) {
        Collection entries = this.messageToEntry.get((Object)message);
        if (entries == null || entries.isEmpty()) {
            return false;
        }
        File file = location.getFile();
        String path = file.getPath();
        String issueId = issue.getId();
        for (Entry entry : entries) {
            if (!entry.issueId.equals(issueId) || !LintBaseline.isSamePathSuffix(path, entry.path)) continue;
            while (entry.previous != null) {
                entry = entry.previous;
            }
            while (entry != null) {
                this.messageToEntry.remove((Object)entry.message, (Object)entry);
                entry = entry.next;
            }
            if (severity == null) {
                severity = issue.getDefaultSeverity();
            }
            if (severity.isError()) {
                ++this.foundErrorCount;
            } else {
                ++this.foundWarningCount;
            }
            return true;
        }
        return false;
    }

    public int getFoundErrorCount() {
        return this.foundErrorCount;
    }

    public int getFoundWarningCount() {
        return this.foundWarningCount;
    }

    public int getFixedCount() {
        return this.baselineIssueCount - this.foundErrorCount - this.foundWarningCount;
    }

    public int getTotalCount() {
        return this.baselineIssueCount;
    }

    static boolean isSamePathSuffix(String path, String suffix) {
        char c;
        int begin;
        int i = path.length() - 1;
        int j = suffix.length() - 1;
        for (begin = 0; begin < j && ((c = suffix.charAt(begin)) == '.' || c == '/' || c == '\\'); ++begin) {
        }
        if (j - begin > i) {
            return false;
        }
        while (j > begin) {
            int c2;
            int c1 = path.charAt(i);
            if (c1 != (c2 = suffix.charAt(j))) {
                if (c1 == 92) {
                    c1 = 47;
                }
                if (c2 == 92) {
                    c2 = 47;
                }
                if (c1 != c2) {
                    return false;
                }
            }
            --i;
            --j;
        }
        return true;
    }

    private void readBaselineFile() {
        if (!this.baselineFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.baselineFile), StandardCharsets.UTF_8));){
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)reader);
            String issue = null;
            String message = null;
            String path = null;
            String line = null;
            Entry currentEntry = null;
            while (parser.next() != 1) {
                int eventType = parser.getEventType();
                if (eventType == 3) {
                    String tag = parser.getName();
                    if (tag.equals(TAG_LOCATION)) {
                        if (issue != null && message != null && path != null) {
                            Entry entry = new Entry(issue, message, path, line);
                            if (currentEntry != null) {
                                currentEntry.next = entry;
                            }
                            entry.previous = currentEntry;
                            currentEntry = entry;
                            this.messageToEntry.put((Object)entry.message, (Object)entry);
                        }
                    } else if (tag.equals(TAG_ISSUE)) {
                        ++this.baselineIssueCount;
                        issue = null;
                        message = null;
                        path = null;
                        line = null;
                        currentEntry = null;
                    }
                } else if (eventType != 2) continue;
                int n = parser.getAttributeCount();
                block24: for (int i = 0; i < n; ++i) {
                    String name = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    switch (name) {
                        case "id": {
                            issue = value;
                            continue block24;
                        }
                        case "message": {
                            message = value;
                            if (!message.startsWith("[")) continue block24;
                            if (message.startsWith("[I18N] ")) {
                                message = message.substring("[I18N] ".length());
                                continue block24;
                            }
                            if (!message.startsWith("[Accessibility] ")) continue block24;
                            message = message.substring("[Accessibility] ".length());
                            continue block24;
                        }
                        case "file": {
                            path = value;
                            continue block24;
                        }
                        case "line": {
                            line = value;
                        }
                    }
                }
            }
        }
        catch (IOException | XmlPullParserException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
            }
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.baselineFile;
    }

    public boolean isWriteOnClose() {
        return this.writeOnClose;
    }

    public void setWriteOnClose(boolean writeOnClose) {
        if (writeOnClose) {
            int count = this.baselineIssueCount > 0 ? this.baselineIssueCount + 10 : 30;
            this.entriesToWrite = Lists.newArrayListWithCapacity((int)count);
        }
        this.writeOnClose = writeOnClose;
    }

    public boolean isRemoveFixed() {
        return this.removeFixed;
    }

    public void setRemoveFixed(boolean skipFixed) {
        this.removeFixed = skipFixed;
    }

    public void close() {
        if (this.writeOnClose) {
            boolean mkdirs;
            File parentFile = this.baselineFile.getParentFile();
            if (parentFile != null && !parentFile.exists() && !(mkdirs = parentFile.mkdirs())) {
                this.client.log(null, "Couldn't create %1$s", parentFile);
                return;
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.baselineFile));){
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                ((Writer)writer).write(60);
                writer.write(TAG_ISSUES);
                writer.write(" format=\"4\"");
                String revision = this.client.getClientRevision();
                if (revision != null) {
                    writer.write(String.format(" by=\"lint %1$s\"", revision));
                }
                writer.write(">\n");
                this.baselineIssueCount = 0;
                if (this.entriesToWrite != null) {
                    Collections.sort(this.entriesToWrite);
                    for (ReportedEntry entry : this.entriesToWrite) {
                        entry.write(writer, this.client);
                        ++this.baselineIssueCount;
                    }
                }
                writer.write("\n</");
                writer.write(TAG_ISSUES);
                writer.write(">\n");
                ((Writer)writer).close();
            }
            catch (IOException ioe) {
                this.client.log(ioe, null, new Object[0]);
            }
        }
    }

    private static String getDisplayPath(Project project, File file) {
        String path = file.getPath();
        if (project != null && path.startsWith(project.getReferenceDir().getPath())) {
            int chop = project.getReferenceDir().getPath().length();
            if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                ++chop;
            }
            if ((path = path.substring(chop)).isEmpty()) {
                path = file.getName();
            }
        }
        return path;
    }

    private static void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        writer.write(10);
        LintBaseline.indent(writer, indent);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(XmlUtils.toXmlAttributeValue((String)value));
        writer.write(34);
    }

    private static void indent(Writer writer, int indent) throws IOException {
        for (int level = 0; level < indent; ++level) {
            writer.write("    ");
        }
    }

    private static class Entry {
        public final String issueId;
        public final String message;
        public final String path;
        public final String line;
        public Entry next;
        public Entry previous;

        public Entry(String issueId, String message, String path, String line) {
            this.issueId = issueId;
            this.message = message;
            this.path = path;
            this.line = line;
        }
    }

    private static class ReportedEntry
    implements Comparable<ReportedEntry> {
        public final Issue issue;
        public final String message;
        public final Location location;
        public final Project project;

        public ReportedEntry(Issue issue, Project project, Location location, String message) {
            this.issue = issue;
            this.location = location;
            this.project = project;
            this.message = message;
        }

        @Override
        public int compareTo(ReportedEntry other) {
            File secondaryFile2;
            int otherLine;
            String id2;
            int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
            if (categoryDelta != 0) {
                return categoryDelta;
            }
            int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
            if (priorityDelta != 0) {
                return priorityDelta;
            }
            String id1 = this.issue.getId();
            int idDelta = id1.compareTo(id2 = other.issue.getId());
            if (idDelta != 0) {
                return idDelta;
            }
            File file = this.location.getFile();
            File otherFile = other.location.getFile();
            int fileDelta = file.getName().compareTo(otherFile.getName());
            if (fileDelta != 0) {
                return fileDelta;
            }
            Position start = this.location.getStart();
            Position otherStart = other.location.getStart();
            int line = start != null ? start.getLine() : -1;
            int n = otherLine = otherStart != null ? otherStart.getLine() : -1;
            if (line != otherLine) {
                return line - otherLine;
            }
            int delta = this.message.compareTo(other.message);
            if (delta != 0) {
                return delta;
            }
            delta = file.compareTo(otherFile);
            if (delta != 0) {
                return delta;
            }
            Location secondary1 = this.location.getSecondary();
            File secondaryFile1 = secondary1 != null ? secondary1.getFile() : null;
            Location secondary2 = other.location.getSecondary();
            File file2 = secondaryFile2 = secondary2 != null ? secondary2.getFile() : null;
            if (secondaryFile1 != null) {
                if (secondaryFile2 != null) {
                    return secondaryFile1.compareTo(secondaryFile2);
                }
                return -1;
            }
            if (secondaryFile2 != null) {
                return 1;
            }
            if (start != null && otherStart != null && (delta = start.getColumn() - otherStart.getColumn()) != 0) {
                return delta;
            }
            return 0;
        }

        void write(Writer writer, LintClient client) {
            try {
                writer.write(10);
                LintBaseline.indent(writer, 1);
                writer.write(60);
                writer.write(LintBaseline.TAG_ISSUE);
                LintBaseline.writeAttribute(writer, 2, LintBaseline.ATTR_ID, this.issue.getId());
                LintBaseline.writeAttribute(writer, 2, LintBaseline.ATTR_MESSAGE, this.message);
                writer.write(">\n");
                for (Location currentLocation = this.location; currentLocation != null; currentLocation = currentLocation.getSecondary()) {
                    int line;
                    LintBaseline.indent(writer, 2);
                    writer.write(60);
                    writer.write(LintBaseline.TAG_LOCATION);
                    String path = LintBaseline.getDisplayPath(this.project, currentLocation.getFile());
                    LintBaseline.writeAttribute(writer, 3, LintBaseline.ATTR_FILE, path);
                    Position start = currentLocation.getStart();
                    if (start != null && (line = start.getLine()) >= 0) {
                        LintBaseline.writeAttribute(writer, 3, LintBaseline.ATTR_LINE, Integer.toString(line + 1));
                    }
                    writer.write("/>\n");
                }
                LintBaseline.indent(writer, 1);
                writer.write("</");
                writer.write(LintBaseline.TAG_ISSUE);
                writer.write(">\n");
            }
            catch (IOException ioe) {
                client.log(ioe, null, new Object[0]);
            }
        }
    }
}

