/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFileIssueRegistry
extends IssueRegistry {
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    private static Map<File, SoftReference<JarFileIssueRegistry>> cache;
    private final List<Issue> issues = Lists.newArrayList();
    private long timestamp;
    private File jarFile;
    private boolean hasLombokLegacyDetectors;
    private boolean hasPsiLegacyDetectors;

    public boolean hasLombokLegacyDetectors() {
        return this.hasLombokLegacyDetectors;
    }

    public boolean hasPsiLegacyDetectors() {
        return this.hasPsiLegacyDetectors;
    }

    public static JarFileIssueRegistry get(LintClient client, File jarFile) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (cache == null) {
            cache = new HashMap<File, SoftReference<JarFileIssueRegistry>>();
        } else {
            JarFileIssueRegistry registry;
            SoftReference<JarFileIssueRegistry> reference = cache.get(jarFile);
            if (reference != null && (registry = reference.get()) != null && registry.isUpToDate()) {
                return registry;
            }
        }
        IssueRegistry.reset();
        JarFileIssueRegistry registry = new JarFileIssueRegistry(client, jarFile);
        cache.put(jarFile, new SoftReference<JarFileIssueRegistry>(registry));
        return registry;
    }

    @Override
    public boolean isUpToDate() {
        return this.timestamp == this.jarFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarFileIssueRegistry(LintClient client, File file) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            Object object = attrs.get(new Attributes.Name(MF_LINT_REGISTRY));
            boolean isLegacy = false;
            if (object == null && (object = attrs.get(new Attributes.Name(MF_LINT_REGISTRY_OLD))) != null) {
                isLegacy = true;
            }
            if (object instanceof String) {
                String className = (String)object;
                URL url = SdkUtils.fileToUrl((File)file);
                ClassLoader loader = client.createUrlClassLoader(new URL[]{url}, JarFileIssueRegistry.class.getClassLoader());
                Class<?> registryClass = Class.forName(className, true, loader);
                IssueRegistry registry = (IssueRegistry)registryClass.newInstance();
                this.issues.addAll(registry.getIssues());
                if (isLegacy) {
                    for (Issue issue : this.issues) {
                        EnumSet<Scope> scope = issue.getImplementation().getScope();
                        if (!scope.contains((Object)Scope.JAVA_FILE) && !scope.contains((Object)Scope.JAVA_LIBRARIES) && !scope.contains((Object)Scope.ALL_JAVA_FILES)) continue;
                        Class<? extends Detector> detectorClass = issue.getImplementation().getDetectorClass();
                        if (Detector.JavaScanner.class.isAssignableFrom(detectorClass)) {
                            this.hasLombokLegacyDetectors = true;
                            break;
                        }
                        if (!Detector.JavaPsiScanner.class.isAssignableFrom(detectorClass)) break;
                        this.hasPsiLegacyDetectors = true;
                        break;
                    }
                }
                if (loader instanceof URLClassLoader) {
                    JarFileIssueRegistry.loadAndCloseURLClassLoader(client, file, (URLClassLoader)loader);
                }
            } else {
                client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", file.getPath(), MF_LINT_REGISTRY);
            }
        }
        finally {
            this.jarFile = file;
            this.timestamp = file.lastModified();
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
        try {
            try (JarFile jar = new JarFile(file);){
                Enumeration<JarEntry> enumeration = jar.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry entry = enumeration.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    name = name.substring(0, name.length() - ".class".length());
                    name = name.replace('/', '.');
                    try {
                        Class<?> aClass = Class.forName(name, true, loader);
                        aClass.newInstance();
                    }
                    catch (Throwable e) {
                        client.log(Severity.ERROR, e, "Failed to prefetch " + name + " from " + file, new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                loader.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }
}

