/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00010B?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u0011\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010'\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010 H\u0096\u0002J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*J\b\u0010,\u001a\u00020\tH\u0016J\u0006\u0010-\u001a\u00020\u0014J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010/\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lcom/android/tools/lint/detector/api/Issue;", "", "id", "", "briefDescription", "explanation", "category", "Lcom/android/tools/lint/detector/api/Category;", "priority", "", "defaultSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "implementation", "Lcom/android/tools/lint/detector/api/Implementation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Category;ILcom/android/tools/lint/detector/api/Severity;Lcom/android/tools/lint/detector/api/Implementation;)V", "getCategory", "()Lcom/android/tools/lint/detector/api/Category;", "getDefaultSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "enabledByDefault", "", "getId", "()Ljava/lang/String;", "getImplementation", "()Lcom/android/tools/lint/detector/api/Implementation;", "setImplementation", "(Lcom/android/tools/lint/detector/api/Implementation;)V", "moreInfo", "", "getMoreInfo", "()Ljava/util/List;", "moreInfoUrls", "", "getPriority", "()I", "addMoreInfo", "moreInfoUrl", "compareTo", "other", "equals", "getBriefDescription", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getExplanation", "hashCode", "isEnabledByDefault", "setEnabledByDefault", "toString", "Companion", "lint-api"})
@Beta
public final class Issue
implements Comparable<Issue> {
    private Object moreInfoUrls;
    private boolean enabledByDefault;
    @NotNull
    private final String id;
    private final String briefDescription;
    private final String explanation;
    @NotNull
    private final Category category;
    private final int priority;
    @NotNull
    private final Severity defaultSeverity;
    @NotNull
    private Implementation implementation;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<String> getMoreInfo() {
        Object object = this.moreInfoUrls;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        if (object instanceof String) {
            Object object2 = this.moreInfoUrls;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            return CollectionsKt.listOf((Object)((String)object2));
        }
        boolean bl = this.moreInfoUrls instanceof List;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object3 = this.moreInfoUrls;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        }
        return (List)object3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getBriefDescription(@NotNull TextFormat format) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
        String string = this.briefDescription;
        TextFormat textFormat = TextFormat.RAW;
        CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        return textFormat.convertTo(string2, format);
    }

    @NotNull
    public final String getExplanation(@NotNull TextFormat format) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
        String trimmed = StringsKt.trimIndent((String)this.explanation);
        String message = StringsKt.replace$default((String)trimmed, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        return TextFormat.RAW.convertTo(message, format);
    }

    @NotNull
    public final Issue addMoreInfo(@NotNull String moreInfoUrl) {
        Intrinsics.checkParameterIsNotNull((Object)moreInfoUrl, (String)"moreInfoUrl");
        Object object = this.moreInfoUrls;
        if (object == null) {
            this.moreInfoUrls = moreInfoUrl;
        } else if (object instanceof String) {
            Object object2 = this.moreInfoUrls;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String existing = (String)object2;
            ArrayList<String> list2 = new ArrayList<String>(2);
            list2.add(existing);
            list2.add(moreInfoUrl);
            this.moreInfoUrls = list2;
        } else {
            boolean bl = this.moreInfoUrls instanceof List;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Object object3 = this.moreInfoUrls;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            }
            TypeIntrinsics.asMutableList((Object)object3).add(moreInfoUrl);
        }
        return this;
    }

    public final boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    @Override
    public int compareTo(@NotNull Issue other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.id.compareTo(other.id);
    }

    @NotNull
    public final Issue setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        Issue issue = (Issue)other;
        return Intrinsics.areEqual((Object)this.id, (Object)issue.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Category getCategory() {
        return this.category;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final Severity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    @NotNull
    public final Implementation getImplementation() {
        return this.implementation;
    }

    public final void setImplementation(@NotNull Implementation implementation) {
        Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"<set-?>");
        this.implementation = implementation;
    }

    private Issue(String id, String briefDescription, String explanation, Category category, int priority, Severity defaultSeverity, Implementation implementation) {
        boolean bl;
        boolean bl2;
        this.id = id;
        this.briefDescription = briefDescription;
        this.explanation = explanation;
        this.category = category;
        this.priority = priority;
        this.defaultSeverity = defaultSeverity;
        this.implementation = implementation;
        this.enabledByDefault = true;
        CharSequence charSequence = this.briefDescription;
        boolean bl3 = bl2 = !(charSequence.length() == 0);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CharSequence charSequence2 = this.explanation;
        boolean bl4 = bl = !(charSequence2.length() == 0);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ Issue(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity defaultSeverity, @NotNull Implementation implementation, DefaultConstructorMarker $constructor_marker) {
        this(id, briefDescription, explanation, category, priority, defaultSeverity, implementation);
    }

    @JvmStatic
    @NotNull
    public static final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity severity, @NotNull Implementation implementation) {
        return Companion.create(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007JZ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/Issue$Companion;", "", "()V", "create", "Lcom/android/tools/lint/detector/api/Issue;", "id", "", "briefDescription", "explanation", "category", "Lcom/android/tools/lint/detector/api/Category;", "priority", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "implementation", "Lcom/android/tools/lint/detector/api/Implementation;", "moreInfo", "enabledByDefault", "", "lint-api"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity severity, @NotNull Implementation implementation) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)briefDescription, (String)"briefDescription");
            Intrinsics.checkParameterIsNotNull((Object)explanation, (String)"explanation");
            Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"implementation");
            return new Issue(id, briefDescription, explanation, category, priority, severity, implementation, null);
        }

        @NotNull
        public final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Implementation implementation, @Nullable String moreInfo, @NotNull Category category, int priority, @NotNull Severity severity, boolean enabledByDefault) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)briefDescription, (String)"briefDescription");
            Intrinsics.checkParameterIsNotNull((Object)explanation, (String)"explanation");
            Intrinsics.checkParameterIsNotNull((Object)implementation, (String)"implementation");
            Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Issue issue = new Issue(id, briefDescription, explanation, category, priority, severity, implementation, null);
            if (moreInfo != null) {
                issue.addMoreInfo(moreInfo);
            }
            if (!enabledByDefault) {
                issue.setEnabledByDefault(false);
            }
            return issue;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Issue create$default(Companion companion, String string, String string2, String string3, Implementation implementation, String string4, Category category, int n, Severity severity, boolean bl, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                string4 = null;
            }
            if ((n2 & 0x20) != 0) {
                category = Category.CORRECTNESS;
            }
            if ((n2 & 0x40) != 0) {
                n = 5;
            }
            if ((n2 & 0x80) != 0) {
                severity = Severity.WARNING;
            }
            if ((n2 & 0x100) != 0) {
                bl = true;
            }
            return companion.create(string, string2, string3, implementation, string4, category, n, severity, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

