/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0003?@AB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010*\u001a\u00020+J*\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u000103H\u0002J2\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00106\u001a\u0004\u0018\u00010\t2\u0006\u00107\u001a\u00020\tJ\b\u00108\u001a\u00020+H\u0002J\u001d\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020;2\u0006\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b<J\u0016\u0010=\u001a\u00020+2\u0006\u00107\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tR\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fRN\u0010#\u001aB\u0012\f\u0012\n %*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n %*\u0004\u0018\u00010&0& %* \u0012\f\u0012\n %*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n %*\u0004\u0018\u00010&0&\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0017\u00a8\u0006B"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;)V", "attributes", "", "", "entriesToWrite", "", "Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "getFile", "()Ljava/io/File;", "fixedCount", "", "getFixedCount", "()I", "<set-?>", "foundErrorCount", "getFoundErrorCount", "setFoundErrorCount", "(I)V", "foundWarningCount", "getFoundWarningCount", "setFoundWarningCount", "isRemoveFixed", "", "()Z", "setRemoveFixed", "(Z)V", "writeOnClose", "isWriteOnClose", "setWriteOnClose", "messageToEntry", "Lcom/google/common/collect/ArrayListMultimap;", "kotlin.jvm.PlatformType", "Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "totalCount", "getTotalCount", "setTotalCount", "close", "", "findAndMark", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "project", "Lcom/android/tools/lint/detector/api/Project;", "getAttribute", "name", "readBaselineFile", "reportBaselineIssues", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "reportBaselineIssues$lint_api", "setAttribute", "value", "Companion", "Entry", "ReportedEntry", "lint-api"})
public final class LintBaseline {
    private int foundErrorCount;
    private int foundWarningCount;
    private int totalCount;
    private final ArrayListMultimap<String, Entry> messageToEntry;
    private boolean isWriteOnClose;
    private boolean isRemoveFixed;
    private List<ReportedEntry> entriesToWrite;
    private Map<String, String> attributes;
    private final LintClient client;
    @NotNull
    private final File file;
    @NotNull
    public static final String VARIANT_ALL = "all";
    @NotNull
    public static final String VARIANT_FATAL = "fatal";
    public static final Companion Companion = new Companion(null);

    public final int getFoundErrorCount() {
        return this.foundErrorCount;
    }

    private final void setFoundErrorCount(int n) {
        this.foundErrorCount = n;
    }

    public final int getFoundWarningCount() {
        return this.foundWarningCount;
    }

    private final void setFoundWarningCount(int n) {
        this.foundWarningCount = n;
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    private final void setTotalCount(int n) {
        this.totalCount = n;
    }

    public final boolean isWriteOnClose() {
        return this.isWriteOnClose;
    }

    public final void setWriteOnClose(boolean writeOnClose) {
        if (writeOnClose) {
            int count = this.totalCount > 0 ? this.totalCount + 10 : 30;
            this.entriesToWrite = new ArrayList(count);
        }
        this.isWriteOnClose = writeOnClose;
    }

    public final boolean isRemoveFixed() {
        return this.isRemoveFixed;
    }

    public final void setRemoveFixed(boolean bl) {
        this.isRemoveFixed = bl;
    }

    public final int getFixedCount() {
        return this.totalCount - this.foundErrorCount - this.foundWarningCount;
    }

    public final void reportBaselineIssues$lint_api(@NotNull LintDriver driver, @NotNull Project project) {
        int fixedCount;
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.foundErrorCount > 0 || this.foundWarningCount > 0) {
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            String message = Companion.describeBaselineFilter(this.foundErrorCount, this.foundWarningCount, LintBaseline.Companion.getDisplayPath(project, baselineFile));
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE, message, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
        if (!((fixedCount = this.getFixedCount()) <= 0 || this.isWriteOnClose && this.isRemoveFixed)) {
            ArrayList sorted;
            Object[] objectArray;
            CharSequence charSequence;
            Object object;
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            HashMap ids = Maps.newHashMap();
            for (Entry entry : this.messageToEntry.values()) {
                Object count = (Object[])ids.get(entry.getIssueId());
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count.intValue() + 1);
                HashMap hashMap = ids;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ids");
                object = hashMap;
                charSequence = entry.getIssueId();
                objectArray = count;
                object.put(charSequence, objectArray);
            }
            ArrayList arrayList = sorted = Lists.newArrayList((Iterable)ids.keySet());
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"sorted");
            CollectionsKt.sort((List)arrayList);
            StringBuilder issueTypes = new StringBuilder();
            for (String id : sorted) {
                charSequence = issueTypes;
                if (charSequence.length() > 0) {
                    issueTypes.append(", ");
                }
                issueTypes.append(id);
                Integer count = (Integer)ids.get(id);
                if (count == null || count <= 1) continue;
                issueTypes.append(" (").append(Integer.toString(count)).append(")");
            }
            object = StringCompanionObject.INSTANCE;
            charSequence = "%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?";
            objectArray = new Object[]{fixedCount, LintBaseline.Companion.getDisplayPath(project, baselineFile)};
            String string = String.format((String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String message = string;
            if (LintClient.Companion.isGradle() && project.getGradleProjectModel() != null) {
                AndroidProject androidProject = project.getGradleProjectModel();
                if (androidProject == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)androidProject, (String)"project.gradleProjectModel!!");
                LintOptions lintOptions = androidProject.getLintOptions();
                Intrinsics.checkExpressionValueIsNotNull((Object)lintOptions, (String)"project.gradleProjectModel!!.lintOptions");
                if (!lintOptions.isCheckDependencies()) {
                    message = message + " Another possible explanation is that lint recently stopped analyzing (and including results from) dependent projects by default. You can turn this back on with `android.lintOptions.checkDependencies=true`.";
                }
            }
            message = message + " Unmatched issue types: " + issueTypes;
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE, message, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
    }

    public final boolean findAndMark(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable Severity severity, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        boolean found = this.findAndMark(issue, location, message, severity);
        if (this.isWriteOnClose && (!this.isRemoveFixed || found) && this.entriesToWrite != null) {
            List<ReportedEntry> list2 = this.entriesToWrite;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            list2.add(new ReportedEntry(issue, project, location, message));
        }
        return found;
    }

    private final boolean findAndMark(Issue issue, Location location, String message, Severity severity) {
        List entries = this.messageToEntry.get((Object)message);
        if (entries == null || entries.isEmpty()) {
            return false;
        }
        File file = location.getFile();
        String path2 = file.getPath();
        String issueId = issue.getId();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Entry entry;
            Entry entry2 = entry = (Entry)iterator.next();
            if (entry2 == null) {
                Intrinsics.throwNpe();
            }
            if (!Intrinsics.areEqual((Object)entry2.getIssueId(), (Object)issueId)) continue;
            String string = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            if (!Companion.isSamePathSuffix(string, entry.getPath())) continue;
            Entry curr = entry;
            while (curr.getPrevious() != null) {
                curr = curr.getPrevious();
            }
            while (curr != null) {
                this.messageToEntry.remove((Object)curr.getMessage(), (Object)curr);
                curr = curr.getNext();
            }
            Severity severity2 = severity;
            if (severity2 == null) {
                severity2 = issue.getDefaultSeverity();
            }
            if (severity2.isError()) {
                int n = this.foundErrorCount;
                this.foundErrorCount = n + 1;
            } else {
                int n = this.foundWarningCount;
                this.foundWarningCount = n + 1;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public final String getAttribute(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Map<String, String> map = this.attributes;
        return map != null ? map.get(name) : null;
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map = this.attributes;
        if (map == null) {
            Map newMap;
            object = this;
            LintBaseline $receiver = (LintBaseline)object;
            $receiver.attributes = newMap = (Map)new LinkedHashMap();
            map = newMap;
        }
        Map attributes = map;
        object = attributes;
        String string = value;
        object.put(name, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readBaselineFile() {
        if (!this.file.exists()) {
            return;
        }
        try {
            var1_1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
            var2_4 = null;
            try {
                reader = (BufferedReader)var1_1;
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((Reader)reader);
                issue = null;
                message = null;
                path = null;
                currentEntry = null;
                while (true) {
                    block41: {
                        block39: {
                            block40: {
                                if (parser.next() == 1) break block39;
                                eventType = parser.getEventType();
                                if (eventType != 3) break block40;
                                tag = parser.getName();
                                if (Intrinsics.areEqual((Object)tag, (Object)"location")) {
                                    if (issue != null && message != null && path != null) {
                                        entry = new Entry(issue, message, path);
                                        if (currentEntry != null) {
                                            currentEntry.setNext(entry);
                                        }
                                        entry.setPrevious(currentEntry);
                                        currentEntry = entry;
                                        this.messageToEntry.put((Object)entry.getMessage(), (Object)entry);
                                    }
                                    break block41;
                                } else if (Intrinsics.areEqual((Object)tag, (Object)"issue")) {
                                    entry = this.totalCount;
                                    this.totalCount = entry + 1;
                                    issue = null;
                                    message = null;
                                    path = null;
                                    currentEntry = null;
                                }
                                break block41;
                            }
                            if (eventType != 2) continue;
                            break block41;
                        }
                        var3_5 = Unit.INSTANCE;
                        CloseableKt.closeFinally((Closeable)var1_1, (Throwable)var2_4);
                        return;
                    }
                    i = 0;
                    n = parser.getAttributeCount();
                    while (true) {
                        if (i >= n) ** break;
                        name = parser.getAttributeName(i);
                        value = parser.getAttributeValue(i);
                        if (name == null) ** GOTO lbl-1000
                        tmp = -1;
                        switch (var14_20.hashCode()) {
                            case 3143036: {
                                if (var14_20.equals("file")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 3159: {
                                if (var14_20.equals("by")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case -1268779017: {
                                if (var14_20.equals("format")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 3355: {
                                if (var14_20.equals("id")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 954925063: {
                                if (var14_20.equals("message")) {
                                    tmp = 4;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 3: {
                                issue = value;
                                break;
                            }
                            case 4: {
                                v0 = message = value;
                                if (v0 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (!StringsKt.startsWith$default((String)v0, (String)"[", (boolean)false, (int)2, null)) break;
                                if (StringsKt.startsWith$default((String)message, (String)"[I18N] ", (boolean)false, (int)2, null)) {
                                    var15_21 = message;
                                    var16_22 = "[I18N] ".length();
                                    v1 = var15_21.substring(var16_22);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).substring(startIndex)");
                                    message = v1;
                                    break;
                                }
                                if (!StringsKt.startsWith$default((String)message, (String)"[Accessibility] ", (boolean)false, (int)2, null)) break;
                                var15_21 = message;
                                var16_22 = "[Accessibility] ".length();
                                v2 = var15_21.substring(var16_22);
                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
                                message = v2;
                                break;
                            }
                            case 1: {
                                path = value;
                                break;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if (parser.getDepth() != 1) break;
                                v3 = name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"name");
                                v4 = value;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"value");
                                this.setAttribute(v3, v4);
                                break;
                            }
                            case 2: 
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (Throwable var3_6) {
                try {
                    var2_4 = var3_6;
                    throw var3_6;
                }
                catch (Throwable var3_7) {
                    CloseableKt.closeFinally((Closeable)var1_1, (Throwable)var2_4);
                    throw var3_7;
                }
            }
        }
        catch (IOException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
                return;
            }
            e.printStackTrace();
            return;
        }
        catch (XmlPullParserException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
                return;
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.isWriteOnClose) {
            boolean mkdirs2;
            File parentFile = this.file.getParentFile();
            if (parentFile != null && !parentFile.exists() && !(mkdirs2 = parentFile.mkdirs())) {
                LintClient lintClient = this.client;
                if (lintClient == null) {
                    Intrinsics.throwNpe();
                }
                lintClient.log(null, "Couldn't create %1$s", parentFile);
                return;
            }
            try {
                Closeable mkdirs2 = new BufferedWriter(new FileWriter(this.file));
                Throwable throwable = null;
                try {
                    Object object;
                    String revision;
                    BufferedWriter writer = (BufferedWriter)mkdirs2;
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    writer.write("<");
                    writer.write("issues");
                    writer.write(" format=\"5\"");
                    LintClient lintClient = this.client;
                    if (lintClient == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((revision = lintClient.getClientDisplayRevision()) != null) {
                        object = StringCompanionObject.INSTANCE;
                        String string = " by=\"lint %1$s\"";
                        Object[] objectArray = new Object[]{revision};
                        BufferedWriter bufferedWriter = writer;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                        String string3 = string2;
                        bufferedWriter.write(string3);
                    }
                    Map<String, String> map = this.attributes;
                    if (map != null) {
                        Object it = object = map;
                        Sequence $receiver$iv = MapsKt.asSequence((Map)it);
                        Sequence sequence = $receiver$iv;
                        Comparator comparator = new Comparator<T>(){

                            public final int compare(T a, T b) {
                                Map.Entry it = (Map.Entry)a;
                                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                                it = (Map.Entry)b;
                                Comparable comparable2 = comparable;
                                String string = (String)it.getKey();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                            }
                        };
                        $receiver$iv = SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator);
                        for (Object element$iv : $receiver$iv) {
                            Map.Entry it2 = (Map.Entry)element$iv;
                            writer.write(' ' + (String)it2.getKey() + "=\"" + XmlUtils.toXmlAttributeValue((String)((String)it2.getValue())) + '\"');
                        }
                    }
                    writer.write(">\n");
                    this.totalCount = 0;
                    if (this.entriesToWrite != null) {
                        List<ReportedEntry> list2 = this.entriesToWrite;
                        if (list2 == null) {
                            Intrinsics.throwNpe();
                        }
                        CollectionsKt.sort(list2);
                        List<ReportedEntry> list3 = this.entriesToWrite;
                        if (list3 == null) {
                            Intrinsics.throwNpe();
                        }
                        for (ReportedEntry entry : list3) {
                            entry.write$lint_api(writer, this.client);
                            int n = this.totalCount;
                            this.totalCount = n + 1;
                        }
                    }
                    writer.write("\n</");
                    writer.write("issues");
                    writer.write(">\n");
                    writer.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)mkdirs2, (Throwable)throwable);
                }
            }
            catch (IOException ioe) {
                LintClient lintClient = this.client;
                if (lintClient == null) {
                    Intrinsics.throwNpe();
                }
                lintClient.log(ioe, null, new Object[0]);
            }
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public LintBaseline(@Nullable LintClient client, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.client = client;
        this.file = file;
        this.messageToEntry = ArrayListMultimap.create((int)100, (int)20);
        this.readBaselineFile();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/android/tools/lint/detector/api/Project;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "getMessage", "()Ljava/lang/String;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "compareTo", "", "other", "write", "", "writer", "Ljava/io/Writer;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "write$lint_api", "lint-api"})
    private static final class ReportedEntry
    implements Comparable<ReportedEntry> {
        @NotNull
        private final Issue issue;
        @Nullable
        private final Project project;
        @NotNull
        private final Location location;
        @NotNull
        private final String message;

        @Override
        public int compareTo(@NotNull ReportedEntry other) {
            File secondaryFile2;
            Location secondary2;
            Location secondary1;
            int otherLine;
            String id2;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
            if (categoryDelta != 0) {
                return categoryDelta;
            }
            int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
            if (priorityDelta != 0) {
                return priorityDelta;
            }
            String id1 = this.issue.getId();
            int idDelta = id1.compareTo(id2 = other.issue.getId());
            if (idDelta != 0) {
                return idDelta;
            }
            File file = this.location.getFile();
            File otherFile = other.location.getFile();
            String string = file.getName();
            String string2 = otherFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"otherFile.name");
            int fileDelta = string.compareTo(string2);
            if (fileDelta != 0) {
                return fileDelta;
            }
            Position start = this.location.getStart();
            Position otherStart = other.location.getStart();
            Position position = start;
            int line = position != null ? position.getLine() : -1;
            Position position2 = otherStart;
            int n = otherLine = position2 != null ? position2.getLine() : -1;
            if (line != otherLine) {
                return line - otherLine;
            }
            int delta = this.message.compareTo(other.message);
            if (delta != 0) {
                return delta;
            }
            delta = file.compareTo(otherFile);
            if (delta != 0) {
                return delta;
            }
            Location location = secondary1 = this.location.getSecondary();
            File secondaryFile1 = location != null ? location.getFile() : null;
            Location location2 = secondary2 = other.location.getSecondary();
            File file2 = secondaryFile2 = location2 != null ? location2.getFile() : null;
            if (secondaryFile1 != null) {
                return secondaryFile2 != null ? secondaryFile1.compareTo(secondaryFile2) : -1;
            }
            if (secondaryFile2 != null) {
                return 1;
            }
            if (start != null && otherStart != null && (delta = start.getColumn() - otherStart.getColumn()) != 0) {
                return delta;
            }
            return 0;
        }

        public final void write$lint_api(@NotNull Writer writer, @NotNull LintClient client) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            try {
                writer.write("\n");
                Companion.indent(writer, 1);
                writer.write("<");
                writer.write("issue");
                Companion.writeAttribute(writer, 2, "id", this.issue.getId());
                Companion.writeAttribute(writer, 2, "message", this.message);
                writer.write(">\n");
                for (Location currentLocation = this.location; currentLocation != null; currentLocation = currentLocation.getSecondary()) {
                    int line;
                    Companion.indent(writer, 2);
                    writer.write("<");
                    writer.write("location");
                    String path2 = Companion.getDisplayPath(this.project, currentLocation.getFile());
                    Companion.writeAttribute(writer, 3, "file", path2);
                    Position start = currentLocation.getStart();
                    if (start != null && (line = start.getLine()) >= 0) {
                        String string = Integer.toString(line + 1);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(line + 1)");
                        Companion.writeAttribute(writer, 3, "line", string);
                    }
                    writer.write("/>\n");
                }
                Companion.indent(writer, 1);
                writer.write("</");
                writer.write("issue");
                writer.write(">\n");
            }
            catch (IOException ioe) {
                client.log(ioe, null, new Object[0]);
            }
        }

        @NotNull
        public final Issue getIssue() {
            return this.issue;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public ReportedEntry(@NotNull Issue issue, @Nullable Project project, @NotNull Location location, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.issue = issue;
            this.project = project;
            this.location = location;
            this.message = message;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "", "issueId", "", "message", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIssueId", "()Ljava/lang/String;", "getMessage", "next", "getNext", "()Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "setNext", "(Lcom/android/tools/lint/client/api/LintBaseline$Entry;)V", "getPath", "previous", "getPrevious", "setPrevious", "lint-api"})
    private static final class Entry {
        @Nullable
        private Entry next;
        @Nullable
        private Entry previous;
        @NotNull
        private final String issueId;
        @NotNull
        private final String message;
        @NotNull
        private final String path;

        @Nullable
        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry entry) {
            this.next = entry;
        }

        @Nullable
        public final Entry getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@Nullable Entry entry) {
            this.previous = entry;
        }

        @NotNull
        public final String getIssueId() {
            return this.issueId;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public Entry(@NotNull String issueId, @NotNull String message, @NotNull String path2) {
            Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
            this.issueId = issueId;
            this.message = message;
            this.path = path2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004J\u001a\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J(\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Companion;", "", "()V", "VARIANT_ALL", "", "VARIANT_FATAL", "describeBaselineFilter", "errors", "", "warnings", "baselineDisplayPath", "getDisplayPath", "project", "Lcom/android/tools/lint/detector/api/Project;", "file", "Ljava/io/File;", "indent", "", "writer", "Ljava/io/Writer;", "isFilteredMessage", "", "errorMessage", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "isFixedMessage", "isSamePathSuffix", "path", "suffix", "writeAttribute", "name", "value", "lint-api"})
    public static final class Companion {
        public final boolean isFilteredMessage(@NotNull String errorMessage, @NotNull TextFormat format) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            return StringsKt.contains$default((CharSequence)format.toText(errorMessage), (CharSequence)"filtered out because", (boolean)false, (int)2, null);
        }

        public final boolean isFixedMessage(@NotNull String errorMessage, @NotNull TextFormat format) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            return StringsKt.contains$default((CharSequence)format.toText(errorMessage), (CharSequence)"perhaps they have been fixed", (boolean)false, (int)2, null);
        }

        @NotNull
        public final String describeBaselineFilter(int errors, int warnings, @NotNull String baselineDisplayPath) {
            Intrinsics.checkParameterIsNotNull((Object)baselineDisplayPath, (String)"baselineDisplayPath");
            String counts = Lint.describeCounts(errors, warnings, false, true);
            return errors + warnings == 1 ? counts + " was filtered out because it is listed in the baseline file, " + baselineDisplayPath + '\n' : counts + " were filtered out because they are listed in the baseline file, " + baselineDisplayPath + '\n';
        }

        public final boolean isSamePathSuffix(@NotNull String path2, @NotNull String suffix) {
            char c;
            int begin;
            Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
            int i = path2.length() - 1;
            int j = suffix.length() - 1;
            for (begin = 0; begin < j && ((c = suffix.charAt(begin)) == '.' || c == '/' || c == '\\'); ++begin) {
            }
            if (j - begin > i) {
                return false;
            }
            while (j > begin) {
                int c2;
                int c1 = path2.charAt(i);
                if (c1 != (c2 = suffix.charAt(j))) {
                    if (c1 == 92) {
                        c1 = 47;
                    }
                    if (c2 == 92) {
                        c2 = 47;
                    }
                    if (c1 != c2) {
                        return false;
                    }
                }
                --i;
                --j;
            }
            return true;
        }

        private final String getDisplayPath(Project project, File file) {
            String path2 = file.getPath();
            if (project != null) {
                String string = path2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                File file2 = project.getReferenceDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.referenceDir");
                String string2 = file2.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.referenceDir.path");
                if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                    File file3 = project.getReferenceDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.referenceDir");
                    int chop = file3.getPath().length();
                    if (path2.length() > chop && path2.charAt(chop) == File.separatorChar) {
                        ++chop;
                    }
                    CharSequence charSequence = path2;
                    String string3 = ((String)charSequence).substring(chop);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    path2 = string3;
                    charSequence = path2;
                    if (charSequence.length() == 0) {
                        path2 = file.getName();
                    }
                }
            }
            String string = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            return string;
        }

        private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
            writer.write("\n");
            this.indent(writer, indent);
            writer.write(name);
            writer.write("=\"");
            writer.write(XmlUtils.toXmlAttributeValue((String)value));
            writer.write("\"");
        }

        /*
         * WARNING - void declaration
         */
        private final void indent(Writer writer, int indent) throws IOException {
            int n = 0;
            int n2 = indent;
            while (n < n2) {
                void level;
                writer.write("    ");
                ++level;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

