/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\f\b'\u0018\u0000 12\u00020\u0001:\u00011B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J[\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00182\u001a\u0010%\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0&\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b'J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0010\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010+\u001a\u00020\fJ\u0016\u0010,\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u000e\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\fJ\u000e\u00100\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R&\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry;", "", "()V", "api", "", "getApi", "()I", "categories", "", "Lcom/android/tools/lint/detector/api/Category;", "idToIssue", "", "", "Lcom/android/tools/lint/detector/api/Issue;", "isUpToDate", "", "()Z", "issues", "getIssues", "()Ljava/util/List;", "minApi", "getMinApi", "scopeIssues", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "cacheable", "createCategoryList", "createDetectors", "Lcom/android/tools/lint/detector/api/Detector;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "scope", "platforms", "Lcom/android/tools/lint/detector/api/Platform;", "scopeToDetectors", "", "createDetectors$lint_api", "createIdToIssueMap", "getCategories", "getIssue", "id", "getIssueCapacity", "getIssuesForScope", "isCategoryName", "name", "isIssueId", "Companion", "lint-api"})
@Beta
public abstract class IssueRegistry {
    private final int api = -1;
    private final boolean isUpToDate = true;
    private volatile List<Category> categories;
    private volatile Map<String, Issue> idToIssue;
    private Map<EnumSet<Scope>, List<Issue>> scopeIssues;
    private static volatile List<Category> cachedCategories;
    private static volatile Map<String, Issue> cachedIdToIssue;
    private static Map<EnumSet<Scope>, List<Issue>> cachedScopeIssues;
    private static final Implementation DUMMY_IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue PARSER_ERROR;
    @JvmField
    @NotNull
    public static final Issue LINT_ERROR;
    @JvmField
    @NotNull
    public static final Issue CANCELLED;
    @JvmField
    @NotNull
    public static final Issue BASELINE;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_LINT_CHECK;
    public static final Companion Companion;

    public int getApi() {
        return this.api;
    }

    public int getMinApi() {
        return this.getApi();
    }

    @NotNull
    public abstract List<Issue> getIssues();

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    protected int getIssueCapacity(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        return 20;
    }

    @NotNull
    protected List<Issue> getIssuesForScope(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        List list2 = this.scopeIssues.get(scope);
        if (list2 == null) {
            List<Issue> issues = this.getIssues();
            if (Intrinsics.areEqual(scope, Scope.ALL)) {
                list2 = issues;
            } else {
                list2 = new ArrayList(this.getIssueCapacity(scope));
                for (Issue issue : issues) {
                    if (!issue.getImplementation().isAdequate(scope)) continue;
                    ((ArrayList)list2).add(issue);
                }
            }
            this.scopeIssues.put(scope, list2);
        }
        return list2;
    }

    @NotNull
    public final List<Detector> createDetectors$lint_api(@NotNull LintClient client, @NotNull Configuration configuration, @NotNull EnumSet<Scope> scope, @NotNull EnumSet<Platform> platforms, @Nullable Map<Scope, List<Detector>> scopeToDetectors) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull(platforms, (String)"platforms");
        List<Issue> issues = this.getIssuesForScope(scope);
        if (issues.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HashSet<Class<? extends Detector>> detectorClasses = new HashSet<Class<? extends Detector>>();
        HashMap detectorToScope = new HashMap();
        for (Issue issue : issues) {
            EnumSet<Scope> issueScope;
            Class<? extends Detector> detectorClass;
            if (!issue.getPlatforms().isEmpty() && !issue.getPlatforms().containsAll((Collection)platforms)) continue;
            Implementation implementation = issue.getImplementation();
            Intrinsics.checkExpressionValueIsNotNull(implementation.getDetectorClass(), (String)"implementation.detectorClass");
            Intrinsics.checkExpressionValueIsNotNull(implementation.getScope(), (String)"implementation.scope");
            if (!detectorClasses.contains(detectorClass)) {
                if (!configuration.isEnabled(issue)) continue;
                boolean bl = implementation.isAdequate(scope);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                detectorClass = client.replaceDetector(detectorClass);
                detectorClasses.add(detectorClass);
            }
            if (scopeToDetectors == null) continue;
            EnumSet s = (EnumSet)detectorToScope.get(detectorClass);
            if (s == null) {
                ((Map)detectorToScope).put(detectorClass, issueScope);
                continue;
            }
            if (s.containsAll((Collection)issueScope)) continue;
            EnumSet union = EnumSet.copyOf(s);
            union.addAll(issueScope);
            Map map = detectorToScope;
            EnumSet enumSet = union;
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"union");
            map.put(detectorClass, enumSet);
        }
        ArrayList<Detector> detectors = new ArrayList<Detector>(detectorClasses.size());
        for (Class clazz : detectorClasses) {
            try {
                EnumSet union;
                Detector detector = (Detector)clazz.newInstance();
                detectors.add(detector);
                if (scopeToDetectors == null) continue;
                if ((EnumSet)detectorToScope.get(clazz) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)union, (String)"detectorToScope[clz] ?: continue");
                for (Scope s : union) {
                    List list2 = scopeToDetectors.get((Object)s);
                    if (list2 == null) {
                        list2 = new ArrayList();
                        Scope scope2 = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)scope2), (String)"s");
                        scopeToDetectors.put(scope2, list2);
                    }
                    Detector detector2 = detector;
                    Intrinsics.checkExpressionValueIsNotNull((Object)detector2, (String)"detector");
                    list2.add(detector2);
                }
            }
            catch (Throwable t) {
                Object[] objectArray = new Object[1];
                Class clazz2 = clazz;
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz2, (String)"clz");
                String string = clazz2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clz.name");
                objectArray[0] = string;
                client.log(t, "Can't initialize detector %1$s", objectArray);
            }
        }
        return detectors;
    }

    public final boolean isIssueId(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.getIssue(id) != null;
    }

    public final boolean isCategoryName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        for (Category category : this.getCategories()) {
            if (!Intrinsics.areEqual((Object)category.getName(), (Object)name) && !Intrinsics.areEqual((Object)category.getFullName(), (Object)name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<Category> getCategories() {
        List<Category> categories = this.categories;
        if (categories == null) {
            this.categories = categories = Collections.unmodifiableList(this.createCategoryList());
            if (this.cacheable()) {
                cachedCategories = categories;
            }
        }
        List<Category> list2 = categories;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        return list2;
    }

    private final List<Category> createCategoryList() {
        HashSet categorySet = Sets.newHashSetWithExpectedSize((int)20);
        for (Issue issue : this.getIssues()) {
            categorySet.add(issue.getCategory());
        }
        ArrayList sorted = new ArrayList(categorySet);
        CollectionsKt.sort((List)sorted);
        return sorted;
    }

    @Nullable
    public final Issue getIssue(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Map<String, Issue> map = this.idToIssue;
        if (map == null) {
            this.idToIssue = map = this.createIdToIssueMap();
            if (this.cacheable()) {
                cachedIdToIssue = map;
            }
        }
        return map.get(id);
    }

    private final Map<String, Issue> createIdToIssueMap() {
        List<Issue> issues = this.getIssues();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(issues.size() + 2));
        for (Issue issue : issues) {
            HashMap hashMap = map;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"map");
            ((Map)hashMap).put(issue.getId(), issue);
        }
        HashMap hashMap = map;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"map");
        ((Map)hashMap).put(PARSER_ERROR.getId(), PARSER_ERROR);
        ((Map)map).put(LINT_ERROR.getId(), LINT_ERROR);
        ((Map)map).put(BASELINE.getId(), BASELINE);
        ((Map)map).put(OBSOLETE_LINT_CHECK.getId(), OBSOLETE_LINT_CHECK);
        return map;
    }

    protected boolean cacheable() {
        return false;
    }

    protected IssueRegistry() {
        if (this.cacheable()) {
            this.scopeIssues = cachedScopeIssues;
            this.idToIssue = cachedIdToIssue;
            this.categories = cachedCategories;
        } else {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
            this.scopeIssues = hashMap;
            this.idToIssue = null;
            this.categories = null;
        }
    }

    static {
        Companion = new Companion(null);
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
        cachedScopeIssues = hashMap;
        DUMMY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
        PARSER_ERROR = Issue.Companion.create("ParserError", "Parser Errors", "\n                Lint will ignore any files that contain fatal parsing errors. These may \\\n                contain other errors, or contain code which affects issues in other files.", Category.LINT, 10, Severity.ERROR, DUMMY_IMPLEMENTATION);
        LINT_ERROR = Issue.Companion.create("LintError", "Lint Failure", "\n                This issue type represents a problem running lint itself. Examples include \\\n                failure to find bytecode for source files (which means certain detectors \\\n                could not be run), parsing errors in lint configuration files, etc.\n\n                These errors are not errors in your own code, but they are shown to make it \\\n                clear that some checks were not completed.\n                ", Category.LINT, 10, Severity.ERROR, DUMMY_IMPLEMENTATION);
        CANCELLED = Issue.Companion.create("LintCanceled", "Lint Canceled", "Lint canceled by user; the issue report may not be complete.", Category.LINT, 0, Severity.INFORMATIONAL, DUMMY_IMPLEMENTATION);
        BASELINE = Issue.Companion.create("LintBaseline", "Baseline Issues", "\n                Lint can be configured with a \"baseline\"; a set of current issues found \\\n                in a codebase, which future runs of lint will silently ignore. Only new \\\n                issues not found in the baseline are reported.\n\n                Note that while opening files in the IDE, baseline issues are not \\\n                filtered out; the purpose of baselines is to allow you to get started \\\n                using lint and break the build on all newly introduced errors, without \\\n                having to go back and fix the entire codebase up front. However, when \\\n                you open up existing files you still want to be aware of and fix issues \\\n                as you come across them.\n\n                This issue type is used to emit two types of informational messages in \\\n                reports: first, whether any issues were filtered out so you don't have \\\n                a false sense of security if you forgot that you've checked in a \\\n                baseline file, and second, whether any issues in the baseline file \\\n                appear to have been fixed such that you can stop filtering them out and \\\n                get warned if the issues are re-introduced.", Category.LINT, 10, Severity.INFORMATIONAL, DUMMY_IMPLEMENTATION);
        OBSOLETE_LINT_CHECK = Issue.Companion.create("ObsoleteLintCustomCheck", "Obsolete custom lint check", "\n                Lint can be extended with \"custom checks\": additional checks implemented \\\n                by developers and libraries to for example enforce specific API usages \\\n                required by a library or a company coding style guideline.\n\n                The Lint APIs are not yet stable, so these checks may either cause a \\\n                performance degradation, or stop working, or provide wrong results.\n\n                This warning flags custom lint checks that are found to be using obsolete \\\n                APIs and will need to be updated to run in the current lint environment.\n\n                It may also flag issues found to be using a **newer** version of the API, \\\n                meaning that you need to use a newer version of lint (or Android Studio \\\n                or Gradle plugin etc) to work with these checks.", Category.LINT, 10, Severity.WARNING, DUMMY_IMPLEMENTATION);
    }

    public static final /* synthetic */ Map access$getCachedIdToIssue$cp() {
        return cachedIdToIssue;
    }

    public static final /* synthetic */ List access$getCachedCategories$cp() {
        return cachedCategories;
    }

    public static final /* synthetic */ Map access$getCachedScopeIssues$cp() {
        return cachedScopeIssues;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry$Companion;", "", "()V", "BASELINE", "Lcom/android/tools/lint/detector/api/Issue;", "CANCELLED", "DUMMY_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "LINT_ERROR", "OBSOLETE_LINT_CHECK", "PARSER_ERROR", "cachedCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "cachedIdToIssue", "", "", "cachedScopeIssues", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "reset", "", "lint-api"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reset() {
            Class<IssueRegistry> clazz = IssueRegistry.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                boolean bl3 = false;
                cachedIdToIssue = null;
                cachedCategories = null;
                HashMap hashMap = Maps.newHashMap();
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
                cachedScopeIssues = hashMap;
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

