/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.AnnotationValuesExtractor;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/lint/detector/api/UastLintUtils;", "", "()V", "Companion", "lint-api"})
public final class UastLintUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final UDeclaration tryResolveUDeclaration(@NotNull UElement $this$tryResolveUDeclaration) {
        return Companion.tryResolveUDeclaration($this$tryResolveUDeclaration);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getContainingFile(@NotNull JavaContext context2, @Nullable PsiElement element) {
        return Companion.getContainingFile(context2, element);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getPsiFile(@Nullable UFile file) {
        return Companion.getPsiFile(file);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getContainingFile(@Nullable PsiElement element) {
        return Companion.getContainingFile(element);
    }

    @JvmStatic
    @Nullable
    public static final String getQualifiedName(@NotNull PsiElement element) {
        return Companion.getQualifiedName(element);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement resolve(@NotNull ExternalReferenceExpression expression, @NotNull UElement context2) {
        return Companion.resolve(expression, context2);
    }

    @JvmStatic
    @NotNull
    public static final String getClassName(@NotNull PsiClassType type) {
        return Companion.getClassName(type);
    }

    @JvmStatic
    @NotNull
    public static final String getClassName(@NotNull PsiClass psiClass) {
        return Companion.getClassName(psiClass);
    }

    @JvmStatic
    @Nullable
    public static final UExpression findLastAssignment(@NotNull PsiVariable variable, @NotNull UElement call) {
        return Companion.findLastAssignment(variable, call);
    }

    @JvmStatic
    @Nullable
    public static final String getReferenceName(@NotNull UReferenceExpression expression) {
        return Companion.getReferenceName(expression);
    }

    @JvmStatic
    @Nullable
    public static final Object findLastValue(@NotNull PsiVariable variable, @NotNull UElement call, @NotNull ConstantEvaluator evaluator) {
        return Companion.findLastValue(variable, call, evaluator);
    }

    @JvmStatic
    @Nullable
    public static final ResourceReference toAndroidReferenceViaResolve(@NotNull UElement element) {
        return Companion.toAndroidReferenceViaResolve(element);
    }

    @JvmStatic
    public static final boolean areIdentifiersEqual(@NotNull UExpression first, @NotNull UExpression second) {
        return Companion.areIdentifiersEqual(first, second);
    }

    @JvmStatic
    @Nullable
    public static final String getIdentifier(@NotNull UExpression expression) {
        return Companion.getIdentifier(expression);
    }

    @JvmStatic
    public static final boolean isNumber(@NotNull UElement argument) {
        return Companion.isNumber(argument);
    }

    @JvmStatic
    public static final boolean isZero(@NotNull UElement argument) {
        return Companion.isZero(argument);
    }

    @JvmStatic
    public static final boolean isMinusOne(@NotNull UElement argument) {
        return Companion.isMinusOne(argument);
    }

    @JvmStatic
    @Nullable
    public static final UExpression getAnnotationValue(@NotNull UAnnotation annotation) {
        return Companion.getAnnotationValue(annotation);
    }

    @JvmStatic
    public static final long getLongAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, long defaultValue) {
        return Companion.getLongAttribute(context2, annotation, name, defaultValue);
    }

    @JvmStatic
    public static final double getDoubleAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, double defaultValue) {
        return Companion.getDoubleAttribute(context2, annotation, name, defaultValue);
    }

    @JvmStatic
    public static final boolean getBoolean(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, boolean defaultValue) {
        return Companion.getBoolean(context2, annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final Boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationBooleanValue(annotation, name);
    }

    @JvmStatic
    public static final boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name, boolean defaultValue) {
        return Companion.getAnnotationBooleanValue(annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final Long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationLongValue(annotation, name);
    }

    @JvmStatic
    public static final long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name, long defaultValue) {
        return Companion.getAnnotationLongValue(annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final Double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationDoubleValue(annotation, name);
    }

    @JvmStatic
    public static final double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name, double defaultValue) {
        return Companion.getAnnotationDoubleValue(annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final String getAnnotationStringValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationStringValue(annotation, name);
    }

    @JvmStatic
    @Nullable
    public static final String[] getAnnotationStringValues(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationStringValues(annotation, name);
    }

    @JvmStatic
    public static final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list2, @NotNull UAnnotation annotation) {
        return Companion.containsAnnotation(list2, annotation);
    }

    @JvmStatic
    public static final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list2, @NotNull String qualifiedName) {
        return Companion.containsAnnotation(list2, qualifiedName);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u001e\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001e\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J!\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u0017\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J!\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001cH\u0007J!\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010 J\"\u0010\u001e\u001a\u00020\u001f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001fH\u0007J\u001c\u0010!\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0007J'\u0010\"\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010#2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J(\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0010\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+H\u0007J\u0010\u0010)\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0007J\u001c\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010'\u001a\u00020(2\b\u00100\u001a\u0004\u0018\u000101H\u0007J\u0014\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u000101H\u0007J(\u00102\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001cH\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\r2\u0006\u00104\u001a\u00020\u0006H\u0007J(\u00105\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001fH\u0007J\u0014\u00106\u001a\u0004\u0018\u00010/2\b\u00107\u001a\u0004\u0018\u000108H\u0007J\u0012\u00109\u001a\u0004\u0018\u00010\r2\u0006\u00100\u001a\u000201H\u0007J\u0012\u0010:\u001a\u0004\u0018\u00010\r2\u0006\u00104\u001a\u00020;H\u0007J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0013H\u0007J\u0010\u0010>\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0013H\u0007J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0013H\u0007J\u001a\u0010@\u001a\u0004\u0018\u0001012\u0006\u00104\u001a\u00020A2\u0006\u0010'\u001a\u00020\u0013H\u0007J\u0012\u0010B\u001a\u0004\u0018\u00010C2\u0006\u00100\u001a\u00020\u0013H\u0007J\u000e\u0010D\u001a\u0004\u0018\u00010E*\u00020\u0013H\u0007\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/detector/api/UastLintUtils$Companion;", "", "()V", "areIdentifiersEqual", "", "first", "Lorg/jetbrains/uast/UExpression;", "second", "containsAnnotation", "list", "", "Lorg/jetbrains/uast/UAnnotation;", "qualifiedName", "", "annotation", "findLastAssignment", "variable", "Lcom/intellij/psi/PsiVariable;", "call", "Lorg/jetbrains/uast/UElement;", "findLastValue", "evaluator", "Lcom/android/tools/lint/detector/api/ConstantEvaluator;", "getAnnotationBooleanValue", "name", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)Ljava/lang/Boolean;", "defaultValue", "getAnnotationDoubleValue", "", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)Ljava/lang/Double;", "getAnnotationLongValue", "", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)Ljava/lang/Long;", "getAnnotationStringValue", "getAnnotationStringValues", "", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)[Ljava/lang/String;", "getAnnotationValue", "getBoolean", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getClassName", "psiClass", "Lcom/intellij/psi/PsiClass;", "type", "Lcom/intellij/psi/PsiClassType;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "getDoubleAttribute", "getIdentifier", "expression", "getLongAttribute", "getPsiFile", "file", "Lorg/jetbrains/uast/UFile;", "getQualifiedName", "getReferenceName", "Lorg/jetbrains/uast/UReferenceExpression;", "isMinusOne", "argument", "isNumber", "isZero", "resolve", "Lcom/android/tools/lint/detector/api/ExternalReferenceExpression;", "toAndroidReferenceViaResolve", "Lcom/android/tools/lint/client/api/ResourceReference;", "tryResolveUDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final UDeclaration tryResolveUDeclaration(@NotNull UElement $this$tryResolveUDeclaration) {
            Intrinsics.checkNotNullParameter((Object)$this$tryResolveUDeclaration, (String)"<this>");
            UResolvable uResolvable = $this$tryResolveUDeclaration instanceof UResolvable ? (UResolvable)$this$tryResolveUDeclaration : null;
            PsiElement $this$toUElementOfType$iv = uResolvable == null ? null : uResolvable.resolve();
            boolean $i$f$toUElementOfType = false;
            return (UDeclaration)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UDeclaration.class);
        }

        @JvmStatic
        @Nullable
        public final PsiFile getContainingFile(@NotNull JavaContext context2, @Nullable PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (element == null) {
                return null;
            }
            PsiFile containingFile = element.getContainingFile();
            return !Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile()) ? this.getContainingFile(element) : containingFile;
        }

        @JvmStatic
        @Nullable
        public final PsiFile getPsiFile(@Nullable UFile file) {
            PsiFile psiFile;
            UFile uFile = file;
            if (uFile == null) {
                psiFile = null;
            } else {
                UFile uFile2 = uFile;
                boolean bl = false;
                boolean bl2 = false;
                UFile it = uFile2;
                boolean bl3 = false;
                psiFile = Companion.getContainingFile((PsiElement)it.getPsi());
            }
            return psiFile;
        }

        @JvmStatic
        @Nullable
        public final PsiFile getContainingFile(@Nullable PsiElement element) {
            PsiFile psiFile;
            if (element == null) {
                return null;
            }
            PsiFile psiFile2 = element instanceof PsiFile ? (PsiFile)element : null;
            PsiFile psiFile3 = psiFile = psiFile2 == null ? element.getContainingFile() : psiFile2;
            if (psiFile == null) {
                return null;
            }
            PsiFile containingFile = psiFile;
            Class<?> cls = containingFile.getClass();
            String name = cls.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (StringsKt.startsWith$default((String)name, (String)"org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration", (boolean)false, (int)2, null)) {
                try {
                    Field declaredField = cls.getSuperclass().getDeclaredField("ktFile");
                    declaredField.setAccessible(true);
                    Object o = declaredField.get(containingFile);
                    if (o instanceof PsiFile) {
                        return (PsiFile)o;
                    }
                }
                catch (Throwable declaredField) {}
            } else if (Intrinsics.areEqual((Object)name, (Object)"org.jetbrains.kotlin.asJava.elements.FakeFileForLightClass")) {
                try {
                    Field declaredField = cls.getDeclaredField("ktFile");
                    declaredField.setAccessible(true);
                    Object o = declaredField.get(containingFile);
                    if (o instanceof PsiFile) {
                        return (PsiFile)o;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return containingFile;
        }

        @JvmStatic
        @Nullable
        public final String getQualifiedName(@NotNull PsiElement element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            if (psiElement instanceof PsiClass) {
                string = ((PsiClass)element).getQualifiedName();
            } else if (psiElement instanceof PsiMethod) {
                PsiClass psiClass = ((PsiMethod)element).getContainingClass();
                if (psiClass == null) {
                    string = null;
                } else {
                    Object object = psiClass;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiClass it = object;
                    boolean bl3 = false;
                    String string2 = Companion.getQualifiedName((PsiElement)it);
                    if (string2 == null) {
                        string = null;
                    } else {
                        object = string2;
                        bl = false;
                        bl2 = false;
                        it = object;
                        boolean bl4 = false;
                        string = (String)it + '.' + ((PsiMethod)element).getName();
                    }
                }
            } else if (psiElement instanceof PsiField) {
                PsiClass psiClass = ((PsiField)element).getContainingClass();
                if (psiClass == null) {
                    string = null;
                } else {
                    Object object = psiClass;
                    boolean bl = false;
                    boolean bl5 = false;
                    PsiClass it = object;
                    boolean bl6 = false;
                    String string3 = Companion.getQualifiedName((PsiElement)it);
                    if (string3 == null) {
                        string = null;
                    } else {
                        object = string3;
                        bl = false;
                        bl5 = false;
                        it = object;
                        boolean bl7 = false;
                        string = (String)it + '.' + ((PsiField)element).getName();
                    }
                }
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        @Nullable
        public final PsiElement resolve(@NotNull ExternalReferenceExpression expression, @NotNull UElement context2) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            UDeclaration uDeclaration = (UDeclaration)UastUtils.getParentOfType$default((UElement)context2, UDeclaration.class, (boolean)false, (int)2, null);
            if (uDeclaration == null) {
                return null;
            }
            UDeclaration declaration = uDeclaration;
            return expression.resolve((PsiElement)declaration.getPsi());
        }

        @JvmStatic
        @NotNull
        public final String getClassName(@NotNull PsiClassType type) {
            Object object;
            Object object2;
            PsiClass psiClass;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Object object3 = psiClass = type.resolve();
            if (object3 == null) {
                object2 = null;
            } else {
                PsiClass psiClass2 = object3;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass2;
                boolean bl3 = false;
                object2 = Companion.getClassName(it);
            }
            Object object4 = object2;
            if (object4 == null) {
                object3 = type.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"type.className");
                object = object3;
            } else {
                object = object4;
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final String getClassName(@NotNull PsiClass psiClass) {
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(psiClass.getName());
            for (PsiClass currPsiClass = psiClass.getContainingClass(); currPsiClass != null; currPsiClass = currPsiClass.getContainingClass()) {
                stringBuilder.insert(0, Intrinsics.stringPlus((String)currPsiClass.getName(), (Object)"."));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
            return string;
        }

        @JvmStatic
        @Nullable
        public final UExpression findLastAssignment(@NotNull PsiVariable variable, @NotNull UElement call) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            PsiVariable currVariable = variable;
            UElement lastAssignment = null;
            if (currVariable instanceof UVariable) {
                currVariable = ((UVariable)currVariable).getPsi();
            }
            if (!currVariable.hasModifierProperty("final") && (currVariable instanceof PsiLocalVariable || currVariable instanceof PsiParameter)) {
                UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
                if (containingFunction != null) {
                    ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(currVariable, call, null, -1);
                    containingFunction.accept((UastVisitor)finder);
                    lastAssignment = finder.getLastAssignment();
                }
            } else {
                lastAssignment = (UElement)UastFacade.INSTANCE.getInitializerBody(currVariable);
            }
            return lastAssignment instanceof UExpression ? (UExpression)lastAssignment : null;
        }

        @JvmStatic
        @Nullable
        public final String getReferenceName(@NotNull UReferenceExpression expression) {
            UExpression selector;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (expression instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expression).getIdentifier();
            }
            if (expression instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)expression).getSelector()) instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)selector).getIdentifier();
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Object findLastValue(@NotNull PsiVariable variable, @NotNull UElement call, @NotNull ConstantEvaluator evaluator) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Object value = null;
            if (!variable.hasModifierProperty("final") && (variable instanceof PsiLocalVariable || variable instanceof PsiParameter)) {
                UExpression body;
                UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
                if (containingFunction != null && (body = containingFunction.getUastBody()) != null) {
                    ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable, call, evaluator, 1);
                    body.accept((UastVisitor)finder);
                    value = finder.getCurrentValue();
                    if (value == null && finder.getLastAssignment() != null) {
                        return ConstantEvaluator.LastAssignmentFinder.LAST_ASSIGNMENT_VALUE_UNKNOWN;
                    }
                }
            } else {
                UExpression initializer = UastFacade.INSTANCE.getInitializerBody(variable);
                if (initializer != null) {
                    value = initializer.evaluate();
                }
            }
            return value;
        }

        @JvmStatic
        @Nullable
        public final ResourceReference toAndroidReferenceViaResolve(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return ResourceReference.Companion.get(element);
        }

        @JvmStatic
        public final boolean areIdentifiersEqual(@NotNull UExpression first, @NotNull UExpression second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            String firstIdentifier = this.getIdentifier(first);
            String secondIdentifier = this.getIdentifier(second);
            return firstIdentifier != null && secondIdentifier != null && Intrinsics.areEqual((Object)firstIdentifier, (Object)secondIdentifier);
        }

        @JvmStatic
        @Nullable
        public final String getIdentifier(@NotNull UExpression expression) {
            String string;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            UExpression uExpression = expression;
            if (uExpression instanceof ULiteralExpression) {
                string = expression.asRenderString();
            } else if (uExpression instanceof UQualifiedReferenceExpression) {
                String receiverIdentifier = this.getIdentifier(((UQualifiedReferenceExpression)expression).getReceiver());
                String selectorIdentifier = this.getIdentifier(((UQualifiedReferenceExpression)expression).getSelector());
                string = receiverIdentifier == null || selectorIdentifier == null ? (String)null : receiverIdentifier + '.' + selectorIdentifier;
            } else {
                string = null;
            }
            return string;
        }

        @JvmStatic
        public final boolean isNumber(@NotNull UElement argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            UElement uElement = argument;
            return uElement instanceof ULiteralExpression ? ((ULiteralExpression)argument).getValue() instanceof Number : (uElement instanceof UPrefixExpression ? this.isNumber((UElement)((UPrefixExpression)argument).getOperand()) : false);
        }

        @JvmStatic
        public final boolean isZero(@NotNull UElement argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            if (argument instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)argument).getValue();
                return value instanceof Number && ((Number)value).intValue() == 0;
            }
            return false;
        }

        @JvmStatic
        public final boolean isMinusOne(@NotNull UElement argument) {
            Object value;
            UExpression operand;
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            boolean bl = argument instanceof UUnaryExpression ? ((operand = ((UUnaryExpression)argument).getOperand()) instanceof ULiteralExpression && ((UUnaryExpression)argument).getOperator() == UastPrefixOperator.UNARY_MINUS ? (value = ((ULiteralExpression)operand).getValue()) instanceof Number && ((Number)value).intValue() == 1 : false) : false;
            return bl;
        }

        @JvmStatic
        @Nullable
        public final UExpression getAnnotationValue(@NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            return annotation.findDeclaredAttributeValue("value");
        }

        @JvmStatic
        public final long getLongAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, long defaultValue) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getAnnotationLongValue(annotation, name, defaultValue);
        }

        @JvmStatic
        public final double getDoubleAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, double defaultValue) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getAnnotationDoubleValue(annotation, name, defaultValue);
        }

        @JvmStatic
        public final boolean getBoolean(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getAnnotationBooleanValue(annotation, name, defaultValue);
        }

        @JvmStatic
        @Nullable
        public final Boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationBooleanValue$lint_api(annotation, name);
        }

        @JvmStatic
        public final boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name, boolean defaultValue) {
            Boolean value;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Boolean bl = value = this.getAnnotationBooleanValue(annotation, name);
            return bl == null ? defaultValue : bl;
        }

        @JvmStatic
        @Nullable
        public final Long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationLongValue$lint_api(annotation, name);
        }

        @JvmStatic
        public final long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name, long defaultValue) {
            Long value;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Long l = value = this.getAnnotationLongValue(annotation, name);
            return l == null ? defaultValue : l;
        }

        @JvmStatic
        @Nullable
        public final Double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationDoubleValue$lint_api(annotation, name);
        }

        @JvmStatic
        public final double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name, double defaultValue) {
            Double value;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Double d = value = this.getAnnotationDoubleValue(annotation, name);
            return d == null ? defaultValue : d;
        }

        @JvmStatic
        @Nullable
        public final String getAnnotationStringValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationStringValue$lint_api(annotation, name);
        }

        @JvmStatic
        @Nullable
        public final String[] getAnnotationStringValues(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationStringValues$lint_api(annotation, name);
        }

        @JvmStatic
        public final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list2, @NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            return list2.stream().anyMatch((Predicate)new Predicate<UAnnotation>(annotation){
                final /* synthetic */ UAnnotation $annotation;
                {
                    this.$annotation = $annotation;
                }

                public final boolean test(UAnnotation e) {
                    return e == this.$annotation;
                }
            });
        }

        @JvmStatic
        public final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list2, @NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            return list2.stream().anyMatch((Predicate)new Predicate<UAnnotation>(qualifiedName){
                final /* synthetic */ String $qualifiedName;
                {
                    this.$qualifiedName = $qualifiedName;
                }

                public final boolean test(UAnnotation e) {
                    return Intrinsics.areEqual((Object)e.getQualifiedName(), (Object)this.$qualifiedName);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

