/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.LintJarVerifierKt;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u000f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0014\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J \u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0006\u0010$\u001a\u00020\u000bJ\b\u0010%\u001a\u0004\u0018\u00010\u0013J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\u0010\u0010)\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u0003H\u0002JK\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010/\u001a\u0004\u0018\u00010\u000b2\b\u00100\u001a\u0004\u0018\u00010\u000b2\u0010\u00101\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u000102H\u0016\u00a2\u0006\u0002\u00103JE\u00104\u001a\u0002052\u0006\u0010.\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\u0010/\u001a\u0004\u0018\u00010\u000b2\u0010\u00106\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u000102H\u0016\u00a2\u0006\u0002\u00107R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/client/api/LintJarVerifier;", "Lorg/objectweb/asm/ClassVisitor;", "jarFile", "Ljava/io/File;", "(Ljava/io/File;)V", "<set-?>", "", "apiCount", "getApiCount", "()I", "currentClassFile", "", "incompatibleReference", "incompatibleReferencer", "methodVisitor", "com/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1", "Lcom/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1;", "packageConflict", "verifyProblem", "", "checkClass", "", "internal", "checkField", "owner", "name", "checkMethod", "descriptor", "describeFirstIncompatibleReference", "describeFirstPackagedDependency", "getClass", "Ljava/lang/Class;", "getField", "Ljava/lang/reflect/Field;", "getMethod", "Ljava/lang/reflect/Executable;", "getReferenceClassFile", "getVerificationThrowable", "hasPackageConflict", "", "isCompatible", "isRelevantApi", "verify", "lintJar", "visit", "version", "access", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "lint-api"})
public final class LintJarVerifier
extends ClassVisitor {
    @Nullable
    private Throwable verifyProblem;
    @Nullable
    private String incompatibleReference;
    @Nullable
    private String incompatibleReferencer;
    @Nullable
    private String packageConflict;
    @NotNull
    private final methodVisitor.1 methodVisitor;
    private int apiCount;
    @Nullable
    private String currentClassFile;

    public LintJarVerifier(@NotNull File jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        super(458752);
        this.methodVisitor = new MethodVisitor(this){
            final /* synthetic */ LintJarVerifier this$0;
            {
                this.this$0 = $receiver;
                super(458752);
            }

            public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                LintJarVerifier.access$checkMethod(this.this$0, owner, name, descriptor);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @Nullable String descriptor) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                LintJarVerifier.access$checkField(this.this$0, owner, name);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }
        };
        try {
            this.verify(jarFile);
        }
        catch (Throwable throwable) {
            this.verifyProblem = throwable;
        }
    }

    private final boolean isRelevantApi(String internal) {
        if (StringsKt.startsWith$default((String)internal, (String)"com/android/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)internal, (String)"com/android/internal/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)internal, (String)"com/android/tools/lint/checks/studio/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)internal, (String)"com/android/tools/lint/checks/infrastructure/", (boolean)false, (int)2, null)) {
            return true;
        }
        return StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/uast", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/kotlin/psi", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/kotlin/asJava", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"com/intellij/psi", (boolean)false, (int)2, null);
    }

    public final boolean isCompatible() {
        return this.incompatibleReference == null;
    }

    public final boolean hasPackageConflict() {
        return this.packageConflict != null;
    }

    @Nullable
    public final Throwable getVerificationThrowable() {
        return this.verifyProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void verify(File lintJar) {
        Closeable closeable = new JarFile(lintJar);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            JarFile jar = (JarFile)closeable;
            boolean bl3 = false;
            Enumeration<JarEntry> enumeration = jar.entries();
            boolean bl4 = false;
            boolean bl5 = false;
            Enumeration<JarEntry> entries = enumeration;
            boolean bl6 = false;
            Ref.BooleanRef firstInDir = new Ref.BooleanRef();
            firstInDir.element = true;
            while (entries.hasMoreElements()) {
                int n;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.jar.JarEntry");
                }
                boolean bl7 = false;
                boolean bl8 = false;
                JarEntry entry = jarEntry;
                boolean bl9 = false;
                boolean directory = entry.isDirectory();
                String name = entry.getName();
                if (directory) {
                    firstInDir.element = true;
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) continue;
                if (firstInDir.element) {
                    if (this.packageConflict == null) {
                        String packageOwner;
                        String string = name;
                        n = 0;
                        int n2 = StringsKt.lastIndexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                        boolean bl10 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        if (this.isRelevantApi(packageOwner)) {
                            this.packageConflict = packageOwner;
                        }
                    }
                    firstInDir.element = false;
                }
                this.currentClassFile = name;
                Closeable closeable2 = jar.getInputStream(entry);
                boolean bl11 = false;
                n = 0;
                Throwable throwable2 = null;
                try {
                    InputStream stream = (InputStream)closeable2;
                    boolean bl12 = false;
                    byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                    ClassReader reader = new ClassReader(bytes);
                    reader.accept((ClassVisitor)this, 6);
                    if (this.incompatibleReference != null) {
                        return;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Enumeration<JarEntry> enumeration2 = enumeration;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final String describeFirstIncompatibleReference() {
        String string;
        String string2 = this.incompatibleReference;
        if (string2 == null) {
            return "Compatible";
        }
        String reference = string2;
        int index = StringsKt.indexOf$default((CharSequence)reference, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String string3 = Type.getObjectType((String)reference).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getObjectType(reference).className");
            return StringsKt.replace$default((String)string3, (char)'$', (char)'.', (boolean)false, (int)4, null);
        }
        String string4 = reference;
        int n = 0;
        boolean bl = false;
        String string5 = string4.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string6 = Type.getObjectType((String)string5).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getObjectType(reference.substring(0, index)).className");
        String className = StringsKt.replace$default((String)string6, (char)'$', (char)'.', (boolean)false, (int)4, null);
        int paren = StringsKt.indexOf$default((CharSequence)reference, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (paren == -1) {
            StringBuilder stringBuilder = new StringBuilder().append(className).append('#');
            string4 = reference;
            n = index + 1;
            bl = false;
            String string7 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            return stringBuilder.append(string7).toString();
        }
        StringBuilder sb = new StringBuilder(className).append(": ");
        String string8 = reference;
        boolean bl2 = false;
        String string9 = string8.substring(paren);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
        String descriptor = string9;
        CharSequence name = reference.subSequence(index + 1, paren);
        Object[] arguments = Type.getArgumentTypes((String)descriptor);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            string = className;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl3 = false;
            String string10 = string;
            if (string10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = string10.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
            sb.append(string11);
        } else {
            String returnType = Type.getReturnType((String)descriptor).getClassName();
            sb.append(returnType).append(' ');
            sb.append(name);
        }
        sb.append('(');
        Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"arguments");
        sb.append(ArraysKt.joinToString$default((Object[])arguments, (CharSequence)",", null, null, (int)0, null, (Function1)describeFirstIncompatibleReference.1.INSTANCE, (int)30, null));
        sb.append(')');
        string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String getReferenceClassFile() {
        String string = this.incompatibleReferencer;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String describeFirstPackagedDependency() {
        String string;
        String string2 = this.packageConflict;
        String string3 = string = string2 == null ? null : StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        return string == null ? "None" : ((string2 = StringsKt.removeSuffix((String)string, (CharSequence)".")) == null ? "None" : string2);
    }

    private final void checkClass(String internal) {
        if (this.isRelevantApi(internal)) {
            try {
                this.getClass(internal);
            }
            catch (Throwable e) {
                this.incompatibleReference = internal;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    public final int getApiCount() {
        return this.apiCount;
    }

    private final void checkMethod(String owner, String name, String descriptor) {
        if (this.isRelevantApi(owner)) {
            try {
                LintJarVerifier lintJarVerifier = this;
                int n = lintJarVerifier.apiCount;
                lintJarVerifier.apiCount = n + 1;
                this.getMethod(owner, name, descriptor);
            }
            catch (Throwable e) {
                this.incompatibleReference = owner + '#' + name + descriptor;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    private final void checkField(String owner, String name) {
        if (this.isRelevantApi(owner)) {
            try {
                LintJarVerifier lintJarVerifier = this;
                int n = lintJarVerifier.apiCount;
                lintJarVerifier.apiCount = n + 1;
                this.getField(owner, name);
            }
            catch (Throwable e) {
                this.incompatibleReference = owner + '#' + name;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    private final Class<?> getClass(String internal) {
        LintJarVerifier lintJarVerifier = this;
        int n = lintJarVerifier.apiCount;
        lintJarVerifier.apiCount = n + 1;
        String className = Type.getObjectType((String)internal).getClassName();
        Class<?> clazz = Class.forName(className);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(className)");
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private final Executable getMethod(String owner, String name, String descriptor) {
        Executable executable;
        Class[] classArray;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Class<?> clz = this.getClass(owner);
        Object object = Type.getArgumentTypes((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgumentTypes(descriptor)");
        object = object;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            Type type2 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            Class clazz = LintJarVerifierKt.access$toTypeClass((Type)type);
            collection.add(clazz);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Class[] classArray2 = thisCollection$iv.toArray(new Class[0]);
        if (classArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Class[] argumentTypes = classArray2;
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            Object object2;
            try {
                object2 = new Class[argumentTypes.length];
                System.arraycopy(argumentTypes, 0, object2, 0, argumentTypes.length);
                object2 = clz.getDeclaredConstructor((Class<?>)object2);
            }
            catch (Throwable e) {
                classArray = new Class[argumentTypes.length];
                System.arraycopy(argumentTypes, 0, classArray, 0, argumentTypes.length);
                object2 = clz.getConstructor(classArray);
            }
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            try {\n                clz.getDeclaredConstructor(*argumentTypes)\n            } catch (e: Throwable) {\n                clz.getConstructor(*argumentTypes)\n            }\n        }");
            executable = (Executable)object;
        } else {
            Object object3;
            try {
                object3 = new Class[argumentTypes.length];
                System.arraycopy(argumentTypes, 0, object3, 0, argumentTypes.length);
                object3 = clz.getDeclaredMethod(name, (Class<?>)object3);
            }
            catch (Throwable e) {
                classArray = new Class[argumentTypes.length];
                System.arraycopy(argumentTypes, 0, classArray, 0, argumentTypes.length);
                object3 = clz.getMethod(name, classArray);
            }
            object = object3;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            try {\n                clz.getDeclaredMethod(name, *argumentTypes)\n            } catch (e: Throwable) {\n                clz.getMethod(name, *argumentTypes)\n            }\n        }");
            executable = (Executable)object;
        }
        return executable;
    }

    private final Field getField(String owner, String name) {
        Field field;
        Class<?> clz = this.getClass(owner);
        try {
            field = clz.getDeclaredField(name);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"{\n            clz.getDeclaredField(name)\n        }");
        }
        catch (Throwable e) {
            Field field2 = clz.getField(name);
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"{\n            clz.getField(name)\n        }");
            field = field2;
        }
        return field;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        String[] it;
        boolean bl;
        boolean bl2;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray2 = superName;
        if (stringArray2 != null) {
            stringArray = stringArray2;
            bl2 = false;
            bl = false;
            it = stringArray;
            boolean bl3 = false;
            this.checkClass((String)it);
        }
        stringArray2 = interfaces;
        if (stringArray2 != null) {
            stringArray = stringArray2;
            bl2 = false;
            bl = false;
            it = stringArray;
            boolean bl4 = false;
            String[] $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            String[] stringArray3 = $this$forEach$iv;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String internal = element$iv = stringArray3[i];
                boolean bl5 = false;
                this.checkClass(internal);
            }
        }
        super.visit(version, access, name, signature, (String)superName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        return this.methodVisitor;
    }

    public static final /* synthetic */ void access$checkMethod(LintJarVerifier $this, String owner, String name, String descriptor) {
        $this.checkMethod(owner, name, descriptor);
    }

    public static final /* synthetic */ void access$checkField(LintJarVerifier $this, String owner, String name) {
        $this.checkField(owner, name);
    }
}

