/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightFieldForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightMethodForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightPsiLiteral;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryExpressionWithTypeKind;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ConstantEvaluator {
    private static final int LARGEST_LITERAL_ARRAY = 12;
    private boolean allowUnknown;
    private boolean allowFieldInitializers;

    public ConstantEvaluator allowUnknowns() {
        this.allowUnknown = true;
        return this;
    }

    public ConstantEvaluator allowFieldInitializers() {
        this.allowFieldInitializers = true;
        return this;
    }

    public Object evaluate(UElement node) {
        Object evaluated;
        UIfExpression expression;
        if (node == null) {
            return null;
        }
        if (node instanceof ULiteralExpression) {
            return ((ULiteralExpression)node).getValue();
        }
        if (node instanceof UPrefixExpression) {
            UastPrefixOperator operator = ((UPrefixExpression)node).getOperator();
            Object operand = this.evaluate((UElement)((UPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == UastPrefixOperator.LOGICAL_NOT) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == UastPrefixOperator.UNARY_PLUS) {
                    return operand;
                }
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof UIfExpression && ((UIfExpression)node).getExpressionType() != null) {
            expression = (UIfExpression)node;
            Object known = this.evaluate((UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((UElement)expression.getElseExpression());
            }
        } else {
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression2 = parenthesizedExpression.getExpression();
                return this.evaluate((UElement)expression2);
            }
            if (node instanceof UPolyadicExpression) {
                UPolyadicExpression polyadicExpression = (UPolyadicExpression)node;
                UastBinaryOperator operator = polyadicExpression.getOperator();
                List operands = polyadicExpression.getOperands();
                if (operands.isEmpty() && node.getSourcePsi() instanceof KtStringTemplateExpression) {
                    return "";
                }
                assert (!operands.isEmpty());
                Object result = this.evaluate((UElement)operands.get(0));
                int n = operands.size();
                for (int i = 1; i < n; ++i) {
                    Object rhs = this.evaluate((UElement)operands.get(i));
                    result = this.evaluateBinary(operator, result, rhs);
                }
                if (result != null) {
                    return result;
                }
            } else {
                Object array;
                Object indexValue;
                List indices2;
                UCallExpression call;
                if (node instanceof UBinaryExpressionWithType && ((UBinaryExpressionWithType)node).getOperationKind() == UastBinaryExpressionWithTypeKind.TYPE_CAST) {
                    UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
                    Object operandValue = this.evaluate((UElement)cast.getOperand());
                    if (operandValue instanceof Number) {
                        Number number = (Number)operandValue;
                        PsiType type = cast.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                    return operandValue;
                }
                if (node instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)node).resolve();
                    if (resolved instanceof PsiVariable) {
                        if (resolved instanceof PsiField) {
                            Object fieldValue;
                            PsiField field = (PsiField)resolved;
                            if ("length".equals(field.getName()) && node instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)node).getReceiver().getExpressionType() instanceof PsiArrayType) {
                                Object array2 = this.evaluate((UElement)((UQualifiedReferenceExpression)node).getReceiver());
                                int size = ConstantEvaluator.getArraySize(array2);
                                if (size != -1) {
                                    return size;
                                }
                                return null;
                            }
                            Object value = field.computeConstantValue();
                            if (value != null) {
                                return value;
                            }
                            if (field.getInitializer() != null && (this.allowFieldInitializers || field.hasModifierProperty("static") && field.hasModifierProperty("final")) && (value = this.evaluate((PsiElement)field.getInitializer())) != null) {
                                if (ConstantEvaluator.surroundedByVariableCheck(node, (PsiVariable)field)) {
                                    return null;
                                }
                                return value;
                            }
                            if (field instanceof KtUltraLightFieldForSourceDeclaration && (fieldValue = this.evaluate((PsiElement)field)) != null) {
                                return fieldValue;
                            }
                            return null;
                        }
                        PsiVariable variable = (PsiVariable)resolved;
                        Object value = UastLintUtils.findLastValue(variable, node, this);
                        if (value == LastAssignmentFinder.LAST_ASSIGNMENT_VALUE_UNKNOWN) {
                            return null;
                        }
                        if (value != null) {
                            if (ConstantEvaluator.surroundedByVariableCheck(node, variable)) {
                                return null;
                            }
                            return value;
                        }
                        if (variable.getInitializer() != null) {
                            Object initializedValue = this.evaluate((PsiElement)variable.getInitializer());
                            if (ConstantEvaluator.surroundedByVariableCheck(node, variable)) {
                                return null;
                            }
                            return initializedValue;
                        }
                        return null;
                    }
                    if (node instanceof UQualifiedReferenceExpression) {
                        USimpleNameReferenceExpression name;
                        UQualifiedReferenceExpression expression3 = (UQualifiedReferenceExpression)node;
                        UExpression selector = expression3.getSelector();
                        UExpression receiver = expression3.getReceiver();
                        if (receiver instanceof USimpleNameReferenceExpression && (name = (USimpleNameReferenceExpression)receiver).getIdentifier().equals("kotlin")) {
                            return this.evaluate((UElement)selector);
                        }
                        if (selector instanceof USimpleNameReferenceExpression) {
                            UCallExpression receiverCall;
                            String name2;
                            UQualifiedReferenceExpression expression1;
                            USimpleNameReferenceExpression nameReferenceExpression = (USimpleNameReferenceExpression)selector;
                            String identifier = nameReferenceExpression.getIdentifier();
                            if (receiver instanceof UQualifiedReferenceExpression && (expression1 = (UQualifiedReferenceExpression)receiver).getReceiver() instanceof USimpleNameReferenceExpression && ((USimpleNameReferenceExpression)expression1.getReceiver()).getIdentifier().equals("kotlin")) {
                                receiver = expression1.getSelector();
                            }
                            if ("size".equals(identifier) && receiver instanceof UCallExpression && (name2 = Lint.getMethodName(receiverCall = (UCallExpression)receiver)) != null) {
                                int size;
                                if (name2.endsWith("Array") && (name2.equals("Array") || ConstantEvaluator.getKotlinPrimitiveArrayType(name2) != null)) {
                                    size = this.getKotlinArrayConstructionSize(receiverCall);
                                    if (size != -1) {
                                        return size;
                                    }
                                } else {
                                    if (name2.endsWith("rrayOf") && (name2.equals("arrayOf") || ConstantEvaluator.getKotlinPrimitiveArrayType(name2) != null)) {
                                        return receiverCall.getValueArgumentCount();
                                    }
                                    if ("arrayOfNulls".equals(name2) && (size = this.getKotlinArrayConstructionSize(receiverCall)) != -1) {
                                        return size;
                                    }
                                }
                            }
                        }
                        if (receiver != null && selector instanceof UCallExpression) {
                            List arguments;
                            Object s;
                            UCallExpression call2 = (UCallExpression)selector;
                            String methodName = call2.getMethodName();
                            if ("trimIndent".equals(methodName)) {
                                s = this.evaluate((UElement)receiver);
                                if (s instanceof String) {
                                    return StringsKt.trimIndent((String)((String)s));
                                }
                            } else if ("trimMargin".equals(methodName)) {
                                s = this.evaluate((UElement)receiver);
                                if (s instanceof String) {
                                    Object arg;
                                    String prefix = "|";
                                    List valueArguments = call2.getValueArguments();
                                    if (valueArguments.size() == 1 && (arg = this.evaluate((UElement)valueArguments.get(0))) != null) {
                                        prefix = arg.toString();
                                    }
                                    return StringsKt.trimMargin((String)((String)s), (String)prefix);
                                }
                            } else if (this.allowUnknown && "format".equals(methodName) && (arguments = call2.getValueArguments()).size() >= 2) {
                                UExpression first = (UExpression)arguments.get(0);
                                UExpression second = (UExpression)arguments.get(1);
                                PsiType expressionType = first.getExpressionType();
                                if (expressionType != null && "java.util.Locale".equals(expressionType.getCanonicalText())) {
                                    return this.evaluate((UElement)second);
                                }
                                return this.evaluate((UElement)first);
                            }
                        }
                    }
                } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                    Object lengthObj;
                    PsiType type;
                    call = (UCallExpression)node;
                    PsiType arrayType = call.getExpressionType();
                    if (arrayType instanceof PsiArrayType && !((type = arrayType.getDeepComponentType()) instanceof PsiArrayType) && call.getValueArgumentCount() == 1 && (lengthObj = this.evaluate((UElement)call.getValueArguments().get(0))) instanceof Number) {
                        int size = ((Number)lengthObj).intValue();
                        int dimensions = arrayType.getArrayDimensions();
                        return ConstantEvaluator.getArray(type, size, dimensions);
                    }
                } else if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                    Object array3 = this.createInitializedArray((UCallExpression)node);
                    if (array3 != null) {
                        return array3;
                    }
                } else if (node instanceof UCallExpression) {
                    call = (UCallExpression)node;
                    String name = Lint.getMethodName(call);
                    if (name != null) {
                        int size;
                        PsiType type;
                        if (name.endsWith("Array") && UastExpressionUtils.isConstructorCall((UElement)call)) {
                            int size2 = this.getKotlinArrayConstructionSize(call);
                            if (size2 != -1) {
                                if (name.equals("Array")) {
                                    PsiType type2 = call.getExpressionType();
                                    if (type2 instanceof PsiArrayType) {
                                        int dimensions = type2.getArrayDimensions();
                                        PsiType componentType = type2.getDeepComponentType();
                                        return ConstantEvaluator.getArray(componentType, size2, dimensions);
                                    }
                                } else {
                                    PsiType type3 = ConstantEvaluator.getKotlinPrimitiveArrayType(name);
                                    if (type3 != null) {
                                        int dimensions = 1;
                                        return ConstantEvaluator.getArray(type3, size2, dimensions);
                                    }
                                }
                            }
                        } else if ("arrayOf".equals(name) || name.endsWith("ArrayOf") && ConstantEvaluator.getKotlinPrimitiveArrayType(name) != null) {
                            Object array4 = this.createInitializedArray(call);
                            if (array4 != null) {
                                return array4;
                            }
                        } else if ("arrayOfNulls".equals(name) && (type = call.getExpressionType()) instanceof PsiArrayType && (size = this.getKotlinArrayConstructionSize(call)) != -1) {
                            int dimensions = type.getArrayDimensions();
                            PsiType componentType = type.getDeepComponentType();
                            return ConstantEvaluator.getArray(componentType, size, dimensions);
                        }
                    }
                } else if (node instanceof UArrayAccessExpression && (indices2 = (expression = (UArrayAccessExpression)node).getIndices()).size() == 1 && (indexValue = this.evaluate((UElement)indices2.get(0))) instanceof Number && (array = this.evaluate((UElement)expression.getReceiver())) != null) {
                    int index = ((Number)indexValue).intValue();
                    if (array instanceof Object[]) {
                        Object[] objArray = (Object[])array;
                        if (index >= 0 && index < objArray.length) {
                            return objArray[index];
                        }
                    } else if (array instanceof int[]) {
                        int[] intArray = (int[])array;
                        if (index >= 0 && index < intArray.length) {
                            return intArray[index];
                        }
                    } else if (array instanceof boolean[]) {
                        boolean[] booleanArray = (boolean[])array;
                        if (index >= 0 && index < booleanArray.length) {
                            return booleanArray[index];
                        }
                    } else if (array instanceof char[]) {
                        char[] charArray = (char[])array;
                        if (index >= 0 && index < charArray.length) {
                            return Character.valueOf(charArray[index]);
                        }
                    } else if (array instanceof long[]) {
                        long[] longArray = (long[])array;
                        if (index >= 0 && index < longArray.length) {
                            return longArray[index];
                        }
                    } else if (array instanceof float[]) {
                        float[] floatArray = (float[])array;
                        if (index >= 0 && index < floatArray.length) {
                            return Float.valueOf(floatArray[index]);
                        }
                    } else if (array instanceof double[]) {
                        double[] doubleArray = (double[])array;
                        if (index >= 0 && index < doubleArray.length) {
                            return doubleArray[index];
                        }
                    } else if (array instanceof byte[]) {
                        byte[] byteArray = (byte[])array;
                        if (index >= 0 && index < byteArray.length) {
                            return byteArray[index];
                        }
                    } else if (array instanceof short[]) {
                        short[] shortArray = (short[])array;
                        if (index >= 0 && index < shortArray.length) {
                            return shortArray[index];
                        }
                    }
                }
            }
        }
        if (node instanceof UExpression && (evaluated = ((UExpression)node).evaluate()) != null) {
            return evaluated;
        }
        return null;
    }

    private Object createInitializedArray(UCallExpression call) {
        PsiType componentType;
        PsiType arrayType = call.getExpressionType();
        if (arrayType instanceof PsiArrayType && !((componentType = arrayType.getDeepComponentType()) instanceof PsiArrayType)) {
            Object[] arr;
            int length = call.getValueArgumentCount();
            ArrayList<Object> evaluatedArgs = new ArrayList<Object>(length);
            int count = 0;
            for (UExpression arg : call.getValueArguments()) {
                Object object = this.evaluate((UElement)arg);
                if (!this.allowUnknown && object == null) {
                    return null;
                }
                evaluatedArgs.add(object);
                if (++count != 40) continue;
                return ConstantEvaluator.getArray(componentType, length, 1);
            }
            if (componentType == PsiType.BOOLEAN) {
                arr = new boolean[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Boolean)) continue;
                    arr[i] = (Boolean)e;
                }
                return arr;
            }
            if (ConstantEvaluator.isObjectType(componentType)) {
                arr = new Object[length];
                for (int i = 0; i < length; ++i) {
                    arr[i] = evaluatedArgs.get(i);
                }
                return arr;
            }
            if (componentType.equals(PsiType.CHAR)) {
                arr = new char[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Character)) continue;
                    arr[i] = ((Character)e).charValue();
                }
                return arr;
            }
            if (componentType.equals(PsiType.BYTE)) {
                arr = new byte[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Byte)) continue;
                    arr[i] = (Byte)e;
                }
                return arr;
            }
            if (componentType.equals(PsiType.DOUBLE)) {
                arr = new double[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Double)) continue;
                    arr[i] = ((Double)e).doubleValue();
                }
                return arr;
            }
            if (componentType.equals(PsiType.FLOAT)) {
                arr = new float[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Float)) continue;
                    arr[i] = ((Float)e).floatValue();
                }
                return arr;
            }
            if (componentType.equals(PsiType.INT)) {
                arr = new int[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Integer)) continue;
                    arr[i] = (Integer)e;
                }
                return arr;
            }
            if (componentType.equals(PsiType.SHORT)) {
                arr = new short[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Short)) continue;
                    arr[i] = (Short)e;
                }
                return arr;
            }
            if (componentType.equals(PsiType.LONG)) {
                arr = new long[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof Long)) continue;
                    arr[i] = ((Long)e).longValue();
                }
                return arr;
            }
            if (ConstantEvaluator.isStringType(componentType)) {
                arr = new String[length];
                for (int i = 0; i < length; ++i) {
                    Object e = evaluatedArgs.get(i);
                    if (!(e instanceof String)) continue;
                    arr[i] = (String)e;
                }
                return arr;
            }
            if (!evaluatedArgs.isEmpty()) {
                Object first = evaluatedArgs.get(0);
                for (Object e : evaluatedArgs) {
                    if (e.getClass() == first.getClass()) continue;
                    return null;
                }
                return evaluatedArgs.toArray((Object[])Array.newInstance(first.getClass(), 0));
            }
        }
        return null;
    }

    private static PsiType getKotlinPrimitiveArrayType(String constructorName) {
        switch (constructorName) {
            case "ByteArray": 
            case "byteArrayOf": {
                return PsiPrimitiveType.BYTE;
            }
            case "CharArray": 
            case "charArrayOf": {
                return PsiPrimitiveType.CHAR;
            }
            case "ShortArray": 
            case "shortArrayOf": {
                return PsiPrimitiveType.SHORT;
            }
            case "IntArray": 
            case "intArrayOf": {
                return PsiPrimitiveType.INT;
            }
            case "LongArray": 
            case "longArrayOf": {
                return PsiPrimitiveType.LONG;
            }
            case "FloatArray": 
            case "floatArrayOf": {
                return PsiPrimitiveType.FLOAT;
            }
            case "DoubleArray": 
            case "doubleArrayOf": {
                return PsiPrimitiveType.DOUBLE;
            }
            case "BooleanArray": 
            case "booleanArrayOf": {
                return PsiPrimitiveType.BOOLEAN;
            }
        }
        return null;
    }

    private int getKotlinArrayConstructionSize(UCallExpression call) {
        Object lengthObj;
        List valueArguments = call.getValueArguments();
        if (!valueArguments.isEmpty() && (lengthObj = this.evaluate((UElement)call.getValueArguments().get(0))) instanceof Number) {
            return ((Number)lengthObj).intValue();
        }
        return -1;
    }

    public static int getArraySize(Object array) {
        if (array instanceof ArrayReference) {
            return ((ArrayReference)array).size;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        return -1;
    }

    private Object evaluateBinary(UastBinaryOperator operator, Object operandLeft, Object operandRight) {
        if (operandLeft == null || operandRight == null) {
            if (this.allowUnknown) {
                if (operandLeft == null) {
                    return operandRight;
                }
                return operandLeft;
            }
            return null;
        }
        if (operandLeft instanceof String && (operandRight instanceof String || operandRight instanceof Character) || operandRight instanceof String && operandLeft instanceof Character) {
            if (operator == UastBinaryOperator.PLUS) {
                return operandLeft + operandRight.toString();
            }
            return null;
        }
        if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
            boolean left = (Boolean)operandLeft;
            boolean right = (Boolean)operandRight;
            if (operator == UastBinaryOperator.LOGICAL_OR) {
                return left || right;
            }
            if (operator == UastBinaryOperator.LOGICAL_AND) {
                return left && right;
            }
            if (operator == UastBinaryOperator.BITWISE_OR) {
                return left | right;
            }
            if (operator == UastBinaryOperator.BITWISE_XOR) {
                return left ^ right;
            }
            if (operator == UastBinaryOperator.BITWISE_AND) {
                return left & right;
            }
            if (operator == UastBinaryOperator.IDENTITY_EQUALS || operator == UastBinaryOperator.EQUALS) {
                return left == right;
            }
            if (operator == UastBinaryOperator.IDENTITY_NOT_EQUALS || operator == UastBinaryOperator.NOT_EQUALS) {
                return left != right;
            }
        } else if (operandLeft instanceof Number && operandRight instanceof Number) {
            boolean isWide;
            boolean isInteger;
            Number left = (Number)operandLeft;
            Number right = (Number)operandRight;
            boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
            boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
            if (operator == UastBinaryOperator.BITWISE_OR) {
                if (isWide) {
                    return left.longValue() | right.longValue();
                }
                return left.intValue() | right.intValue();
            }
            if (operator == UastBinaryOperator.BITWISE_XOR) {
                if (isWide) {
                    return left.longValue() ^ right.longValue();
                }
                return left.intValue() ^ right.intValue();
            }
            if (operator == UastBinaryOperator.BITWISE_AND) {
                if (isWide) {
                    return left.longValue() & right.longValue();
                }
                return left.intValue() & right.intValue();
            }
            if (operator == UastBinaryOperator.EQUALS || operator == UastBinaryOperator.IDENTITY_EQUALS) {
                if (isInteger) {
                    return left.longValue() == right.longValue();
                }
                return left.doubleValue() == right.doubleValue();
            }
            if (operator == UastBinaryOperator.NOT_EQUALS || operator == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                if (isInteger) {
                    return left.longValue() != right.longValue();
                }
                return left.doubleValue() != right.doubleValue();
            }
            if (operator == UastBinaryOperator.GREATER) {
                if (isInteger) {
                    return left.longValue() > right.longValue();
                }
                return left.doubleValue() > right.doubleValue();
            }
            if (operator == UastBinaryOperator.GREATER_OR_EQUALS) {
                if (isInteger) {
                    return left.longValue() >= right.longValue();
                }
                return left.doubleValue() >= right.doubleValue();
            }
            if (operator == UastBinaryOperator.LESS) {
                if (isInteger) {
                    return left.longValue() < right.longValue();
                }
                return left.doubleValue() < right.doubleValue();
            }
            if (operator == UastBinaryOperator.LESS_OR_EQUALS) {
                if (isInteger) {
                    return left.longValue() <= right.longValue();
                }
                return left.doubleValue() <= right.doubleValue();
            }
            if (operator == UastBinaryOperator.SHIFT_LEFT) {
                if (isWide) {
                    return left.longValue() << right.intValue();
                }
                return left.intValue() << right.intValue();
            }
            if (operator == UastBinaryOperator.SHIFT_RIGHT) {
                if (isWide) {
                    return left.longValue() >> right.intValue();
                }
                return left.intValue() >> right.intValue();
            }
            if (operator == UastBinaryOperator.UNSIGNED_SHIFT_RIGHT) {
                if (isWide) {
                    return left.longValue() >>> right.intValue();
                }
                return left.intValue() >>> right.intValue();
            }
            if (operator == UastBinaryOperator.PLUS) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() + right.longValue();
                    }
                    return left.intValue() + right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() + right.doubleValue();
                }
                return Float.valueOf(left.floatValue() + right.floatValue());
            }
            if (operator == UastBinaryOperator.MINUS) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() - right.longValue();
                    }
                    return left.intValue() - right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() - right.doubleValue();
                }
                return Float.valueOf(left.floatValue() - right.floatValue());
            }
            if (operator == UastBinaryOperator.MULTIPLY) {
                if (isInteger) {
                    if (isWide) {
                        return left.longValue() * right.longValue();
                    }
                    return left.intValue() * right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() * right.doubleValue();
                }
                return Float.valueOf(left.floatValue() * right.floatValue());
            }
            if (operator == UastBinaryOperator.DIV) {
                if (isInteger) {
                    if (right.longValue() == 0L) {
                        return null;
                    }
                    if (isWide) {
                        return left.longValue() / right.longValue();
                    }
                    return left.intValue() / right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() / right.doubleValue();
                }
                return Float.valueOf(left.floatValue() / right.floatValue());
            }
            if (operator == UastBinaryOperator.MOD) {
                if (isInteger) {
                    if (right.longValue() == 0L) {
                        return null;
                    }
                    if (isWide) {
                        return left.longValue() % right.longValue();
                    }
                    return left.intValue() % right.intValue();
                }
                if (isWide) {
                    return left.doubleValue() % right.doubleValue();
                }
                return Float.valueOf(left.floatValue() % right.floatValue());
            }
            return null;
        }
        return null;
    }

    private static boolean surroundedByVariableCheck(UElement node, PsiVariable variable) {
        if (node == null) {
            return false;
        }
        UIfExpression curr = (UIfExpression)UastUtils.getParentOfType((UElement)node, UIfExpression.class);
        while (curr != null) {
            UExpression condition;
            if (ConstantEvaluator.references(curr.getCondition(), variable) && !UastUtils.isUastChildOf((UElement)node, (UElement)(condition = curr.getCondition()), (boolean)false)) {
                return true;
            }
            curr = (UIfExpression)UastUtils.getParentOfType((UElement)curr, UIfExpression.class);
        }
        return false;
    }

    private static boolean isStringType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        return resolvedClass != null && "java.lang.String".equals(resolvedClass.getQualifiedName());
    }

    private static boolean isObjectType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type).resolve();
        return resolvedClass != null && "java.lang.Object".equals(resolvedClass.getQualifiedName());
    }

    /*
     * WARNING - void declaration
     */
    public Object evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PsiLiteral) {
            KtExpression origin;
            UExpression uastExpression;
            Object value = ((PsiLiteral)node).getValue();
            if (value == null && node instanceof KtLightPsiLiteral && (uastExpression = (UExpression)UastFacade.INSTANCE.convertElement((PsiElement)(origin = ((KtLightPsiLiteral)node).getKotlinOrigin()), null, UExpression.class)) != null) {
                value = uastExpression.evaluate();
            }
            return value;
        }
        if (node instanceof PsiPrefixExpression) {
            IElementType operator = ((PsiPrefixExpression)node).getOperationTokenType();
            Object operand = this.evaluate((PsiElement)((PsiPrefixExpression)node).getOperand());
            if (operand == null) {
                return null;
            }
            if (operator == JavaTokenType.EXCL) {
                if (operand instanceof Boolean) {
                    return (Boolean)operand == false;
                }
            } else {
                if (operator == JavaTokenType.PLUS) {
                    return operand;
                }
                if (operator == JavaTokenType.TILDE) {
                    if (operand instanceof Integer) {
                        return ~((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return (Long)operand ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (operand instanceof Short) {
                        return (int)(~((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(~((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(~((Byte)operand).byteValue());
                    }
                } else if (operator == JavaTokenType.MINUS) {
                    if (operand instanceof Integer) {
                        return -((Integer)operand).intValue();
                    }
                    if (operand instanceof Long) {
                        return -((Long)operand).longValue();
                    }
                    if (operand instanceof Double) {
                        return -((Double)operand).doubleValue();
                    }
                    if (operand instanceof Float) {
                        return Float.valueOf(-((Float)operand).floatValue());
                    }
                    if (operand instanceof Short) {
                        return (int)(-((Short)operand).shortValue());
                    }
                    if (operand instanceof Character) {
                        return (int)(-((Character)operand).charValue());
                    }
                    if (operand instanceof Byte) {
                        return (int)(-((Byte)operand).byteValue());
                    }
                }
            }
        } else if (node instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)node;
            Object known = this.evaluate((PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.evaluate((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.evaluate((PsiElement)expression.getElseExpression());
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return this.evaluate((PsiElement)expression);
            }
        } else if (node instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)node;
            IElementType operator = expression.getOperationTokenType();
            Object operandLeft = this.evaluate((PsiElement)expression.getLOperand());
            Object operandRight = this.evaluate((PsiElement)expression.getROperand());
            if (operandLeft == null || operandRight == null) {
                if (this.allowUnknown) {
                    if (operandLeft == null) {
                        return operandRight;
                    }
                    return operandLeft;
                }
                return null;
            }
            if (operandLeft instanceof String && (operandRight instanceof String || operandRight instanceof Character) || operandRight instanceof String && operandLeft instanceof Character) {
                if (operator == JavaTokenType.PLUS) {
                    return operandLeft.toString() + operandRight.toString();
                }
                return null;
            }
            if (operandLeft instanceof Boolean && operandRight instanceof Boolean) {
                boolean left = (Boolean)operandLeft;
                boolean right = (Boolean)operandRight;
                if (operator == JavaTokenType.OROR) {
                    return left || right;
                }
                if (operator == JavaTokenType.ANDAND) {
                    return left && right;
                }
                if (operator == JavaTokenType.OR) {
                    return left | right;
                }
                if (operator == JavaTokenType.XOR) {
                    return left ^ right;
                }
                if (operator == JavaTokenType.AND) {
                    return left & right;
                }
                if (operator == JavaTokenType.EQEQ) {
                    return left == right;
                }
                if (operator == JavaTokenType.NE) {
                    return left != right;
                }
            } else if (operandLeft instanceof Number && operandRight instanceof Number) {
                boolean isWide;
                boolean isInteger;
                Number left = (Number)operandLeft;
                Number right = (Number)operandRight;
                boolean bl = isInteger = !(left instanceof Float) && !(left instanceof Double) && !(right instanceof Float) && !(right instanceof Double);
                boolean bl2 = isInteger ? left instanceof Long || right instanceof Long : (isWide = left instanceof Double || right instanceof Double);
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        return left.longValue() | right.longValue();
                    }
                    return left.intValue() | right.intValue();
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        return left.longValue() ^ right.longValue();
                    }
                    return left.intValue() ^ right.intValue();
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        return left.longValue() & right.longValue();
                    }
                    return left.intValue() & right.intValue();
                }
                if (operator == JavaTokenType.EQEQ) {
                    if (isInteger) {
                        return left.longValue() == right.longValue();
                    }
                    return left.doubleValue() == right.doubleValue();
                }
                if (operator == JavaTokenType.NE) {
                    if (isInteger) {
                        return left.longValue() != right.longValue();
                    }
                    return left.doubleValue() != right.doubleValue();
                }
                if (operator == JavaTokenType.GT) {
                    if (isInteger) {
                        return left.longValue() > right.longValue();
                    }
                    return left.doubleValue() > right.doubleValue();
                }
                if (operator == JavaTokenType.GE) {
                    if (isInteger) {
                        return left.longValue() >= right.longValue();
                    }
                    return left.doubleValue() >= right.doubleValue();
                }
                if (operator == JavaTokenType.LT) {
                    if (isInteger) {
                        return left.longValue() < right.longValue();
                    }
                    return left.doubleValue() < right.doubleValue();
                }
                if (operator == JavaTokenType.LE) {
                    if (isInteger) {
                        return left.longValue() <= right.longValue();
                    }
                    return left.doubleValue() <= right.doubleValue();
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        return left.longValue() << right.intValue();
                    }
                    return left.intValue() << right.intValue();
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        return left.longValue() >> right.intValue();
                    }
                    return left.intValue() >> right.intValue();
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        return left.longValue() >>> right.intValue();
                    }
                    return left.intValue() >>> right.intValue();
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() + right.longValue();
                        }
                        return left.intValue() + right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() + right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() + right.floatValue());
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() - right.longValue();
                        }
                        return left.intValue() - right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() - right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() - right.floatValue());
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isInteger) {
                        if (isWide) {
                            return left.longValue() * right.longValue();
                        }
                        return left.intValue() * right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() * right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() * right.floatValue());
                }
                if (operator == JavaTokenType.DIV) {
                    if (isInteger) {
                        if (right.longValue() == 0L) {
                            return null;
                        }
                        if (isWide) {
                            return left.longValue() / right.longValue();
                        }
                        return left.intValue() / right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() / right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() / right.floatValue());
                }
                if (operator == JavaTokenType.PERC) {
                    if (isInteger) {
                        if (right.longValue() == 0L) {
                            return null;
                        }
                        if (isWide) {
                            return left.longValue() % right.longValue();
                        }
                        return left.intValue() % right.intValue();
                    }
                    if (isWide) {
                        return left.doubleValue() % right.doubleValue();
                    }
                    return Float.valueOf(left.floatValue() % right.floatValue());
                }
                return null;
            }
        } else if (node instanceof PsiPolyadicExpression) {
            int i;
            Object value;
            void var13_143;
            PsiPolyadicExpression expression = (PsiPolyadicExpression)node;
            IElementType operator = expression.getOperationTokenType();
            PsiExpression[] operands = expression.getOperands();
            ArrayList<Object> values = new ArrayList<Object>(operands.length);
            boolean hasString = false;
            boolean hasBoolean = false;
            boolean hasNumber = false;
            boolean isFloat = false;
            boolean isWide = false;
            PsiExpression[] psiExpressionArray = operands;
            int n = psiExpressionArray.length;
            boolean bl = false;
            while (var13_143 < n) {
                PsiExpression operand = psiExpressionArray[var13_143];
                value = this.evaluate((PsiElement)operand);
                if (value != null) {
                    values.add(value);
                    if (value instanceof String) {
                        hasString = true;
                    } else if (value instanceof Boolean) {
                        hasBoolean = true;
                    } else if (value instanceof Number) {
                        if (value instanceof Float) {
                            isFloat = true;
                        } else if (value instanceof Double) {
                            isFloat = true;
                            isWide = true;
                        } else if (value instanceof Long) {
                            isWide = true;
                        }
                        hasNumber = true;
                    }
                }
                ++var13_143;
            }
            if (values.isEmpty()) {
                return null;
            }
            if (hasString) {
                if (operator == JavaTokenType.PLUS) {
                    StringBuilder sb = new StringBuilder();
                    for (Object e : values) {
                        sb.append(e.toString());
                    }
                    return sb.toString();
                }
                return null;
            }
            if (!this.allowUnknown && operands.length != values.size()) {
                return null;
            }
            if (hasBoolean) {
                if (operator == JavaTokenType.OROR) {
                    boolean result = false;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result = result || (Boolean)e != false;
                    }
                    return result;
                }
                if (operator == JavaTokenType.ANDAND) {
                    boolean result = true;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result = result && (Boolean)e != false;
                    }
                    return result;
                }
                if (operator == JavaTokenType.OR) {
                    boolean result = false;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result |= ((Boolean)e).booleanValue();
                    }
                    return result;
                }
                if (operator == JavaTokenType.XOR) {
                    boolean result = false;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result ^= ((Boolean)e).booleanValue();
                    }
                    return result;
                }
                if (operator == JavaTokenType.AND) {
                    boolean result = true;
                    for (Object e : values) {
                        if (!(e instanceof Boolean)) continue;
                        result &= ((Boolean)e).booleanValue();
                    }
                    return result;
                }
                if (operator == JavaTokenType.EQEQ) {
                    boolean result = false;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Boolean)) continue;
                        boolean b = (Boolean)e;
                        result = i == 0 ? b : result == b;
                    }
                    return result;
                }
                if (operator == JavaTokenType.NE) {
                    boolean result = false;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Boolean)) continue;
                        boolean b = (Boolean)e;
                        result = i == 0 ? b : result != b;
                    }
                    return result;
                }
                return null;
            }
            if (hasNumber) {
                int prev;
                Object value2;
                if (operator == JavaTokenType.OR) {
                    if (isWide) {
                        void var13_153;
                        long result = 0L;
                        boolean bl3 = false;
                        while (var13_153 < values.size()) {
                            Object value10 = values.get((int)var13_153);
                            if (value10 instanceof Number) {
                                long l = ((Number)value10).longValue();
                                result = var13_153 == false ? l : (result |= l);
                            }
                            ++var13_153;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result |= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.XOR) {
                    if (isWide) {
                        void var13_156;
                        long result = 0L;
                        boolean bl4 = false;
                        while (var13_156 < values.size()) {
                            value2 = values.get((int)var13_156);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_156 == false ? l : (result ^= l);
                            }
                            ++var13_156;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result ^= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.AND) {
                    if (isWide) {
                        void var13_159;
                        long result = 0L;
                        boolean bl5 = false;
                        while (var13_159 < values.size()) {
                            value2 = values.get((int)var13_159);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_159 == false ? l : (result &= l);
                            }
                            ++var13_159;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result &= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.EQEQ) {
                    void var13_162;
                    if (isWide) {
                        boolean result = false;
                        long prev2 = 0L;
                        for (int i3 = 0; i3 < values.size(); ++i3) {
                            value = values.get(i3);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i3 != 0) {
                                result = prev2 == l;
                            }
                            prev2 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl6 = false;
                    while (var13_162 < values.size()) {
                        value2 = values.get((int)var13_162);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_162 != false) {
                                result = prev == l;
                            }
                            prev = l;
                        }
                        ++var13_162;
                    }
                    return result;
                }
                if (operator == JavaTokenType.NE) {
                    void var13_164;
                    if (isWide) {
                        boolean result = false;
                        long prev3 = 0L;
                        for (int i4 = 0; i4 < values.size(); ++i4) {
                            value = values.get(i4);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i4 != 0) {
                                result = prev3 != l;
                            }
                            prev3 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl7 = false;
                    while (var13_164 < values.size()) {
                        value2 = values.get((int)var13_164);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_164 != false) {
                                result = prev != l;
                            }
                            prev = l;
                        }
                        ++var13_164;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GT) {
                    void var13_166;
                    if (isWide) {
                        boolean result = false;
                        long prev4 = 0L;
                        for (int i5 = 0; i5 < values.size(); ++i5) {
                            value = values.get(i5);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i5 != 0) {
                                result = prev4 > l;
                            }
                            prev4 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl8 = false;
                    while (var13_166 < values.size()) {
                        value2 = values.get((int)var13_166);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_166 != false) {
                                result = prev > l;
                            }
                            prev = l;
                        }
                        ++var13_166;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GE) {
                    void var13_168;
                    if (isWide) {
                        boolean result = false;
                        long prev5 = 0L;
                        for (int i6 = 0; i6 < values.size(); ++i6) {
                            value = values.get(i6);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i6 != 0) {
                                result = prev5 >= l;
                            }
                            prev5 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl9 = false;
                    while (var13_168 < values.size()) {
                        value2 = values.get((int)var13_168);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_168 != false) {
                                result = prev >= l;
                            }
                            prev = l;
                        }
                        ++var13_168;
                    }
                    return result;
                }
                if (operator == JavaTokenType.LT) {
                    void var13_170;
                    if (isWide) {
                        boolean result = false;
                        long prev6 = 0L;
                        for (int i7 = 0; i7 < values.size(); ++i7) {
                            value = values.get(i7);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i7 != 0) {
                                result = prev6 < l;
                            }
                            prev6 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl10 = false;
                    while (var13_170 < values.size()) {
                        value2 = values.get((int)var13_170);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_170 != false) {
                                result = prev < l;
                            }
                            prev = l;
                        }
                        ++var13_170;
                    }
                    return result;
                }
                if (operator == JavaTokenType.LE) {
                    void var13_172;
                    if (isWide) {
                        boolean result = false;
                        long prev7 = 0L;
                        for (int i8 = 0; i8 < values.size(); ++i8) {
                            value = values.get(i8);
                            if (!(value instanceof Number)) continue;
                            long l = ((Number)value).longValue();
                            if (i8 != 0) {
                                result = prev7 <= l;
                            }
                            prev7 = l;
                        }
                        return result;
                    }
                    boolean result = false;
                    prev = 0;
                    boolean bl11 = false;
                    while (var13_172 < values.size()) {
                        value2 = values.get((int)var13_172);
                        if (value2 instanceof Number) {
                            int l = ((Number)value2).intValue();
                            if (var13_172 != false) {
                                result = prev <= l;
                            }
                            prev = l;
                        }
                        ++var13_172;
                    }
                    return result;
                }
                if (operator == JavaTokenType.LTLT) {
                    if (isWide) {
                        void var13_174;
                        long result = 0L;
                        boolean bl12 = false;
                        while (var13_174 < values.size()) {
                            value2 = values.get((int)var13_174);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_174 == false ? l : (result <<= (int)l);
                            }
                            ++var13_174;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result <<= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GTGT) {
                    if (isWide) {
                        void var13_177;
                        long result = 0L;
                        boolean bl13 = false;
                        while (var13_177 < values.size()) {
                            value2 = values.get((int)var13_177);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_177 == false ? l : (result >>= (int)l);
                            }
                            ++var13_177;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result >>= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.GTGTGT) {
                    if (isWide) {
                        void var13_180;
                        long result = 0L;
                        boolean bl14 = false;
                        while (var13_180 < values.size()) {
                            value2 = values.get((int)var13_180);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_180 == false ? l : (result >>>= (int)l);
                            }
                            ++var13_180;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result >>>= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.PLUS) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_183;
                            double result = 0.0;
                            boolean bl15 = false;
                            while (var13_183 < values.size()) {
                                value2 = values.get((int)var13_183);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_183 == false ? l : (result += l);
                                }
                                ++var13_183;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result += l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_186;
                        long result = 0L;
                        boolean bl16 = false;
                        while (var13_186 < values.size()) {
                            value2 = values.get((int)var13_186);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_186 == false ? l : (result += l);
                            }
                            ++var13_186;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result += l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.MINUS) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_189;
                            double result = 0.0;
                            boolean bl17 = false;
                            while (var13_189 < values.size()) {
                                value2 = values.get((int)var13_189);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_189 == false ? l : (result -= l);
                                }
                                ++var13_189;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result -= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_192;
                        long result = 0L;
                        boolean bl18 = false;
                        while (var13_192 < values.size()) {
                            value2 = values.get((int)var13_192);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_192 == false ? l : (result -= l);
                            }
                            ++var13_192;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result -= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.ASTERISK) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_195;
                            double result = 0.0;
                            boolean bl19 = false;
                            while (var13_195 < values.size()) {
                                value2 = values.get((int)var13_195);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_195 == false ? l : (result *= l);
                                }
                                ++var13_195;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result *= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_198;
                        long result = 0L;
                        boolean bl20 = false;
                        while (var13_198 < values.size()) {
                            value2 = values.get((int)var13_198);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                result = var13_198 == false ? l : (result *= l);
                            }
                            ++var13_198;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        result *= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.DIV) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_201;
                            double result = 0.0;
                            boolean bl21 = false;
                            while (var13_201 < values.size()) {
                                value2 = values.get((int)var13_201);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_201 == false ? l : (result /= l);
                                }
                                ++var13_201;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result /= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_204;
                        long result = 0L;
                        boolean bl22 = false;
                        while (var13_204 < values.size()) {
                            value2 = values.get((int)var13_204);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                if (var13_204 == false) {
                                    result = l;
                                } else {
                                    if (l == 0L) {
                                        return null;
                                    }
                                    result /= l;
                                }
                            }
                            ++var13_204;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        if (l == 0) {
                            return null;
                        }
                        result /= l;
                    }
                    return result;
                }
                if (operator == JavaTokenType.PERC) {
                    if (isFloat) {
                        if (isWide) {
                            void var13_207;
                            double result = 0.0;
                            boolean bl23 = false;
                            while (var13_207 < values.size()) {
                                value2 = values.get((int)var13_207);
                                if (value2 instanceof Number) {
                                    double l = ((Number)value2).doubleValue();
                                    result = var13_207 == false ? l : (result %= l);
                                }
                                ++var13_207;
                            }
                            return result;
                        }
                        float result = 0.0f;
                        for (i = 0; i < values.size(); ++i) {
                            Object e = values.get(i);
                            if (!(e instanceof Number)) continue;
                            float l = ((Number)e).floatValue();
                            if (i == 0) {
                                result = l;
                                continue;
                            }
                            result %= l;
                        }
                        return Float.valueOf(result);
                    }
                    if (isWide) {
                        void var13_210;
                        long result = 0L;
                        boolean bl24 = false;
                        while (var13_210 < values.size()) {
                            value2 = values.get((int)var13_210);
                            if (value2 instanceof Number) {
                                long l = ((Number)value2).longValue();
                                if (var13_210 == false) {
                                    result = l;
                                } else {
                                    if (l == 0L) {
                                        return null;
                                    }
                                    result %= l;
                                }
                            }
                            ++var13_210;
                        }
                        return result;
                    }
                    int result = 0;
                    for (i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (!(e instanceof Number)) continue;
                        int l = ((Number)e).intValue();
                        if (i == 0) {
                            result = l;
                            continue;
                        }
                        if (l == 0) {
                            return null;
                        }
                        result %= l;
                    }
                    return result;
                }
                return null;
            }
        } else {
            if (node instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                Object operandValue = this.evaluate((PsiElement)cast.getOperand());
                if (operandValue instanceof Number) {
                    Number number = (Number)operandValue;
                    PsiTypeElement typeElement = cast.getCastType();
                    if (typeElement != null) {
                        PsiType type = typeElement.getType();
                        if (PsiType.FLOAT.equals((Object)type)) {
                            return Float.valueOf(number.floatValue());
                        }
                        if (PsiType.DOUBLE.equals((Object)type)) {
                            return number.doubleValue();
                        }
                        if (PsiType.INT.equals((Object)type)) {
                            return number.intValue();
                        }
                        if (PsiType.LONG.equals((Object)type)) {
                            return number.longValue();
                        }
                        if (PsiType.SHORT.equals((Object)type)) {
                            return number.shortValue();
                        }
                        if (PsiType.BYTE.equals((Object)type)) {
                            return number.byteValue();
                        }
                    }
                }
                return operandValue;
            }
            if (node instanceof PsiReference) {
                PsiLocalVariable variable;
                PsiExpression last;
                PsiElement resolved = ((PsiReference)node).resolve();
                if (resolved instanceof PsiField) {
                    PsiExpression expression;
                    PsiField field = (PsiField)resolved;
                    if ("length".equals(field.getName()) && node instanceof PsiReferenceExpression && (expression = ((PsiReferenceExpression)node).getQualifierExpression()) != null && expression.getType() instanceof PsiArrayType) {
                        Object array = this.evaluate((PsiElement)expression);
                        int size = ConstantEvaluator.getArraySize(array);
                        if (size != -1) {
                            return size;
                        }
                        return null;
                    }
                    Object value = field.computeConstantValue();
                    if (value != null) {
                        return value;
                    }
                    if (field.getInitializer() != null && (this.allowFieldInitializers || field.hasModifierProperty("static") && field.hasModifierProperty("final")) && (value = this.evaluate((PsiElement)field.getInitializer())) != null) {
                        PsiIfStatement curr = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiIfStatement.class);
                        while (curr != null) {
                            PsiExpression condition;
                            if (curr.getCondition() != null && ConstantEvaluator.references(curr.getCondition(), (PsiVariable)field) && !PsiTreeUtil.isAncestor((PsiElement)(condition = curr.getCondition()), (PsiElement)node, (boolean)true)) {
                                return value;
                            }
                            curr = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)curr, PsiIfStatement.class, (boolean)true);
                        }
                        return value;
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                    return this.evaluate((PsiElement)last);
                }
            } else if (node instanceof PsiNewExpression) {
                PsiNewExpression creation = (PsiNewExpression)node;
                PsiArrayInitializerExpression initializer = creation.getArrayInitializer();
                PsiType type = creation.getType();
                if (type instanceof PsiArrayType) {
                    Object fixedSize;
                    if (initializer != null) {
                        int i;
                        Object[] array;
                        PsiExpression[] initializers = initializer.getInitializers();
                        Class<?> commonType = null;
                        ArrayList values = Lists.newArrayListWithExpectedSize((int)initializers.length);
                        int count = 0;
                        for (PsiExpression expression : initializers) {
                            Object object = this.evaluate((PsiElement)expression);
                            if (object != null) {
                                values.add(object);
                                if (commonType == null) {
                                    commonType = object.getClass();
                                } else {
                                    while (!commonType.isAssignableFrom(object.getClass())) {
                                        commonType = commonType.getSuperclass();
                                    }
                                }
                            } else if (!this.allowUnknown) {
                                return null;
                            }
                            if (++count != 40) continue;
                            return ConstantEvaluator.getArray(type.getDeepComponentType(), initializers.length, 1);
                        }
                        if ((type = type.getDeepComponentType()) == PsiType.INT) {
                            if (!values.isEmpty()) {
                                array = new int[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Integer)) continue;
                                    array[i] = (Integer)o;
                                }
                                return array;
                            }
                            return new int[0];
                        }
                        if (type == PsiType.BOOLEAN) {
                            if (!values.isEmpty()) {
                                array = new boolean[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Boolean)) continue;
                                    array[i] = ((Boolean)o).booleanValue() ? 1 : 0;
                                }
                                return array;
                            }
                            return new boolean[0];
                        }
                        if (type == PsiType.DOUBLE) {
                            if (!values.isEmpty()) {
                                array = new double[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Double)) continue;
                                    array[i] = (int)((Double)o).doubleValue();
                                }
                                return array;
                            }
                            return new double[0];
                        }
                        if (type == PsiType.LONG) {
                            if (!values.isEmpty()) {
                                array = new long[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Long)) continue;
                                    array[i] = (int)((Long)o).longValue();
                                }
                                return array;
                            }
                            return new long[0];
                        }
                        if (type == PsiType.FLOAT) {
                            if (!values.isEmpty()) {
                                array = new float[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Float)) continue;
                                    array[i] = (int)((Float)o).floatValue();
                                }
                                return array;
                            }
                            return new float[0];
                        }
                        if (type == PsiType.CHAR) {
                            if (!values.isEmpty()) {
                                array = new char[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Character)) continue;
                                    array[i] = ((Character)o).charValue();
                                }
                                return array;
                            }
                            return new char[0];
                        }
                        if (type == PsiType.BYTE) {
                            if (!values.isEmpty()) {
                                array = new byte[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Byte)) continue;
                                    array[i] = ((Byte)o).byteValue();
                                }
                                return array;
                            }
                            return new byte[0];
                        }
                        if (type == PsiType.SHORT) {
                            if (!values.isEmpty()) {
                                array = new short[values.size()];
                                for (i = 0; i < values.size(); ++i) {
                                    Object o = values.get(i);
                                    if (!(o instanceof Short)) continue;
                                    array[i] = ((Short)o).shortValue();
                                }
                                return array;
                            }
                            return new short[0];
                        }
                        if (!values.isEmpty()) {
                            Object o = Array.newInstance(commonType, values.size());
                            return values.toArray((Object[])o);
                        }
                        return null;
                    }
                    PsiExpression[] arrayDimensions = creation.getArrayDimensions();
                    int size = 0;
                    if (arrayDimensions.length > 0 && (fixedSize = this.evaluate((PsiElement)arrayDimensions[0])) instanceof Number) {
                        size = ((Number)fixedSize).intValue();
                    }
                    int dimensions = type.getArrayDimensions();
                    type = type.getDeepComponentType();
                    return ConstantEvaluator.getArray(type, size, dimensions);
                }
            } else {
                if (node instanceof KtLiteralStringTemplateEntry) {
                    return node.getText();
                }
                if (node instanceof KtStringTemplateExpression) {
                    KtStringTemplateExpression template = (KtStringTemplateExpression)node;
                    StringBuilder sb = new StringBuilder();
                    boolean parts = false;
                    for (KtStringTemplateEntry entry : template.getEntries()) {
                        if (entry instanceof KtLiteralStringTemplateEntry) {
                            sb.append(entry.getText());
                            parts = true;
                            continue;
                        }
                        KtExpression expression = entry.getExpression();
                        Object part = this.evaluate((PsiElement)expression);
                        if (!(part instanceof String)) continue;
                        sb.append(part);
                        parts = true;
                    }
                    if (parts) {
                        return sb.toString();
                    }
                } else {
                    if (node instanceof KtUltraLightMethodForSourceDeclaration) {
                        return this.valueFromProperty(((KtUltraLightMethodForSourceDeclaration)node).getKotlinOrigin());
                    }
                    if (node instanceof KtUltraLightFieldForSourceDeclaration) {
                        return this.valueFromProperty((KtDeclaration)((KtUltraLightFieldForSourceDeclaration)node).getKotlinOrigin());
                    }
                    if (node instanceof KtProperty) {
                        KtProperty property = (KtProperty)node;
                        return this.valueFromProperty((KtDeclaration)property);
                    }
                }
            }
        }
        return null;
    }

    private Object valueFromProperty(KtDeclaration origin) {
        if (origin instanceof KtProperty) {
            KtExpression initializer;
            KtProperty property = (KtProperty)origin;
            if (this.allowFieldInitializers) {
                KtExpression initializer2 = property.getInitializer();
                if (initializer2 != null) {
                    return this.evaluate((PsiElement)initializer2);
                }
            } else if (!property.isVar() && property.getGetter() == null && property.getSetter() == null && (initializer = property.getInitializer()) != null) {
                return this.evaluate((PsiElement)initializer);
            }
        }
        return null;
    }

    private static Object getArray(PsiType type, int size, int dimensions) {
        if (type instanceof PsiPrimitiveType) {
            if (size <= 12) {
                if (PsiType.BYTE.equals((Object)type)) {
                    return new byte[size];
                }
                if (PsiType.BOOLEAN.equals((Object)type)) {
                    return new boolean[size];
                }
                if (PsiType.INT.equals((Object)type)) {
                    return new int[size];
                }
                if (PsiType.LONG.equals((Object)type)) {
                    return new long[size];
                }
                if (PsiType.CHAR.equals((Object)type)) {
                    return new char[size];
                }
                if (PsiType.FLOAT.equals((Object)type)) {
                    return new float[size];
                }
                if (PsiType.DOUBLE.equals((Object)type)) {
                    return new double[size];
                }
                if (PsiType.SHORT.equals((Object)type)) {
                    return new short[size];
                }
            } else {
                if (PsiType.BYTE.equals((Object)type)) {
                    return new ArrayReference(Byte.TYPE, size, dimensions);
                }
                if (PsiType.BOOLEAN.equals((Object)type)) {
                    return new ArrayReference(Boolean.TYPE, size, dimensions);
                }
                if (PsiType.INT.equals((Object)type)) {
                    return new ArrayReference(Integer.TYPE, size, dimensions);
                }
                if (PsiType.LONG.equals((Object)type)) {
                    return new ArrayReference(Long.TYPE, size, dimensions);
                }
                if (PsiType.CHAR.equals((Object)type)) {
                    return new ArrayReference(Character.TYPE, size, dimensions);
                }
                if (PsiType.FLOAT.equals((Object)type)) {
                    return new ArrayReference(Float.TYPE, size, dimensions);
                }
                if (PsiType.DOUBLE.equals((Object)type)) {
                    return new ArrayReference(Double.TYPE, size, dimensions);
                }
                if (PsiType.SHORT.equals((Object)type)) {
                    return new ArrayReference(Short.TYPE, size, dimensions);
                }
            }
        } else if (type instanceof PsiClassType) {
            String className = type.getCanonicalText();
            if ("java.lang.String".equals(className)) {
                if (size < 12) {
                    return new String[size];
                }
                return new ArrayReference(String.class, size, dimensions);
            }
            if ("java.lang.Object".equals(className)) {
                if (size < 12) {
                    return new Object[size];
                }
                return new ArrayReference(Object.class, size, dimensions);
            }
            return new ArrayReference(className, size, dimensions);
        }
        return null;
    }

    private static boolean references(PsiExpression element, final PsiVariable variable) {
        final AtomicBoolean found = new AtomicBoolean();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement refersTo = reference.resolve();
                if (variable.equals(refersTo)) {
                    found.set(true);
                }
                super.visitReferenceElement(reference);
            }
        });
        return found.get();
    }

    private static boolean references(UExpression element, final PsiVariable variable) {
        final AtomicBoolean found = new AtomicBoolean();
        element.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                PsiElement refersTo = node.resolve();
                if (variable.equals(refersTo)) {
                    found.set(true);
                }
                return super.visitSimpleNameReferenceExpression(node);
            }

            public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                return super.visitQualifiedReferenceExpression(node);
            }
        });
        return found.get();
    }

    public static boolean isArrayLiteral(PsiElement node) {
        PsiTypeCastExpression castExpression;
        PsiExpression operand;
        if (node instanceof PsiReference) {
            PsiLocalVariable variable;
            PsiExpression last;
            PsiElement resolved = ((PsiReference)node).resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return ConstantEvaluator.isArrayLiteral((PsiElement)field.getInitializer());
                }
            } else if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)last);
            }
        } else if (node instanceof PsiNewExpression) {
            PsiNewExpression creation = (PsiNewExpression)node;
            if (creation.getArrayInitializer() != null) {
                return true;
            }
            PsiType type = creation.getType();
            if (type instanceof PsiArrayType) {
                return true;
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return ConstantEvaluator.isArrayLiteral((PsiElement)expression);
            }
        } else if (node instanceof PsiTypeCastExpression && (operand = (castExpression = (PsiTypeCastExpression)node).getOperand()) != null) {
            return ConstantEvaluator.isArrayLiteral((PsiElement)operand);
        }
        return false;
    }

    public static boolean isArrayLiteral(UElement node) {
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.findLastAssignment(variable = (PsiVariable)resolved, node)) != null) {
                return ConstantEvaluator.isArrayLiteral((UElement)lastAssignment);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression = parenthesizedExpression.getExpression();
                return ConstantEvaluator.isArrayLiteral((UElement)expression);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                assert (castExpression != null);
                UExpression operand = castExpression.getOperand();
                return ConstantEvaluator.isArrayLiteral((UElement)operand);
            }
        }
        return false;
    }

    public static Object evaluate(JavaContext context2, PsiElement node) {
        Object evaluate = new ConstantEvaluator().evaluate(node);
        return evaluate;
    }

    public static Object evaluate(JavaContext context2, UElement element) {
        if (element instanceof ULiteralExpression) {
            return ((ULiteralExpression)element).getValue();
        }
        return new ConstantEvaluator().evaluate(element);
    }

    public static String evaluateString(JavaContext context2, PsiElement node, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator();
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(node)) instanceof String ? (String)value : null;
    }

    public static PsiExpression findLastAssignment(PsiElement usage, PsiVariable variable) {
        return ConstantEvaluator.findLastAssignment(usage, variable, false);
    }

    private static PsiExpression findLastAssignment(PsiElement usage, PsiVariable variable, boolean allowNonConst) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)usage, PsiStatement.class, (boolean)false);
        if (statement != null) {
            PsiStatement prev = allowNonConst ? statement : (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            String targetName = variable.getName();
            if (targetName == null) {
                return null;
            }
            while (prev != null) {
                if (prev instanceof PsiDeclarationStatement) {
                    for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                        if (!variable.equals(element)) continue;
                        return variable.getInitializer();
                    }
                } else if (prev instanceof PsiExpressionStatement) {
                    PsiReferenceExpression reference;
                    PsiAssignmentExpression assign;
                    PsiExpression lhs;
                    PsiExpression expression = ((PsiExpressionStatement)prev).getExpression();
                    if (expression instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                        return assign.getRExpression();
                    }
                } else if (prev instanceof PsiIfStatement) {
                    PsiStatement elseBranch;
                    PsiStatement thenBranch = ((PsiIfStatement)prev).getThenBranch();
                    if (thenBranch instanceof PsiBlockStatement) {
                        PsiExpression assignmentInIf;
                        PsiStatement[] thenStatements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements();
                        PsiExpression psiExpression = assignmentInIf = thenStatements.length > 0 ? ConstantEvaluator.findLastAssignment((PsiElement)thenStatements[thenStatements.length - 1], variable, true) : null;
                        if (assignmentInIf != null) {
                            return allowNonConst ? assignmentInIf : null;
                        }
                    }
                    if ((elseBranch = ((PsiIfStatement)prev).getElseBranch()) instanceof PsiBlockStatement) {
                        PsiExpression assignmentInElse;
                        PsiStatement[] elseStatements = ((PsiBlockStatement)elseBranch).getCodeBlock().getStatements();
                        PsiExpression psiExpression = assignmentInElse = elseStatements.length > 0 ? ConstantEvaluator.findLastAssignment((PsiElement)elseStatements[elseStatements.length - 1], variable, true) : null;
                        if (assignmentInElse != null) {
                            return allowNonConst ? assignmentInElse : null;
                        }
                    }
                }
                prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
            }
        }
        return null;
    }

    public static String evaluateString(JavaContext context2, UElement element, boolean allowUnknown) {
        Object value;
        ConstantEvaluator evaluator = new ConstantEvaluator();
        if (allowUnknown) {
            evaluator.allowUnknowns();
        }
        return (value = evaluator.evaluate(element)) instanceof String ? (String)value : null;
    }

    public static class ArrayReference {
        public final Class<?> type;
        public final String className;
        public final int size;
        public final int dimensions;

        public ArrayReference(Class<?> type, int size, int dimensions) {
            this.type = type;
            this.className = null;
            this.size = size;
            this.dimensions = dimensions;
        }

        public ArrayReference(String className, int size, int dimensions) {
            this.className = className;
            this.type = null;
            this.size = size;
            this.dimensions = dimensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayReference that = (ArrayReference)o;
            return this.size == that.size && this.dimensions == that.dimensions && Objects.equals(this.type, that.type) && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.className, this.size, this.dimensions);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Array Reference: ");
            if (this.type != null) {
                sb.append(this.type.toString());
            } else if (this.className != null) {
                sb.append(this.className);
            }
            for (int i = 0; i < this.dimensions - 1; ++i) {
                sb.append("[]");
            }
            sb.append("[");
            sb.append(Integer.toString(this.size));
            sb.append("]");
            return sb.toString();
        }
    }

    public static class LastAssignmentFinder
    extends AbstractUastVisitor {
        public static final Object LAST_ASSIGNMENT_VALUE_UNKNOWN = new String("<unknown>");
        private final PsiVariable mVariable;
        private final UElement mEndAt;
        private final ConstantEvaluator mConstantEvaluator;
        private boolean mDone = false;
        private int mCurrentLevel = 0;
        private int mVariableLevel = -1;
        private Object mCurrentValue;
        private UElement mLastAssignment;

        public LastAssignmentFinder(PsiVariable variable, UElement endAt, ConstantEvaluator constantEvaluator, int variableLevel) {
            this.mVariable = variable;
            this.mEndAt = endAt;
            UExpression initializer = UastFacade.INSTANCE.getInitializerBody(variable);
            this.mLastAssignment = initializer;
            this.mConstantEvaluator = constantEvaluator;
            if (initializer != null && constantEvaluator != null) {
                this.mCurrentValue = constantEvaluator.evaluate((UElement)initializer);
            }
            this.mVariableLevel = variableLevel;
        }

        public Object getCurrentValue() {
            return this.mCurrentValue;
        }

        public UElement getLastAssignment() {
            return this.mLastAssignment;
        }

        public boolean visitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                ++this.mCurrentLevel;
            }
            if (node.equals(this.mEndAt)) {
                this.mDone = true;
            }
            return this.mDone || super.visitElement(node);
        }

        public boolean visitVariable(UVariable node) {
            if (this.mVariableLevel < 0 && node.getPsi().isEquivalentTo((PsiElement)this.mVariable)) {
                this.mVariableLevel = this.mCurrentLevel;
            }
            return super.visitVariable(node);
        }

        public void afterVisitBinaryExpression(UBinaryExpression node) {
            if (!this.mDone && node.getOperator() instanceof UastBinaryOperator.AssignOperator && this.mVariableLevel >= 0) {
                UExpression leftOperand = node.getLeftOperand();
                UastBinaryOperator operator = node.getOperator();
                if (!(operator instanceof UastBinaryOperator.AssignOperator) || !(leftOperand instanceof UResolvable)) {
                    return;
                }
                PsiElement resolved = ((UResolvable)leftOperand).resolve();
                if (!this.mVariable.equals(resolved)) {
                    return;
                }
                UExpression rightOperand = node.getRightOperand();
                ConstantEvaluator constantEvaluator = this.mConstantEvaluator;
                this.mLastAssignment = rightOperand;
                if (this.mCurrentLevel >= this.mVariableLevel + 1) {
                    this.mCurrentValue = null;
                    return;
                }
                this.mCurrentValue = constantEvaluator != null ? constantEvaluator.evaluate((UElement)rightOperand) : null;
            }
            super.afterVisitBinaryExpression(node);
        }

        public void afterVisitElement(UElement node) {
            if (LastAssignmentFinder.elementHasLevel(node)) {
                --this.mCurrentLevel;
            }
            super.afterVisitElement(node);
        }

        private static boolean elementHasLevel(UElement node) {
            return !(node instanceof UBlockExpression) && !(node instanceof UDeclarationsExpression) && !(node instanceof UParenthesizedExpression);
        }
    }
}

