/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ApiConstraintKt;
import com.android.tools.lint.detector.api.ExtensionSdkRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 #2\u00020\u0001:\u0004#$%&B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0000H&J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0013\u0010\b\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0000H\u00a6\u0004J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H'J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0004H&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0000H&J\b\u0010\u0011\u001a\u00020\u0007H&J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H&J\b\u0010\u0014\u001a\u00020\u0007H&J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0000H&J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\u0018\u001a\u00020\u0004H&J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0000H\u00a6\u0002J\u0013\u0010\u001d\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0000H\u00a6\u0004J\b\u0010\u001e\u001a\u00020\u001bH&J\b\u0010\u001f\u001a\u00020\u0007H&J\b\u0010 \u001a\u00020\u001bH&J\u0014\u0010 \u001a\u00020\u001b2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H&\u0082\u0001\u0002'\f\u00a8\u0006("}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint;", "", "()V", "alwaysAtLeast", "", "minSdk", "apiLevel", "", "and", "other", "everHigher", "findSdk", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "sdkId", "certain", "firstMissing", "requirement", "fromInclusive", "getConstraints", "", "getSdk", "includes", "isAtLeast", "constraint", "isEmpty", "min", "minString", "", "not", "or", "serialize", "toExclusive", "toString", "sdkRegistry", "Lcom/android/tools/lint/detector/api/ExtensionSdkRegistry;", "Companion", "MultiSdkApiConstraint", "SdkApiConstraint", "SdkApiConstraints", "Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint;", "lint-api"})
public abstract class ApiConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final SdkApiConstraint NONE = SdkApiConstraint.Companion.getNO_LEVELS();
    @JvmField
    @NotNull
    public static final SdkApiConstraint UNKNOWN = new SdkApiConstraint(0L, -2, null);
    @JvmField
    @NotNull
    public static final SdkApiConstraint ALL = com.android.tools.lint.detector.api.ApiConstraint$Companion.atLeast$default(Companion, 1, 0, 2, null);
    @NotNull
    private static final List<SdkApiConstraint> simpleApiLevels;

    private ApiConstraint() {
    }

    public final int min() {
        return this.fromInclusive();
    }

    public abstract int fromInclusive();

    public abstract int toExclusive();

    public abstract boolean isAtLeast(@NotNull ApiConstraint var1);

    public abstract boolean includes(int var1);

    public abstract boolean alwaysAtLeast(@NotNull ApiConstraint var1);

    @NotNull
    public abstract ApiConstraint not();

    public abstract boolean isEmpty();

    @NotNull
    public abstract ApiConstraint or(@Nullable ApiConstraint var1);

    @NotNull
    public abstract ApiConstraint and(@Nullable ApiConstraint var1);

    @NotNull
    public abstract String serialize();

    @NotNull
    public abstract String toString();

    @NotNull
    public abstract String toString(@Nullable ExtensionSdkRegistry var1);

    public static /* synthetic */ String toString$default(ApiConstraint apiConstraint, ExtensionSdkRegistry extensionSdkRegistry, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toString");
        }
        if ((n & 1) != 0) {
            extensionSdkRegistry = null;
        }
        return apiConstraint.toString(extensionSdkRegistry);
    }

    @NotNull
    public final String minString() {
        return String.valueOf(this.fromInclusive());
    }

    @Nullable
    public abstract SdkApiConstraint findSdk(int var1, boolean var2);

    public static /* synthetic */ SdkApiConstraint findSdk$default(ApiConstraint apiConstraint, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findSdk");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return apiConstraint.findSdk(n, bl);
    }

    public abstract int getSdk();

    @NotNull
    public abstract List<SdkApiConstraint> getConstraints();

    @Deprecated(message="Use the ApiConstraint version instead to make sure you're checking the right SDK extension", replaceWith=@ReplaceWith(expression="isAtLeast(ApiConstraint.get(apiLevel,com.android.tools.lint.detector.api.ExtensionSdk.Companion.ANDROID_SDK_ID))", imports={}))
    public boolean isAtLeast(int apiLevel) {
        return this.isAtLeast(com.android.tools.lint.detector.api.ApiConstraint$Companion.atLeast$default(Companion, apiLevel, 0, 2, null));
    }

    @Deprecated(message="Use the ApiConstraint version instead to make sure you're checking the right SDK extension", replaceWith=@ReplaceWith(expression="alwaysAtLeast(ApiConstraint.get(apiLevel,com.android.tools.lint.detector.api.ExtensionSdk.Companion.ANDROID_SDK_ID))", imports={}))
    public abstract boolean alwaysAtLeast(int var1);

    @Deprecated(message="Use the ApiConstraint version instead to make sure you're checking the right SDK extension", replaceWith=@ReplaceWith(expression="everHigher(ApiConstraint.get(apiLevel,com.android.tools.lint.detector.api.ExtensionSdk.Companion.ANDROID_SDK_ID))", imports={}))
    public abstract boolean everHigher(int var1);

    @Nullable
    public abstract SdkApiConstraint firstMissing(@NotNull ApiConstraint var1);

    @JvmStatic
    @NotNull
    public static final SdkApiConstraint get(int apiLevel, int sdkId) {
        return Companion.get(apiLevel, sdkId);
    }

    @JvmStatic
    @NotNull
    public static final SdkApiConstraint atLeast(int apiLevel, int sdkId) {
        return Companion.atLeast(apiLevel, sdkId);
    }

    public /* synthetic */ ApiConstraint(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * WARNING - void declaration
     */
    static {
        int n = 34;
        Companion companion = Companion;
        ArrayList<SdkApiConstraint> arrayList = new ArrayList<SdkApiConstraint>(n);
        int n2 = 0;
        while (n2 < n) {
            void p0;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<SdkApiConstraint> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(com.android.tools.lint.detector.api.ApiConstraint$Companion.atLeast$default(companion, (int)p0, 0, 2, null));
        }
        simpleApiLevels = arrayList;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0007J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ-\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007\u00a2\u0006\u0002\b\u001eJ\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ \u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0011R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$Companion;", "", "()V", "ALL", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "NONE", "UNKNOWN", "simpleApiLevels", "", "above", "apiLevel", "", "sdkId", "atLeast", "atMost", "below", "deserialize", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "s", "", "exactly", "get", "getFromUsesSdk", "usesSdk", "Lorg/w3c/dom/Element;", "max", "api1", "api2", "either", "", "maxNullable", "not", "range", "fromInclusive", "toExclusive", "serialize", "constraint", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SdkApiConstraint get(int apiLevel, int sdkId) {
            if (apiLevel == -1) {
                return UNKNOWN;
            }
            if (apiLevel < simpleApiLevels.size() && sdkId == 0) {
                return (SdkApiConstraint)simpleApiLevels.get(apiLevel);
            }
            return this.atLeast(apiLevel, sdkId);
        }

        public static /* synthetic */ SdkApiConstraint get$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.get(n, n2);
        }

        @JvmName(name="maxNullable")
        @Nullable
        public final ApiConstraint maxNullable(@Nullable ApiConstraint api1, @Nullable ApiConstraint api2, boolean either) {
            if (api1 == null) {
                return api2;
            }
            return this.max(api1, api2, either);
        }

        public static /* synthetic */ ApiConstraint maxNullable$default(Companion companion, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.maxNullable(apiConstraint, apiConstraint2, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ApiConstraint max(@NotNull ApiConstraint api1, @Nullable ApiConstraint api2, boolean either) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)api1, (String)"api1");
            boolean bl2 = bl = api1 != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = api2 != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (api2 == null) {
                return api1;
            }
            if (api1.isEmpty()) {
                return NONE;
            }
            if (api2.isEmpty()) {
                return NONE;
            }
            ApiConstraint apiConstraint = api1;
            if (apiConstraint instanceof SdkApiConstraint) {
                ApiConstraint apiConstraint2;
                if (api2 instanceof SdkApiConstraint) {
                    int sdkId = ((SdkApiConstraint)api1).getSdkId();
                    if (sdkId == ((SdkApiConstraint)api2).getSdkId()) {
                        apiConstraint2 = new SdkApiConstraint(ULong.constructor-impl((long)(((SdkApiConstraint)api1).getBits-s-VKNKU() & ((SdkApiConstraint)api2).getBits-s-VKNKU())), sdkId, null);
                    } else {
                        Object[] objectArray = new SdkApiConstraints[]{new SdkApiConstraints(sdkId, (SdkApiConstraint)api1, either), new SdkApiConstraints(((SdkApiConstraint)api2).getSdkId(), (SdkApiConstraint)api2, either)};
                        apiConstraint2 = new MultiSdkApiConstraint(CollectionsKt.listOf((Object[])objectArray));
                    }
                } else {
                    apiConstraint2 = this.max(api2, api1, either);
                }
                return apiConstraint2;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                ApiConstraint apiConstraint3 = api2;
                if (apiConstraint3 instanceof SdkApiConstraint) {
                    void $this$mapTo$iv$iv;
                    SdkApiConstraints sdkApiConstraints = ((MultiSdkApiConstraint)api1).findSdks$lint_api(((SdkApiConstraint)api2).getSdkId());
                    if (sdkApiConstraints == null) {
                        return new MultiSdkApiConstraint(CollectionsKt.plus((Collection)((MultiSdkApiConstraint)api1).getSdkConstraints$lint_api(), (Object)new SdkApiConstraints(((SdkApiConstraint)api2).getSdkId(), (SdkApiConstraint)api2, either)));
                    }
                    SdkApiConstraints match = sdkApiConstraints;
                    Iterable $this$map$iv = ((MultiSdkApiConstraint)api1).getSdkConstraints$lint_api();
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it;
                        SdkApiConstraints sdkApiConstraints2 = (SdkApiConstraints)item$iv$iv2;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(it == match ? it.andWith((SdkApiConstraint)api2, either) : it);
                    }
                    List apis2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                    return new MultiSdkApiConstraint(apis2);
                }
                if (apiConstraint3 instanceof MultiSdkApiConstraint) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ((MultiSdkApiConstraint)api1).getSdkConstraints$lint_api();
                    boolean $i$f$map = false;
                    Iterable $i$f$map2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void have;
                        SdkApiConstraints item$iv$iv2 = (SdkApiConstraints)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        SdkApiConstraints match = ((MultiSdkApiConstraint)api2).findSdks$lint_api(have.getSdkId());
                        collection.add(match != null ? have.and(match) : have);
                    }
                    List apis3 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    Iterable $this$forEach$iv = ((MultiSdkApiConstraint)api2).getSdkConstraints$lint_api();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl6 = false;
                        if (((MultiSdkApiConstraint)api1).findSdks$lint_api(it.getSdkId()) != null) continue;
                        apis3.add(it);
                    }
                    return new MultiSdkApiConstraint(apis3);
                }
                throw new NoWhenBranchMatchedException();
            }
            throw new NoWhenBranchMatchedException();
        }

        public static /* synthetic */ ApiConstraint max$default(Companion companion, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.max(apiConstraint, apiConstraint2, bl);
        }

        @JvmStatic
        @NotNull
        public final SdkApiConstraint atLeast(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, null, false, sdkId, 6, null);
        }

        public static /* synthetic */ SdkApiConstraint atLeast$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atLeast(n, n2);
        }

        @NotNull
        public final SdkApiConstraint below(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, null, apiLevel, false, sdkId, 5, null);
        }

        public static /* synthetic */ SdkApiConstraint below$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.below(n, n2);
        }

        @NotNull
        public final SdkApiConstraint above(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel + 1, null, false, sdkId, 6, null);
        }

        public static /* synthetic */ SdkApiConstraint above$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.above(n, n2);
        }

        @NotNull
        public final SdkApiConstraint atMost(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, null, apiLevel + 1, false, sdkId, 5, null);
        }

        public static /* synthetic */ SdkApiConstraint atMost$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atMost(n, n2);
        }

        @NotNull
        public final SdkApiConstraint range(int fromInclusive, int toExclusive, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, fromInclusive, toExclusive, false, sdkId, 4, null);
        }

        public static /* synthetic */ SdkApiConstraint range$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.range(n, n2, n3);
        }

        @NotNull
        public final SdkApiConstraint exactly(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, apiLevel + 1, false, sdkId, 4, null);
        }

        public static /* synthetic */ SdkApiConstraint exactly$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.exactly(n, n2);
        }

        @NotNull
        public final SdkApiConstraint not(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint(apiLevel, apiLevel + 1, true, sdkId);
        }

        public static /* synthetic */ SdkApiConstraint not$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.not(n, n2);
        }

        @NotNull
        public final String serialize(@NotNull ApiConstraint constraint2) {
            Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
            return constraint2.serialize();
        }

        @NotNull
        public final ApiConstraint deserialize(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return StringsKt.startsWith$default((CharSequence)s, (char)'{', (boolean)false, (int)2, null) ? MultiSdkApiConstraint.Companion.deserialize(s) : (ApiConstraint)SdkApiConstraint.Companion.deserialize(s);
        }

        @Nullable
        public final ApiConstraint getFromUsesSdk(@NotNull Element usesSdk) {
            Intrinsics.checkNotNullParameter((Object)usesSdk, (String)"usesSdk");
            boolean bl = Intrinsics.areEqual((Object)usesSdk.getTagName(), (Object)"uses-sdk");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String minSdkVersionString = usesSdk.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
            Intrinsics.checkNotNullExpressionValue((Object)minSdkVersionString, (String)"minSdkVersionString");
            int minSdkVersion = ApiConstraintKt.access$getApiLevel(minSdkVersionString);
            String codeName = ApiConstraintKt.access$isNumber(minSdkVersionString) ? null : minSdkVersionString;
            Node node = usesSdk.getFirstChild();
            if (node == null) {
                return minSdkVersion != -1 ? (ApiConstraint)com.android.tools.lint.detector.api.ApiConstraint$Companion.get$default(this, minSdkVersion, 0, 2, null) : null;
            }
            Node curr = node;
            List list2 = new ArrayList();
            boolean addMinSdkVersion = minSdkVersion != -1;
            while (true) {
                if (curr.getNodeType() == 1 && Intrinsics.areEqual((Object)curr.getNodeName(), (Object)"extension-sdk")) {
                    Element extension = (Element)curr;
                    String sdkVersionString = extension.getAttributeNS("http://schemas.android.com/apk/res/android", "sdkVersion");
                    Intrinsics.checkNotNullExpressionValue((Object)sdkVersionString, (String)"sdkVersionString");
                    int sdkVersion = ApiConstraintKt.access$getApiLevel(sdkVersionString);
                    String string = extension.getAttributeNS("http://schemas.android.com/apk/res/android", "minExtensionVersion");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extension.getAttributeNS\u2026I, \"minExtensionVersion\")");
                    int extensionVersion = ApiConstraintKt.access$getApiLevel(string);
                    if (sdkVersion == minSdkVersion && (codeName == null || Intrinsics.areEqual((Object)codeName, (Object)sdkVersionString))) {
                        addMinSdkVersion = false;
                    }
                    list2.add(SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, extensionVersion, null, false, sdkVersion, 6, null));
                }
                if (curr.getNextSibling() == null) break;
            }
            if (addMinSdkVersion) {
                list2.add(0, SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, minSdkVersion, null, false, 0, 6, null));
            }
            return new MultiSdkApiConstraint(list2, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0013\u0010\u0010\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0016\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0001H\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\rH\u0016J\t\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\"\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\b\u0010&\u001a\u00020$H\u0016J\u0012\u0010&\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "bits", "Lkotlin/ULong;", "sdkId", "", "(JILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBits-s-VKNKU", "()J", "J", "getSdkId", "()I", "alwaysAtLeast", "", "minSdk", "apiLevel", "and", "other", "everHigher", "findSdk", "certain", "firstMissing", "requirement", "fromInclusive", "getConstraints", "", "getSdk", "includes", "includesApiLevel", "level", "isAtLeast", "constraint", "isEmpty", "not", "or", "serialize", "", "toExclusive", "toString", "sdkRegistry", "Lcom/android/tools/lint/detector/api/ExtensionSdkRegistry;", "Companion", "lint-api"})
    public static final class SdkApiConstraint
    extends ApiConstraint {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long bits;
        private final int sdkId;
        private static final int FIRST_LEVEL = 1;
        private static final int INFINITY = 65;
        private static final int CUR_DEVELOPMENT_MARKER = 62;
        private static final int CUR_DEVELOPMENT = 10000;
        private static final int MAX_LEVEL = 61;
        @NotNull
        private static final SdkApiConstraint ALL_LEVELS = new SdkApiConstraint(-1L, -1, null);
        @NotNull
        private static final SdkApiConstraint NO_LEVELS = new SdkApiConstraint(0L, -1, null);

        private SdkApiConstraint(long bits, int sdkId) {
            super(null);
            this.bits = bits;
            this.sdkId = sdkId;
        }

        public /* synthetic */ SdkApiConstraint(long l, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(l, n, null);
        }

        public final long getBits-s-VKNKU() {
            return this.bits;
        }

        public final int getSdkId() {
            return this.sdkId;
        }

        @Override
        public int fromInclusive() {
            if (this.bits == 0L) {
                return -1;
            }
            int bit = SdkApiConstraint.Companion.lowestBitSet-VKZWuLQ(this.bits);
            return SdkApiConstraint.Companion.fromInternalApiLevel(bit);
        }

        @Override
        public int toExclusive() {
            if (this.bits == 0L) {
                return 65;
            }
            int bit = SdkApiConstraint.Companion.highestBitSet-VKZWuLQ(this.bits);
            return SdkApiConstraint.Companion.fromInternalApiLevel(bit + 1);
        }

        @Override
        public boolean isAtLeast(@NotNull ApiConstraint constraint2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
            boolean bl2 = bl = this != UNKNOWN && constraint2 != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.bits == 0L) {
                return true;
            }
            ApiConstraint apiConstraint = constraint2;
            if (apiConstraint instanceof SdkApiConstraint) {
                return this.sdkId == ((SdkApiConstraint)constraint2).sdkId && this.fromInclusive() >= constraint2.fromInclusive();
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                boolean anyMatch = false;
                for (SdkApiConstraints sdkApiConstraints : ((MultiSdkApiConstraint)constraint2).getSdkConstraints$lint_api()) {
                    SdkApiConstraint alwaysNeed = sdkApiConstraints.component2();
                    SdkApiConstraint mightNeed = sdkApiConstraints.component3();
                    if (alwaysNeed != null) {
                        if (!this.isAtLeast(alwaysNeed)) {
                            return false;
                        }
                        anyMatch = true;
                        continue;
                    }
                    if (mightNeed != null) {
                        if (anyMatch || !this.isAtLeast(mightNeed)) continue;
                        anyMatch = true;
                        continue;
                    }
                    throw new IllegalStateException();
                }
                return anyMatch;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @Nullable
        public SdkApiConstraint firstMissing(@NotNull ApiConstraint requirement) {
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            ApiConstraint apiConstraint = requirement;
            if (apiConstraint instanceof SdkApiConstraint) {
                return (SdkApiConstraint)requirement;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint;
                boolean anyMatch = false;
                SdkApiConstraint firstMissing = null;
                for (SdkApiConstraints sdkApiConstraints : ((MultiSdkApiConstraint)requirement).getSdkConstraints$lint_api()) {
                    SdkApiConstraint alwaysNeed = sdkApiConstraints.component2();
                    SdkApiConstraint mightNeed = sdkApiConstraints.component3();
                    if (alwaysNeed != null) {
                        if (!this.isAtLeast(alwaysNeed)) {
                            return alwaysNeed;
                        }
                        anyMatch = true;
                        continue;
                    }
                    if (mightNeed != null) {
                        if (anyMatch) continue;
                        if (this.isAtLeast(mightNeed)) {
                            anyMatch = true;
                            continue;
                        }
                        if (firstMissing != null) continue;
                        firstMissing = mightNeed;
                        continue;
                    }
                    throw new IllegalStateException();
                }
                if (anyMatch) {
                    sdkApiConstraint = null;
                } else {
                    sdkApiConstraint = firstMissing;
                    if (sdkApiConstraint == null) {
                        sdkApiConstraint = ((SdkApiConstraints)CollectionsKt.first(((MultiSdkApiConstraint)requirement).getSdkConstraints$lint_api())).lowest();
                    }
                }
                return sdkApiConstraint;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean isAtLeast(int apiLevel) {
            boolean bl;
            boolean bl2 = bl = this != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return this.sdkId == 0 && this.fromInclusive() >= apiLevel;
        }

        @Override
        public boolean includes(int apiLevel) {
            return ULong.constructor-impl((long)(this.bits & SdkApiConstraint.Companion.getApiLevelMask-I7RO_PI(apiLevel))) != 0L;
        }

        @Override
        public boolean alwaysAtLeast(int apiLevel) {
            long minSdk = Companion.createConstraintBits-qJGtvoU$default(Companion, apiLevel, null, false, 6, null);
            return ULong.constructor-impl((long)(minSdk & this.bits)) == minSdk;
        }

        @Override
        public boolean alwaysAtLeast(@NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
            ApiConstraint apiConstraint = minSdk;
            if (apiConstraint instanceof SdkApiConstraint) {
                boolean bl;
                boolean bl2 = bl = this.sdkId == ((SdkApiConstraint)minSdk).sdkId;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return ULong.constructor-impl((long)(((SdkApiConstraint)minSdk).bits & this.bits)) == ((SdkApiConstraint)minSdk).bits;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint = ApiConstraint.findSdk$default(minSdk, this.sdkId, false, 2, null);
                if (sdkApiConstraint == null) {
                    return false;
                }
                SdkApiConstraint sdk = sdkApiConstraint;
                return this.alwaysAtLeast(sdk);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean everHigher(int apiLevel) {
            long minSdk = Companion.createConstraintBits-qJGtvoU$default(Companion, apiLevel + 1, null, false, 6, null);
            return ULong.constructor-impl((long)(minSdk & this.bits)) != 0L;
        }

        @Override
        @NotNull
        public SdkApiConstraint not() {
            return new SdkApiConstraint(ULong.constructor-impl((long)(this.bits ^ 0xFFFFFFFFFFFFFFFFL)), this.sdkId, null);
        }

        @Override
        public boolean isEmpty() {
            return this.bits == 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint or(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = this != UNKNOWN && other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint == null) {
                return this;
            }
            if (apiConstraint instanceof SdkApiConstraint) {
                if (((SdkApiConstraint)other).isEmpty()) {
                    return this;
                }
                if (this.sdkId != ((SdkApiConstraint)other).sdkId) {
                    if (this.isEmpty()) {
                        return other;
                    }
                    Object[] objectArray = new SdkApiConstraints[]{new SdkApiConstraints(this.sdkId, null, this), new SdkApiConstraints(this.sdkId, null, (SdkApiConstraint)other)};
                    return new MultiSdkApiConstraint(CollectionsKt.listOf((Object[])objectArray));
                }
                return new SdkApiConstraint(ULong.constructor-impl((long)(this.bits | ((SdkApiConstraint)other).bits)), this.sdkId, null);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                void $this$mapTo$iv$iv;
                if (this.isEmpty()) {
                    return other;
                }
                if (((MultiSdkApiConstraint)other).isEmpty()) {
                    return this;
                }
                Iterable $this$map$iv = ((MultiSdkApiConstraint)other).getSdkConstraints$lint_api();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getSdkId() == this.sdkId ? it.orWith(this, true) : it);
                }
                List list2 = (List)destination$iv$iv;
                List mergedList = ApiConstraint.findSdk$default(other, this.sdkId, false, 2, null) != null ? list2 : CollectionsKt.plus((Collection)list2, (Object)new SdkApiConstraints(this.sdkId, null, this));
                return new MultiSdkApiConstraint(mergedList);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public ApiConstraint and(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = this != UNKNOWN && other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.isEmpty() || other != null && other.isEmpty()) {
                return NONE;
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint == null) {
                return this;
            }
            if (apiConstraint instanceof SdkApiConstraint) {
                if (this.sdkId != ((SdkApiConstraint)other).sdkId) {
                    return NONE;
                }
                return new SdkApiConstraint(ULong.constructor-impl((long)(this.bits & ((SdkApiConstraint)other).bits)), this.sdkId, null);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint = ApiConstraint.findSdk$default(other, this.sdkId, false, 2, null);
                if (sdkApiConstraint == null) {
                    return NONE;
                }
                SdkApiConstraint match = sdkApiConstraint;
                return new SdkApiConstraint(ULong.constructor-impl((long)(this.bits & match.bits)), this.sdkId, null);
            }
            throw new NoWhenBranchMatchedException();
        }

        private final boolean includesApiLevel(int level) {
            return ULong.constructor-impl((long)(this.bits & ULong.constructor-impl((long)(1L << level)))) != 0L;
        }

        @Override
        @NotNull
        public String serialize() {
            String s = UStringsKt.toString-JSWoG40((long)this.bits, (int)16);
            return this.sdkId == 0 ? s : s + ";" + this.sdkId;
        }

        @Override
        @NotNull
        public String toString() {
            String desc;
            String string = desc = this.sdkId == 0 ? "API level" : "version";
            if (this.bits == SdkApiConstraint.NO_LEVELS.bits) {
                if (this == UNKNOWN) {
                    return "Unknown";
                }
                return "No " + desc + "s";
            }
            if (this.bits == SdkApiConstraint.ALL_LEVELS.bits) {
                return "All " + desc + "s";
            }
            long negated = ULong.constructor-impl((long)(this.bits ^ 0xFFFFFFFFFFFFFFFFL));
            long lowest = ULong.constructor-impl((long)(negated & ULong.constructor-impl((long)(-negated))));
            if (lowest == negated) {
                int from = 1;
                while (lowest != 1L && lowest != 0L) {
                    lowest = ULong.constructor-impl((long)(lowest >>> 1));
                    ++from;
                }
                if (from > 1) {
                    return desc + " \u2260 " + from;
                }
            }
            List spans = new ArrayList();
            int next = 0;
            int max = 64;
            while (true) {
                if (next < max && !this.includesApiLevel(next)) {
                    ++next;
                    continue;
                }
                if (next == max) break;
                int start = SdkApiConstraint.Companion.fromInternalApiLevel(next++);
                while (next < max && this.includesApiLevel(next)) {
                    ++next;
                }
                int end = SdkApiConstraint.Companion.fromInternalApiLevel(next);
                String startString = String.valueOf(start);
                String endString = String.valueOf(end);
                if (end == start + 1) {
                    spans.add(desc + " = " + startString);
                    continue;
                }
                if (start == 1) {
                    spans.add(desc + " < " + endString);
                    continue;
                }
                if (end == max || next == max) {
                    spans.add(desc + " \u2265 " + startString);
                    break;
                }
                spans.add(desc + " \u2265 " + startString + " and " + desc + " < " + endString);
            }
            return CollectionsKt.joinToString$default((Iterable)spans, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String toString(@Nullable ExtensionSdkRegistry sdkRegistry) {
            Object object = sdkRegistry;
            Comparable sdk = object != null && (object = ((ExtensionSdkRegistry)object).find(this.sdkId)) != null ? (Comparable)object : (Comparable)((Object)("SDK " + this.sdkId));
            String constraintString = this.toString();
            return this.sdkId == 0 ? constraintString : sdk + ": " + constraintString;
        }

        @Override
        @Nullable
        public SdkApiConstraint findSdk(int sdkId, boolean certain) {
            return sdkId == this.sdkId ? this : null;
        }

        @Override
        public int getSdk() {
            return this.sdkId;
        }

        @Override
        @NotNull
        public List<SdkApiConstraint> getConstraints() {
            return CollectionsKt.listOf((Object)this);
        }

        @JvmStatic
        public static final boolean isValidApiLevel(int api) {
            return Companion.isValidApiLevel(api);
        }

        public /* synthetic */ SdkApiConstraint(long bits, int sdkId, DefaultConstructorMarker $constructor_marker) {
            this(bits, sdkId);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u001c\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J8\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J \u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b!\u0010\"J \u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b%\u0010\"J(\u0010&\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\bH\u0007J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u0004J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u001f\u0010-\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u00020\u001c*\u00020\u0017H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b1\u00102J\u0019\u00103\u001a\u00020\b*\u00020\u0017H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b4\u00105J\u0019\u00106\u001a\u00020\b*\u00020\u0017H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b7\u00105R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint$Companion;", "", "()V", "ALL_LEVELS", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "getALL_LEVELS", "()Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "CUR_DEVELOPMENT", "", "CUR_DEVELOPMENT_MARKER", "FIRST_LEVEL", "INFINITY", "MAX_LEVEL", "NO_LEVELS", "getNO_LEVELS", "createConstraint", "fromInclusive", "toExclusive", "negate", "", "sdkId", "(Ljava/lang/Integer;Ljava/lang/Integer;ZI)Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "createConstraintBits", "Lkotlin/ULong;", "createConstraintBits-qJGtvoU", "(Ljava/lang/Integer;Ljava/lang/Integer;Z)J", "deserialize", "s", "", "fromInternalApiLevel", "level", "getApiLevelMask", "apiLevel", "getApiLevelMask-I7RO_PI", "(I)J", "getBitMask", "bit", "getBitMask-I7RO_PI", "getBitMaskRange", "getBitMaskRange-ZIaKswc", "(II)J", "isValidApiLevel", "api", "serialize", "constraint", "toInternalApiLevel", "default", "(Ljava/lang/Integer;I)I", "binary", "binary-VKZWuLQ", "(J)Ljava/lang/String;", "highestBitSet", "highestBitSet-VKZWuLQ", "(J)I", "lowestBitSet", "lowestBitSet-VKZWuLQ", "lint-api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SdkApiConstraint getALL_LEVELS() {
                return ALL_LEVELS;
            }

            @NotNull
            public final SdkApiConstraint getNO_LEVELS() {
                return NO_LEVELS;
            }

            private final String binary-VKZWuLQ(long $this$binary_u2dVKZWuLQ) {
                String set = UStringsKt.toString-JSWoG40((long)$this$binary_u2dVKZWuLQ, (int)2);
                return StringsKt.repeat((CharSequence)"0", (int)(64 - set.length())) + set;
            }

            private final long getApiLevelMask-I7RO_PI(int apiLevel) {
                return ULong.constructor-impl((long)(1L << this.toInternalApiLevel(apiLevel)));
            }

            private final int toInternalApiLevel(Integer level, int n) {
                Integer n2 = level;
                if (n2 == null) {
                    return n - 1;
                }
                return this.toInternalApiLevel(n2);
            }

            private final int toInternalApiLevel(int level) {
                int n;
                if (level <= 61) {
                    n = level - 1;
                } else if (level == 10000 || level == 10001) {
                    n = 62 + (level - 10000) - 1;
                } else {
                    throw new IllegalStateException(("Unsupported API level " + level).toString());
                }
                return n;
            }

            private final int fromInternalApiLevel(int level) {
                int n;
                int userLevel = level + 1;
                switch (userLevel) {
                    case 62: 
                    case 63: {
                        n = 10000 + (userLevel - 62);
                        break;
                    }
                    default: {
                        n = userLevel;
                    }
                }
                return n;
            }

            private final long getBitMask-I7RO_PI(int bit) {
                return bit >= 63 ? -1L : ULong.constructor-impl((long)(ULong.constructor-impl((long)(1L << bit + 1)) - 1L));
            }

            private final long getBitMaskRange-ZIaKswc(int fromInclusive, int toExclusive) {
                long inv = fromInclusive == 0 ? ULong.constructor-impl((long)(0L ^ 0xFFFFFFFFFFFFFFFFL)) : ULong.constructor-impl((long)(this.getBitMask-I7RO_PI(fromInclusive - 1) ^ 0xFFFFFFFFFFFFFFFFL));
                return ULong.constructor-impl((long)(this.getBitMask-I7RO_PI(toExclusive - 1) & inv));
            }

            private final int lowestBitSet-VKZWuLQ(long $this$lowestBitSet_u2dVKZWuLQ) {
                return Long.numberOfTrailingZeros($this$lowestBitSet_u2dVKZWuLQ);
            }

            private final int highestBitSet-VKZWuLQ(long $this$highestBitSet_u2dVKZWuLQ) {
                return 63 - Long.numberOfLeadingZeros($this$highestBitSet_u2dVKZWuLQ);
            }

            @NotNull
            public final SdkApiConstraint createConstraint(@Nullable Integer fromInclusive, @Nullable Integer toExclusive, boolean negate, int sdkId) {
                return new SdkApiConstraint(this.createConstraintBits-qJGtvoU(fromInclusive, toExclusive, negate), sdkId, null);
            }

            public static /* synthetic */ SdkApiConstraint createConstraint$default(Companion companion, Integer n, Integer n2, boolean bl, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = null;
                }
                if ((n4 & 2) != 0) {
                    n2 = null;
                }
                if ((n4 & 4) != 0) {
                    bl = false;
                }
                if ((n4 & 8) != 0) {
                    n3 = 0;
                }
                return companion.createConstraint(n, n2, bl, n3);
            }

            public final long createConstraintBits-qJGtvoU(@Nullable Integer fromInclusive, @Nullable Integer toExclusive, boolean negate) {
                int from = this.toInternalApiLevel(fromInclusive, 1);
                int to = this.toInternalApiLevel(toExclusive, 65);
                long it = this.getBitMaskRange-ZIaKswc(from, to);
                boolean bl = false;
                long bits = negate ? ULong.constructor-impl((long)(it ^ 0xFFFFFFFFFFFFFFFFL)) : it;
                return bits;
            }

            public static /* synthetic */ long createConstraintBits-qJGtvoU$default(Companion companion, Integer n, Integer n2, boolean bl, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = null;
                }
                if ((n3 & 2) != 0) {
                    n2 = null;
                }
                if ((n3 & 4) != 0) {
                    bl = false;
                }
                return companion.createConstraintBits-qJGtvoU(n, n2, bl);
            }

            @NotNull
            public final String serialize(@NotNull SdkApiConstraint constraint2) {
                Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
                return constraint2.serialize();
            }

            @NotNull
            public final SdkApiConstraint deserialize(@NotNull String s) {
                String string;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                int index = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)0, (boolean)false, (int)6, null);
                int sdkId = 0;
                if (index == -1) {
                    sdkId = 0;
                    string = s;
                } else {
                    String string2 = s.substring(index + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    sdkId = Integer.parseInt(string2);
                    String string3 = s.substring(0, index);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                }
                String rangeBits = string;
                return new SdkApiConstraint(UStringsKt.toULong((String)rangeBits, (int)16), sdkId, null);
            }

            @JvmStatic
            public final boolean isValidApiLevel(int api) {
                return api >= 0 && (api <= 61 || api == 10000);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0005J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u001f\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraints;", "", "sdkId", "", "constraint", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "either", "", "(ILcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;Z)V", "always", "sometimes", "(ILcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;)V", "getAlways", "()Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "getSdkId", "()I", "getSometimes", "and", "other", "andWith", "matchAlways", "matchSometimes", "component1", "component2", "component3", "copy", "equals", "hashCode", "highest", "lowest", "or", "orWith", "toString", "", "lint-api"})
    public static final class SdkApiConstraints {
        private final int sdkId;
        @Nullable
        private final SdkApiConstraint always;
        @Nullable
        private final SdkApiConstraint sometimes;

        public SdkApiConstraints(int sdkId, @Nullable SdkApiConstraint always, @Nullable SdkApiConstraint sometimes) {
            this.sdkId = sdkId;
            this.always = always;
            this.sometimes = sometimes;
        }

        public final int getSdkId() {
            return this.sdkId;
        }

        @Nullable
        public final SdkApiConstraint getAlways() {
            return this.always;
        }

        @Nullable
        public final SdkApiConstraint getSometimes() {
            return this.sometimes;
        }

        @NotNull
        public final SdkApiConstraint lowest() {
            SdkApiConstraint sdkApiConstraint = this.always;
            if (sdkApiConstraint == null) {
                SdkApiConstraint sdkApiConstraint2 = this.sometimes;
                sdkApiConstraint = sdkApiConstraint2;
                Intrinsics.checkNotNull((Object)sdkApiConstraint2);
            }
            return sdkApiConstraint;
        }

        @NotNull
        public final SdkApiConstraint highest() {
            SdkApiConstraint sdkApiConstraint = this.sometimes;
            if (sdkApiConstraint == null) {
                SdkApiConstraint sdkApiConstraint2 = this.always;
                sdkApiConstraint = sdkApiConstraint2;
                Intrinsics.checkNotNull((Object)sdkApiConstraint2);
            }
            return sdkApiConstraint;
        }

        public SdkApiConstraints(int sdkId, @NotNull SdkApiConstraint constraint2, boolean either) {
            Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
            this(sdkId, either ? null : constraint2, either ? constraint2 : null);
        }

        @NotNull
        public final SdkApiConstraints and(@NotNull SdkApiConstraints other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.andWith(other.always, other.sometimes);
        }

        @NotNull
        public final SdkApiConstraints andWith(@NotNull SdkApiConstraint constraint2, boolean either) {
            Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
            return this.andWith(either ? null : constraint2, either ? constraint2 : null);
        }

        private final SdkApiConstraints andWith(SdkApiConstraint matchAlways, SdkApiConstraint matchSometimes) {
            boolean bl;
            SdkApiConstraint sometimes;
            SdkApiConstraint always;
            SdkApiConstraints have = this;
            SdkApiConstraint sdkApiConstraint = matchAlways != null ? (have.always != null ? new SdkApiConstraint(ULong.constructor-impl((long)(matchAlways.getBits-s-VKNKU() & have.always.getBits-s-VKNKU())), have.sdkId, null) : matchAlways) : (always = have.always);
            SdkApiConstraint sdkApiConstraint2 = matchSometimes != null ? (have.sometimes != null ? new SdkApiConstraint(ULong.constructor-impl((long)(matchSometimes.getBits-s-VKNKU() & have.sometimes.getBits-s-VKNKU())), have.sdkId, null) : matchSometimes) : (sometimes = have.sometimes);
            if (always != null && sometimes != null && ULong.constructor-impl((long)(always.getBits-s-VKNKU() & sometimes.getBits-s-VKNKU())) == always.getBits-s-VKNKU()) {
                sometimes = null;
            }
            boolean bl2 = bl = always != null || sometimes != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return new SdkApiConstraints(have.sdkId, always, sometimes);
        }

        @NotNull
        public final SdkApiConstraints or(@NotNull SdkApiConstraints other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.orWith(other.always, other.sometimes);
        }

        @NotNull
        public final SdkApiConstraints orWith(@NotNull SdkApiConstraint constraint2, boolean either) {
            Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
            return this.orWith(either ? null : constraint2, either ? constraint2 : null);
        }

        private final SdkApiConstraints orWith(SdkApiConstraint matchAlways, SdkApiConstraint matchSometimes) {
            boolean bl;
            SdkApiConstraint sometimes;
            SdkApiConstraint always;
            SdkApiConstraints have = this;
            SdkApiConstraint sdkApiConstraint = matchAlways != null ? (have.always != null ? new SdkApiConstraint(ULong.constructor-impl((long)(matchAlways.getBits-s-VKNKU() | have.always.getBits-s-VKNKU())), have.sdkId, null) : matchAlways) : (always = have.always);
            SdkApiConstraint sdkApiConstraint2 = matchSometimes != null ? (have.sometimes != null ? new SdkApiConstraint(ULong.constructor-impl((long)(matchSometimes.getBits-s-VKNKU() | have.sometimes.getBits-s-VKNKU())), have.sdkId, null) : matchSometimes) : (sometimes = have.sometimes);
            if (always != null && sometimes != null && ULong.constructor-impl((long)(always.getBits-s-VKNKU() | sometimes.getBits-s-VKNKU())) == always.getBits-s-VKNKU()) {
                sometimes = null;
            }
            boolean bl2 = bl = always != null || sometimes != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return new SdkApiConstraints(have.sdkId, always, sometimes);
        }

        public final int component1() {
            return this.sdkId;
        }

        @Nullable
        public final SdkApiConstraint component2() {
            return this.always;
        }

        @Nullable
        public final SdkApiConstraint component3() {
            return this.sometimes;
        }

        @NotNull
        public final SdkApiConstraints copy(int sdkId, @Nullable SdkApiConstraint always, @Nullable SdkApiConstraint sometimes) {
            return new SdkApiConstraints(sdkId, always, sometimes);
        }

        public static /* synthetic */ SdkApiConstraints copy$default(SdkApiConstraints sdkApiConstraints, int n, SdkApiConstraint sdkApiConstraint, SdkApiConstraint sdkApiConstraint2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = sdkApiConstraints.sdkId;
            }
            if ((n2 & 2) != 0) {
                sdkApiConstraint = sdkApiConstraints.always;
            }
            if ((n2 & 4) != 0) {
                sdkApiConstraint2 = sdkApiConstraints.sometimes;
            }
            return sdkApiConstraints.copy(n, sdkApiConstraint, sdkApiConstraint2);
        }

        @NotNull
        public String toString() {
            return "SdkApiConstraints(sdkId=" + this.sdkId + ", always=" + this.always + ", sometimes=" + this.sometimes + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.sdkId);
            result = result * 31 + (this.always == null ? 0 : this.always.hashCode());
            result = result * 31 + (this.sometimes == null ? 0 : this.sometimes.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SdkApiConstraints)) {
                return false;
            }
            SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)other;
            if (this.sdkId != sdkApiConstraints.sdkId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.always, (Object)sdkApiConstraints.always)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sometimes, (Object)sdkApiConstraints.sometimes);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0000\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016J\t\u0010#\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010$\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0011H\u0016J\b\u0010(\u001a\u00020&H\u0016J\u0012\u0010(\u001a\u00020&2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint;", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "apis", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "anyOf", "", "(Ljava/util/List;Z)V", "sdkConstraints", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraints;", "(Ljava/util/List;)V", "Lkotlin/sequences/Sequence;", "getSdkConstraints$lint_api", "()Ljava/util/List;", "alwaysAtLeast", "minSdk", "apiLevel", "", "and", "other", "everHigher", "findSdk", "sdkId", "certain", "findSdks", "findSdks$lint_api", "firstMissing", "requirement", "fromInclusive", "getConstraints", "getSdk", "includes", "isAtLeast", "constraint", "isEmpty", "not", "or", "serialize", "", "toExclusive", "toString", "sdkRegistry", "Lcom/android/tools/lint/detector/api/ExtensionSdkRegistry;", "Companion", "lint-api"})
    public static final class MultiSdkApiConstraint
    extends ApiConstraint {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<SdkApiConstraints> sdkConstraints;
        @NotNull
        private final Sequence<SdkApiConstraint> apis;

        public MultiSdkApiConstraint(@NotNull List<SdkApiConstraints> sdkConstraints) {
            Intrinsics.checkNotNullParameter(sdkConstraints, (String)"sdkConstraints");
            super(null);
            this.sdkConstraints = sdkConstraints;
            this.apis = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.sdkConstraints), (Function1)apis.1.INSTANCE);
        }

        @NotNull
        public final List<SdkApiConstraints> getSdkConstraints$lint_api() {
            return this.sdkConstraints;
        }

        /*
         * WARNING - void declaration
         */
        public MultiSdkApiConstraint(@NotNull List<SdkApiConstraint> apis2, boolean anyOf) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(apis2, (String)"apis");
            Iterable iterable = apis2;
            MultiSdkApiConstraint multiSdkApiConstraint = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraint sdkApiConstraint = (SdkApiConstraint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(anyOf ? new SdkApiConstraints(it.getSdkId(), null, (SdkApiConstraint)it) : new SdkApiConstraints(it.getSdkId(), (SdkApiConstraint)it, null));
            }
            multiSdkApiConstraint((List)destination$iv$iv);
        }

        @Override
        public int fromInclusive() {
            return ((SdkApiConstraints)CollectionsKt.first(this.sdkConstraints)).lowest().fromInclusive();
        }

        @Override
        public int toExclusive() {
            return ((SdkApiConstraints)CollectionsKt.first(this.sdkConstraints)).highest().toExclusive();
        }

        @Override
        public boolean isAtLeast(@NotNull ApiConstraint constraint2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
            boolean bl2 = bl = constraint2 != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (constraint2.isEmpty()) {
                return true;
            }
            ApiConstraint apiConstraint = constraint2;
            if (apiConstraint instanceof SdkApiConstraint) {
                SdkApiConstraints match;
                Object object;
                Object v1;
                block15: {
                    int sdkId = ((SdkApiConstraint)constraint2).getSdkId();
                    Iterable $this$firstOrNull$iv = this.sdkConstraints;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl3 = false;
                        if (!(it.getSdkId() == sdkId)) continue;
                        v1 = element$iv;
                        break block15;
                    }
                    v1 = null;
                }
                return (object = (match = (SdkApiConstraints)v1)) != null && (object = ((SdkApiConstraints)object).getAlways()) != null ? ((SdkApiConstraint)object).isAtLeast(constraint2) : false;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                boolean bl4;
                boolean anyMatch;
                block17: {
                    anyMatch = false;
                    for (SdkApiConstraints $this$firstOrNull$iv : ((MultiSdkApiConstraint)constraint2).sdkConstraints) {
                        Object alwaysHave;
                        Object v3;
                        SdkApiConstraint mightNeed;
                        SdkApiConstraint alwaysNeed;
                        block16: {
                            int sdkId = $this$firstOrNull$iv.component1();
                            alwaysNeed = $this$firstOrNull$iv.component2();
                            mightNeed = $this$firstOrNull$iv.component3();
                            Iterable $this$firstOrNull$iv2 = this.sdkConstraints;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv2) {
                                SdkApiConstraints it = (SdkApiConstraints)element$iv;
                                boolean bl5 = false;
                                if (!(it.getSdkId() == sdkId)) continue;
                                v3 = element$iv;
                                break block16;
                            }
                            v3 = null;
                        }
                        SdkApiConstraints match = v3;
                        if (alwaysNeed != null) {
                            Object object = match;
                            if (object == null || (object = ((SdkApiConstraints)object).getAlways()) == null) {
                                return false;
                            }
                            alwaysHave = object;
                            if (!((SdkApiConstraint)alwaysHave).isAtLeast(alwaysNeed)) {
                                return false;
                            }
                            anyMatch = true;
                            continue;
                        }
                        if (mightNeed != null) {
                            if (match == null || anyMatch) continue;
                            alwaysHave = match.component2();
                            SdkApiConstraint sometimesHave = match.component3();
                            if ((alwaysHave == null || !((SdkApiConstraint)alwaysHave).isAtLeast(mightNeed)) && (sometimesHave == null || !sometimesHave.isAtLeast(mightNeed))) continue;
                            anyMatch = true;
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    Iterable $this$any$iv = this.sdkConstraints;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SdkApiConstraints it = (SdkApiConstraints)element$iv;
                            boolean bl6 = false;
                            if (!(it.getSometimes() != null && ((MultiSdkApiConstraint)constraint2).findSdks$lint_api(it.getSdkId()) == null)) continue;
                            bl4 = true;
                            break block17;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    return false;
                }
                return anyMatch;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean includes(int apiLevel) {
            for (SdkApiConstraint api : this.apis) {
                if (!api.includes(apiLevel)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean alwaysAtLeast(int apiLevel) {
            for (SdkApiConstraint api : this.apis) {
                if (!api.alwaysAtLeast(apiLevel)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean alwaysAtLeast(@NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
            ApiConstraint apiConstraint = minSdk;
            if (apiConstraint instanceof SdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint = ApiConstraint.findSdk$default(this, ((SdkApiConstraint)minSdk).getSdkId(), false, 2, null);
                if (sdkApiConstraint == null) {
                    return false;
                }
                SdkApiConstraint sdk = sdkApiConstraint;
                return sdk.alwaysAtLeast(minSdk);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                for (SdkApiConstraint api : this.apis) {
                    SdkApiConstraint match = ApiConstraint.findSdk$default(minSdk, api.getSdkId(), false, 2, null);
                    if (match == null || !api.alwaysAtLeast(match)) continue;
                    return true;
                }
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean everHigher(int apiLevel) {
            for (SdkApiConstraint api : this.apis) {
                if (!api.everHigher(apiLevel)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public SdkApiConstraint firstMissing(@NotNull ApiConstraint requirement) {
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            if (requirement.isEmpty()) {
                return null;
            }
            ApiConstraint apiConstraint = requirement;
            if (apiConstraint instanceof SdkApiConstraint) {
                SdkApiConstraints match;
                Object object;
                Object v0;
                block16: {
                    int sdkId = ((SdkApiConstraint)requirement).getSdkId();
                    Iterable $this$firstOrNull$iv = this.sdkConstraints;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl = false;
                        if (!(it.getSdkId() == sdkId)) continue;
                        v0 = element$iv;
                        break block16;
                    }
                    v0 = null;
                }
                return ((object = (match = (SdkApiConstraints)v0)) != null && (object = ((SdkApiConstraints)object).getAlways()) != null ? ((SdkApiConstraint)object).isAtLeast(requirement) : false) ? (SdkApiConstraint)null : (SdkApiConstraint)requirement;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                boolean bl;
                SdkApiConstraint firstMissing;
                boolean anyMatch;
                block18: {
                    anyMatch = false;
                    firstMissing = null;
                    for (SdkApiConstraints $i$f$firstOrNull : ((MultiSdkApiConstraint)requirement).sdkConstraints) {
                        Object alwaysHave;
                        Object v2;
                        SdkApiConstraint mightNeed;
                        SdkApiConstraint alwaysNeed;
                        block17: {
                            int sdkId = $i$f$firstOrNull.component1();
                            alwaysNeed = $i$f$firstOrNull.component2();
                            mightNeed = $i$f$firstOrNull.component3();
                            Iterable $this$firstOrNull$iv = this.sdkConstraints;
                            boolean $i$f$firstOrNull2 = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                SdkApiConstraints it = (SdkApiConstraints)element$iv;
                                boolean bl2 = false;
                                if (!(it.getSdkId() == sdkId)) continue;
                                v2 = element$iv;
                                break block17;
                            }
                            v2 = null;
                        }
                        SdkApiConstraints match = v2;
                        if (alwaysNeed != null) {
                            Object object = match;
                            if (object == null || (object = ((SdkApiConstraints)object).getAlways()) == null) {
                                return alwaysNeed;
                            }
                            alwaysHave = object;
                            if (!((SdkApiConstraint)alwaysHave).isAtLeast(alwaysNeed)) {
                                return alwaysNeed;
                            }
                            anyMatch = true;
                            continue;
                        }
                        if (mightNeed != null) {
                            if (anyMatch) continue;
                            if (match == null) {
                                if (firstMissing != null) continue;
                                firstMissing = mightNeed;
                                continue;
                            }
                            alwaysHave = match.component2();
                            SdkApiConstraint sometimesHave = match.component3();
                            if (alwaysHave != null && ((SdkApiConstraint)alwaysHave).isAtLeast(mightNeed) || sometimesHave != null && sometimesHave.isAtLeast(mightNeed)) {
                                anyMatch = true;
                                continue;
                            }
                            if (firstMissing != null) continue;
                            firstMissing = mightNeed;
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    Iterable $this$any$iv = this.sdkConstraints;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SdkApiConstraints it = (SdkApiConstraints)element$iv;
                            boolean bl3 = false;
                            if (!(it.getSometimes() != null && ((MultiSdkApiConstraint)requirement).findSdks$lint_api(it.getSdkId()) == null)) continue;
                            bl = true;
                            break block18;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return firstMissing;
                }
                return anyMatch ? null : firstMissing;
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint not() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.sdkConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SdkApiConstraint sdkApiConstraint = it.getSometimes();
                SdkApiConstraint sdkApiConstraint2 = it.getAlways();
                collection.add(new SdkApiConstraints(it.getSdkId(), sdkApiConstraint != null ? sdkApiConstraint.not() : null, sdkApiConstraint2 != null ? sdkApiConstraint2.not() : null));
            }
            List reversed = (List)destination$iv$iv;
            return new MultiSdkApiConstraint(reversed);
        }

        @Override
        public boolean isEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.sdkConstraints;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl2 = false;
                        if (it.lowest().isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint or(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (other == null) {
                return this;
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint instanceof SdkApiConstraint) {
                return ((SdkApiConstraint)other).or(this);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.sdkConstraints;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    SdkApiConstraints match = ((MultiSdkApiConstraint)other).findSdks$lint_api(it.getSdkId());
                    collection.add(match != null ? match.or((SdkApiConstraints)it) : it);
                }
                List apis2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                Iterable $this$forEach$iv = ((MultiSdkApiConstraint)other).sdkConstraints;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl4 = false;
                    if (this.findSdks$lint_api(it.getSdkId()) != null) continue;
                    apis2.add(it);
                }
                return new MultiSdkApiConstraint(apis2);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public ApiConstraint and(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (other == null) {
                return this;
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint instanceof SdkApiConstraint) {
                return ((SdkApiConstraint)other).and(this);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                List anded = new ArrayList();
                for (SdkApiConstraint api : this.apis) {
                    SdkApiConstraint match = ApiConstraint.findSdk$default(other, api.getSdkId(), false, 2, null);
                    if (match == null) continue;
                    anded.add(new SdkApiConstraint(ULong.constructor-impl((long)(api.getBits-s-VKNKU() & match.getBits-s-VKNKU())), api.getSdkId(), null));
                }
                return Companion.create(anded, false);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public String serialize() {
            return "{" + CollectionsKt.joinToString$default((Iterable)this.sdkConstraints, (CharSequence)",", null, null, (int)0, null, (Function1)serialize.1.INSTANCE, (int)30, null) + "}";
        }

        @Override
        @NotNull
        public String toString() {
            return this.toString(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String toString(@Nullable ExtensionSdkRegistry sdkRegistry) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = this.sdkConstraints;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<SdkApiConstraint> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SdkApiConstraint it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SdkApiConstraints it = (SdkApiConstraints)element$iv$iv;
                boolean bl2 = false;
                if (it.getAlways() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List andItems = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv2 = this.sdkConstraints;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                SdkApiConstraint it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                SdkApiConstraints it = (SdkApiConstraints)element$iv$iv;
                boolean bl4 = false;
                if (it.getSometimes() == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List orItems = (List)destination$iv$iv2;
            String andString2 = CollectionsKt.joinToString$default((Iterable)andItems, (CharSequence)" and ", null, null, (int)0, null, (Function1)((Function1)new Function1<SdkApiConstraint, CharSequence>(sdkRegistry){
                final /* synthetic */ ExtensionSdkRegistry $sdkRegistry;
                {
                    this.$sdkRegistry = $sdkRegistry;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull SdkApiConstraint it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.toString(this.$sdkRegistry);
                }
            }), (int)30, null);
            String orString2 = CollectionsKt.joinToString$default((Iterable)orItems, (CharSequence)" or ", null, null, (int)0, null, (Function1)((Function1)new Function1<SdkApiConstraint, CharSequence>(sdkRegistry){
                final /* synthetic */ ExtensionSdkRegistry $sdkRegistry;
                {
                    this.$sdkRegistry = $sdkRegistry;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull SdkApiConstraint it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.toString(this.$sdkRegistry);
                }
            }), (int)30, null);
            return !((Collection)andItems).isEmpty() ? (!((Collection)orItems).isEmpty() ? (orItems.size() == 1 ? andString2 + " and optionally " + orString2 : andString2 + " and any of (" + orString2 + ")") : andString2) : orString2;
        }

        @Override
        @Nullable
        public SdkApiConstraint findSdk(int sdkId, boolean certain) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == sdkId)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SdkApiConstraints sdkApiConstraints = v0;
            if (sdkApiConstraints == null) {
                return null;
            }
            SdkApiConstraints sdkConstraints = sdkApiConstraints;
            return certain ? sdkConstraints.getAlways() : sdkConstraints.lowest();
        }

        @Nullable
        public final SdkApiConstraints findSdks$lint_api(int sdkId) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == sdkId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Override
        public int getSdk() {
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<SdkApiConstraint> getConstraints() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.sdkConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.lowest());
            }
            return (List)destination$iv$iv;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0003\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint$Companion;", "", "()V", "create", "Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint;", "description", "", "anyOf", "", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "apis", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "describe", "constraint", "deserialize", "s", "lint-api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ApiConstraint create(@NotNull List<SdkApiConstraint> apis2, boolean anyOf) {
                ApiConstraint apiConstraint;
                Intrinsics.checkNotNullParameter(apis2, (String)"apis");
                if (apis2.size() == 1) {
                    apiConstraint = apis2.get(0);
                } else {
                    if (apis2.isEmpty()) {
                        return NONE;
                    }
                    apiConstraint = new MultiSdkApiConstraint(apis2, anyOf);
                }
                return apiConstraint;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MultiSdkApiConstraint create(@NotNull String description, boolean anyOf) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)description, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void s;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    int index = StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)':', (int)0, (boolean)false, (int)6, null);
                    if (index == -1) {
                        throw new IllegalStateException(("Invalid extension constraint descriptor " + (String)s + " (in " + description + ")").toString());
                    }
                    String string2 = s.substring(index + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    int apiLevel = Integer.parseInt(string2);
                    String string3 = s.substring(0, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    int sdk = Integer.parseInt(string3);
                    collection.add(sdk == 0 ? com.android.tools.lint.detector.api.ApiConstraint$Companion.get$default(ApiConstraint.Companion, apiLevel, 0, 2, null) : SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, null, false, sdk, 6, null));
                }
                List constraints = (List)destination$iv$iv;
                return new MultiSdkApiConstraint(constraints, anyOf);
            }

            public static /* synthetic */ MultiSdkApiConstraint create$default(Companion companion, String string, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                return companion.create(string, bl);
            }

            @NotNull
            public final String describe(@NotNull ApiConstraint constraint2) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)constraint2, (String)"constraint");
                ApiConstraint apiConstraint = constraint2;
                if (apiConstraint instanceof SdkApiConstraint) {
                    object = "0:" + constraint2.min();
                } else if (apiConstraint instanceof MultiSdkApiConstraint) {
                    object = CollectionsKt.joinToString$default((Iterable)((MultiSdkApiConstraint)constraint2).getSdkConstraints$lint_api(), (CharSequence)",", null, null, (int)0, null, (Function1)describe.1.INSTANCE, (int)30, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ApiConstraint deserialize(@NotNull String s) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)s, (CharSequence)"{", (CharSequence)"}"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    int n;
                    SdkApiConstraint sdkApiConstraint;
                    SdkApiConstraint always;
                    SdkApiConstraint sdkApiConstraint2;
                    void t;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    int index = StringsKt.indexOf$default((CharSequence)((CharSequence)t), (char)':', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        String string2 = t.substring(0, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        sdkApiConstraint2 = SdkApiConstraint.Companion.deserialize(string2);
                    } else {
                        sdkApiConstraint2 = always = null;
                    }
                    if (index < t.length() - 1) {
                        String string3 = t.substring(index + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                        sdkApiConstraint = SdkApiConstraint.Companion.deserialize(string3);
                    } else {
                        sdkApiConstraint = null;
                    }
                    SdkApiConstraint sometimes = sdkApiConstraint;
                    SdkApiConstraint sdkApiConstraint3 = always;
                    if (sdkApiConstraint3 != null) {
                        n = sdkApiConstraint3.getSdkId();
                    } else {
                        SdkApiConstraint sdkApiConstraint4 = sometimes;
                        Intrinsics.checkNotNull((Object)sdkApiConstraint4);
                        n = sdkApiConstraint4.getSdkId();
                    }
                    collection.add(new SdkApiConstraints(n, always, sometimes));
                }
                List apis2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                return new MultiSdkApiConstraint(apis2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

