/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintJarApiMigration;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.helpers.ZipStreamsKt;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u0003567B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001d\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u0004\u0018\u00010%*\u00020#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020!0'H\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020#H\u0002J(\u0010,\u001a\u00020!*\u00020%2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J(\u0010/\u001a\u00020!*\u00020%2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J(\u00100\u001a\u00020!*\u00020%2\u0006\u0010-\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u000e\u00103\u001a\u0004\u0018\u00010%*\u00020%H\u0002J\n\u00104\u001a\u00020\n*\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;)V", "getMigratedJar", "Ljava/io/File;", "jar", "registryClass", "", "migrateJar", "", "jarBytes", "migrateClass", "bytes", "mapClass", "s", "migrateClassNames", "pop", "E", "", "(Ljava/util/List;)Ljava/lang/Object;", "mapApi", "owner", "oldApi", "descriptor", "getSuperTypes", "", "type", "(Ljava/lang/String;)[Ljava/lang/String;", "key", "isRelevantMethod", "", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "find", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "condition", "Lkotlin/Function1;", "migrateAnalyzeCall", "classBytes", "handleLintUtilRedirection", "method", "isCall", "name", "desc", "isVirtualCall", "isStaticCall", "findClass", "Ljava/lang/Class;", "prev", "prettyPrint", "SwitchToInterfaceClassVisitor", "SwitchToInterfaceMethodVisitor", "Companion", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintJarApiMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintJarApiMigration.kt\ncom/android/tools/lint/client/api/LintJarApiMigration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2555:1\n295#2,2:2556\n*S KotlinDebug\n*F\n+ 1 LintJarApiMigration.kt\ncom/android/tools/lint/client/api/LintJarApiMigration\n*L\n2156#1:2556,2\n*E\n"})
public final class LintJarApiMigration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    private static final boolean DEBUG = false;

    public LintJarApiMigration(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @NotNull
    public final File getMigratedJar(@NotNull File jar, @NotNull String registryClass) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)registryClass, (String)"registryClass");
        File cacheDir = this.client.getCacheDir("migrated-jars", true);
        byte[] jarContents = FilesKt.readBytes((File)jar);
        HashFunction hashFunction = Hashing.farmHashFingerprint64();
        Hasher hasher = hashFunction.newHasher();
        hasher.putBytes(jarContents);
        HashCode hashCode = hasher.hash();
        String string = hashCode.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String hashCodeString = string;
        String fileName = (String)(!StringsKt.isBlank((CharSequence)registryClass) ? registryClass + "-" : "") + hashCodeString + "..jar";
        File cachedJar = new File(cacheDir, fileName);
        if (!cachedJar.isFile()) {
            byte[] bytes = this.migrateJar(jarContents);
            FilesKt.writeBytes((File)cachedJar, (byte[])bytes);
        }
        return cachedJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] migrateJar(byte[] jarBytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Closeable closeable = new JarInputStream(new ByteArrayInputStream(jarBytes));
        Throwable throwable = null;
        try {
            JarInputStream jis = (JarInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = output;
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream fos = (ByteArrayOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new JarOutputStream(fos);
                Throwable throwable3 = null;
                try {
                    JarOutputStream jos = (JarOutputStream)closeable3;
                    boolean bl3 = false;
                    JarEntry entry = jis.getNextJarEntry();
                    while (entry != null) {
                        jos.putNextEntry(new JarEntry(entry.getName()));
                        String name = entry.getName();
                        Intrinsics.checkNotNull((Object)name);
                        if (StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) && !entry.isDirectory()) {
                            byte[] bytes = ZipStreamsKt.readAllBytes(jis, (ZipEntry)entry);
                            byte[] migrated = this.migrateClass(bytes);
                            jos.write(migrated);
                        } else {
                            ByteStreamsKt.copyTo$default((InputStream)jis, (OutputStream)jos, (int)0, (int)2, null);
                        }
                        jos.closeEntry();
                        entry = jis.getNextJarEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public final byte[] migrateClass(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.migrateClassNames(this.migrateAnalyzeCall(bytes));
    }

    @Nullable
    public final String mapClass(@Nullable String s) {
        Object object;
        if (s == null || !Companion.isRelevantType(s)) {
            return null;
        }
        int innerClassIndex = StringsKt.indexOf$default((CharSequence)s, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (innerClassIndex != -1) {
            String string = s.substring(0, innerClassIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String mapped = this.mapClass(string);
            if (mapped != null) {
                String string2 = s.substring(innerClassIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return mapped + string2;
            }
        }
        switch (s) {
            case "org/jetbrains/kotlin/analysis/api/KaStarTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaSymbolBasedReference": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaTypeArgumentWithVariance": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisApiInternals": {
                object = "org/jetbrains/kotlin/analysis/api/KaAnalysisApiInternals";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisNonPublicApi": {
                object = "org/jetbrains/kotlin/analysis/api/KaAnalysisNonPublicApi";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtAnalysisSession": {
                object = "org/jetbrains/kotlin/analysis/api/KaSession";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtStarTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtSymbolBasedReference": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtTypeArgumentWithVariance": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KtTypeProjection": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplication": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationValue": {
                object = "KaAnnotationValue$NestedAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationApplicationWithArgumentsInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationsList": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaArrayAnnotationValue": {
                object = "KaAnnotationValue$ArrayValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaConstantAnnotationValue": {
                object = "KaAnnotationValue$ConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaEnumEntryAnnotationValue": {
                object = "KaAnnotationValue$EnumEntryValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaKClassAnnotationValue": {
                object = "KaAnnotationValue$ClassLiteralValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaUnsupportedAnnotationValue": {
                object = "KaAnnotationValue$UnsupportedValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotated": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplication": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationValue": {
                object = "KaAnnotationValue$NestedAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplicationWithArgumentsInfo": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtAnnotationsList": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtArrayAnnotationValue": {
                object = "KaAnnotationValue$ArrayValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue": {
                object = "KaAnnotationValue$ConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtEnumEntryAnnotationValue": {
                object = "KaAnnotationValue$EnumEntryValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtKClassAnnotationValue": {
                object = "KaAnnotationValue$ClassLiteralValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue": {
                object = "org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KtUnsupportedAnnotationValue": {
                object = "KaAnnotationValue$UnsupportedValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KtConstantValue": {
                object = "org/jetbrains/kotlin/analysis/api/base/KaConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KtContextReceiver": {
                object = "org/jetbrains/kotlin/analysis/api/base/KaContextReceiver";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KtContextReceiversOwner": {
                object = "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaAnnotationCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaApplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCallableMemberCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundArrayAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaCompoundVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaDelegatedConstructorCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaErrorCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaExplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaImplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaInapplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaPartiallyAppliedVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleVariableAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccess";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSimpleVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSmartCastedReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaSuccessCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KaVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtAnnotationCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtApplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCallableMemberCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundArrayAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtCompoundVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtDelegatedConstructorCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtErrorCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtExplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtImplicitReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtInapplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtPartiallyAppliedVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleFunctionCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleVariableAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccess";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSimpleVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSmartCastedReceiverValue": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtSuccessCallInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/calls/KtVariableAccessCall": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtBuiltinTypes": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtClassTypeBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompilationResult": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompilationResult";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompiledFile": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompiledFile";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompilerTarget": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompilerTarget";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtCompletionExtensionCandidateChecker": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaCompletionExtensionCandidateChecker";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtDataFlowExitPointSnapshot": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaDataFlowExitPointSnapshot";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtDiagnosticCheckerFilter": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtExtensionApplicabilityResult": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaExtensionApplicabilityResult";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiver": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiverSmartCast": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImplicitReceiverSmartCastKind": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCastKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtImportOptimizerResult": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaImportOptimizerResult";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeContext": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaScopeContext";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeKind": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaScopeKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtScopeWithKind": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtSmartCastInfo": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtSubstitutorBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaSubstitutorBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtSubtypingErrorTypePolicy": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtTypeBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KtTypeParameterTypeBuilder": {
                object = "org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractCallsInPlaceContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractConditionalContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractConstantValue": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractParameterValue": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KtContractReturnsContractEffectDeclaration": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBinaryLogicExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanConstantExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractBooleanValueParameterExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractIsInstancePredicateExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractIsNullPredicateExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KtContractLogicalNotExpression": {
                object = "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic": {
                object = "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi": {
                object = "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic0": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic1": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic2": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic3": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KtCompilerPluginDiagnostic4": {
                object = "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtIllegalLifetimeOwnerAccessException": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtInaccessibleLifetimeOwnerAccessException": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaInaccessibleLifetimeOwnerAccessException";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtInvalidLifetimeOwnerAccessException": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaInvalidLifetimeOwnerAccessException";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwner": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeOwnerField": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwnerField";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken": {
                object = "org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/KtKeywordRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/KaKeywordRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/KtKeywordsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/KaKeywordsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtAnnotationRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaAnnotationRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtAnnotationRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaAnnotationRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KtRendererAnnotationsFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/KaRendererAnnotationsFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationArgumentsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationArgumentsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationQualifierRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationQualifierRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KtAnnotationUseSiteTargetRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/annotations/renderers/KaAnnotationUseSiteTargetRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KtContextReceiversRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KaContextReceiversRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KtContextReceiversRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/KaContextReceiversRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KtContextReceiverLabelRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KaContextReceiverLabelRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KtContextReceiverListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/base/contextReceivers/renderers/KaContextReceiverListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtCallableReturnTypeFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaCallableReturnTypeFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtDeclarationRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaDeclarationRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRecommendedRendererCodeStyle": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRecommendedRendererCodeStyle";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRendererCodeStyle": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRendererCodeStyle";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/KtRendererTypeApproximator": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/KaRendererTypeApproximator";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtFunctionLikeBodyRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaFunctionLikeBodyRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtParameterDefaultValueRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaParameterDefaultValueRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtPropertyAccessorBodyRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaPropertyAccessorBodyRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtRendererBodyMemberScopeProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaRendererBodyMemberScopeProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtRendererBodyMemberScopeSorter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaRendererBodyMemberScopeSorter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtScriptInitializerRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaScriptInitializerRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KtVariableInitializerRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/bodies/KaVariableInitializerRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KtDeclarationRendererForDebug": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KaDeclarationRendererForDebug";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KtDeclarationRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/impl/KaDeclarationRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/KtDeclarationModifiersRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/KaDeclarationModifiersRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/impl/KtDeclarationModifiersRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/impl/KaDeclarationModifiersRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtModifierListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaModifierListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtModifiersSorter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaModifiersSorter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererKeywordFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererKeywordFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererModalityModifierProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererModalityModifierProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererOtherModifiersProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererOtherModifiersProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KtRendererVisibilityModifierProvider": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/modifiers/renderers/KaRendererVisibilityModifierProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtCallableParameterRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaCallableParameterRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassInitializerRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassInitializerRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassifierBodyRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtClassifierBodyWithMembersRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyWithMembersRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtDeclarationNameRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaDeclarationNameRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtTypeParameterRendererFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaTypeParameterRendererFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KtTypeParametersRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaTypeParametersRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaFunctionSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaNamedFunctionSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtAnonymousFunctionSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaAnonymousFunctionSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtBackingFieldSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaBackingFieldSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableReceiverRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableReceiverRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableReturnTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableReturnTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtCallableSignatureRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaCallableSignatureRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtConstructorSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaConstructorSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtDestructuringDeclarationRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaDestructuringDeclarationRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtEnumEntrySymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaEnumEntrySymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtFunctionSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaNamedFunctionSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtJavaFieldSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaJavaFieldSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtKotlinPropertySymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaKotlinPropertySymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtLocalVariableSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaLocalVariableSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertyAccessorsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertyAccessorsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertyGetterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertyGetterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtPropertySetterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaPropertySetterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtSamConstructorSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaSamConstructorSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtScriptSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaScriptSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtSyntheticJavaPropertySymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaSyntheticJavaPropertySymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KtValueParameterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/callables/KaValueParameterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassOrObjectSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtAnonymousObjectSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaAnonymousObjectSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtNamedClassOrObjectSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaNamedClassSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtSingleTypeParameterSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaSingleTypeParameterSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KtTypeAliasSymbolRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/classifiers/KaTypeAliasSymbolRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypeListRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypeListRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypesCallArgumentsRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypesCallArgumentsRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KtSuperTypesFilter": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/declarations/superTypes/KaSuperTypesFilter";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/KtExpandedTypeRenderingMode": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/KaExpandedTypeRenderingMode";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/KtTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/KaTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KtTypeRendererForDebug": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KaTypeRendererForDebug";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KtTypeRendererForSource": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/impl/KaTypeRendererForSource";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtCapturedTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaCapturedTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtClassTypeQualifierRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaClassTypeQualifierRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtDefinitelyNotNullTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaDefinitelyNotNullTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtDynamicTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaDynamicTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtFlexibleTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaFlexibleTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtFunctionalTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaFunctionalTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtIntersectionTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaIntersectionTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeErrorTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaErrorTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeNameRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeNameRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeParameterTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeParameterTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtTypeProjectionRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaTypeProjectionRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtUnresolvedClassErrorTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaUnresolvedClassErrorTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KtUsualClassTypeRenderer": {
                object = "org/jetbrains/kotlin/analysis/api/renderer/types/renderers/KaUsualClassTypeRenderer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccess": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KtApplicableCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KtCallCandidateInfo": {
                object = "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtension": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtension";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionFile": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionFile";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionNavigationTargetsProvider": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionNavigationTargetsProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KtResolveExtensionProvider": {
                object = "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtensionProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScope": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/KaScope";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScopeLike": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtScopeNameFilter": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/(Name) -> Boolean";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KtTypeScope": {
                object = "org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider": {
                object = "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaVariableLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KtVariableLikeSignature": {
                object = "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaVariableLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtAnonymousFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtAnonymousObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousObjectSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtBackingFieldSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaBackingFieldSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassInitializerSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassInitializerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassKind": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtClassifierSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtDeclarationSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtDestructuringDeclarationSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDestructuringDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtEnumEntryInitializerSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntryInitializerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtFunctionSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtJavaFieldSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaJavaFieldSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtKotlinPropertySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaKotlinPropertySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtLocalVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaLocalVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtNamedClassOrObjectSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPackageSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPackageSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertyAccessorSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertyGetterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyGetterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertySetterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySetterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtReceiverParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSamConstructorSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSamConstructorSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtScriptSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSymbolOrigin": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolOrigin";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtSyntheticJavaPropertySymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaSyntheticJavaPropertySymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtTypeAliasSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaTypeAliasSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtTypeParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KtVariableSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossibleMultiplatformSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithMembers": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithModality": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithTypeParameters": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithVisibility": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtAnnotatedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtNamedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtPossibleMultiplatformSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtPossiblyNamedSymbol": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossiblyNamedSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolKind": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithKind": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithMembers": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithModality": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithTypeParameters": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KtSymbolWithVisibility": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KtPsiBasedSymbolPointer": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KtSymbolPointer": {
                object = "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaFunctionalType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaFunctionType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaNonErrorClassType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtCapturedType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaCapturedType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtClassErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtClassTypeQualifier": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtDefinitelyNotNullType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaDefinitelyNotNullType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtDynamicType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaDynamicType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtFlexibleType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaFlexibleType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtFunctionalType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaFunctionType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtIntersectionType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaIntersectionType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtNonErrorClassType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaClassType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeErrorType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaErrorType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeMappingMode": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeMappingMode";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeNullability": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeNullability";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtTypeParameterType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaTypeParameterType";
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KtUsualClassType": {
                object = "org/jetbrains/kotlin/analysis/api/types/KaUsualClassType";
                break;
            }
            default: {
                String ktPrefix = "org/jetbrains/kotlin/analysis/api/";
                int lastIndex = StringsKt.lastIndexOf$default((CharSequence)s, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (StringsKt.startsWith$default((String)s, (String)ktPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)s, (String)"Kt", (int)(lastIndex + 1), (boolean)false, (int)4, null)) {
                    String string = s.substring(0, lastIndex + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string3 = s.substring(lastIndex + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    object = string + "Ka" + string3;
                    break;
                }
                object = null;
            }
        }
        return object;
    }

    private final byte[] migrateClassNames(byte[] jarBytes) {
        ClassReader classReader = new ClassReader(jarBytes);
        ClassWriter classWriter2 = new ClassWriter(classReader){

            protected String getCommonSuperClass(String type1, String type2) {
                String string;
                Intrinsics.checkNotNullParameter((Object)type1, (String)"type1");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type2");
                try {
                    string = super.getCommonSuperClass(type1, type2);
                }
                catch (TypeNotPresentException e) {
                    string = "java/lang/Object";
                }
                return string;
            }
        };
        Remapper mapper2 = new Remapper(this){
            final /* synthetic */ LintJarApiMigration this$0;
            {
                this.this$0 = $receiver;
            }

            public String mapMethodName(String owner, String name, String descriptor) {
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            public String mapInvokeDynamicMethodName(String name, String descriptor) {
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            public String mapRecordComponentName(String owner, String name, String descriptor) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            public String mapFieldName(String owner, String name, String descriptor) {
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            public String mapPackageName(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            public String mapModuleName(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = this.this$0.mapClass(name);
                if (string == null) {
                    string = name;
                }
                return string;
            }

            public String map(String internalName) {
                String string = this.this$0.mapClass(internalName);
                if (string == null) {
                    string = internalName;
                }
                return string;
            }
        };
        SwitchToInterfaceClassVisitor myVisitor = new SwitchToInterfaceClassVisitor((ClassVisitor)classWriter2);
        ClassRemapper classMapper = new ClassRemapper((ClassVisitor)myVisitor, mapper2);
        classReader.accept((ClassVisitor)classMapper, 0);
        byte[] byArray = classWriter2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private final <E> E pop(List<E> $this$pop) {
        return $this$pop.remove($this$pop.size() - 1);
    }

    private final String mapApi(String owner, String oldApi, String descriptor) {
        String beforeClosingParen = StringsKt.substringBefore$default((String)descriptor, (String)")", null, (int)2, null);
        String initialSig = !Intrinsics.areEqual((Object)beforeClosingParen, (Object)descriptor) && beforeClosingParen.length() > 1 ? beforeClosingParen + ")" : "(L" + owner + ";)";
        List queue = new ArrayList();
        queue.add(initialSig);
        while (!((Collection)queue).isEmpty()) {
            String string;
            String sig = (String)this.pop(queue);
            String key = oldApi + " " + sig;
            String newApi = this.mapApi(key, oldApi);
            if (!Intrinsics.areEqual((Object)newApi, (Object)oldApi)) {
                return newApi;
            }
            String beforeSemi = StringsKt.substringBefore$default((String)sig, (String)";", null, (int)2, null);
            if (beforeSemi.length() > 2) {
                String string2 = beforeSemi.substring(2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = "";
            }
            String oldSuperType = string;
            for (String superType : this.getSuperTypes(oldSuperType)) {
                queue.add(StringsKt.replace$default((String)sig, (String)oldSuperType, (String)superType, (boolean)false, (int)4, null));
            }
        }
        return oldApi;
    }

    private final String[] getSuperTypes(String type) {
        String[] stringArray;
        switch (type) {
            case "org/jetbrains/kotlin/analysis/api/KaConstantInitializerValue": {
                String[] stringArray2 = new String[]{"org/jetbrains/kotlin/analysis/api/KaInitializerValue"};
                stringArray = stringArray2;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaConstantValueForAnnotation": {
                String[] stringArray3 = new String[]{"org/jetbrains/kotlin/analysis/api/KaInitializerValue"};
                stringArray = stringArray3;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaNonConstantInitializerValue": {
                String[] stringArray4 = new String[]{"org/jetbrains/kotlin/analysis/api/KaInitializerValue"};
                stringArray = stringArray4;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/KaSession": {
                String[] stringArray5 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner", "org/jetbrains/kotlin/analysis/api/KaResolver", "org/jetbrains/kotlin/analysis/api/KaSymbolRelationProvider", "org/jetbrains/kotlin/analysis/api/KaDiagnosticProvider", "org/jetbrains/kotlin/analysis/api/KaScopeProvider", "org/jetbrains/kotlin/analysis/api/KaCompletionCandidateChecker", "org/jetbrains/kotlin/analysis/api/KaExpressionTypeProvider", "org/jetbrains/kotlin/analysis/api/KaTypeProvider", "org/jetbrains/kotlin/analysis/api/KaTypeInformationProvider", "org/jetbrains/kotlin/analysis/api/KaSymbolProvider", "org/jetbrains/kotlin/analysis/api/KaJavaInteroperabilityComponent", "org/jetbrains/kotlin/analysis/api/KaSymbolInformationProvider", "org/jetbrains/kotlin/analysis/api/KaTypeRelationChecker", "org/jetbrains/kotlin/analysis/api/KaExpressionInformationProvider", "org/jetbrains/kotlin/analysis/api/KaEvaluator", "org/jetbrains/kotlin/analysis/api/KaReferenceShortener", "org/jetbrains/kotlin/analysis/api/KaImportOptimizer", "org/jetbrains/kotlin/analysis/api/KaRenderer", "org/jetbrains/kotlin/analysis/api/KaVisibilityChecker", "org/jetbrains/kotlin/analysis/api/KaOriginalPsiProvider", "org/jetbrains/kotlin/analysis/api/KaTypeCreator", "org/jetbrains/kotlin/analysis/api/KaAnalysisScopeProvider", "org/jetbrains/kotlin/analysis/api/KaSignatureSubstitutor", "org/jetbrains/kotlin/analysis/api/KaResolveExtensionInfoProvider", "org/jetbrains/kotlin/analysis/api/KaCompilerPluginGeneratedDeclarationsProvider", "org/jetbrains/kotlin/analysis/api/KaCompilerFacility", "org/jetbrains/kotlin/analysis/api/KaMetadataCalculator", "org/jetbrains/kotlin/analysis/api/KaSubstitutorProvider", "org/jetbrains/kotlin/analysis/api/KaDataFlowProvider", "org/jetbrains/kotlin/analysis/api/KaSourceProvider"};
                stringArray = stringArray5;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation": {
                String[] stringArray6 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray6;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList": {
                String[] stringArray7 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray7;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue": {
                String[] stringArray8 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray8;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue": {
                String[] stringArray9 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray9;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KaContextReceiver": {
                String[] stringArray10 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray10;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner": {
                String[] stringArray11 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray11;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes": {
                String[] stringArray12 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray12;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder": {
                String[] stringArray13 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder"};
                stringArray = stringArray13;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaCompilerPluginGeneratedDeclarations": {
                String[] stringArray14 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray14;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaExtensionApplicabilityResult": {
                String[] stringArray15 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray15;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver": {
                String[] stringArray16 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray16;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast": {
                String[] stringArray17 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray17;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaScopeContext": {
                String[] stringArray18 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray18;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind": {
                String[] stringArray19 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray19;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaScopeWithKindImpl": {
                String[] stringArray20 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaScopeWithKind"};
                stringArray = stringArray20;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo": {
                String[] stringArray21 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray21;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaSubstitutorBuilder": {
                String[] stringArray22 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray22;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder": {
                String[] stringArray23 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray23;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder": {
                String[] stringArray24 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaTypeBuilder"};
                stringArray = stringArray24;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration": {
                String[] stringArray25 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration"};
                stringArray = stringArray25;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration": {
                String[] stringArray26 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration"};
                stringArray = stringArray26;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue": {
                String[] stringArray27 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray27;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration": {
                String[] stringArray28 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray28;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue": {
                String[] stringArray29 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray29;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration": {
                String[] stringArray30 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractEffectDeclaration"};
                stringArray = stringArray30;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsNotNullEffectDeclaration": {
                String[] stringArray31 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration"};
                stringArray = stringArray31;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsSpecificValueEffectDeclaration": {
                String[] stringArray32 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration"};
                stringArray = stringArray32;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsSuccessfullyEffectDeclaration": {
                String[] stringArray33 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration"};
                stringArray = stringArray33;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression": {
                String[] stringArray34 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                stringArray = stringArray34;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression": {
                String[] stringArray35 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                stringArray = stringArray35;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression": {
                String[] stringArray36 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray36;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression": {
                String[] stringArray37 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                stringArray = stringArray37;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression": {
                String[] stringArray38 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                stringArray = stringArray38;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression": {
                String[] stringArray39 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                stringArray = stringArray39;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression": {
                String[] stringArray40 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanExpression"};
                stringArray = stringArray40;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/descriptors/symbols/descriptorBased/KaDefaultValueParameterSymbol": {
                String[] stringArray41 = new String[]{"org/jetbrains/kotlin/analysis/api/descriptors/symbols/descriptorBased/KaValueParameterSymbol"};
                stringArray = stringArray41;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/descriptors/symbols/psiBased/KaDefaultValueParameterSymbol": {
                String[] stringArray42 = new String[]{"org/jetbrains/kotlin/analysis/api/descriptors/symbols/psiBased/KaValueParameterSymbol"};
                stringArray = stringArray42;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic": {
                String[] stringArray43 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray43;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnosticWithPsi": {
                String[] stringArray44 = new String[]{"org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic"};
                stringArray = stringArray44;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/components/KaLazyCompletionExtensionCandidateChecker": {
                String[] stringArray45 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaCompletionExtensionCandidateChecker"};
                stringArray = stringArray45;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0Impl": {
                String[] stringArray46 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic0"};
                stringArray = stringArray46;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1Impl": {
                String[] stringArray47 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic1"};
                stringArray = stringArray47;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2Impl": {
                String[] stringArray48 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic2"};
                stringArray = stringArray48;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3Impl": {
                String[] stringArray49 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic3"};
                stringArray = stringArray49;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4Impl": {
                String[] stringArray50 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/diagnostics/KaCompilerPluginDiagnostic4"};
                stringArray = stringArray50;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaTopLevelCallableSymbolPointer": {
                String[] stringArray51 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaSymbolPointer"};
                stringArray = stringArray51;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/fir/utils/KaGenericTypePointer": {
                String[] stringArray52 = new String[]{"org/jetbrains/kotlin/analysis/api/fir/utils/KaTypePointer"};
                stringArray = stringArray52;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaBaseContextReceiver": {
                String[] stringArray53 = new String[]{"org/jetbrains/kotlin/analysis/api/base/KaContextReceiver"};
                stringArray = stringArray53;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaBaseSession": {
                String[] stringArray54 = new String[]{"org/jetbrains/kotlin/analysis/api/KaSession", "org/jetbrains/kotlin/analysis/api/impl/base/KaResolver", "org/jetbrains/kotlin/analysis/api/impl/base/KaSymbolRelationProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaDiagnosticProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaScopeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaCompletionCandidateChecker", "org/jetbrains/kotlin/analysis/api/impl/base/KaExpressionTypeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeInformationProvider", "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaJavaInteroperabilityComponent", "org/jetbrains/kotlin/analysis/api/impl/base/KaSymbolInformationProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeRelationChecker", "org/jetbrains/kotlin/analysis/api/impl/base/KaExpressionInformationProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaEvaluator", "org/jetbrains/kotlin/analysis/api/impl/base/KaReferenceShortener", "org/jetbrains/kotlin/analysis/api/impl/base/KaImportOptimizer", "org/jetbrains/kotlin/analysis/api/impl/base/KaRenderer", "org/jetbrains/kotlin/analysis/api/impl/base/KaVisibilityChecker", "org/jetbrains/kotlin/analysis/api/impl/base/KaOriginalPsiProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaTypeCreator", "org/jetbrains/kotlin/analysis/api/impl/base/KaAnalysisScopeProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaSignatureSubstitutor", "org/jetbrains/kotlin/analysis/api/impl/base/KaResolveExtensionInfoProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaCompilerPluginGeneratedDeclarationsProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaCompilerFacility", "org/jetbrains/kotlin/analysis/api/impl/base/KaMetadataCalculator", "org/jetbrains/kotlin/analysis/api/impl/base/KaSubstitutorProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaDataFlowProvider", "org/jetbrains/kotlin/analysis/api/impl/base/KaSourceProvider"};
                stringArray = stringArray54;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaBooleanConstantValueImpl": {
                String[] stringArray55 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$BooleanValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaBooleanConstantValue"};
                stringArray = stringArray55;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaByteConstantValueImpl": {
                String[] stringArray56 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ByteValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaByteConstantValue"};
                stringArray = stringArray56;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaChainedSubstitutor": {
                String[] stringArray57 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaSubstitutor"};
                stringArray = stringArray57;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaCharConstantValueImpl": {
                String[] stringArray58 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$CharValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaCharConstantValue"};
                stringArray = stringArray58;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaDoubleConstantValueImpl": {
                String[] stringArray59 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$DoubleValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaDoubleConstantValue"};
                stringArray = stringArray59;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaErrorConstantValueImpl": {
                String[] stringArray60 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ErrorValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaErrorConstantValue"};
                stringArray = stringArray60;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaFloatConstantValueImpl": {
                String[] stringArray61 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$FloatValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaFloatConstantValue"};
                stringArray = stringArray61;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaIntConstantValueImpl": {
                String[] stringArray62 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$IntValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaIntConstantValue"};
                stringArray = stringArray62;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaLongConstantValueImpl": {
                String[] stringArray63 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$LongValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaLongConstantValue"};
                stringArray = stringArray63;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaMapBackedSubstitutor": {
                String[] stringArray64 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaSubstitutor"};
                stringArray = stringArray64;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaNullConstantValueImpl": {
                String[] stringArray65 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$NullValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaNullConstantValue"};
                stringArray = stringArray65;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaShortConstantValueImpl": {
                String[] stringArray66 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ShortValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaShortConstantValue"};
                stringArray = stringArray66;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaStringConstantValueImpl": {
                String[] stringArray67 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$StringValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaStringConstantValue"};
                stringArray = stringArray67;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedByteConstantValueImpl": {
                String[] stringArray68 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$UByteValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedByteConstantValue"};
                stringArray = stringArray68;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedIntConstantValueImpl": {
                String[] stringArray69 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$UIntValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedIntConstantValue"};
                stringArray = stringArray69;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedLongConstantValueImpl": {
                String[] stringArray70 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$ULongValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedLongConstantValue"};
                stringArray = stringArray70;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/KaUnsignedShortConstantValueImpl": {
                String[] stringArray71 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$UShortValue", "org/jetbrains/kotlin/analysis/api/impl/base/KaConstantValue$KaUnsignedShortConstantValue"};
                stringArray = stringArray71;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationImpl": {
                String[] stringArray72 = new String[]{"org/jetbrains/kotlin/analysis/api/annotations/KaAnnotation"};
                stringArray = stringArray72;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaArrayAnnotationValueImpl": {
                String[] stringArray73 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$ArrayValue"};
                stringArray = stringArray73;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaBaseEmptyAnnotationList": {
                String[] stringArray74 = new String[]{"org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList"};
                stringArray = stringArray74;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaBaseNamedAnnotationValue": {
                String[] stringArray75 = new String[]{"org/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue"};
                stringArray = stringArray75;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaClassLiteralAnnotationValueImpl": {
                String[] stringArray76 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$ClassLiteralValue"};
                stringArray = stringArray76;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaConstantAnnotationValueImpl": {
                String[] stringArray77 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$ConstantValue"};
                stringArray = stringArray77;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaEnumEntryAnnotationValueImpl": {
                String[] stringArray78 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$EnumEntryValue"};
                stringArray = stringArray78;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaNestedAnnotationAnnotationValueImpl": {
                String[] stringArray79 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$NestedAnnotationValue"};
                stringArray = stringArray79;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaUnsupportedAnnotationValueImpl": {
                String[] stringArray80 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/annotations/KaAnnotationValue$UnsupportedValue"};
                stringArray = stringArray80;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaAbstractResolver": {
                String[] stringArray81 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaResolver"};
                stringArray = stringArray81;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaAbstractSignatureSubstitutor": {
                String[] stringArray82 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaSignatureSubstitutor"};
                stringArray = stringArray82;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaAnalysisScopeProviderImpl": {
                String[] stringArray83 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaAnalysisScopeProvider"};
                stringArray = stringArray83;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseClassTypeBuilder": {
                String[] stringArray84 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaClassTypeBuilder"};
                stringArray = stringArray84;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseCompilerPluginGeneratedDeclarations": {
                String[] stringArray85 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaCompilerPluginGeneratedDeclarations"};
                stringArray = stringArray85;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseImplicitReceiver": {
                String[] stringArray86 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiver"};
                stringArray = stringArray86;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseImplicitReceiverSmartCast": {
                String[] stringArray87 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaImplicitReceiverSmartCast"};
                stringArray = stringArray87;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseScopeContext": {
                String[] stringArray88 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaScopeContext"};
                stringArray = stringArray88;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSmartCastInfo": {
                String[] stringArray89 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaSmartCastInfo"};
                stringArray = stringArray89;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSymbolProvider": {
                String[] stringArray90 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/symbols/KaSymbolProvider"};
                stringArray = stringArray90;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseTypeCreator": {
                String[] stringArray91 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaTypeCreator"};
                stringArray = stringArray91;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseTypeParameterTypeBuilder": {
                String[] stringArray92 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaTypeParameterTypeBuilder"};
                stringArray = stringArray92;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseTypeRelationChecker": {
                String[] stringArray93 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent", "org/jetbrains/kotlin/analysis/api/components/KaTypeRelationChecker"};
                stringArray = stringArray93;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaRendererImpl": {
                String[] stringArray94 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaRenderer", "org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent"};
                stringArray = stringArray94;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/components/KaSessionComponent": {
                String[] stringArray95 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray95;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractCallsInPlaceContractEffectDeclaration": {
                String[] stringArray96 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractCallsInPlaceContractEffectDeclaration"};
                stringArray = stringArray96;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractConditionalContractEffectDeclaration": {
                String[] stringArray97 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConditionalContractEffectDeclaration"};
                stringArray = stringArray97;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractConstantValue": {
                String[] stringArray98 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractConstantValue"};
                stringArray = stringArray98;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractParameterValue": {
                String[] stringArray99 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractParameterValue"};
                stringArray = stringArray99;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractReturnsNotNullEffectDeclaration": {
                String[] stringArray100 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration$KaContractReturnsNotNullEffectDeclaration"};
                stringArray = stringArray100;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractReturnsSpecificValueEffectDeclaration": {
                String[] stringArray101 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration$KaContractReturnsSpecificValueEffectDeclaration"};
                stringArray = stringArray101;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/KaBaseContractReturnsSuccessfullyEffectDeclaration": {
                String[] stringArray102 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/KaContractReturnsContractEffectDeclaration$KaContractReturnsSuccessfullyEffectDeclaration"};
                stringArray = stringArray102;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractBinaryLogicExpression": {
                String[] stringArray103 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBinaryLogicExpression"};
                stringArray = stringArray103;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractBooleanConstantExpression": {
                String[] stringArray104 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanConstantExpression"};
                stringArray = stringArray104;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractBooleanValueParameterExpression": {
                String[] stringArray105 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractBooleanValueParameterExpression"};
                stringArray = stringArray105;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractIsInstancePredicateExpression": {
                String[] stringArray106 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsInstancePredicateExpression"};
                stringArray = stringArray106;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractIsNullPredicateExpression": {
                String[] stringArray107 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractIsNullPredicateExpression"};
                stringArray = stringArray107;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/contracts/description/booleans/KaBaseContractLogicalNotExpression": {
                String[] stringArray108 = new String[]{"org/jetbrains/kotlin/analysis/api/contracts/description/booleans/KaContractLogicalNotExpression"};
                stringArray = stringArray108;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker": {
                String[] stringArray109 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker"};
                stringArray = stringArray109;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseAnalysisPermissionChecker": {
                String[] stringArray110 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker"};
                stringArray = stringArray110;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseModuleProvider": {
                String[] stringArray111 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModuleProvider"};
                stringArray = stringArray111;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBuiltinsModuleImpl": {
                String[] stringArray112 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaBuiltinsModule"};
                stringArray = stringArray112;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/references/KaBaseSimpleNameReference": {
                String[] stringArray113 = new String[]{"org/jetbrains/kotlin/idea/references/KtSimpleNameReference"};
                stringArray = stringArray113;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseAnnotationCall": {
                String[] stringArray114 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall"};
                stringArray = stringArray114;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseApplicableCallCandidateInfo": {
                String[] stringArray115 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo"};
                stringArray = stringArray115;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundArrayAccessCall": {
                String[] stringArray116 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall", "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall"};
                stringArray = stringArray116;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundAssignOperation": {
                String[] stringArray117 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAssignOperation"};
                stringArray = stringArray117;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundUnaryOperation": {
                String[] stringArray118 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundUnaryOperation"};
                stringArray = stringArray118;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseCompoundVariableAccessCall": {
                String[] stringArray119 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall"};
                stringArray = stringArray119;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseDelegatedConstructorCall": {
                String[] stringArray120 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall"};
                stringArray = stringArray120;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseErrorCallInfo": {
                String[] stringArray121 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo"};
                stringArray = stringArray121;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseExplicitReceiverValue": {
                String[] stringArray122 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue"};
                stringArray = stringArray122;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseImplicitReceiverValue": {
                String[] stringArray123 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue"};
                stringArray = stringArray123;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseInapplicableCallCandidateInfo": {
                String[] stringArray124 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo"};
                stringArray = stringArray124;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBasePartiallyAppliedSymbol": {
                String[] stringArray125 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaPartiallyAppliedSymbol"};
                stringArray = stringArray125;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSimpleFunctionCall": {
                String[] stringArray126 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall"};
                stringArray = stringArray126;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSimpleVariableAccessCall": {
                String[] stringArray127 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall"};
                stringArray = stringArray127;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSimpleVariableWriteAccess": {
                String[] stringArray128 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaSimpleVariableAccess$Write"};
                stringArray = stringArray128;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSmartCastedReceiverValue": {
                String[] stringArray129 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue"};
                stringArray = stringArray129;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/resolution/KaBaseSuccessCallInfo": {
                String[] stringArray130 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo"};
                stringArray = stringArray130;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/scopes/KaBaseCompositeScope": {
                String[] stringArray131 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScope"};
                stringArray = stringArray131;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/scopes/KaBaseCompositeTypeScope": {
                String[] stringArray132 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope"};
                stringArray = stringArray132;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/scopes/KaBaseEmptyScope": {
                String[] stringArray133 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScope"};
                stringArray = stringArray133;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider": {
                String[] stringArray134 = new String[]{"org/jetbrains/kotlin/analysis/api/session/KaSessionProvider"};
                stringArray = stringArray134;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope": {
                String[] stringArray135 = new String[]{"com/intellij/psi/search/GlobalSearchScope"};
                stringArray = stringArray135;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyAccessorSymbolPointer": {
                String[] stringArray136 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaSymbolPointer"};
                stringArray = stringArray136;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyGetterSymbolPointer": {
                String[] stringArray137 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyAccessorSymbolPointer"};
                stringArray = stringArray137;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertySetterSymbolPointer": {
                String[] stringArray138 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBasePropertyAccessorSymbolPointer"};
                stringArray = stringArray138;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseReceiverParameterSymbolPointer": {
                String[] stringArray139 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaSymbolPointer"};
                stringArray = stringArray139;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseValueParameterFromDefaultSetterSymbolPointer": {
                String[] stringArray140 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaSymbolPointer"};
                stringArray = stringArray140;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseResolvedClassTypeQualifier": {
                String[] stringArray141 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaResolvedClassTypeQualifier"};
                stringArray = stringArray141;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseStarTypeProjection": {
                String[] stringArray142 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection"};
                stringArray = stringArray142;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseTypeArgumentWithVariance": {
                String[] stringArray143 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance"};
                stringArray = stringArray143;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/types/KaBaseUnresolvedClassTypeQualifier": {
                String[] stringArray144 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaUnresolvedClassTypeQualifier"};
                stringArray = stringArray144;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/util/KaBaseCompiledFileForOutputFile": {
                String[] stringArray145 = new String[]{"org/jetbrains/kotlin/analysis/api/components/KaCompiledFile"};
                stringArray = stringArray145;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/util/KaNonBoundToPsiErrorDiagnostic": {
                String[] stringArray146 = new String[]{"org/jetbrains/kotlin/analysis/api/diagnostics/KaDiagnostic"};
                stringArray = stringArray146;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/impl/base/util/KaSessionCreationContextImpl": {
                String[] stringArray147 = new String[]{"org/jetbrains/kotlin/analysis/api/impl/base/util/KaSessionCreationContext"};
                stringArray = stringArray147;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KaInaccessibleLifetimeOwnerAccessException": {
                String[] stringArray148 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException"};
                stringArray = stringArray148;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/lifetime/KaInvalidLifetimeOwnerAccessException": {
                String[] stringArray149 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaIllegalLifetimeOwnerAccessException"};
                stringArray = stringArray149;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/permissions/KaAnalysisPermissionRegistryImpl": {
                String[] stringArray150 = new String[]{"org/jetbrains/kotlin/analysis/api/permissions/KaAnalysisPermissionRegistry"};
                stringArray = stringArray150;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker": {
                String[] stringArray151 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/KaEngineService"};
                stringArray = stringArray151;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/modification/KaSourceModificationService": {
                String[] stringArray152 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/KaEngineService"};
                stringArray = stringArray152;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker": {
                String[] stringArray153 = new String[]{"org/jetbrains/kotlin/analysis/api/platform/KaEngineService"};
                stringArray = stringArray153;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/platform/projectStructure/KaDanglingFileModuleImpl": {
                String[] stringArray154 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule"};
                stringArray = stringArray154;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaBuiltinsModule": {
                String[] stringArray155 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray155;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule": {
                String[] stringArray156 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray156;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule": {
                String[] stringArray157 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray157;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule": {
                String[] stringArray158 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray158;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule": {
                String[] stringArray159 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray159;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaScriptDependencyModule": {
                String[] stringArray160 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray160;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaScriptModule": {
                String[] stringArray161 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray161;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule": {
                String[] stringArray162 = new String[]{"org/jetbrains/kotlin/analysis/api/projectStructure/KaModule"};
                stringArray = stringArray162;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyWithMembersRenderer": {
                String[] stringArray163 = new String[]{"org/jetbrains/kotlin/analysis/api/renderer/declarations/renderers/KaClassifierBodyRenderer"};
                stringArray = stringArray163;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaAnnotationCall": {
                String[] stringArray164 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall"};
                stringArray = stringArray164;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaApplicableCallCandidateInfo": {
                String[] stringArray165 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo"};
                stringArray = stringArray165;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCall": {
                String[] stringArray166 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray166;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo": {
                String[] stringArray167 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray167;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo": {
                String[] stringArray168 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray168;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall": {
                String[] stringArray169 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCall"};
                stringArray = stringArray169;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundArrayAccessCall": {
                String[] stringArray170 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCall", "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall"};
                stringArray = stringArray170;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAssignOperation": {
                String[] stringArray171 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation"};
                stringArray = stringArray171;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation": {
                String[] stringArray172 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray172;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundUnaryOperation": {
                String[] stringArray173 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCompoundOperation"};
                stringArray = stringArray173;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall": {
                String[] stringArray174 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCall", "org/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall"};
                stringArray = stringArray174;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaDelegatedConstructorCall": {
                String[] stringArray175 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall"};
                stringArray = stringArray175;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaErrorCallInfo": {
                String[] stringArray176 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo"};
                stringArray = stringArray176;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaExplicitReceiverValue": {
                String[] stringArray177 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue"};
                stringArray = stringArray177;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall": {
                String[] stringArray178 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall"};
                stringArray = stringArray178;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaImplicitReceiverValue": {
                String[] stringArray179 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue"};
                stringArray = stringArray179;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaInapplicableCallCandidateInfo": {
                String[] stringArray180 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallCandidateInfo"};
                stringArray = stringArray180;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaPartiallyAppliedSymbol": {
                String[] stringArray181 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray181;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue": {
                String[] stringArray182 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray182;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleFunctionCall": {
                String[] stringArray183 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall"};
                stringArray = stringArray183;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSimpleVariableAccessCall": {
                String[] stringArray184 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall"};
                stringArray = stringArray184;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSmartCastedReceiverValue": {
                String[] stringArray185 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaReceiverValue"};
                stringArray = stringArray185;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSuccessCallInfo": {
                String[] stringArray186 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallInfo"};
                stringArray = stringArray186;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaSymbolBasedReference": {
                String[] stringArray187 = new String[]{"org/jetbrains/kotlin/idea/references/KtReference"};
                stringArray = stringArray187;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolution/KaVariableAccessCall": {
                String[] stringArray188 = new String[]{"org/jetbrains/kotlin/analysis/api/resolution/KaCallableMemberCall"};
                stringArray = stringArray188;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtension": {
                String[] stringArray189 = new String[]{"com/intellij/openapi/Disposable"};
                stringArray = stringArray189;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KaScope": {
                String[] stringArray190 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike"};
                stringArray = stringArray190;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike": {
                String[] stringArray191 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray191;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/scopes/KaTypeScope": {
                String[] stringArray192 = new String[]{"org/jetbrains/kotlin/analysis/api/scopes/KaScopeLike"};
                stringArray = stringArray192;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider": {
                String[] stringArray193 = new String[]{"com/intellij/openapi/Disposable"};
                stringArray = stringArray193;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature": {
                String[] stringArray194 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray194;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaFunctionSignature": {
                String[] stringArray195 = new String[]{"org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature"};
                stringArray = stringArray195;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/signatures/KaVariableSignature": {
                String[] stringArray196 = new String[]{"org/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature"};
                stringArray = stringArray196;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousFunctionSymbol": {
                String[] stringArray197 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol"};
                stringArray = stringArray197;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaAnonymousObjectSymbol": {
                String[] stringArray198 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol"};
                stringArray = stringArray198;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaBackingFieldSymbol": {
                String[] stringArray199 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                stringArray = stringArray199;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol": {
                String[] stringArray200 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol", "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner"};
                stringArray = stringArray200;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassInitializerSymbol": {
                String[] stringArray201 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol"};
                stringArray = stringArray201;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol": {
                String[] stringArray202 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol"};
                stringArray = stringArray202;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol": {
                String[] stringArray203 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationContainerSymbol"};
                stringArray = stringArray203;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol": {
                String[] stringArray204 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol"};
                stringArray = stringArray204;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol": {
                String[] stringArray205 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol"};
                stringArray = stringArray205;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol": {
                String[] stringArray206 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol"};
                stringArray = stringArray206;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaDestructuringDeclarationSymbol": {
                String[] stringArray207 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol"};
                stringArray = stringArray207;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntryInitializerSymbol": {
                String[] stringArray208 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationContainerSymbol"};
                stringArray = stringArray208;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol": {
                String[] stringArray209 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                stringArray = stringArray209;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol": {
                String[] stringArray210 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol"};
                stringArray = stringArray210;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol": {
                String[] stringArray211 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol"};
                stringArray = stringArray211;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaJavaFieldSymbol": {
                String[] stringArray212 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                stringArray = stringArray212;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaKotlinPropertySymbol": {
                String[] stringArray213 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol"};
                stringArray = stringArray213;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaLocalVariableSymbol": {
                String[] stringArray214 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                stringArray = stringArray214;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol": {
                String[] stringArray215 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterOwnerSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner"};
                stringArray = stringArray215;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol": {
                String[] stringArray216 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol"};
                stringArray = stringArray216;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPackageSymbol": {
                String[] stringArray217 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                stringArray = stringArray217;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol": {
                String[] stringArray218 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol"};
                stringArray = stringArray218;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol": {
                String[] stringArray219 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol"};
                stringArray = stringArray219;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertyGetterSymbol": {
                String[] stringArray220 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol"};
                stringArray = stringArray220;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySetterSymbol": {
                String[] stringArray221 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertyAccessorSymbol"};
                stringArray = stringArray221;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol": {
                String[] stringArray222 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterOwnerSymbol"};
                stringArray = stringArray222;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol": {
                String[] stringArray223 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol"};
                stringArray = stringArray223;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaSamConstructorSymbol": {
                String[] stringArray224 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol"};
                stringArray = stringArray224;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol": {
                String[] stringArray225 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol"};
                stringArray = stringArray225;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaSymbol": {
                String[] stringArray226 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray226;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaSyntheticJavaPropertySymbol": {
                String[] stringArray227 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaPropertySymbol"};
                stringArray = stringArray227;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaTypeAliasSymbol": {
                String[] stringArray228 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterOwnerSymbol"};
                stringArray = stringArray228;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol": {
                String[] stringArray229 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaClassifierSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol"};
                stringArray = stringArray229;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol": {
                String[] stringArray230 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaParameterSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaAnnotatedSymbol"};
                stringArray = stringArray230;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/KaVariableSymbol": {
                String[] stringArray231 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol", "org/jetbrains/kotlin/analysis/api/symbols/KaNamedSymbol"};
                stringArray = stringArray231;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol": {
                String[] stringArray232 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol", "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated"};
                stringArray = stringArray232;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaDeclarationContainerSymbol": {
                String[] stringArray233 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                stringArray = stringArray233;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaPossiblyNamedSymbol": {
                String[] stringArray234 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                stringArray = stringArray234;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind": {
                String[] stringArray235 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                stringArray = stringArray235;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/markers/KaTypeParameterOwnerSymbol": {
                String[] stringArray236 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/KaSymbol"};
                stringArray = stringArray236;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/symbols/pointers/KaPsiBasedSymbolPointer": {
                String[] stringArray237 = new String[]{"org/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer"};
                stringArray = stringArray237;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaCapturedType": {
                String[] stringArray238 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray238;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaClassErrorType": {
                String[] stringArray239 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaErrorType"};
                stringArray = stringArray239;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaClassType": {
                String[] stringArray240 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray240;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier": {
                String[] stringArray241 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray241;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaDefinitelyNotNullType": {
                String[] stringArray242 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray242;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaDynamicType": {
                String[] stringArray243 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray243;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaErrorType": {
                String[] stringArray244 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray244;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaFlexibleType": {
                String[] stringArray245 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray245;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaFunctionType": {
                String[] stringArray246 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassType", "org/jetbrains/kotlin/analysis/api/base/KaContextReceiversOwner"};
                stringArray = stringArray246;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaIntersectionType": {
                String[] stringArray247 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray247;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaResolvedClassTypeQualifier": {
                String[] stringArray248 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier"};
                stringArray = stringArray248;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaStarTypeProjection": {
                String[] stringArray249 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaTypeProjection"};
                stringArray = stringArray249;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaSubstitutor": {
                String[] stringArray250 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray250;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaType": {
                String[] stringArray251 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner", "org/jetbrains/kotlin/analysis/api/annotations/KaAnnotated"};
                stringArray = stringArray251;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeArgumentWithVariance": {
                String[] stringArray252 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaTypeProjection"};
                stringArray = stringArray252;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeParameterType": {
                String[] stringArray253 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaType"};
                stringArray = stringArray253;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaTypeProjection": {
                String[] stringArray254 = new String[]{"org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwner"};
                stringArray = stringArray254;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaUnresolvedClassTypeQualifier": {
                String[] stringArray255 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassTypeQualifier"};
                stringArray = stringArray255;
                break;
            }
            case "org/jetbrains/kotlin/analysis/api/types/KaUsualClassType": {
                String[] stringArray256 = new String[]{"org/jetbrains/kotlin/analysis/api/types/KaClassType"};
                stringArray = stringArray256;
                break;
            }
            default: {
                stringArray = new String[]{};
            }
        }
        return stringArray;
    }

    private final String mapApi(String key, String oldApi) {
        String string;
        switch (key) {
            case "getAnnotations (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;)": {
                string = "";
                break;
            }
            case "getAnnotationInfos (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;)": {
                string = "";
                break;
            }
            case "getAnalysisSession (Lorg/jetbrains/kotlin/analysis/api/KaSession;)": {
                string = "getUseSiteSession";
                break;
            }
            case "getConstantValue (Lorg/jetbrains/kotlin/analysis/api/annotations/ConstantValue;)": {
                string = "getValue";
                break;
            }
            case "getAnnotationInfos (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotated;)": {
                string = "getAnnotations";
                break;
            }
            case "getAnnotationsList (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotated;)": {
                string = "getAnnotations";
                break;
            }
            case "annotationsByClassId (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;Lorg/jetbrains/kotlin/name/ClassId;)": {
                string = "get";
                break;
            }
            case "getAnnotationClassIds (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;)": {
                string = "getClassIds";
                break;
            }
            case "hasAnnotation (Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationList;Lorg/jetbrains/kotlin/name/ClassId;)": {
                string = "contains";
                break;
            }
            case "getAnnotationValue (Lorg/jetbrains/kotlin/analysis/api/annotations/NestedAnnotationValue;)": {
                string = "getAnnotation";
                break;
            }
            case "renderAsKotlinConstant (Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;)": {
                string = "render";
                break;
            }
            case "getANY (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getAny";
                break;
            }
            case "getBOOLEAN (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getBoolean";
                break;
            }
            case "getBYTE (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getByte";
                break;
            }
            case "getCHAR (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getChar";
                break;
            }
            case "getDOUBLE (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getDouble";
                break;
            }
            case "getFLOAT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getFloat";
                break;
            }
            case "getINT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getInt";
                break;
            }
            case "getLONG (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getLong";
                break;
            }
            case "getNOTHING (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getNothing";
                break;
            }
            case "getNULLABLE_ANY (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getNullableAny";
                break;
            }
            case "getNULLABLE_NOTHING (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getNullableNothing";
                break;
            }
            case "getSHORT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getShort";
                break;
            }
            case "getSTRING (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getString";
                break;
            }
            case "getTHROWABLE (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getThrowable";
                break;
            }
            case "getUNIT (Lorg/jetbrains/kotlin/analysis/api/components/KaBuiltinTypes;)": {
                string = "getUnit";
                break;
            }
            case "getExitPointSnapshot (Ljava/util/List;)": {
                string = "computeExitPointSnapshot";
                break;
            }
            case "collectDiagnosticsForFile (Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter;)": {
                string = "collectDiagnostics";
                break;
            }
            case "getDiagnostics (Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/analysis/api/components/KaDiagnosticCheckerFilter;)": {
                string = "diagnostic";
                break;
            }
            case "getMissingCases (Lorg/jetbrains/kotlin/psi/KtWhenExpression;)": {
                string = "computeMissingCases";
                break;
            }
            case "getReturnTargetSymbol (Lorg/jetbrains/kotlin/psi/KtReturnExpression;)": {
                string = "getTargetSymbol";
                break;
            }
            case "getFunctionalType (Lorg/jetbrains/kotlin/psi/KtFunction;)": {
                string = "getFunctionType";
                break;
            }
            case "getKaType (Lorg/jetbrains/kotlin/psi/KtExpression;)": {
                string = "getExpressionType";
                break;
            }
            case "getKtType (Lorg/jetbrains/kotlin/psi/KtExpression;)": {
                string = "getExpressionType";
                break;
            }
            case "getReturnKaType (Lorg/jetbrains/kotlin/psi/KtDeclaration;)": {
                string = "getReturnType";
                break;
            }
            case "getReturnKtType (Lorg/jetbrains/kotlin/psi/KtDeclaration;)": {
                string = "getReturnType";
                break;
            }
            case "analyseImports (Lorg/jetbrains/kotlin/psi/KtFile;)": {
                string = "analyzeImportsToOptimize";
                break;
            }
            case "asKtType (Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiElement;)": {
                string = "asKaType";
                break;
            }
            case "mapTypeToJvmType (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;)": {
                string = "mapToJvmType";
                break;
            }
            case "collectCallCandidates (Lorg/jetbrains/kotlin/psi/KtElement;)": {
                string = "collectCallCandidatesOld";
                break;
            }
            case "collectCallCandidatesOld (Lorg/jetbrains/kotlin/psi/KtElement;)": {
                string = "resolveToCallCandidates";
                break;
            }
            case "resolveCall (Lorg/jetbrains/kotlin/psi/KtElement;)": {
                string = "resolveToCall";
                break;
            }
            case "resolveCallOld (Lorg/jetbrains/kotlin/psi/KtElement;)": {
                string = "resolveToCall";
                break;
            }
            case "getScopeContextForPosition (Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtElement;)": {
                string = "scopeContext";
                break;
            }
            case "getDeprecationStatus (Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;)": {
                string = "deprecationStatus";
                break;
            }
            case "getUnwrapFakeOverrides (Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)": {
                string = "getFakeOverrideOriginal";
                break;
            }
            case "getExpandedClassSymbol (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "getExpandedSymbol";
                break;
            }
            case "isAny (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isAnyType";
                break;
            }
            case "isBoolean (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isBooleanType";
                break;
            }
            case "isByte (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isByteType";
                break;
            }
            case "isChar (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isCharType";
                break;
            }
            case "isCharSequence (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isCharSequenceType";
                break;
            }
            case "isClassTypeWithClassId (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/name/ClassId;)": {
                string = "isClassType";
                break;
            }
            case "isDouble (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isDoubleType";
                break;
            }
            case "isFloat (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isFloatType";
                break;
            }
            case "isFunctionalInterfaceType (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isFunctionalInterface";
                break;
            }
            case "isInt (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isIntType";
                break;
            }
            case "isLong (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isLongType";
                break;
            }
            case "isNothing (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isNothingType";
                break;
            }
            case "isShort (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isShortType";
                break;
            }
            case "isString (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isStringType";
                break;
            }
            case "isUByte (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isUByteType";
                break;
            }
            case "isUInt (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isUIntType";
                break;
            }
            case "isULong (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isULongType";
                break;
            }
            case "isUShort (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isUShortType";
                break;
            }
            case "isUnit (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "isUnitType";
                break;
            }
            case "buildSelfClassType (Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedClassSymbol;)": {
                string = "getDefaultType";
                break;
            }
            case "getAllSuperTypes (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)": {
                string = "allSupertypes";
                break;
            }
            case "getDirectSuperTypes (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)": {
                string = "directSuperTypes";
                break;
            }
            case "getImplicitReceiverTypesAtPosition (Lorg/jetbrains/kotlin/psi/KtElement;)": {
                string = "collectImplicitReceiverTypes";
                break;
            }
            case "getKaType (Lorg/jetbrains/kotlin/psi/KtTypeReference;)": {
                string = "getType";
                break;
            }
            case "getKtType (Lorg/jetbrains/kotlin/psi/KtTypeReference;)": {
                string = "getType";
                break;
            }
            case "getReceiverKtType (Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;)": {
                string = "getReceiverType";
                break;
            }
            case "hasCommonSubTypeWith (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "hasCommonSubtypeWith";
                break;
            }
            case "isEqualTo (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "semanticallyEquals";
                break;
            }
            case "isEqualTo (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy;)": {
                string = "semanticallyEquals";
                break;
            }
            case "isSubTypeOf (Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lorg/jetbrains/kotlin/analysis/api/components/KaSubtypingErrorTypePolicy;)": {
                string = "isSubtypeOf";
                break;
            }
            case "getAnalysisExtensionFileContextModule (Lcom/intellij/openapi/vfs/VirtualFile;)": {
                string = "getAnalysisContextModule";
                break;
            }
            case "getPlatform (Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)": {
                string = "getTargetPlatform";
                break;
            }
            case "getModuleName (Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;)": {
                string = "getName";
                break;
            }
            case "getCompoundAccess (Lorg/jetbrains/kotlin/analysis/api/resolution/KaCompoundAccessCall;)": {
                string = "getCompoundOperation";
                break;
            }
            case "getPartiallyAppliedSymbol (Lorg/jetbrains/kotlin/analysis/api/resolution/KaCompoundVariableAccessCall;)": {
                string = "getVariablePartiallyAppliedSymbol";
                break;
            }
            case "getAllSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;)": {
                string = "getDeclarations";
                break;
            }
            case "getCallableSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Ljava/util/Collection;)": {
                string = "callables";
                break;
            }
            case "getCallableSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Lorg/jetbrains/kotlin/name/Name;)": {
                string = "callables";
                break;
            }
            case "getClassifierSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Ljava/util/Collection;)": {
                string = "classifiers";
                break;
            }
            case "getClassifierSymbols (Lorg/jetbrains/kotlin/analysis/api/scopes/KaScope;Lorg/jetbrains/kotlin/name/Name;)": {
                string = "classifiers";
                break;
            }
            case "getCallableIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/signatures/KaCallableSignature;)": {
                string = "getCallableId";
                break;
            }
            case "getCreatePackagePartProvider (Lorg/jetbrains/kotlin/analysis/api/standalone/StandaloneAnalysisAPISession;)": {
                string = "getProject::createPackagePartProvider";
                break;
            }
            case "getMockProject (Lorg/jetbrains/kotlin/analysis/api/standalone/StandaloneAnalysisAPISession;)": {
                string = "getProject";
                break;
            }
            case "getCallableIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)": {
                string = "getCallableId";
                break;
            }
            case "getClassIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;)": {
                string = "getClassId";
                break;
            }
            case "getContainingClassIdIfNonLocal (Lorg/jetbrains/kotlin/analysis/api/symbols/KaConstructorSymbol;)": {
                string = "getContainingClassId";
                break;
            }
            case "getType (Lorg/jetbrains/kotlin/analysis/api/symbols/KaReceiverParameterSymbol;)": {
                string = "getReturnType";
                break;
            }
            case "getAnonymousFunctionSymbol (Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)": {
                string = "getSymbol";
                break;
            }
            case "getAnonymousObjectSymbol (Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;)": {
                string = "getSymbol";
                break;
            }
            case "getClassOrObjectSymbol (Lorg/jetbrains/kotlin/psi/KtClassOrObject;)": {
                string = "getClassSymbol";
                break;
            }
            case "getClassOrObjectSymbolByClassId (Lorg/jetbrains/kotlin/name/ClassId;)": {
                string = "findClass";
                break;
            }
            case "getConstructorSymbol (Lorg/jetbrains/kotlin/psi/KtConstructor;)": {
                string = "getSymbol";
                break;
            }
            case "getDestructuringDeclarationEntrySymbol (Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;)": {
                string = "getSymbol";
                break;
            }
            case "getEnumEntrySymbol (Lorg/jetbrains/kotlin/psi/KtEnumEntry;)": {
                string = "getSymbol";
                break;
            }
            case "getFileSymbol (Lorg/jetbrains/kotlin/psi/KtFile;)": {
                string = "getSymbol";
                break;
            }
            case "getFunctionLikeSymbol (Lorg/jetbrains/kotlin/psi/KtNamedFunction;)": {
                string = "getSymbol";
                break;
            }
            case "getNamedClassOrObjectSymbol (Lorg/jetbrains/kotlin/psi/KtClassOrObject;)": {
                string = "getNamedClassSymbol";
                break;
            }
            case "getPackageSymbolIfPackageExists (Lorg/jetbrains/kotlin/name/FqName;)": {
                string = "findPackage";
                break;
            }
            case "getParameterSymbol (Lorg/jetbrains/kotlin/psi/KtParameter;)": {
                string = "getSymbol";
                break;
            }
            case "getPropertyAccessorSymbol (Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;)": {
                string = "getSymbol";
                break;
            }
            case "getROOT_PACKAGE_SYMBOL ()": {
                string = "getRootPackageSymbol";
                break;
            }
            case "getScriptSymbol (Lorg/jetbrains/kotlin/psi/KtScript;)": {
                string = "getSymbol";
                break;
            }
            case "getTopLevelCallableSymbols (Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)": {
                string = "findTopLevelCallables";
                break;
            }
            case "getTypeAliasByClassId (Lorg/jetbrains/kotlin/name/ClassId;)": {
                string = "findTypeAlias";
                break;
            }
            case "getTypeAliasSymbol (Lorg/jetbrains/kotlin/psi/KtTypeAlias;)": {
                string = "getSymbol";
                break;
            }
            case "getTypeParameterSymbol (Lorg/jetbrains/kotlin/psi/KtTypeParameter;)": {
                string = "getSymbol";
                break;
            }
            case "getVariableSymbol (Lorg/jetbrains/kotlin/psi/KtProperty;)": {
                string = "getSymbol";
                break;
            }
            case "getSymbolKind (Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaSymbolWithKind;)": {
                string = "getLocation";
                break;
            }
            case "getAbbreviatedTypeOrSelf (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "getAbbreviationOrSelf";
                break;
            }
            case "getCandidateClassSymbols (Lorg/jetbrains/kotlin/analysis/api/types/KaClassErrorType;)": {
                string = "getCandidateSymbols";
                break;
            }
            case "getClassSymbol (Lorg/jetbrains/kotlin/analysis/api/types/KaClassType;)": {
                string = "getSymbol";
                break;
            }
            case "getOwnTypeArguments (Lorg/jetbrains/kotlin/analysis/api/types/KaClassType;)": {
                string = "getTypeArguments";
                break;
            }
            case "asStringForDebugging (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "toString";
                break;
            }
            case "getAbbreviatedType (Lorg/jetbrains/kotlin/analysis/api/types/KaType;)": {
                string = "getAbbreviation";
                break;
            }
            default: {
                string = oldApi;
            }
        }
        return string;
    }

    private final boolean isRelevantMethod(MethodNode methodNode) {
        return this.find(methodNode, (Function1<? super AbstractInsnNode, Boolean>)((Function1)isRelevantMethod.1.INSTANCE)) != null;
    }

    private final AbstractInsnNode find(MethodNode $this$find, Function1<? super AbstractInsnNode, Boolean> condition) {
        ListIterator listIterator = $this$find.instructions.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"iterator(...)");
        ListIterator listIterator2 = listIterator;
        while (listIterator2.hasNext()) {
            AbstractInsnNode instruction = (AbstractInsnNode)listIterator2.next();
            Intrinsics.checkNotNull((Object)instruction);
            if (!((Boolean)condition.invoke((Object)instruction)).booleanValue()) continue;
            return instruction;
        }
        return null;
    }

    private final byte[] migrateAnalyzeCall(byte[] classBytes) {
        ClassReader cr = new ClassReader(classBytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean modified = false;
        for (MethodNode method : cn.methods) {
            Intrinsics.checkNotNull((Object)method);
            if (this.isRelevantMethod(method)) {
                String before = "";
                modified = this.migrateAnalyzeCall(method) || modified;
            }
            String string = cn.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if (!StringsKt.startsWith$default((String)string, (String)"androidx/navigation/", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)method.name, (Object)"isClassReference") && !Intrinsics.areEqual((Object)method.name, (Object)"isClassReference$default") || !this.handleLintUtilRedirection(method)) continue;
            modified = true;
        }
        if (!modified) {
            return classBytes;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        byte[] result = cw.toByteArray();
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private final boolean handleLintUtilRedirection(MethodNode method) {
        if (Intrinsics.areEqual((Object)method.name, (Object)"isClassReference") && (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;)Lkotlin/Pair;") || Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;"))) {
            InsnList instructions = method.instructions;
            instructions.clear();
            LabelNode startLabel = new LabelNode();
            instructions.add((AbstractInsnNode)startLabel);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;)Lkotlin/Pair;")) {
                instructions.add((AbstractInsnNode)new InsnNode(4));
                instructions.add((AbstractInsnNode)new InsnNode(4));
                instructions.add((AbstractInsnNode)new InsnNode(4));
            } else if (Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;")) {
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
                instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            } else {
                return false;
            }
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/android/tools/lint/detector/api/UastLintUtilsKt", method.name, "(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;"));
            instructions.add((AbstractInsnNode)new InsnNode(176));
            LabelNode endLabel = new LabelNode();
            instructions.add((AbstractInsnNode)endLabel);
            method.maxStack = 2;
            method.maxLocals = 4;
            method.tryCatchBlocks.clear();
            method.localVariables.clear();
            method.localVariables.add(new LocalVariableNode("$this$isClassReference", "Lorg/jetbrains/uast/UExpression;", null, startLabel, endLabel, 0));
            return true;
        }
        if (Intrinsics.areEqual((Object)method.name, (Object)"isClassReference$default") && Intrinsics.areEqual((Object)method.desc, (Object)"(Lorg/jetbrains/uast/UExpression;ZZZILjava/lang/Object;)Lkotlin/Pair;")) {
            Object v1;
            block8: {
                InsnList insnList = method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
                Iterable $this$firstOrNull$iv = (Iterable)insnList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isStaticCall(it, "isClassReference", "androidx/navigation/lint/common/LintUtilKt", "(Lorg/jetbrains/uast/UExpression;ZZZ)Lkotlin/Pair;")) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            AbstractInsnNode abstractInsnNode = v1;
            if (abstractInsnNode == null) {
                return false;
            }
            AbstractInsnNode replace = abstractInsnNode;
            ((MethodInsnNode)replace).owner = "com/android/tools/lint/detector/api/UastLintUtilsKt";
            return true;
        }
        return false;
    }

    private final boolean isCall(AbstractInsnNode $this$isCall, String name, String owner, String desc) {
        MethodInsnNode methodInsnNode = $this$isCall instanceof MethodInsnNode ? (MethodInsnNode)$this$isCall : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode curr = methodInsnNode;
        return Intrinsics.areEqual((Object)curr.name, (Object)name) && Intrinsics.areEqual((Object)curr.owner, (Object)owner) && (desc == null || Intrinsics.areEqual((Object)curr.desc, (Object)desc));
    }

    static /* synthetic */ boolean isCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isCall(abstractInsnNode, string, string2, string3);
    }

    private final boolean isVirtualCall(AbstractInsnNode $this$isVirtualCall, String name, String owner, String desc) {
        return $this$isVirtualCall.getOpcode() == 182 && this.isCall($this$isVirtualCall, name, owner, desc);
    }

    static /* synthetic */ boolean isVirtualCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isVirtualCall(abstractInsnNode, string, string2, string3);
    }

    private final boolean isStaticCall(AbstractInsnNode $this$isStaticCall, String name, String owner, String desc) {
        return $this$isStaticCall.getOpcode() == 184 && this.isCall($this$isStaticCall, name, owner, desc);
    }

    static /* synthetic */ boolean isStaticCall$default(LintJarApiMigration lintJarApiMigration, AbstractInsnNode abstractInsnNode, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return lintJarApiMigration.isStaticCall(abstractInsnNode, string, string2, string3);
    }

    private final boolean migrateAnalyzeCall(MethodNode methodNode) {
        boolean modified = false;
        InsnList instructions = methodNode.instructions;
        Ref.ObjectRef curr = new Ref.ObjectRef();
        curr.element = instructions.getFirst();
        int ktElementVariable = -1;
        while (curr.element != null) {
            AbstractInsnNode end;
            Object object = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            if (this.isVirtualCall((AbstractInsnNode)object, "beforeEnteringAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory", "(Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V")) {
                end = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getToken", "org/jetbrains/kotlin/analysis/api/KtAnalysisSession", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n == null) break;
                int sessionVariable = n;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getTokenFactory", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n2 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n2 == null) break;
                int sessionProviderVariable = n2;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "beforeEnteringAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/impl/NoWriteActionInAnalyseCallChecker", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getNoWriteActionInAnalyseCallChecker", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n3 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n3 == null) break;
                int sessionProviderVariable2 = n3;
                Object object2 = curr.element;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                AbstractInsnNode startReplace = (AbstractInsnNode)object2;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getAnalysisSession", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || ((AbstractInsnNode)curr.element).getOpcode() == 192 && LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n4 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n4 == null) break;
                ktElementVariable = n4;
                AbstractInsnNode last = startReplace.getPrevious();
                AbstractInsnNode c = last.getNext();
                while (c != end) {
                    AbstractInsnNode next = c.getNext();
                    if (!(c instanceof LabelNode) && !(c instanceof LineNumberNode)) {
                        instructions.remove(c);
                    }
                    c = next;
                }
                VarInsnNode i1 = new VarInsnNode(25, sessionProviderVariable);
                VarInsnNode i2 = new VarInsnNode(25, sessionVariable);
                VarInsnNode i3 = new VarInsnNode(25, ktElementVariable);
                MethodInsnNode i4 = new MethodInsnNode(182, "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider", "beforeEnteringAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", false);
                instructions.insert(last, (AbstractInsnNode)i1);
                instructions.insert((AbstractInsnNode)i1, (AbstractInsnNode)i2);
                instructions.insert((AbstractInsnNode)i2, (AbstractInsnNode)i3);
                instructions.insert((AbstractInsnNode)i3, (AbstractInsnNode)i4);
                curr.element = end;
                modified = true;
                continue;
            }
            Object object3 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element");
            if (LintJarApiMigration.isVirtualCall$default(this, (AbstractInsnNode)object3, "afterLeavingAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/impl/NoWriteActionInAnalyseCallChecker", null, 4, null)) {
                AbstractInsnNode last;
                end = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getNoWriteActionInAnalyseCallChecker", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n == null) break;
                int sessionProviderVariable = n;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "afterLeavingAnalysisContext", "org/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getToken", "org/jetbrains/kotlin/analysis/api/KtAnalysisSession", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n5 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n5 == null) break;
                int sessionVariable = n5;
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall$default(this, curr, "getTokenFactory", "org/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider", null, 16, null) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                Integer n6 = LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (n6 == null) break;
                n6.intValue();
                if (((AbstractInsnNode)curr.element).getPrevious() == null) break;
                AbstractInsnNode c = last.getNext();
                while (c != end) {
                    AbstractInsnNode next = c.getNext();
                    if (!(c instanceof LabelNode) && !(c instanceof LineNumberNode)) {
                        instructions.remove(c);
                    }
                    c = next;
                }
                VarInsnNode i1 = new VarInsnNode(25, sessionProviderVariable);
                VarInsnNode i2 = new VarInsnNode(25, sessionVariable);
                VarInsnNode i3 = new VarInsnNode(25, ktElementVariable);
                MethodInsnNode i4 = new MethodInsnNode(182, "org/jetbrains/kotlin/analysis/api/session/KaSessionProvider", "afterLeavingAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", false);
                instructions.insert(last, (AbstractInsnNode)i1);
                instructions.insert((AbstractInsnNode)i1, (AbstractInsnNode)i2);
                instructions.insert((AbstractInsnNode)i2, (AbstractInsnNode)i3);
                instructions.insert((AbstractInsnNode)i3, (AbstractInsnNode)i4);
                curr.element = end;
                modified = true;
                continue;
            }
            Object object4 = curr.element;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
            if (LintJarApiMigration.isStaticCall$default(this, (AbstractInsnNode)object4, "getAllSuperTypes$default", "org/jetbrains/kotlin/analysis/api/components/KtTypeProviderMixIn", null, 4, null)) {
                AbstractInsnNode shouldApproximateLoad;
                AbstractInsnNode aconstNull;
                AbstractInsnNode iconst1;
                AbstractInsnNode checkCast;
                end = ((AbstractInsnNode)curr.element).getNext();
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null || LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                LintJarApiMigration.migrateAnalyzeCall$expectAload((Ref.ObjectRef<AbstractInsnNode>)curr);
                if (LintJarApiMigration.migrateAnalyzeCall$prev((Ref.ObjectRef<AbstractInsnNode>)curr, this) == null) break;
                AbstractInsnNode sessionLoad = checkCast.getPrevious();
                AbstractInsnNode beforeInvokeStatic = ((AbstractInsnNode)curr.element).getPrevious();
                instructions.remove(checkCast);
                instructions.remove(iconst1);
                instructions.remove(aconstNull);
                MethodInsnNode newCall = new MethodInsnNode(185, "org/jetbrains/kotlin/analysis/api/KaSession", "allSupertypes", "(Lorg/jetbrains/kotlin/analysis/api/types/KaType;Z)Lkotlin/sequences/Sequence;", true);
                instructions.insert(shouldApproximateLoad, (AbstractInsnNode)newCall);
                MethodInsnNode toList = new MethodInsnNode(184, "kotlin/sequences/SequencesKt", "toList", "(Lkotlin/sequences/Sequence;)Ljava/util/List;", false);
                instructions.insert((AbstractInsnNode)newCall, (AbstractInsnNode)toList);
                AbstractInsnNode next = toList.getNext();
                instructions.remove(next);
                curr.element = end;
                modified = true;
                continue;
            }
            if (((AbstractInsnNode)curr.element).getNext() == null) {
                Object cfr_ignored_0 = curr.element;
                break;
            }
            curr.element = curr.element;
        }
        return modified;
    }

    private final Class<?> findClass(String owner) {
        try {
            String className = Type.getObjectType((String)owner).getClassName();
            return Class.forName(className, false, LintJarApiMigration.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private final AbstractInsnNode prev(AbstractInsnNode $this$prev) {
        AbstractInsnNode curr = $this$prev.getPrevious();
        while (curr instanceof LabelNode || curr instanceof LineNumberNode) {
            curr = curr.getPrevious();
        }
        return curr;
    }

    @NotNull
    public final String prettyPrint(@NotNull MethodNode $this$prettyPrint) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyPrint, (String)"<this>");
        return $this$prettyPrint.toString();
    }

    private static final AbstractInsnNode migrateAnalyzeCall$prev(Ref.ObjectRef<AbstractInsnNode> curr, LintJarApiMigration this$0) {
        Object object = curr.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        curr.element = this$0.prev((AbstractInsnNode)object);
        return (AbstractInsnNode)curr.element;
    }

    private static final Integer migrateAnalyzeCall$expectAload(Ref.ObjectRef<AbstractInsnNode> curr) {
        Integer n;
        if (((AbstractInsnNode)curr.element).getOpcode() == 25) {
            Object object = curr.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.objectweb.asm.tree.VarInsnNode");
            n = ((VarInsnNode)object).var;
        } else {
            n = null;
        }
        return n;
    }

    private static final AbstractInsnNode migrateAnalyzeCall$expectVirtualCall(LintJarApiMigration this$0, Ref.ObjectRef<AbstractInsnNode> curr, String name, String owner, String desc) {
        Object object = curr.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        return this$0.isVirtualCall((AbstractInsnNode)object, name, owner, desc) ? (AbstractInsnNode)curr.element : null;
    }

    static /* synthetic */ AbstractInsnNode migrateAnalyzeCall$expectVirtualCall$default(LintJarApiMigration lintJarApiMigration, Ref.ObjectRef objectRef, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        return LintJarApiMigration.migrateAnalyzeCall$expectVirtualCall(lintJarApiMigration, (Ref.ObjectRef<AbstractInsnNode>)objectRef, string, string2, string3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$Companion;", "", "<init>", "()V", "DEBUG", "", "isRelevantType", "s", "", "getMigratedJar", "Ljava/io/File;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jar", "registryClass", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRelevantType(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return StringsKt.startsWith$default((String)s, (String)"org/jetbrains/kotlin/analysis/api/", (boolean)false, (int)2, null);
        }

        @NotNull
        public final File getMigratedJar(@NotNull LintClient client, @NotNull File jar, @NotNull String registryClass) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
            Intrinsics.checkNotNullParameter((Object)registryClass, (String)"registryClass");
            return new LintJarApiMigration(client).getMigratedJar(jar, registryClass);
        }

        public static /* synthetic */ File getMigratedJar$default(Companion companion, LintClient lintClient, File file, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            return companion.getMigratedJar(lintClient, file, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004JE\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$SwitchToInterfaceClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "chained", "<init>", "(Lcom/android/tools/lint/client/api/LintJarApiMigration;Lorg/objectweb/asm/ClassVisitor;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "access", "", "name", "", "descriptor", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "lint-api"})
    private final class SwitchToInterfaceClassVisitor
    extends ClassVisitor {
        public SwitchToInterfaceClassVisitor(ClassVisitor chained) {
            Intrinsics.checkNotNullParameter((Object)chained, (String)"chained");
            super(589824, chained);
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor2 = super.visitMethod(access, name, descriptor, signature, exceptions);
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor2, (String)"visitMethod(...)");
            return new SwitchToInterfaceMethodVisitor(methodVisitor2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/client/api/LintJarApiMigration$SwitchToInterfaceMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "chained", "<init>", "(Lcom/android/tools/lint/client/api/LintJarApiMigration;Lorg/objectweb/asm/MethodVisitor;)V", "visitMethodInsn", "", "opcode", "", "owner", "", "name", "descriptor", "isInterface", "", "lint-api"})
    private final class SwitchToInterfaceMethodVisitor
    extends MethodVisitor {
        public SwitchToInterfaceMethodVisitor(MethodVisitor chained) {
            Intrinsics.checkNotNullParameter((Object)chained, (String)"chained");
            super(589824, chained);
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if ((opcode == 184 || opcode == 182 || opcode == 185) && Companion.isRelevantType(owner)) {
                Class clz = LintJarApiMigration.this.findClass(owner);
                if (clz == null) {
                    LintJarApiMigration.this.client.log(Severity.WARNING, null, "WARNING: Missing analysis API method " + owner + "#" + name + descriptor, new Object[0]);
                } else {
                    int newOpCode = clz.isInterface() ? 185 : opcode;
                    String newApi = LintJarApiMigration.this.mapApi(owner, name, descriptor);
                    if (((CharSequence)newApi).length() > 0) {
                        super.visitMethodInsn(newOpCode, owner, newApi, descriptor, clz.isInterface());
                    }
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

