/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.AndroidXConstants;
import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxName;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ApiLevel;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.VersionChecksKt;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 >2\u00020\u0001:\u0003>?@B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ0\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u001c\b\u0002\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J6\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J@\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J6\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u0012H\u0002J\u0012\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0012\u0010%\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J$\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020$2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001d0\u000fH\u0002JB\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001d2\u001c\b\u0002\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\b\b\u0002\u0010,\u001a\u00020\u0014H\u0002J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010.\u001a\u00020/H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002JD\u00105\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u001c\b\u0002\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u001e\u00106\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u0002082\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001e\u00109\u001a\u0004\u0018\u00010\u000b2\u0006\u00107\u001a\u0002082\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001a\u0010:\u001a\u0004\u0018\u00010\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\"\u0010:\u001a\u0004\u0018\u00010\u000b2\u0006\u0010.\u001a\u00020\u00102\u0006\u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J@\u0010;\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010<\u001a\u0004\u0018\u00010\u00102\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J@\u0010=\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010<\u001a\u0004\u0018\u00010\u00102\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fj\u0004\u0018\u0001`\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/lint/detector/api/VersionChecks;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "project", "Lcom/android/tools/lint/detector/api/Project;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Lcom/android/tools/lint/client/api/JavaEvaluator;Lcom/android/tools/lint/detector/api/Project;)V", "getVersionCheckConditional", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "apiLevelLookup", "Lkotlin/Function1;", "Lorg/jetbrains/uast/UElement;", "Lcom/android/tools/lint/detector/api/ApiLevel;", "Lcom/android/tools/lint/detector/api/ApiLevelLookup;", "getSdkVersionLookup", "", "element", "getWithinVersionCheckConditional", "apiLookup", "depth", "getVersionConditional", "current", "prev", "isTrue", "", "isFalse", "getCumulativeCaseConstraint", "Lorg/jetbrains/uast/USwitchClauseExpression;", "includeCurrent", "uncertainAnd", "condition", "Lorg/jetbrains/uast/UExpression;", "uncertainOr", "uncertain", "expression", "constant", "getCaseConstraint", "entry", "casesAreApiLevels", "sdkId", "getReferenceApiLookup", "call", "Lorg/jetbrains/uast/UCallExpression;", "getLambdaInvocation", "parameter", "Lcom/intellij/psi/PsiParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "getVersionCheckConstraint", "getValidFromAnnotation", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "getValidFromInferredAnnotation", "getValidVersionCall", "getOredWithConstraint", "before", "getAndedWithConstraint", "Companion", "VersionCheckWithExitFinder", "SdkIntAnnotation", "lint-api"})
@SourceDebugExtension(value={"SMAP\nVersionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1860:1\n1755#2,3:1861\n1755#2,3:1865\n808#2,11:1868\n1#3:1864\n*S KotlinDebug\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks\n*L\n809#1:1861,3\n865#1:1865,3\n967#1:1868,11\n*E\n"})
public final class VersionChecks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    @NotNull
    private final JavaEvaluator evaluator;
    @Nullable
    private final Project project;
    private static final int MAX_CALL_DEPTH = 50;
    @JvmField
    @NotNull
    public static final Issue SDK_INT_VERSION_DATA;
    @NotNull
    public static final String SDK_INT = "SDK_INT";
    @NotNull
    public static final String SDK_INT_FULL = "SDK_INT_FULL";
    @NotNull
    private static final String CHECKS_SDK_INT_AT_LEAST_NAME = "ChecksSdkIntAtLeast";
    @NotNull
    public static final String CHECKS_SDK_INT_AT_LEAST_ANNOTATION = "androidx.annotation.ChecksSdkIntAtLeast";
    @NotNull
    private static final String PLATFORM_CHECKS_SDK_INT_AT_LEAST_ANNOTATION = "android.annotation.ChecksSdkIntAtLeast";
    @NotNull
    private static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    @NotNull
    private static final String ANDROIDX_SDK_SUPPRESS_ANNOTATION = "androidx.test.filters.SdkSuppress";
    @NotNull
    private static final String ROBO_ELECTRIC_CONFIG_ANNOTATION = "org.robolectric.annotation.Config";
    @JvmField
    public static final AndroidxName REQUIRES_API_ANNOTATION;
    @NotNull
    public static final String REQUIRES_EXTENSION_ANNOTATION = "androidx.annotation.RequiresExtension";
    @NotNull
    private static final String GET_BUILD_SDK_INT = "getBuildSdkInt";
    @NotNull
    private static final Pair<UAnnotation, ApiConstraint> NO_ANNOTATION_FOUND;
    @NotNull
    private static final String[] VERSION_METHOD_NAME_PREFIXES;
    @NotNull
    private static final String[] VERSION_METHOD_NAME_SUFFIXES;

    public VersionChecks(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        this.client = client;
        this.evaluator = evaluator;
        this.project = project;
    }

    private final ApiConstraint getVersionCheckConditional(UBinaryExpression binary, Function1<? super UElement, ApiLevel> apiLevelLookup) {
        return Companion.getVersionCheckConditional(binary, this.client, this.evaluator, this.project, apiLevelLookup);
    }

    static /* synthetic */ ApiConstraint getVersionCheckConditional$default(VersionChecks versionChecks, UBinaryExpression uBinaryExpression, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return versionChecks.getVersionCheckConditional(uBinaryExpression, (Function1<? super UElement, ApiLevel>)function1);
    }

    private final int getSdkVersionLookup(UElement element) {
        return VersionChecks.Companion.getSdkVersionLookup(element, this.client, this.evaluator, this.project);
    }

    private final ApiConstraint getWithinVersionCheckConditional(UElement element, Function1<? super UElement, ApiLevel> apiLookup, int depth) {
        UElement current = null;
        UElement prev = element;
        ApiConstraint constraint2 = null;
        for (current = element.getUastParent(); current != null; current = current.getUastParent()) {
            if (current instanceof UMethod || current instanceof UField) {
                if (!(current.getUastParent() instanceof UAnonymousClass)) {
                    break;
                }
            } else {
                if (current instanceof UFile) break;
                ApiConstraint currentConstraint = this.getVersionConditional(current, prev, apiLookup, depth);
                constraint2 = ApiConstraint.Companion.maxNullable(currentConstraint, constraint2, false);
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)current.getUastParent());
                if (parent instanceof USwitchClauseExpression) {
                    boolean bl;
                    boolean ored;
                    block8: {
                        ored = current instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)current).getOperator(), (Object)UastBinaryOperator.LOGICAL_OR) && prev != UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)CollectionsKt.first((List)((UPolyadicExpression)current).getOperands())));
                        Iterable $this$any$iv = ((USwitchClauseExpression)parent).getCaseValues();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                UExpression it = (UExpression)element$iv;
                                boolean bl2 = false;
                                if (!(it == current)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    boolean fromCondition = bl;
                    constraint2 = ApiConstraint.Companion.maxNullable$default(ApiConstraint.Companion, constraint2, this.getCumulativeCaseConstraint((USwitchClauseExpression)parent, !ored && !fromCondition, apiLookup), false, 4, null);
                    UElement uElement = current.getUastParent();
                    if (uElement == null) break;
                    current = uElement;
                }
            }
            prev = current;
        }
        return constraint2;
    }

    private final ApiConstraint getVersionConditional(UElement current, UElement prev, Function1<? super UElement, ApiLevel> apiLookup, int depth) {
        if (current instanceof UPolyadicExpression) {
            return ((UPolyadicExpression)current).getOperator() == UastBinaryOperator.LOGICAL_AND ? this.getAndedWithConstraint(current, prev, apiLookup, depth) : (((UPolyadicExpression)current).getOperator() == UastBinaryOperator.LOGICAL_OR ? this.getOredWithConstraint(current, prev, apiLookup, depth) : null);
        }
        if (current instanceof UIfExpression) {
            ApiConstraint apiConstraint;
            UExpression condition = ((UIfExpression)current).getCondition();
            if (prev != condition) {
                ApiConstraint thenConstraint;
                boolean fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)current).getThenExpression());
                if (fromThen && this.uncertainOr(condition)) {
                    return null;
                }
                if (!fromThen && this.uncertainAnd(condition)) {
                    return null;
                }
                ApiConstraint apiConstraint2 = thenConstraint = this.getVersionCheckConstraint((UElement)condition, prev, apiLookup, depth);
                if (apiConstraint2 != null) {
                    ApiConstraint it = apiConstraint2;
                    boolean bl = false;
                    apiConstraint = fromThen ? it : it.not();
                } else {
                    apiConstraint = null;
                }
            } else {
                apiConstraint = null;
            }
            return apiConstraint;
        }
        if (current instanceof USwitchClauseExpressionWithBody) {
            boolean bl;
            block22: {
                Iterable $this$any$iv = ((USwitchClauseExpressionWithBody)current).getCaseValues();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UExpression it = (UExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it == prev)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            boolean includeCurrent = !bl;
            return this.getCumulativeCaseConstraint((USwitchClauseExpression)current, includeCurrent, apiLookup);
        }
        if (current instanceof UCallExpression) {
            UExpression uExpression = prev instanceof UExpression ? (UExpression)prev : null;
            if ((uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null) instanceof ULambdaExpression) {
                PsiMethod method = ((UCallExpression)current).resolve();
                if (method != null) {
                    ApiConstraint constraint2;
                    UCallExpression lambdaInvocation;
                    ApiLevel value;
                    SdkIntAnnotation annotation = SdkIntAnnotation.Companion.get((PsiModifierListOwner)method);
                    if (annotation != null && (value = annotation.getApiLevel-8e34biw(this.evaluator, (PsiModifierListOwner)method, (UCallExpression)current)) != null) {
                        return ApiLevel.atLeast-impl(value.unbox-impl(), annotation.getSdkId());
                    }
                    Map<UExpression, PsiParameter> mapping = this.evaluator.computeArgumentMapping((UCallExpression)current, method);
                    PsiParameter parameter = mapping.get(prev);
                    if (parameter != null && (lambdaInvocation = this.getLambdaInvocation(parameter, method)) != null && (constraint2 = this.getWithinVersionCheckConditional((UElement)lambdaInvocation, this.getReferenceApiLookup((UCallExpression)current), depth + 1)) != null) {
                        return constraint2;
                    }
                }
                return null;
            }
        }
        if (current instanceof UCallExpression) {
            UExpression uExpression = prev instanceof UExpression ? (UExpression)prev : null;
            if ((uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null) instanceof UObjectLiteralExpression) {
                PsiMethod method = ((UCallExpression)current).resolve();
                if (method != null) {
                    ApiConstraint constraint3;
                    UCallExpression lambdaInvocation;
                    ApiLevel value;
                    SdkIntAnnotation annotation = SdkIntAnnotation.Companion.get((PsiModifierListOwner)method);
                    if (annotation != null && (value = annotation.getApiLevel-8e34biw(this.evaluator, (PsiModifierListOwner)method, (UCallExpression)current)) != null) {
                        return ApiLevel.atLeast-impl(value.unbox-impl(), annotation.getSdkId());
                    }
                    Map<UExpression, PsiParameter> mapping = this.evaluator.computeArgumentMapping((UCallExpression)current, method);
                    PsiParameter parameter = mapping.get(prev);
                    if (parameter != null && (lambdaInvocation = this.getLambdaInvocation(parameter, method)) != null && (constraint3 = this.getWithinVersionCheckConditional((UElement)lambdaInvocation, this.getReferenceApiLookup((UCallExpression)current), depth + 1)) != null) {
                        return constraint3;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private final boolean isTrue(UElement element) {
        Object object = ConstantEvaluator.evaluate(null, element);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private final boolean isFalse(UElement element) {
        Object object = ConstantEvaluator.evaluate(null, element);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        if (bl != null) {
        } else {
            return false;
        }
        return !bl.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    private final ApiConstraint getCumulativeCaseConstraint(USwitchClauseExpression current, boolean includeCurrent, Function1<? super UElement, ApiLevel> apiLookup) {
        UExpression switchExpression;
        List list;
        USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType((UElement)((UElement)current), USwitchExpression.class, (boolean)true);
        Object object = uSwitchExpression;
        if (object != null && (object = object.getBody()) != null && (object = object.getExpressions()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)object;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof USwitchClauseExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List entries = list;
        USwitchExpression uSwitchExpression2 = uSwitchExpression;
        UExpression uExpression = switchExpression = uSwitchExpression2 != null ? uSwitchExpression2.getExpression() : null;
        int sdkId = uExpression != null ? this.getSdkVersionLookup((UElement)uExpression) : -1;
        boolean casesAreApiLevels = sdkId != -1;
        ApiConstraint currentConstraint = null;
        for (USwitchClauseExpression entry : entries) {
            ApiConstraint caseConstraint = this.getCaseConstraint(entry, casesAreApiLevels, apiLookup, sdkId);
            if (entry == current) {
                if (!includeCurrent) {
                    return currentConstraint;
                }
                if (this.uncertainOr((UExpression)CollectionsKt.firstOrNull((List)entry.getCaseValues()))) {
                    return currentConstraint;
                }
                ApiConstraint apiConstraint = ApiConstraint.Companion.maxNullable$default(ApiConstraint.Companion, caseConstraint, currentConstraint, false, 4, null);
                if (apiConstraint == null) break;
                return apiConstraint;
            }
            if (caseConstraint == null || this.uncertainAnd((UExpression)CollectionsKt.firstOrNull((List)entry.getCaseValues()))) continue;
            ApiConstraint reverse = caseConstraint.not();
            currentConstraint = ApiConstraint.Companion.max(reverse, currentConstraint, false);
        }
        return null;
    }

    private final boolean uncertainAnd(UExpression condition) {
        UExpression uExpression = condition;
        UExpression uExpression2 = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        UPolyadicExpression uPolyadicExpression = uExpression2 instanceof UPolyadicExpression ? (UPolyadicExpression)uExpression2 : null;
        if (uPolyadicExpression == null) {
            return false;
        }
        UPolyadicExpression expression = uPolyadicExpression;
        return Intrinsics.areEqual((Object)expression.getOperator(), (Object)UastBinaryOperator.LOGICAL_AND) && this.uncertain((UExpression)expression, (Function1<? super UElement, Boolean>)((Function1)new Function1<UElement, Boolean>((Object)this){

            public final Boolean invoke(UElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return VersionChecks.access$isTrue((VersionChecks)this.receiver, p0);
            }
        }));
    }

    private final boolean uncertainOr(UExpression condition) {
        UExpression uExpression = condition;
        UExpression uExpression2 = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        UPolyadicExpression uPolyadicExpression = uExpression2 instanceof UPolyadicExpression ? (UPolyadicExpression)uExpression2 : null;
        if (uPolyadicExpression == null) {
            return false;
        }
        UPolyadicExpression expression = uPolyadicExpression;
        return Intrinsics.areEqual((Object)expression.getOperator(), (Object)UastBinaryOperator.LOGICAL_OR) && this.uncertain((UExpression)expression, (Function1<? super UElement, Boolean>)((Function1)new Function1<UElement, Boolean>((Object)this){

            public final Boolean invoke(UElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return VersionChecks.access$isFalse((VersionChecks)this.receiver, p0);
            }
        }));
    }

    private final boolean uncertain(UExpression expression, Function1<? super UElement, Boolean> constant) {
        if (!(expression instanceof UBinaryExpression)) {
            return true;
        }
        UExpression left = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)expression).getLeftOperand());
        if (!((Boolean)constant.invoke((Object)left)).booleanValue() && VersionChecks.getVersionCheckConstraint$default(this, (UElement)left, null, null, 0, 6, null) == null) {
            return true;
        }
        UExpression right = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)expression).getRightOperand());
        return (Boolean)constant.invoke((Object)right) == false && VersionChecks.getVersionCheckConstraint$default(this, (UElement)right, null, null, 0, 6, null) == null;
    }

    private final ApiConstraint getCaseConstraint(USwitchClauseExpression entry, boolean casesAreApiLevels, Function1<? super UElement, ApiLevel> apiLevelLookup, int sdkId) {
        List caseValues = entry.getCaseValues();
        if (caseValues.isEmpty()) {
            return null;
        }
        if (!casesAreApiLevels) {
            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)CollectionsKt.first((List)caseValues)));
            return VersionChecks.getVersionCheckConstraint$default(this, (UElement)uExpression, null, apiLevelLookup, 0, 2, null);
        }
        ApiConstraint constraint2 = null;
        for (UExpression uExpression : caseValues) {
            ApiConstraint caseConstraint;
            ApiConstraint apiConstraint;
            UExpression expression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
            if (expression instanceof UBinaryExpression && Intrinsics.areEqual((Object)((UBinaryExpression)expression).getOperator().getText(), (Object)"in")) {
                UBinaryExpression range;
                UExpression uExpression2 = (UExpression)CollectionsKt.lastOrNull((List)((UBinaryExpression)expression).getOperands());
                UExpression uExpression3 = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
                UBinaryExpression uBinaryExpression = range = uExpression3 instanceof UBinaryExpression ? (UBinaryExpression)uExpression3 : null;
                apiConstraint = range != null ? com.android.tools.lint.detector.api.VersionChecks$Companion.getSdkIntConstraintFromExpression$default(Companion, range, null, sdkId, 2, null) : null;
            } else {
                int level = VersionChecks.Companion.getApiLevel-zulsYdA(expression, (Function1<? super UElement, ApiLevel>)apiLevelLookup);
                apiConstraint = ApiLevel.isValid-impl(level) ? ApiConstraint.Companion.exactly-kG1hquA$default(ApiConstraint.Companion, level, 0, 2, null) : null;
            }
            if ((caseConstraint = apiConstraint) == null) continue;
            if (constraint2 != null) {
                constraint2 = caseConstraint.or(constraint2);
                continue;
            }
            constraint2 = caseConstraint;
        }
        return constraint2;
    }

    static /* synthetic */ ApiConstraint getCaseConstraint$default(VersionChecks versionChecks, USwitchClauseExpression uSwitchClauseExpression, boolean bl, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return versionChecks.getCaseConstraint(uSwitchClauseExpression, bl, (Function1<? super UElement, ApiLevel>)function1, n);
    }

    private final Function1<UElement, ApiLevel> getReferenceApiLookup(UCallExpression call) {
        return (Function1)new Function1<UElement, ApiLevel>(call, this){
            final /* synthetic */ UCallExpression $call;
            final /* synthetic */ VersionChecks this$0;
            {
                this.$call = $call;
                this.this$0 = $receiver;
                super(1);
            }

            public final int invoke-DTtIgKc(UElement reference) {
                PsiParameterList parameterList;
                PsiElement resolved;
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                int apiLevel = 0;
                apiLevel = ApiLevel.Companion.getNONE-wqyE5NY();
                if (reference instanceof UReferenceExpression && (resolved = ((UReferenceExpression)reference).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null) {
                    PsiMethod psiMethod = this.$call.resolve();
                    if (psiMethod != null) {
                        PsiMethod psiMethod2 = psiMethod;
                        VersionChecks versionChecks = this.this$0;
                        UCallExpression uCallExpression = this.$call;
                        PsiMethod method = psiMethod2;
                        boolean bl = false;
                        Map<UExpression, PsiParameter> mapping = VersionChecks.access$getEvaluator$p(versionChecks).computeArgumentMapping(uCallExpression, method);
                        for (Map.Entry<UExpression, PsiParameter> entry : mapping.entrySet()) {
                            UExpression argument = entry.getKey();
                            PsiParameter parameter = entry.getValue();
                            if (!Intrinsics.areEqual((Object)parameter, (Object)resolved)) continue;
                            apiLevel = com.android.tools.lint.detector.api.VersionChecks$Companion.access$getApiLevel-zulsYdA(VersionChecks.Companion, argument, null);
                            break;
                        }
                    } else {
                        VersionChecks versionChecks = this.this$0;
                        UCallExpression uCallExpression = this.$call;
                        VersionChecks $this$invoke_DTtIgKc_u24lambda_u241 = versionChecks;
                        boolean bl = false;
                        int index = parameterList.getParameterIndex((PsiParameter)resolved);
                        List arguments = uCallExpression.getValueArguments();
                        if (index != -1 && index < arguments.size()) {
                            apiLevel = com.android.tools.lint.detector.api.VersionChecks$Companion.access$getApiLevel-zulsYdA(VersionChecks.Companion, (UExpression)arguments.get(index), null);
                        }
                    }
                }
                return apiLevel;
            }
        };
    }

    private final UCallExpression getLambdaInvocation(PsiParameter parameter, PsiMethod method) {
        if (method instanceof PsiCompiledElement) {
            return null;
        }
        UMethod uMethod = (UMethod)UastFacade.INSTANCE.convertElementWithParent((PsiElement)method, UMethod.class);
        if (uMethod == null) {
            return null;
        }
        UMethod uMethod2 = uMethod;
        Ref match = new Ref();
        String string = parameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String parameterName = string;
        uMethod2.accept((UastVisitor)new AbstractUastVisitor(parameterName, (Ref<UCallExpression>)match){
            final /* synthetic */ String $parameterName;
            final /* synthetic */ Ref<UCallExpression> $match;
            {
                this.$parameterName = $parameterName;
                this.$match = $match;
            }

            public boolean visitCallExpression(UCallExpression node) {
                String callName;
                String name;
                UExpression receiver;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UExpression uExpression = node.getReceiver();
                Object object = receiver = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                if (receiver instanceof USimpleNameReferenceExpression) {
                    name = ((USimpleNameReferenceExpression)receiver).getIdentifier();
                    if (Intrinsics.areEqual((Object)name, (Object)this.$parameterName)) {
                        this.$match.set((Object)node);
                    }
                } else if (receiver instanceof UReferenceExpression && Intrinsics.areEqual((Object)(name = ((UReferenceExpression)receiver).getResolvedName()), (Object)this.$parameterName)) {
                    this.$match.set((Object)node);
                }
                if (Intrinsics.areEqual((Object)(callName = Lint.getMethodName(node)), (Object)this.$parameterName)) {
                    this.$match.set((Object)node);
                }
                return super.visitCallExpression(node);
            }
        });
        return (UCallExpression)match.get();
    }

    private final ApiConstraint getVersionCheckConstraint(UElement element, UElement prev, Function1<? super UElement, ApiLevel> apiLookup, int depth) {
        if (depth >= 50) {
            return null;
        }
        if (element instanceof UPolyadicExpression) {
            ApiConstraint constraint2;
            ApiConstraint apiConstraint;
            if (element instanceof UBinaryExpression && (apiConstraint = this.getVersionCheckConditional((UBinaryExpression)element, apiLookup)) != null) {
                ApiConstraint it = apiConstraint;
                boolean bl = false;
                return it;
            }
            UastBinaryOperator tokenType = ((UPolyadicExpression)element).getOperator();
            if (tokenType == UastBinaryOperator.LOGICAL_AND) {
                ApiConstraint constraint3 = this.getAndedWithConstraint(element, prev, apiLookup, depth);
                if (constraint3 != null) {
                    return constraint3;
                }
            } else if (tokenType == UastBinaryOperator.LOGICAL_OR && (constraint2 = this.getOredWithConstraint(element, prev, apiLookup, depth)) != null) {
                return constraint2.not();
            }
        } else {
            if (element instanceof UCallExpression) {
                return this.getValidVersionCall((UCallExpression)element, depth + 1);
            }
            if (element instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof PsiField) {
                    PsiElement field = resolved;
                    ApiConstraint validFromAnnotation = VersionChecks.getValidFromAnnotation$default(this, (PsiModifierListOwner)field, null, 2, null);
                    if (validFromAnnotation != null) {
                        return validFromAnnotation;
                    }
                    ApiConstraint validFromInferredAnnotation = VersionChecks.getValidFromInferredAnnotation$default(this, (PsiModifierListOwner)field, null, 2, null);
                    if (validFromInferredAnnotation != null) {
                        return validFromInferredAnnotation;
                    }
                    PsiModifierList modifierList = ((PsiField)field).getModifierList();
                    if (modifierList != null && modifierList.hasExplicitModifier("final")) {
                        ApiConstraint constraint4;
                        UExpression initializer;
                        UExpression uExpression = UastFacade.INSTANCE.getInitializerBody((PsiVariable)field);
                        Object object = initializer = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                        if (initializer != null && (constraint4 = VersionChecks.getVersionCheckConstraint$default(this, (UElement)initializer, null, null, depth + 1, 6, null)) != null) {
                            return constraint4;
                        }
                    }
                } else if (resolved instanceof PsiParameter) {
                    ApiConstraint validFromAnnotation = VersionChecks.getValidFromAnnotation$default(this, (PsiModifierListOwner)resolved, null, 2, null);
                    if (validFromAnnotation != null) {
                        return validFromAnnotation;
                    }
                    PsiElement paramList = ((PsiParameter)resolved).getParent();
                    PsiElement containingMethod = paramList.getParent();
                    if (containingMethod instanceof PsiMethod && ((PsiMethod)containingMethod).isConstructor()) {
                        ApiConstraint validFromAnnotationOnField;
                        PsiField constructorProperty;
                        PsiClass psiClass = ((PsiMethod)containingMethod).getContainingClass();
                        PsiField psiField = constructorProperty = psiClass != null ? psiClass.findFieldByName(((PsiParameter)resolved).getName(), false) : null;
                        if (constructorProperty != null && (validFromAnnotationOnField = VersionChecks.getValidFromAnnotation$default(this, (PsiModifierListOwner)constructorProperty, null, 2, null)) != null) {
                            return validFromAnnotationOnField;
                        }
                    }
                } else if (resolved instanceof PsiLocalVariable) {
                    ApiConstraint constraint5;
                    UExpression initializer;
                    UExpression uExpression = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved);
                    Object object = initializer = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                    if (initializer != null && (constraint5 = VersionChecks.getVersionCheckConstraint$default(this, (UElement)initializer, null, null, depth + 1, 6, null)) != null) {
                        return constraint5;
                    }
                } else {
                    UExpression selector;
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
                        UExpression uExpression = ((UQualifiedReferenceExpression)element).getSelector();
                        Intrinsics.checkNotNull((Object)uExpression, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                        UCallExpression call = (UCallExpression)uExpression;
                        return this.getValidVersionCall(call, depth + 1);
                    }
                    if (resolved instanceof PsiMethod) {
                        UField field;
                        PsiElement constructorProperty = LightClassUtilsKt.getUnwrapped((PsiElement)resolved);
                        KtProperty ktProperty = constructorProperty instanceof KtProperty ? (KtProperty)constructorProperty : null;
                        UElement constraint5 = ktProperty != null ? UastContextKt.toUElement((PsiElement)((PsiElement)ktProperty)) : null;
                        UField uField = field = constraint5 instanceof UField ? (UField)constraint5 : null;
                        if (field != null && field.isFinal()) {
                            ApiConstraint apiConstraint;
                            UExpression uExpression;
                            PsiModifierListOwner javaPsi;
                            PsiElement containingMethod = field.getJavaPsi();
                            PsiModifierListOwner psiModifierListOwner = javaPsi = containingMethod instanceof PsiModifierListOwner ? (PsiModifierListOwner)containingMethod : null;
                            if (javaPsi != null) {
                                ApiConstraint validFromAnnotation = VersionChecks.getValidFromAnnotation$default(this, javaPsi, null, 2, null);
                                if (validFromAnnotation != null) {
                                    return validFromAnnotation;
                                }
                                ApiConstraint validFromInferredAnnotation = VersionChecks.getValidFromInferredAnnotation$default(this, javaPsi, null, 2, null);
                                if (validFromInferredAnnotation != null) {
                                    return validFromInferredAnnotation;
                                }
                            }
                            if ((uExpression = field.getUastInitializer()) != null && (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) != null) {
                                UExpression it = uExpression;
                                boolean bl = false;
                                apiConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)it, null, null, depth + 1, 6, null);
                            } else {
                                apiConstraint = null;
                            }
                            return apiConstraint;
                        }
                        return this.getValidVersionCall(element, (PsiMethod)resolved, depth + 1);
                    }
                    if (resolved == null && element instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression) {
                        return this.getValidVersionCall((UCallExpression)selector, depth + 1);
                    }
                }
            } else if (element instanceof UUnaryExpression) {
                UExpression operand;
                ApiConstraint apiConstraint;
                if (((UUnaryExpression)element).getOperator() == UastPrefixOperator.LOGICAL_NOT && (apiConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)(operand = ((UUnaryExpression)element).getOperand()), null, null, depth, 6, null)) != null) {
                    ApiConstraint it = apiConstraint;
                    boolean bl = false;
                    if (!it.negatable()) {
                        return null;
                    }
                    return it.not();
                }
            } else if (element instanceof UParenthesizedExpression) {
                return this.getVersionCheckConstraint((UElement)((UParenthesizedExpression)element).getExpression(), element, apiLookup, depth);
            }
        }
        return null;
    }

    static /* synthetic */ ApiConstraint getVersionCheckConstraint$default(VersionChecks versionChecks, UElement uElement, UElement uElement2, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            uElement2 = null;
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        return versionChecks.getVersionCheckConstraint(uElement, uElement2, (Function1<? super UElement, ApiLevel>)function1, n);
    }

    private final ApiConstraint getValidFromAnnotation(PsiModifierListOwner owner, UCallExpression call) {
        SdkIntAnnotation sdkIntAnnotation = SdkIntAnnotation.Companion.get(owner);
        if (sdkIntAnnotation == null) {
            return null;
        }
        SdkIntAnnotation sdkIntAnnotation2 = sdkIntAnnotation;
        ApiLevel apiLevel = sdkIntAnnotation2.getApiLevel-8e34biw(this.evaluator, owner, call);
        return apiLevel != null ? ApiLevel.atLeast-impl(apiLevel.unbox-impl(), sdkIntAnnotation2.getSdkId()) : null;
    }

    static /* synthetic */ ApiConstraint getValidFromAnnotation$default(VersionChecks versionChecks, PsiModifierListOwner psiModifierListOwner, UCallExpression uCallExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uCallExpression = null;
        }
        return versionChecks.getValidFromAnnotation(psiModifierListOwner, uCallExpression);
    }

    private final ApiConstraint getValidFromInferredAnnotation(PsiModifierListOwner owner, UCallExpression call) {
        SdkIntAnnotation sdkIntAnnotation = VersionChecks.Companion.findChecksSdkInferredAnnotation(owner, this.client, this.evaluator, this.project);
        if (sdkIntAnnotation == null) {
            return null;
        }
        SdkIntAnnotation annotation = sdkIntAnnotation;
        ApiLevel apiLevel = annotation.getApiLevel-8e34biw(this.evaluator, owner, call);
        return apiLevel != null ? ApiLevel.atLeast-impl(apiLevel.unbox-impl(), annotation.getSdkId()) : null;
    }

    static /* synthetic */ ApiConstraint getValidFromInferredAnnotation$default(VersionChecks versionChecks, PsiModifierListOwner psiModifierListOwner, UCallExpression uCallExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uCallExpression = null;
        }
        return versionChecks.getValidFromInferredAnnotation(psiModifierListOwner, uCallExpression);
    }

    private final ApiConstraint getValidVersionCall(UCallExpression call, int depth) {
        PsiMethod method = call.resolve();
        if (method == null) {
            String name;
            int version;
            UIdentifier identifier = call.getMethodIdentifier();
            if (identifier != null && (version = Companion.getMinSdkVersionFromMethodName(name = identifier.getName())) != -1) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, version, 0, 2, null);
            }
            return null;
        }
        return this.getValidVersionCall((UElement)call, method, depth);
    }

    private final ApiConstraint getValidVersionCall(UElement call, PsiMethod method, int depth) {
        int version;
        PsiClass containingClass;
        UCallExpression callExpression = call instanceof UCallExpression ? (UCallExpression)call : null;
        ApiConstraint validFromAnnotation = this.getValidFromAnnotation((PsiModifierListOwner)method, callExpression);
        if (validFromAnnotation != null) {
            return validFromAnnotation;
        }
        ApiConstraint validFromInferredAnnotation = this.getValidFromInferredAnnotation((PsiModifierListOwner)method, callExpression);
        if (validFromInferredAnnotation != null) {
            return validFromInferredAnnotation;
        }
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"isAtLeast", (boolean)false, (int)2, null) && (containingClass = method.getContainingClass()) != null && Intrinsics.areEqual((Object)"BuildCompat", (Object)containingClass.getName())) {
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastN")) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, 24, 0, 2, null);
            }
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastNMR1")) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, 25, 0, 2, null);
            }
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastO")) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, 26, 0, 2, null);
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeastP", (boolean)false, (int)2, null)) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, 28, 0, 2, null);
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeastQ", (boolean)false, (int)2, null)) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, 29, 0, 2, null);
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeast", (boolean)false, (int)2, null) && name.length() == 10 && Character.isUpperCase(name.charAt(9)) && Intrinsics.compare((int)name.charAt(9), (int)81) > 0) {
                return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, 36, 0, 2, null);
            }
        }
        if ((version = Companion.getMinSdkVersionFromMethodName(name)) != -1) {
            return ApiConstraint.Companion.atLeast$default(ApiConstraint.Companion, version, 0, 2, null);
        }
        if (!method.hasModifierProperty("abstract")) {
            List expressions;
            UExpression uExpression = UastFacade.INSTANCE.getMethodBody(method);
            if (uExpression == null) {
                return null;
            }
            UExpression body = uExpression;
            List list = expressions = body instanceof UBlockExpression ? ((UBlockExpression)body).getExpressions() : CollectionsKt.listOf((Object)body);
            if (expressions.size() == 1) {
                ApiConstraint constraint2;
                List arguments;
                Object object;
                UExpression statement = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(0)));
                if (statement instanceof UReturnExpression) {
                    UExpression uExpression2 = ((UReturnExpression)statement).getReturnExpression();
                    object = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
                } else {
                    object = statement;
                }
                if (object == null) {
                    return null;
                }
                UExpression returnValue = object;
                List list2 = arguments = call instanceof UCallExpression ? ((UCallExpression)call).getValueArguments() : CollectionsKt.emptyList();
                if (arguments.isEmpty()) {
                    ApiConstraint constraint3;
                    if ((returnValue instanceof UPolyadicExpression || returnValue instanceof UCallExpression || returnValue instanceof UQualifiedReferenceExpression) && (constraint3 = VersionChecks.getVersionCheckConstraint$default(this, (UElement)returnValue, null, null, depth + 1, 6, null)) != null) {
                        return constraint3;
                    }
                } else if (arguments.size() == 1 && (constraint2 = VersionChecks.getVersionCheckConstraint$default(this, (UElement)returnValue, null, (Function1)new Function1<UElement, ApiLevel>((List<? extends UExpression>)arguments){
                    final /* synthetic */ List<UExpression> $arguments;
                    {
                        this.$arguments = $arguments;
                        super(1);
                    }

                    public final int invoke-DTtIgKc(UElement reference) {
                        int index;
                        PsiParameterList parameterList;
                        PsiElement resolved;
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        int apiLevel = ApiLevel.Companion.getNONE-wqyE5NY();
                        if (reference instanceof UReferenceExpression && (resolved = ((UReferenceExpression)reference).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null && (index = parameterList.getParameterIndex((PsiParameter)resolved)) != -1 && index < this.$arguments.size()) {
                            apiLevel = com.android.tools.lint.detector.api.VersionChecks$Companion.access$getApiLevel-zulsYdA(VersionChecks.Companion, this.$arguments.get(index), null);
                        }
                        return apiLevel;
                    }
                }, depth + 1, 2, null)) != null) {
                    return constraint2;
                }
            }
        }
        return null;
    }

    private final ApiConstraint getOredWithConstraint(UElement element, UElement before, Function1<? super UElement, ApiLevel> apiLookup, int depth) {
        if (element instanceof UBinaryExpression) {
            Object left;
            if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                ApiConstraint apiConstraint;
                ApiConstraint leftConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)left, null, apiLookup, depth, 2, null);
                UExpression right = ((UBinaryExpression)element).getRightOperand();
                if (right != before) {
                    ApiConstraint rightConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)right, null, apiLookup, depth, 2, null);
                    ApiConstraint apiConstraint2 = leftConstraint;
                    ApiConstraint apiConstraint3 = rightConstraint;
                    apiConstraint = ApiConstraint.Companion.maxNullable(apiConstraint2 != null ? apiConstraint2.not() : null, apiConstraint3 != null ? apiConstraint3.not() : null, false);
                } else {
                    ApiConstraint apiConstraint4 = leftConstraint;
                    apiConstraint = apiConstraint4 != null ? apiConstraint4.not() : null;
                }
                return apiConstraint;
            }
            left = VersionChecks.getVersionCheckConditional$default(this, (UBinaryExpression)element, null, 2, null);
            if (left != null) {
                Object it = left;
                boolean bl = false;
                return ((ApiConstraint)it).not();
            }
        } else {
            if (element instanceof UPolyadicExpression) {
                if (((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR) {
                    UExpression operand;
                    ApiConstraint constraint2 = null;
                    Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
                    while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                        ApiConstraint apiConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)operand, null, apiLookup, depth, 2, null);
                        constraint2 = ApiConstraint.Companion.maxNullable(constraint2, apiConstraint != null ? apiConstraint.not() : null, false);
                    }
                    return constraint2;
                }
                return null;
            }
            if (element instanceof UParenthesizedExpression) {
                return this.getOredWithConstraint((UElement)((UParenthesizedExpression)element).getExpression(), element, apiLookup, depth);
            }
        }
        return null;
    }

    private final ApiConstraint getAndedWithConstraint(UElement element, UElement before, Function1<? super UElement, ApiLevel> apiLookup, int depth) {
        if (element instanceof UBinaryExpression) {
            Object left;
            if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                ApiConstraint leftConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)left, null, apiLookup, depth, 2, null);
                UExpression right = ((UBinaryExpression)element).getRightOperand();
                if (right != before) {
                    ApiConstraint rightConstraint = VersionChecks.getVersionCheckConstraint$default(this, (UElement)right, null, apiLookup, depth, 2, null);
                    ApiConstraint max = ApiConstraint.Companion.maxNullable$default(ApiConstraint.Companion, leftConstraint, rightConstraint, false, 4, null);
                    if (max != null && (leftConstraint == null || rightConstraint == null)) {
                        return max.asNonNegatable();
                    }
                    return max;
                }
                ApiConstraint apiConstraint = leftConstraint;
                return apiConstraint != null ? apiConstraint.asNonNegatable() : null;
            }
            left = VersionChecks.getVersionCheckConditional$default(this, (UBinaryExpression)element, null, 2, null);
            if (left != null) {
                Object it = left;
                boolean bl = false;
                return ((ApiConstraint)it).asNonNegatable();
            }
        } else if (element instanceof UPolyadicExpression) {
            if (((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND) {
                UExpression operand;
                ApiConstraint constraint2 = null;
                Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
                while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                    constraint2 = ApiConstraint.Companion.maxNullable$default(ApiConstraint.Companion, constraint2, VersionChecks.getVersionCheckConstraint$default(this, (UElement)operand, null, apiLookup, depth, 2, null), false, 4, null);
                }
                ApiConstraint apiConstraint = constraint2;
                return apiConstraint != null ? apiConstraint.asNonNegatable() : null;
            }
        } else if (element instanceof UParenthesizedExpression) {
            return this.getAndedWithConstraint((UElement)((UParenthesizedExpression)element).getExpression(), element, apiLookup, depth);
        }
        return null;
    }

    @Deprecated(message="Use SdkVersion instead")
    @JvmStatic
    public static final int codeNameToApi(@NotNull String text) {
        return Companion.codeNameToApi(text);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<UAnnotation, ApiConstraint> getTargetApiAnnotation(@NotNull JavaEvaluator evaluator, @Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApiAnnotation(evaluator, scope, isApiLevelAnnotation);
    }

    @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(context, element, ApiConstraint.get(api), lowerBound)", imports={}))
    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api, boolean lowerBound) {
        return Companion.isWithinVersionCheckConditional(context2, element, api, lowerBound);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, @NotNull ApiConstraint api, boolean lowerBound) {
        return Companion.isWithinVersionCheckConditional(context2, element, api, lowerBound);
    }

    @JvmStatic
    @Nullable
    public static final ApiConstraint getOuterVersionCheckConstraint(@NotNull JavaContext context2, @NotNull UElement element) {
        return Companion.getOuterVersionCheckConstraint(context2, element);
    }

    @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(client, evaluator, element, ApiConstraint.get(api), lowerBound)", imports={}))
    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean lowerBound) {
        return Companion.isWithinVersionCheckConditional(client, evaluator, element, api, lowerBound);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, @NotNull ApiConstraint api, boolean lowerBound) {
        return Companion.isWithinVersionCheckConditional(client, evaluator, element, api, lowerBound);
    }

    @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isPrecededByVersionCheckExit(context, element, ApiConstraint.get(api))", imports={}))
    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull JavaContext context2, @NotNull UElement element, int api) {
        return Companion.isPrecededByVersionCheckExit(context2, element, api);
    }

    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull JavaContext context2, @NotNull UElement element, @NotNull ApiConstraint api) {
        return Companion.isPrecededByVersionCheckExit(context2, element, api);
    }

    @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isPrecededByVersionCheckExit(client, evaluator, element, ApiConstraint.get(api), project)", imports={}))
    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, @Nullable Project project) {
        return Companion.isPrecededByVersionCheckExit(client, evaluator, element, api, project);
    }

    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, @NotNull ApiConstraint api, @Nullable Project project) {
        return Companion.isPrecededByVersionCheckExit(client, evaluator, element, api, project);
    }

    @JvmStatic
    @Nullable
    public static final ApiConstraint getVersionCheckConditional(@NotNull UBinaryExpression binary, @NotNull LintClient client, @NotNull JavaEvaluator evaluator, @Nullable Project project, @Nullable Function1<? super UElement, ApiLevel> apiLevelLookup) {
        return Companion.getVersionCheckConditional(binary, client, evaluator, project, apiLevelLookup);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<UAnnotation, ApiConstraint> getTargetApiAnnotation(@NotNull JavaEvaluator evaluator, @Nullable UElement scope) {
        return Companion.getTargetApiAnnotation(evaluator, scope);
    }

    @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(context, element, ApiConstraint.get(api), lowerBound)", imports={}))
    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api) {
        return Companion.isWithinVersionCheckConditional(context2, element, api);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, @NotNull ApiConstraint api) {
        return Companion.isWithinVersionCheckConditional(context2, element, api);
    }

    @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(client, evaluator, element, ApiConstraint.get(api), lowerBound)", imports={}))
    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api) {
        return Companion.isWithinVersionCheckConditional(client, evaluator, element, api);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, @NotNull ApiConstraint api) {
        return Companion.isWithinVersionCheckConditional(client, evaluator, element, api);
    }

    public static final /* synthetic */ boolean access$isTrue(VersionChecks $this, UElement element) {
        return $this.isTrue(element);
    }

    public static final /* synthetic */ boolean access$isFalse(VersionChecks $this, UElement element) {
        return $this.isFalse(element);
    }

    public static final /* synthetic */ JavaEvaluator access$getEvaluator$p(VersionChecks $this) {
        return $this.evaluator;
    }

    static {
        String[] stringArray = Issue.Companion;
        Category category = Category.LINT;
        Severity severity = Severity.INFORMATIONAL;
        Implementation implementation = new Implementation(Companion.FakeDetector.class, Scope.EMPTY);
        SDK_INT_VERSION_DATA = Issue.Companion.create$default((Issue.Companion)stringArray, "_ChecksSdkIntAtLeast", "Version Storage", "_", implementation, null, category, 0, severity, false, true, null, null, 3408, null);
        REQUIRES_API_ANNOTATION = AndroidxName.of((AndroidxName)AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RequiresApi");
        NO_ANNOTATION_FOUND = TuplesKt.to(null, null);
        stringArray = new String[]{"isAtLeast", "isRunning", "is", "runningOn", "running", "has"};
        VERSION_METHOD_NAME_PREFIXES = stringArray;
        stringArray = new String[]{"OrLater", "OrAbove", "OrHigher", "OrNewer", "Sdk"};
        VERSION_METHOD_NAME_SUFFIXES = stringArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001QB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\tH\u0007J@\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#0\"H\u0007J\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020#2\u0006\u0010&\u001a\u00020\tJ$\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020\u001b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#0\"J*\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00052\b\b\u0002\u0010/\u001a\u00020#H\u0007J*\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001c2\b\b\u0002\u0010/\u001a\u00020#H\u0007J\u001a\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 H\u0007J2\u0010*\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00052\b\b\u0002\u0010/\u001a\u00020#H\u0007J2\u0010*\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001c2\b\b\u0002\u0010/\u001a\u00020#H\u0007J \u00103\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0005H\u0007J \u00103\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001cH\u0007J4\u00103\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u00052\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0007J4\u00103\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001c2\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0007J\u000e\u00106\u001a\u0004\u0018\u000107*\u00020 H\u0002J,\u00108\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010 2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00104\u001a\u0004\u0018\u000105H\u0002J,\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00104\u001a\u0004\u0018\u000105H\u0002JJ\u0010=\u001a\u0004\u0018\u00010\u001c2\u0006\u0010>\u001a\u00020?2\u0006\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00104\u001a\u0004\u0018\u0001052\u001c\b\u0002\u0010@\u001a\u0016\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020A\u0018\u00010\"j\u0004\u0018\u0001`BH\u0007J:\u0010C\u001a\u0004\u0018\u00010\u001c2\u0006\u0010D\u001a\u00020?2\u001c\b\u0002\u0010@\u001a\u0016\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020A\u0018\u00010\"j\u0004\u0018\u0001`B2\b\b\u0002\u0010E\u001a\u00020\u0005H\u0002J5\u0010F\u001a\u00020A2\b\u0010-\u001a\u0004\u0018\u0001072\u001a\u0010@\u001a\u0016\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020A\u0018\u00010\"j\u0004\u0018\u0001`BH\u0002\u00a2\u0006\u0004\bG\u0010HJ\u000e\u0010I\u001a\u0004\u0018\u00010J*\u00020JH\u0002J\u0010\u0010O\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\t0LX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010MR\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\t0LX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010M\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/detector/api/VersionChecks$Companion;", "", "<init>", "()V", "MAX_CALL_DEPTH", "", "SDK_INT_VERSION_DATA", "Lcom/android/tools/lint/detector/api/Issue;", "SDK_INT", "", "SDK_INT_FULL", "CHECKS_SDK_INT_AT_LEAST_NAME", "CHECKS_SDK_INT_AT_LEAST_ANNOTATION", "PLATFORM_CHECKS_SDK_INT_AT_LEAST_ANNOTATION", "SDK_SUPPRESS_ANNOTATION", "ANDROIDX_SDK_SUPPRESS_ANNOTATION", "ROBO_ELECTRIC_CONFIG_ANNOTATION", "REQUIRES_API_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "Lcom/android/support/AndroidxName;", "REQUIRES_EXTENSION_ANNOTATION", "GET_BUILD_SDK_INT", "codeNameToApi", "text", "getTargetApiAnnotation", "Lkotlin/Pair;", "Lorg/jetbrains/uast/UAnnotation;", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "scope", "Lorg/jetbrains/uast/UElement;", "isApiLevelAnnotation", "Lkotlin/Function1;", "", "NO_ANNOTATION_FOUND", "isTargetAnnotation", "fqcn", "isRequiresApiAnnotation", "getTargetApiForAnnotation", "annotation", "isWithinVersionCheckConditional", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "api", "lowerBound", "getOuterVersionCheckConstraint", "client", "Lcom/android/tools/lint/client/api/LintClient;", "isPrecededByVersionCheckExit", "project", "Lcom/android/tools/lint/detector/api/Project;", "parentExpression", "Lorg/jetbrains/uast/UExpression;", "getSdkVersionLookup", "findChecksSdkInferredAnnotation", "Lcom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation;", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "getVersionCheckConditional", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "apiLevelLookup", "Lcom/android/tools/lint/detector/api/ApiLevel;", "Lcom/android/tools/lint/detector/api/ApiLevelLookup;", "getSdkIntConstraintFromExpression", "expression", "sdkId", "getApiLevel", "getApiLevel-zulsYdA", "(Lorg/jetbrains/uast/UExpression;Lkotlin/jvm/functions/Function1;)I", "flip", "Lorg/jetbrains/uast/UastBinaryOperator;", "VERSION_METHOD_NAME_PREFIXES", "", "[Ljava/lang/String;", "VERSION_METHOD_NAME_SUFFIXES", "getMinSdkVersionFromMethodName", "name", "FakeDetector", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nVersionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1860:1\n1#2:1861\n1310#3,2:1862\n1310#3,2:1864\n*S KotlinDebug\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks$Companion\n*L\n746#1:1862,2\n748#1:1864,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use SdkVersion instead")
        @JvmStatic
        public final int codeNameToApi(@NotNull String text) {
            String string;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)text, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex != -1) {
                String string2 = text.substring(dotIndex + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = text;
            }
            String buildCode = string;
            return SdkVersionInfo.getApiByBuildCode((String)buildCode, (boolean)true);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<UAnnotation, ApiConstraint> getTargetApiAnnotation(@NotNull JavaEvaluator evaluator, @Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            for (UElement current = scope; current != null; current = current.getUastParent()) {
                PsiPackage pkg;
                if (current instanceof UAnnotated) {
                    for (UAnnotation annotation : ((UAnnotated)current).getUAnnotations()) {
                        ApiConstraint target = this.getTargetApiForAnnotation(annotation, isApiLevelAnnotation);
                        if (target == null) continue;
                        return TuplesKt.to((Object)annotation, (Object)target);
                    }
                }
                if (!(current instanceof UFile)) continue;
                PsiElement psiElement = ((UFile)current).getJavaPsi();
                if (psiElement == null) {
                    psiElement = (PsiElement)((UFile)current).getSourcePsi();
                }
                if ((pkg = evaluator.getPackage(psiElement)) == null) break;
                for (PsiAnnotation psiAnnotation : pkg.getAnnotations()) {
                    UAnnotation annotation;
                    ApiConstraint target;
                    UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)UastFacade.INSTANCE;
                    Intrinsics.checkNotNull((Object)psiAnnotation);
                    UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)uastLanguagePlugin, (PsiElement)((PsiElement)psiAnnotation), null, null, (int)4, null);
                    UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                    if (uAnnotation == null || (target = this.getTargetApiForAnnotation(annotation = uAnnotation, isApiLevelAnnotation)) == null) continue;
                    return TuplesKt.to((Object)annotation, (Object)target);
                }
                break;
            }
            return NO_ANNOTATION_FOUND;
        }

        public static /* synthetic */ Pair getTargetApiAnnotation$default(Companion companion, JavaEvaluator javaEvaluator, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)Companion){

                    public final Boolean invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((Companion)this.receiver).isTargetAnnotation(p0);
                    }
                };
            }
            return companion.getTargetApiAnnotation(javaEvaluator, uElement, (Function1<? super String, Boolean>)function1);
        }

        public final boolean isTargetAnnotation(@NotNull String fqcn) {
            Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
            return Intrinsics.areEqual((Object)fqcn, (Object)"android.annotation.TargetApi") || this.isRequiresApiAnnotation(fqcn) || Intrinsics.areEqual((Object)fqcn, (Object)VersionChecks.SDK_SUPPRESS_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)VersionChecks.ANDROIDX_SDK_SUPPRESS_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)VersionChecks.ROBO_ELECTRIC_CONFIG_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)"TargetApi") || StringsKt.startsWith$default((String)fqcn, (String)"android.annotation.", (boolean)false, (int)2, null) && this.isTargetAnnotation(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(fqcn));
        }

        public final boolean isRequiresApiAnnotation(@NotNull String fqcn) {
            Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
            return REQUIRES_API_ANNOTATION.isEquals(fqcn) || Intrinsics.areEqual((Object)fqcn, (Object)"RequiresApi") || Intrinsics.areEqual((Object)VersionChecks.REQUIRES_EXTENSION_ANNOTATION, (Object)fqcn) || StringsKt.startsWith$default((String)fqcn, (String)"android.annotation.", (boolean)false, (int)2, null) && this.isRequiresApiAnnotation(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(fqcn));
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final ApiConstraint getTargetApiForAnnotation(@NotNull UAnnotation annotation, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            block22: {
                block20: {
                    Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                    Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
                    fqcn = annotation.getQualifiedName();
                    if (fqcn == null || !((Boolean)isApiLevelAnnotation.invoke((Object)fqcn)).booleanValue()) break block20;
                    if (Intrinsics.areEqual((Object)fqcn, (Object)"androidx.annotation.RequiresExtension")) {
                        sdkId = (int)UastLintUtils.Companion.getAnnotationLongValue(annotation, "extension", 0L);
                        value = (int)UastLintUtils.Companion.getAnnotationLongValue(annotation, "version", 0L);
                        return ApiConstraint.Companion.atLeast(value, sdkId);
                    }
                    sdkId = 0;
                    attributeList = annotation.getAttributeValues();
                    block5: for (UNamedExpression attribute : attributeList) {
                        block21: {
                            if (fqcn == null) break block21;
                            switch (fqcn.hashCode()) {
                                case 1080124037: {
                                    if (!fqcn.equals("androidx.test.filters.SdkSuppress")) {
                                        break;
                                    }
                                    ** GOTO lbl24
                                }
                                case 854141857: {
                                    if (!fqcn.equals("org.robolectric.annotation.Config")) {
                                        break;
                                    }
                                    ** GOTO lbl24
                                }
                                case -1087347458: {
                                    if (!fqcn.equals("android.support.test.filters.SdkSuppress")) break;
lbl24:
                                    // 3 sources

                                    if ((name = attribute.getName()) != null && (StringsKt.startsWith$default((String)name, (String)"minSdk", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"codeName"))) break;
                                    continue block5;
                                }
                            }
                        }
                        if ((expression = attribute.getExpression()) instanceof ULiteralExpression) {
                            value = ((ULiteralExpression)expression).getValue();
                            if (value instanceof Integer) {
                                return ApiLevel.Companion.getMinConstraint(((Number)value).intValue(), sdkId);
                            }
                            if (!(value instanceof String)) continue;
                            return ApiLevel.Companion.getMinConstraint$default(ApiLevel.Companion, (String)value, sdkId, false, 4, null);
                        }
                        var10_18 = ConstantEvaluator.evaluate(null, (UElement)expression);
                        v0 = constant = var10_18 instanceof Integer != false ? (Integer)var10_18 : null;
                        if (constant != null) {
                            return ApiLevel.Companion.getMinConstraint(constant, sdkId);
                        }
                        if (expression instanceof UReferenceExpression) {
                            name = ((UReferenceExpression)expression).getResolvedName();
                            if (name == null) continue;
                            return ApiLevel.Companion.getMinConstraint$default(ApiLevel.Companion, name, sdkId, false, 4, null);
                        }
                        return ApiLevel.Companion.getMinConstraint$default(ApiLevel.Companion, expression.asSourceString(), sdkId, false, 4, null);
                    }
                    break block22;
                }
                if (fqcn == null) {
                    v1 = annotation.getSourcePsi();
                    if (v1 == null) {
                        return null;
                    }
                    psi = v1;
                    if (psi instanceof PsiCompiledElement) {
                        return null;
                    }
                    text = psi.getText();
                    Intrinsics.checkNotNull((Object)text);
                    start = StringsKt.indexOf$default((CharSequence)text, (char)'(', (int)0, (boolean)false, (int)6, null);
                    if (start == -1) {
                        return null;
                    }
                    colon = StringsKt.indexOf$default((CharSequence)text, (char)':', (int)0, (boolean)false, (int)6, null);
                    v2 = text.substring(colon < start ? colon + 1 : 0, start);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                    annotationString = v2;
                    if (((Boolean)isApiLevelAnnotation.invoke((Object)annotationString)).booleanValue() && (end = StringsKt.indexOf$default((CharSequence)text, (char)')', (int)(start + 1), (boolean)false, (int)4, null)) != -1) {
                        v3 = text.substring(start + 1, end);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                        name = v3;
                        index = StringsKt.indexOf$default((CharSequence)name, (char)'=', (int)0, (boolean)false, (int)6, null);
                        if (index != -1) {
                            v4 = name.substring(index + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
                            name = StringsKt.trim((CharSequence)v4).toString();
                        }
                        if ((index = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                            v5 = name.substring(index + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                            name = v5;
                        }
                        return ApiLevel.Companion.getMinConstraint$default(ApiLevel.Companion, name, 0, false, 4, null);
                    }
                }
            }
            return null;
        }

        @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(context, element, ApiConstraint.get(api), lowerBound)", imports={}))
        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api, boolean lowerBound) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.isWithinVersionCheckConditional(context2, element, ApiConstraint.Companion.get$default(ApiConstraint.Companion, api, 0, 2, null), lowerBound);
        }

        public static /* synthetic */ boolean isWithinVersionCheckConditional$default(Companion companion, JavaContext javaContext, UElement uElement, int n, boolean bl, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = true;
            }
            return companion.isWithinVersionCheckConditional(javaContext, uElement, n, bl);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, @NotNull ApiConstraint api, boolean lowerBound) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            LintClient client = context2.getClient();
            JavaEvaluator evaluator = context2.getEvaluator();
            Project project = context2.getProject();
            VersionChecks check = new VersionChecks(client, evaluator, project);
            ApiConstraint apiConstraint = check.getWithinVersionCheckConditional(element, (Function1<? super UElement, ApiLevel>)null, 0);
            if (apiConstraint == null) {
                return false;
            }
            ApiConstraint constraint2 = apiConstraint;
            return lowerBound ? constraint2.isAtLeast(api) : constraint2.not().isAtLeast(api);
        }

        public static /* synthetic */ boolean isWithinVersionCheckConditional$default(Companion companion, JavaContext javaContext, UElement uElement, ApiConstraint apiConstraint, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.isWithinVersionCheckConditional(javaContext, uElement, apiConstraint, bl);
        }

        @JvmStatic
        @Nullable
        public final ApiConstraint getOuterVersionCheckConstraint(@NotNull JavaContext context2, @NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            LintClient client = context2.getClient();
            JavaEvaluator evaluator = context2.getEvaluator();
            Project project = context2.getProject();
            VersionChecks check = new VersionChecks(client, evaluator, project);
            return check.getWithinVersionCheckConditional(element, (Function1<? super UElement, ApiLevel>)null, 0);
        }

        @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(client, evaluator, element, ApiConstraint.get(api), lowerBound)", imports={}))
        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean lowerBound) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.isWithinVersionCheckConditional(client, evaluator, element, ApiConstraint.Companion.get$default(ApiConstraint.Companion, api, 0, 2, null), lowerBound);
        }

        public static /* synthetic */ boolean isWithinVersionCheckConditional$default(Companion companion, LintClient lintClient, JavaEvaluator javaEvaluator, UElement uElement, int n, boolean bl, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                bl = true;
            }
            return companion.isWithinVersionCheckConditional(lintClient, javaEvaluator, uElement, n, bl);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, @NotNull ApiConstraint api, boolean lowerBound) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            VersionChecks check = new VersionChecks(client, evaluator, null);
            ApiConstraint apiConstraint = check.getWithinVersionCheckConditional(element, (Function1<? super UElement, ApiLevel>)null, 0);
            if (apiConstraint == null) {
                return false;
            }
            ApiConstraint constraint2 = apiConstraint;
            return lowerBound ? constraint2.isAtLeast(api) : constraint2.not().isAtLeast(api);
        }

        public static /* synthetic */ boolean isWithinVersionCheckConditional$default(Companion companion, LintClient lintClient, JavaEvaluator javaEvaluator, UElement uElement, ApiConstraint apiConstraint, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return companion.isWithinVersionCheckConditional(lintClient, javaEvaluator, uElement, apiConstraint, bl);
        }

        @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isPrecededByVersionCheckExit(context, element, ApiConstraint.get(api))", imports={}))
        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull JavaContext context2, @NotNull UElement element, int api) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.isPrecededByVersionCheckExit(context2, element, ApiConstraint.Companion.get$default(ApiConstraint.Companion, api, 0, 2, null));
        }

        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull JavaContext context2, @NotNull UElement element, @NotNull ApiConstraint api) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            LintClient client = context2.getClient();
            JavaEvaluator evaluator = context2.getEvaluator();
            Project project = context2.getProject();
            return this.isPrecededByVersionCheckExit(client, evaluator, element, api, project);
        }

        @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isPrecededByVersionCheckExit(client, evaluator, element, ApiConstraint.get(api), project)", imports={}))
        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.isPrecededByVersionCheckExit(client, evaluator, element, ApiConstraint.Companion.get$default(ApiConstraint.Companion, api, 0, 2, null), project);
        }

        public static /* synthetic */ boolean isPrecededByVersionCheckExit$default(Companion companion, LintClient lintClient, JavaEvaluator javaEvaluator, UElement uElement, int n, Project project, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                project = null;
            }
            return companion.isPrecededByVersionCheckExit(lintClient, javaEvaluator, uElement, n, project);
        }

        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, @NotNull ApiConstraint api, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            VersionChecks check = new VersionChecks(client, evaluator, project);
            UElement prev = element;
            UExpression current = this.parentExpression(prev);
            while (current != null) {
                VersionCheckWithExitFinder visitor = check.new VersionCheckWithExitFinder(prev, api);
                current.accept((UastVisitor)visitor);
                if (visitor.found()) {
                    return true;
                }
                prev = (UElement)current;
                current = this.parentExpression((UElement)current);
            }
            return false;
        }

        public static /* synthetic */ boolean isPrecededByVersionCheckExit$default(Companion companion, LintClient lintClient, JavaEvaluator javaEvaluator, UElement uElement, ApiConstraint apiConstraint, Project project, int n, Object object) {
            if ((n & 0x10) != 0) {
                project = null;
            }
            return companion.isPrecededByVersionCheckExit(lintClient, javaEvaluator, uElement, apiConstraint, project);
        }

        private final UExpression parentExpression(UElement $this$parentExpression) {
            return (UExpression)UastUtils.getParentOfType((UElement)$this$parentExpression, UExpression.class, (boolean)true);
        }

        private final int getSdkVersionLookup(UElement element, LintClient client, JavaEvaluator evaluator, Project project) {
            if (element instanceof UReferenceExpression) {
                String resolvedName = ((UReferenceExpression)element).getResolvedName();
                if (Intrinsics.areEqual((Object)VersionChecks.SDK_INT, (Object)resolvedName)) {
                    return 0;
                }
                if (Intrinsics.areEqual((Object)VersionChecks.SDK_INT_FULL, (Object)resolvedName)) {
                    return -2;
                }
                UElement selector = UastLintUtilsKt.findSelector(element);
                if (selector != element) {
                    return this.getSdkVersionLookup(selector, client, evaluator, project);
                }
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof ULocalVariable) {
                    UExpression initializer = ((ULocalVariable)resolved).getUastInitializer();
                    if (initializer != null) {
                        return this.getSdkVersionLookup((UElement)initializer, client, evaluator, project);
                    }
                } else if (resolved instanceof PsiVariable) {
                    Object object;
                    PsiExpression initializer = ((PsiVariable)resolved).getInitializer();
                    if (initializer != null && (object = UastContextKt.toUElement((PsiElement)((PsiElement)initializer))) != null) {
                        UElement it = object;
                        boolean bl = false;
                        return Companion.getSdkVersionLookup(it, client, evaluator, project);
                    }
                    if (resolved instanceof PsiField) {
                        object = SdkIntAnnotation.Companion.get((PsiModifierListOwner)resolved);
                        if (object != null) {
                            Object it = object;
                            boolean bl = false;
                            return ((SdkIntAnnotation)it).getSdkId();
                        }
                        object = this.findChecksSdkInferredAnnotation((PsiModifierListOwner)resolved, client, evaluator, project);
                        if (object != null) {
                            Object it = object;
                            boolean bl = false;
                            return ((SdkIntAnnotation)it).getSdkId();
                        }
                    }
                }
            } else if (element instanceof UCallExpression) {
                String methodName = Lint.getMethodName((UCallExpression)element);
                if (Intrinsics.areEqual((Object)methodName, (Object)VersionChecks.GET_BUILD_SDK_INT)) {
                    return 0;
                }
                if (Intrinsics.areEqual((Object)methodName, (Object)"getExtensionVersion")) {
                    UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)((UCallExpression)element).getValueArguments());
                    if (uExpression != null) {
                        UExpression firstArg = uExpression;
                        boolean bl = false;
                        Object object = ConstantEvaluator.evaluate(null, (UElement)firstArg);
                        if (object != null) {
                            Object constant = object;
                            boolean bl2 = false;
                            Number number = constant instanceof Number ? (Number)((Number)constant) : (Number)null;
                            return number != null ? number.intValue() : -1;
                        }
                    }
                }
            } else if (element instanceof UParenthesizedExpression) {
                return this.getSdkVersionLookup((UElement)((UParenthesizedExpression)element).getExpression(), client, evaluator, project);
            }
            return -1;
        }

        private final SdkIntAnnotation findChecksSdkInferredAnnotation(PsiModifierListOwner owner, LintClient client, JavaEvaluator evaluator, Project project) {
            SdkIntAnnotation sdkIntAnnotation;
            if (!client.supportsPartialAnalysis()) {
                return null;
            }
            if (project == null || !(owner instanceof PsiCompiledElement)) {
                return null;
            }
            PsiModifierListOwner psiModifierListOwner = owner;
            if (psiModifierListOwner instanceof PsiMethod) {
                sdkIntAnnotation = SdkIntAnnotation.Companion.findSdkIntAnnotation(client, evaluator, project, owner);
                if (sdkIntAnnotation == null) {
                    return null;
                }
            } else if (psiModifierListOwner instanceof PsiField) {
                sdkIntAnnotation = SdkIntAnnotation.Companion.findSdkIntAnnotation(client, evaluator, project, owner);
                if (sdkIntAnnotation == null) {
                    return null;
                }
            } else {
                return null;
            }
            SdkIntAnnotation annotation = sdkIntAnnotation;
            return annotation;
        }

        @JvmStatic
        @Nullable
        public final ApiConstraint getVersionCheckConditional(@NotNull UBinaryExpression binary, @NotNull LintClient client, @NotNull JavaEvaluator evaluator, @Nullable Project project, @Nullable Function1<? super UElement, ApiLevel> apiLevelLookup) {
            Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            UastBinaryOperator tokenType = null;
            tokenType = binary.getOperator();
            if (tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUALS || tokenType == UastBinaryOperator.LESS_OR_EQUALS || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS || tokenType == UastBinaryOperator.NOT_EQUALS || tokenType == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                UExpression left = binary.getLeftOperand();
                int level = 0;
                UExpression right = null;
                int sdkId = this.getSdkVersionLookup((UElement)left, client, evaluator, project);
                if (sdkId == -1) {
                    right = binary.getRightOperand();
                    sdkId = this.getSdkVersionLookup((UElement)right, client, evaluator, project);
                    if (sdkId == -1) {
                        return null;
                    }
                    UastBinaryOperator uastBinaryOperator = this.flip(tokenType);
                    if (uastBinaryOperator == null) {
                        uastBinaryOperator = tokenType;
                    }
                    tokenType = uastBinaryOperator;
                    level = this.getApiLevel-zulsYdA(left, apiLevelLookup);
                } else {
                    right = binary.getRightOperand();
                    level = this.getApiLevel-zulsYdA(right, apiLevelLookup);
                }
                if (ApiLevel.isValid-impl(level)) {
                    UastBinaryOperator uastBinaryOperator;
                    if (sdkId == -2) {
                        sdkId = 0;
                    }
                    if (Intrinsics.areEqual((Object)(uastBinaryOperator = tokenType), (Object)UastBinaryOperator.GREATER_OR_EQUALS)) {
                        return ApiConstraint.Companion.atLeast-kG1hquA(level, sdkId);
                    }
                    if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER)) {
                        return ApiConstraint.Companion.above-kG1hquA(level, sdkId);
                    }
                    if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS)) {
                        return ApiConstraint.Companion.atMost-kG1hquA(level, sdkId);
                    }
                    if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS)) {
                        return ApiConstraint.Companion.below-kG1hquA(level, sdkId);
                    }
                    if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) {
                        return ApiConstraint.Companion.exactly-kG1hquA(level, sdkId);
                    }
                    if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                        return ApiConstraint.Companion.not-kG1hquA(level, sdkId);
                    }
                    if (_Assertions.ENABLED) {
                        boolean bl = false;
                        UastBinaryOperator uastBinaryOperator2 = tokenType;
                        throw new AssertionError(uastBinaryOperator2);
                    }
                }
            } else if (Intrinsics.areEqual((Object)tokenType.getText(), (Object)"in")) {
                UExpression left = binary.getLeftOperand();
                int sdkId = this.getSdkVersionLookup((UElement)left, client, evaluator, project);
                if (sdkId == -1) {
                    return null;
                }
                UExpression right = UastUtils.skipParenthesizedExprDown((UExpression)binary.getRightOperand());
                if (right instanceof UBinaryExpression) {
                    return this.getSdkIntConstraintFromExpression((UBinaryExpression)right, apiLevelLookup, sdkId);
                }
            }
            return null;
        }

        public static /* synthetic */ ApiConstraint getVersionCheckConditional$default(Companion companion, UBinaryExpression uBinaryExpression, LintClient lintClient, JavaEvaluator javaEvaluator, Project project, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = null;
            }
            return companion.getVersionCheckConditional(uBinaryExpression, lintClient, javaEvaluator, project, (Function1<? super UElement, ApiLevel>)function1);
        }

        private final ApiConstraint getSdkIntConstraintFromExpression(UBinaryExpression expression, Function1<? super UElement, ApiLevel> apiLevelLookup, int sdkId) {
            if (expression.getOperands().size() == 2) {
                int lowerBound = this.getApiLevel-zulsYdA((UExpression)expression.getOperands().get(0), apiLevelLookup);
                int upperBound = this.getApiLevel-zulsYdA((UExpression)expression.getOperands().get(1), apiLevelLookup);
                boolean includesEndPoint = Intrinsics.areEqual((Object)expression.getOperator().getText(), (Object)"..");
                if (!ApiLevel.equals-impl0(lowerBound, ApiLevel.Companion.getNONE-wqyE5NY()) && !ApiLevel.equals-impl0(upperBound, ApiLevel.Companion.getNONE-wqyE5NY())) {
                    if (sdkId == -2) {
                        int from = ApiLevel.component1-impl(lowerBound);
                        int fromMinor = ApiLevel.component2-impl(lowerBound);
                        int to = ApiLevel.component1-impl(upperBound);
                        int toMinor = ApiLevel.component2-impl(upperBound);
                        return ApiConstraint.Companion.range(from, fromMinor, to, toMinor + (includesEndPoint ? 1 : 0), 0);
                    }
                    int adjustedUpperBound = ApiLevel.getMajor-impl(upperBound) + (includesEndPoint ? 1 : 0);
                    return ApiConstraint.Companion.range(ApiLevel.getMajor-impl(lowerBound), 0, adjustedUpperBound, 0, sdkId);
                }
            }
            return null;
        }

        static /* synthetic */ ApiConstraint getSdkIntConstraintFromExpression$default(Companion companion, UBinaryExpression uBinaryExpression, Function1 function1, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                function1 = null;
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.getSdkIntConstraintFromExpression(uBinaryExpression, (Function1<? super UElement, ApiLevel>)function1, n);
        }

        private final int getApiLevel-zulsYdA(UExpression element, Function1<? super UElement, ApiLevel> apiLevelLookup) {
            int level = ApiLevel.Companion.getNONE-wqyE5NY();
            if (element instanceof UReferenceExpression) {
                Object constant;
                String codeName = ((UReferenceExpression)element).getResolvedName();
                if (codeName != null) {
                    level = ApiLevel.Companion.get-zulsYdA(codeName, false);
                }
                if (ApiLevel.isMissing-impl(level) && (constant = ConstantEvaluator.evaluate(null, (UElement)element)) instanceof Number) {
                    level = ApiLevel.Companion.get-DTtIgKc(((Number)constant).intValue());
                }
            } else if (element instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)element).getValue();
                if (value instanceof Integer) {
                    level = ApiLevel.Companion.get-DTtIgKc(((Number)value).intValue());
                }
            } else if (element instanceof UParenthesizedExpression) {
                return this.getApiLevel-zulsYdA(((UParenthesizedExpression)element).getExpression(), apiLevelLookup);
            }
            if (ApiLevel.isMissing-impl(level) && apiLevelLookup != null && element != null) {
                level = ((ApiLevel)apiLevelLookup.invoke((Object)element)).unbox-impl();
            }
            return level;
        }

        private final UastBinaryOperator flip(UastBinaryOperator $this$flip) {
            UastBinaryOperator uastBinaryOperator = $this$flip;
            return Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER) ? (UastBinaryOperator)UastBinaryOperator.LESS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.LESS_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.GREATER_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS) ? (UastBinaryOperator)UastBinaryOperator.GREATER : null)));
        }

        @VisibleForTesting
        public final int getMinSdkVersionFromMethodName(@NotNull String name) {
            String string;
            String string2;
            String prefix;
            block14: {
                String string3;
                int n;
                block13: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    String[] $this$firstOrNull$iv = VERSION_METHOD_NAME_PREFIXES;
                    boolean $i$f$firstOrNull = false;
                    n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                        string3 = element$iv;
                        break block13;
                    }
                    string3 = null;
                }
                if (string3 == null) {
                    return -1;
                }
                prefix = string3;
                String[] $this$firstOrNull$iv = VERSION_METHOD_NAME_SUFFIXES;
                boolean $i$f$firstOrNull = false;
                int element$iv = $this$firstOrNull$iv.length;
                for (n = 0; n < element$iv; ++n) {
                    String element$iv2;
                    String it = element$iv2 = $this$firstOrNull$iv[n];
                    boolean bl = false;
                    if (!SdkUtils.endsWithIgnoreCase((String)name, (String)it)) continue;
                    string2 = element$iv2;
                    break block14;
                }
                string2 = string = null;
            }
            if (string2 == null) {
                if (!Intrinsics.areEqual((Object)prefix, (Object)"is")) {
                    string = "";
                } else {
                    return -1;
                }
            }
            String suffix = string;
            String string4 = name.substring(prefix.length(), name.length() - suffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String codeName = string4;
            int version = SdkVersionInfo.getApiByPreviewName((String)codeName, (boolean)false);
            if (version == -1) {
                version = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
                if (version == -1 && codeName.length() == 1 && Character.isUpperCase(codeName.charAt(0))) {
                    version = 36;
                } else if (SdkUtils.startsWithIgnoreCase((String)codeName, (String)"api")) {
                    int end;
                    int begin = 3;
                    int length = codeName.length();
                    if (begin < length && codeName.charAt(begin) == '_') {
                        ++begin;
                    }
                    for (end = begin; end < length && Character.isDigit(codeName.charAt(end)); ++end) {
                    }
                    if (begin < end) {
                        String string5 = codeName.substring(begin, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        version = Integer.decode(string5);
                    }
                }
            }
            return version;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<UAnnotation, ApiConstraint> getTargetApiAnnotation(@NotNull JavaEvaluator evaluator, @Nullable UElement scope) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            return com.android.tools.lint.detector.api.VersionChecks$Companion.getTargetApiAnnotation$default(this, evaluator, scope, null, 4, null);
        }

        @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(context, element, ApiConstraint.get(api), lowerBound)", imports={}))
        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return com.android.tools.lint.detector.api.VersionChecks$Companion.isWithinVersionCheckConditional$default(this, context2, element, api, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, @NotNull ApiConstraint api) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return com.android.tools.lint.detector.api.VersionChecks$Companion.isWithinVersionCheckConditional$default(this, context2, element, api, false, 8, null);
        }

        @Deprecated(message="Use the ApiConstraint version instead", replaceWith=@ReplaceWith(expression="isWithinVersionCheckConditional(client, evaluator, element, ApiConstraint.get(api), lowerBound)", imports={}))
        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return com.android.tools.lint.detector.api.VersionChecks$Companion.isWithinVersionCheckConditional$default(this, client, evaluator, element, api, false, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, @NotNull ApiConstraint api) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return com.android.tools.lint.detector.api.VersionChecks$Companion.isWithinVersionCheckConditional$default(this, client, evaluator, element, api, false, 16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/detector/api/VersionChecks$Companion$FakeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "<init>", "()V", "checkPartialResults", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "filterIncident", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "lint-api"})
        public static final class FakeDetector
        extends Detector {
            @Override
            public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
            }

            @Override
            public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
                Intrinsics.checkNotNullParameter((Object)map, (String)"map");
                return false;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ'\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001fJ\u000f\u0010 \u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b!\u0010\u0016J*\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0013\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation;", "", "api", "", "codename", "", "parameter", "lambda", "sdkId", "<init>", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;I)V", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/intellij/psi/PsiAnnotation;)V", "getApi", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getCodename", "()Ljava/lang/String;", "getParameter", "getLambda", "getSdkId", "()I", "getApiLevel", "Lcom/android/tools/lint/detector/api/ApiLevel;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "call", "Lorg/jetbrains/uast/UCallExpression;", "getApiLevel-8e34biw", "apiLevel", "apiLevel-wqyE5NY", "findArgumentFor", "Lorg/jetbrains/uast/UExpression;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "parameterIndex", "Companion", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nVersionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1860:1\n1#2:1861\n*E\n"})
    public static final class SdkIntAnnotation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Integer api;
        @Nullable
        private final String codename;
        @Nullable
        private final Integer parameter;
        @Nullable
        private final Integer lambda;
        private final int sdkId;

        public SdkIntAnnotation(@Nullable Integer api, @Nullable String codename, @Nullable Integer parameter, @Nullable Integer lambda, int sdkId) {
            this.api = api;
            this.codename = codename;
            this.parameter = parameter;
            this.lambda = lambda;
            this.sdkId = sdkId;
        }

        @Nullable
        public final Integer getApi() {
            return this.api;
        }

        @Nullable
        public final String getCodename() {
            return this.codename;
        }

        @Nullable
        public final Integer getParameter() {
            return this.parameter;
        }

        @Nullable
        public final Integer getLambda() {
            return this.lambda;
        }

        public final int getSdkId() {
            return this.sdkId;
        }

        public SdkIntAnnotation(@NotNull PsiAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this(VersionChecksKt.getAnnotationIntValue$default(annotation, "api", 0, 2, null), VersionChecksKt.getAnnotationStringValue$default(annotation, "codename", null, 2, null), VersionChecksKt.getAnnotationIntValue$default(annotation, "parameter", 0, 2, null), VersionChecksKt.getAnnotationIntValue$default(annotation, "lambda", 0, 2, null), VersionChecksKt.getAnnotationIntValue(annotation, "extension", 0));
        }

        @Nullable
        public final ApiLevel getApiLevel-8e34biw(@NotNull JavaEvaluator evaluator, @NotNull PsiModifierListOwner owner, @Nullable UCallExpression call) {
            UExpression argument;
            int n;
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            int apiLevel = this.apiLevel-wqyE5NY();
            if (ApiLevel.isValid-impl(apiLevel)) {
                return ApiLevel.box-impl(apiLevel);
            }
            Integer n2 = this.parameter;
            if (n2 != null) {
                n = n2;
            } else {
                Integer n3 = this.lambda;
                if (n3 != null) {
                    n = n3;
                } else {
                    return null;
                }
            }
            int index = n;
            if (owner instanceof PsiMethod && call != null && (argument = this.findArgumentFor(evaluator, (PsiMethod)owner, index, call)) != null) {
                ApiLevel apiLevel2;
                Object v = ConstantEvaluator.evaluate(null, (UElement)argument);
                Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
                if (number != null) {
                    int it = number.intValue();
                    boolean bl = false;
                    apiLevel2 = ApiLevel.box-impl(ApiLevel.constructor-impl(it));
                } else {
                    apiLevel2 = null;
                }
                return apiLevel2;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final int apiLevel-wqyE5NY() {
            int n;
            if (this.api != null) {
                Integer n2 = this.api;
                int n3 = -1;
                if (n2 == null || n2 != n3) {
                    n = ApiLevel.constructor-impl(this.api);
                    return n;
                }
            }
            if (this.codename != null) {
                n = ApiLevel.Companion.get-zulsYdA$default(ApiLevel.Companion, this.codename, false, 2, null);
                return n;
            }
            n = ApiLevel.Companion.getNONE-wqyE5NY();
            return n;
        }

        private final UExpression findArgumentFor(JavaEvaluator evaluator, PsiMethod calledMethod, int parameterIndex, UCallExpression call) {
            PsiParameter[] psiParameterArray = calledMethod.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            PsiParameter[] parameters = psiParameterArray;
            if (parameterIndex >= 0 && parameterIndex < parameters.length) {
                PsiParameter target = parameters[parameterIndex];
                Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping(call, calledMethod);
                for (Map.Entry<UExpression, PsiParameter> entry : mapping.entrySet()) {
                    UExpression key = entry.getKey();
                    PsiParameter value1 = entry.getValue();
                    if (value1 != target && !value1.isEquivalentTo((PsiElement)target)) continue;
                    return key;
                }
            }
            return null;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation$Companion;", "", "<init>", "()V", "get", "Lcom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation;", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "getMethodKey", "", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "method", "Lorg/jetbrains/uast/UMethod;", "getFieldKey", "field", "Lorg/jetbrains/uast/UField;", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/psi/PsiField;", "findSdkIntAnnotation", "client", "Lcom/android/tools/lint/client/api/LintClient;", "project", "Lcom/android/tools/lint/detector/api/Project;", "findAttribute", "args", "name", "lint-api"})
        @SourceDebugExtension(value={"SMAP\nVersionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1860:1\n1#2:1861\n1863#3:1862\n1864#3:1865\n1317#4,2:1863\n*S KotlinDebug\n*F\n+ 1 VersionChecks.kt\ncom/android/tools/lint/detector/api/VersionChecks$SdkIntAnnotation$Companion\n*L\n1820#1:1862\n1820#1:1865\n1821#1:1863,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final SdkIntAnnotation get(@NotNull PsiModifierListOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                block4: for (PsiAnnotation annotation : owner.getAnnotations()) {
                    v0 = annotation.getNameReferenceElement();
                    v1 = referenceName = v0 != null ? v0.getReferenceName() : null;
                    if (referenceName != null && !Intrinsics.areEqual((Object)referenceName, (Object)"ChecksSdkIntAtLeast") || (var7_7 = annotation.getQualifiedName()) == null) continue;
                    switch (var7_7.hashCode()) {
                        case 316653948: {
                            if (!var7_7.equals("androidx.annotation.ChecksSdkIntAtLeast")) {
                                continue block4;
                            }
                            ** GOTO lbl13
                        }
                        case -702295498: {
                            if (!var7_7.equals("android.annotation.ChecksSdkIntAtLeast")) continue block4;
lbl13:
                            // 2 sources

                            Intrinsics.checkNotNull((Object)annotation);
                            return new SdkIntAnnotation(annotation);
                        }
                    }
                }
                return null;
            }

            @NotNull
            public final String getMethodKey(@NotNull JavaEvaluator evaluator, @NotNull UMethod method) {
                String string;
                Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                String desc = evaluator.getMethodDescription(method.getJavaPsi(), false, false);
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
                if (uClass != null) {
                    UClass it = uClass;
                    boolean bl = false;
                    string = evaluator.getQualifiedName(it.getJavaPsi());
                } else {
                    string = null;
                }
                String cls = string;
                return cls + "#" + method.getName() + desc;
            }

            @NotNull
            public final String getFieldKey(@NotNull JavaEvaluator evaluator, @NotNull UField field) {
                String string;
                Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)field));
                if (uClass != null) {
                    UClass it = uClass;
                    boolean bl = false;
                    string = evaluator.getQualifiedName(it.getJavaPsi());
                } else {
                    string = null;
                }
                String cls = string;
                return cls + "#" + UastLintUtilsKt.getNameFromSource((UElement)field);
            }

            private final String getMethodKey(JavaEvaluator evaluator, PsiMethod method) {
                String string;
                String desc = evaluator.getMethodDescription(method, false, false);
                PsiClass psiClass = method.getContainingClass();
                if (psiClass != null) {
                    PsiClass it = psiClass;
                    boolean bl = false;
                    string = evaluator.getQualifiedName(it);
                } else {
                    string = null;
                }
                String cls = string;
                return cls + "#" + method.getName() + desc;
            }

            private final String getFieldKey(JavaEvaluator evaluator, PsiField field) {
                String string;
                PsiClass psiClass = field.getContainingClass();
                if (psiClass != null) {
                    PsiClass it = psiClass;
                    boolean bl = false;
                    string = evaluator.getQualifiedName(it);
                } else {
                    string = null;
                }
                String cls = string;
                return cls + "#" + field.getName();
            }

            @Nullable
            public final SdkIntAnnotation findSdkIntAnnotation(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull Project project, @NotNull PsiModifierListOwner owner) {
                String string;
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                PsiModifierListOwner psiModifierListOwner = owner;
                if (psiModifierListOwner instanceof PsiMethod) {
                    string = this.getMethodKey(evaluator, (PsiMethod)owner);
                } else if (psiModifierListOwner instanceof PsiField) {
                    string = this.getFieldKey(evaluator, (PsiField)owner);
                } else {
                    return null;
                }
                String key = string;
                Collection<LintMap> lintMaps = client.getPartialResults(project, SDK_INT_VERSION_DATA).maps();
                Map map = new LinkedHashMap();
                Iterable $this$forEach$iv = lintMaps;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LintMap lintMap = (LintMap)element$iv;
                    boolean bl = false;
                    Sequence<String> $this$forEach$iv2 = lintMap.keys();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String it;
                        String key2 = (String)element$iv2;
                        boolean bl2 = false;
                        if (lintMap.get(key2) == null) continue;
                        boolean bl3 = false;
                        map.put(key2, it);
                    }
                }
                String string2 = (String)map.get(key);
                if (string2 == null) {
                    return null;
                }
                String args = string2;
                String string3 = this.findAttribute(args, "api");
                Integer api = string3 != null ? StringsKt.toIntOrNull((String)string3) : null;
                String codename = this.findAttribute(args, "codename");
                String string4 = this.findAttribute(args, "parameter");
                Integer parameter = string4 != null ? StringsKt.toIntOrNull((String)string4) : null;
                String string5 = this.findAttribute(args, "lambda");
                Integer lambda = string5 != null ? StringsKt.toIntOrNull((String)string5) : null;
                Object object = this.findAttribute(args, "extension");
                int sdkId = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                return new SdkIntAnnotation(api, codename, parameter, lambda, sdkId);
            }

            private final String findAttribute(String args, String name) {
                String key = name + "=";
                int index = StringsKt.indexOf$default((CharSequence)args, (String)key, (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    return null;
                }
                int start = index + key.length();
                int it = StringsKt.indexOf$default((CharSequence)args, (char)',', (int)start, (boolean)false, (int)4, null);
                boolean bl = false;
                int end = it == -1 ? args.length() : it;
                String string = args.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/VersionChecks$VersionCheckWithExitFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "endElement", "Lorg/jetbrains/uast/UElement;", "api", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "<init>", "(Lcom/android/tools/lint/detector/api/VersionChecks;Lorg/jetbrains/uast/UElement;Lcom/android/tools/lint/detector/api/ApiConstraint;)V", "found", "", "done", "visitElement", "node", "visitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "fallsThrough", "body", "Lorg/jetbrains/uast/UExpression;", "lint-api"})
    private final class VersionCheckWithExitFinder
    extends AbstractUastVisitor {
        @NotNull
        private final UElement endElement;
        @NotNull
        private final ApiConstraint api;
        private boolean found;
        private boolean done;

        public VersionCheckWithExitFinder(@NotNull UElement endElement, ApiConstraint api) {
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.endElement = endElement;
            this.api = api;
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.done) {
                return true;
            }
            if (node == this.endElement) {
                this.done = true;
            }
            return this.done;
        }

        public boolean visitIfExpression(@NotNull UIfExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean exit = super.visitIfExpression(node);
            if (this.done) {
                return true;
            }
            if (UastUtils.isUastChildOf((UElement)this.endElement, (UElement)((UElement)node), (boolean)true)) {
                this.done = true;
                return true;
            }
            UExpression thenBranch = node.getThenExpression();
            UExpression elseBranch = node.getElseExpression();
            ApiConstraint constraint2 = VersionChecks.getVersionCheckConstraint$default(VersionChecks.this, (UElement)node.getCondition(), null, null, 0, 6, null);
            if (thenBranch != null) {
                ApiConstraint apiConstraint = constraint2;
                boolean bl = apiConstraint != null && (apiConstraint = apiConstraint.not()) != null ? apiConstraint.isAtLeast(this.api) : false;
                if (bl && UastLintUtilsKt.isUnconditionalReturn(thenBranch)) {
                    this.found = true;
                    this.done = true;
                }
            }
            if (elseBranch != null) {
                ApiConstraint apiConstraint = constraint2;
                boolean bl = apiConstraint != null ? apiConstraint.isAtLeast(this.api) : false;
                if (bl && UastLintUtilsKt.isUnconditionalReturn(elseBranch)) {
                    this.found = true;
                    this.done = true;
                }
            }
            return exit;
        }

        public boolean visitSwitchExpression(@NotNull USwitchExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitSwitchExpression(node);
            if (this.done) {
                return true;
            }
            if (UastUtils.isUastChildOf((UElement)this.endElement, (UElement)((UElement)node), (boolean)true)) {
                this.done = true;
                return true;
            }
            UExpression subject = node.getExpression();
            if (subject != null && VersionChecks.this.getSdkVersionLookup((UElement)subject) == -1) {
                return this.done;
            }
            ApiConstraint fallthroughConstraint = null;
            ApiConstraint currentConstraint = null;
            for (UExpression entry : node.getBody().getExpressions()) {
                if (!(entry instanceof USwitchClauseExpression)) continue;
                UExpression uExpression = entry;
                USwitchClauseExpressionWithBody uSwitchClauseExpressionWithBody = uExpression instanceof USwitchClauseExpressionWithBody ? (USwitchClauseExpressionWithBody)uExpression : null;
                UExpressionList body = uSwitchClauseExpressionWithBody != null ? uSwitchClauseExpressionWithBody.getBody() : null;
                ApiConstraint caseConstraint = VersionChecks.getCaseConstraint$default(VersionChecks.this, (USwitchClauseExpression)entry, subject != null, null, 0, 12, null);
                if (body != null && caseConstraint != null && !this.fallsThrough((UExpression)body)) {
                    fallthroughConstraint = ApiConstraint.Companion.max(caseConstraint.not(), fallthroughConstraint, false);
                }
                if (caseConstraint != null) {
                    ApiConstraint reverse = caseConstraint.not();
                    currentConstraint = ApiConstraint.Companion.max(reverse, currentConstraint, false);
                }
                if (!((USwitchClauseExpression)entry).getCaseValues().isEmpty() || body == null || this.fallsThrough((UExpression)body)) continue;
                if (currentConstraint == null) break;
                currentConstraint = currentConstraint.not();
                fallthroughConstraint = fallthroughConstraint != null ? ApiConstraint.Companion.max(fallthroughConstraint, currentConstraint, false) : currentConstraint;
                break;
            }
            ApiConstraint apiConstraint = fallthroughConstraint;
            if (apiConstraint == null) {
                return this.done;
            }
            ApiConstraint constraint2 = apiConstraint;
            if (constraint2.isAtLeast(this.api)) {
                this.found = true;
                this.done = true;
            }
            return this.done;
        }

        private final boolean fallsThrough(UExpression body) {
            return !UastLintUtilsKt.isUnconditionalReturn(body);
        }

        public final boolean found() {
            return this.found;
        }
    }
}

