/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0000J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/detector/api/TextFormat;", "", "<init>", "(Ljava/lang/String;I)V", "RAW", "TEXT", "HTML", "HTML_WITH_UNICODE", "toHtml", "", "text", "toText", "convertTo", "message", "to", "fromHtml", "html", "fromRaw", "Companion", "lint-api"})
@SourceDebugExtension(value={"SMAP\nTextFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFormat.kt\ncom/android/tools/lint/detector/api/TextFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,642:1\n1#2:643\n*E\n"})
public final class TextFormat
extends Enum<TextFormat> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String HTTP_PREFIX = "http://";
    @NotNull
    public static final String HTTPS_PREFIX = "https://";
    @NotNull
    public static final String A_HREF_PREFIX = "<a href=\"";
    public static final /* enum */ TextFormat RAW;
    public static final /* enum */ TextFormat TEXT;
    public static final /* enum */ TextFormat HTML;
    public static final /* enum */ TextFormat HTML_WITH_UNICODE;
    private static final /* synthetic */ TextFormat[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @NotNull
    public final String toHtml(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.convertTo(text, HTML);
    }

    @NotNull
    public final String toText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.convertTo(text, TEXT);
    }

    @NotNull
    public final String convertTo(@NotNull String message2, @NotNull TextFormat to) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        if (this == to) {
            return message2;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[to.ordinal()]) {
                    case 1: {
                        string = message2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = to.fromRaw(message2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 2: {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[to.ordinal()]) {
                    case 1: {
                        string = TextFormat.Companion.textToRaw(message2);
                        break;
                    }
                    case 2: {
                        string = message2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        String string2 = XmlUtils.toXmlTextValue((String)message2);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toXmlTextValue(...)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 3: {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[to.ordinal()]) {
                    case 3: {
                        string = message2;
                        break;
                    }
                    case 4: {
                        string = TextFormat.Companion.removeNumericEntities(message2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = to.fromHtml(message2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 4: {
                String string;
                switch (WhenMappings.$EnumSwitchMapping$0[to.ordinal()]) {
                    case 3: 
                    case 4: {
                        string = message2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = to.fromHtml(message2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String fromHtml(String html) {
        boolean bl;
        boolean bl2 = bl = this == RAW || this == TEXT;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextFormat$fromHtml$22 = false;
            TextFormat $i$a$-assert-TextFormat$fromHtml$22 = this;
            throw new AssertionError((Object)$i$a$-assert-TextFormat$fromHtml$22);
        }
        StringBuilder sb = new StringBuilder(html.length());
        boolean inPre = false;
        int i = 0;
        int n = html.length();
        while (i < n) {
            String tag;
            int end;
            char c = html.charAt(i);
            if (c == '<') {
                if (StringsKt.startsWith$default((String)html, (String)"<!--", (int)i, (boolean)false, (int)4, null)) {
                    end = StringsKt.indexOf$default((CharSequence)html, (String)"-->", (int)i, (boolean)false, (int)4, null);
                    if (end == -1) break;
                    i = end + 2;
                    ++i;
                    continue;
                }
                int begin = 0;
                boolean isEndTag = false;
                if (StringsKt.startsWith$default((String)html, (String)"</", (int)i, (boolean)false, (int)4, null)) {
                    begin = i + 2;
                    isEndTag = true;
                } else {
                    begin = i + 1;
                }
                i = StringsKt.indexOf$default((CharSequence)html, (char)'>', (int)i, (boolean)false, (int)4, null);
                if (i == -1) break;
                int end2 = i;
                if (html.charAt(i - 1) == '/') {
                    --end2;
                    isEndTag = true;
                }
                String string = html.substring(begin, end2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                tag = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (char)' ', null, (int)2, null);
                if (StringsKt.equals((String)tag, (String)"br", (boolean)true)) {
                    sb.append('\n');
                } else if (StringsKt.equals((String)tag, (String)"p", (boolean)true) || StringsKt.equals((String)tag, (String)"div", (boolean)true) || StringsKt.equals((String)tag, (String)"pre", (boolean)true) || StringsKt.equals((String)tag, (String)"blockquote", (boolean)true) || StringsKt.equals((String)tag, (String)"dl", (boolean)true) || StringsKt.equals((String)tag, (String)"dd", (boolean)true) || StringsKt.equals((String)tag, (String)"dt", (boolean)true) || StringsKt.equals((String)tag, (String)"ol", (boolean)true) || StringsKt.equals((String)tag, (String)"ul", (boolean)true) || StringsKt.equals((String)tag, (String)"li", (boolean)true) || tag.length() == 2 && StringsKt.startsWith$default((String)tag, (String)"h", (boolean)false, (int)2, null) && Character.isDigit(tag.charAt(1))) {
                    if (((CharSequence)sb).length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                        sb.append('\n');
                    }
                    if (Intrinsics.areEqual((Object)tag, (Object)"li") && !isEndTag) {
                        sb.append("* ");
                    }
                    if (StringsKt.equals((String)tag, (String)"pre", (boolean)true)) {
                        if (this == RAW) {
                            sb.append("```");
                            if (end2 < html.length() - 2 && !CharsKt.isWhitespace((char)html.charAt(end2 + 1))) {
                                sb.append("\n");
                            }
                            if (inPre) {
                                sb.append("\n");
                            }
                        }
                        inPre = !isEndTag;
                    }
                } else if (this == RAW) {
                    if (StringsKt.equals((String)tag, (String)"code", (boolean)true)) {
                        sb.append("`");
                    } else if (StringsKt.equals((String)tag, (String)"strong", (boolean)true) || StringsKt.equals((String)tag, (String)"b", (boolean)true)) {
                        sb.append("**");
                    } else if (StringsKt.equals((String)tag, (String)"i", (boolean)true)) {
                        sb.append("*");
                    } else if (StringsKt.equals((String)tag, (String)"s", (boolean)true)) {
                        sb.append("~~");
                    }
                }
            } else if (c == '&') {
                end = StringsKt.indexOf$default((CharSequence)html, (char)';', (int)i, (boolean)false, (int)4, null);
                if (end > i) {
                    String entity;
                    String s;
                    Intrinsics.checkNotNullExpressionValue((Object)html.substring(i, end + 1), (String)"substring(...)");
                    tag = s = XmlUtils.fromXmlAttributeValue((String)entity);
                    Intrinsics.checkNotNull((Object)tag);
                    if (StringsKt.startsWith$default((String)tag, (String)"&", (boolean)false, (int)2, null)) {
                        if (StringsKt.equals((String)entity, (String)"&nbsp;", (boolean)true)) {
                            s = " ";
                        } else if (StringsKt.startsWith$default((String)entity, (String)"&#", (boolean)false, (int)2, null)) {
                            try {
                                String string = entity.substring(2);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                int value = Integer.parseInt(string);
                                s = Character.toString((char)value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    sb.append(s);
                    i = end;
                } else {
                    sb.append(c);
                }
            } else if (Character.isWhitespace(c)) {
                if (inPre) {
                    sb.append(c);
                } else if (((CharSequence)sb).length() == 0 || !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                    sb.append(' ');
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String s = string;
        s = SdkUtils.wrap((String)s, (int)60, null);
        return s;
    }

    private final String fromRaw(String text) {
        boolean bl;
        boolean bl2 = bl = this == HTML || this == HTML_WITH_UNICODE || this == TEXT;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextFormat$fromRaw$22 = false;
            TextFormat $i$a$-assert-TextFormat$fromRaw$22 = this;
            throw new AssertionError((Object)$i$a$-assert-TextFormat$fromRaw$22);
        }
        StringBuilder sb = new StringBuilder(3 * text.length() / 2);
        boolean html = this == HTML || this == HTML_WITH_UNICODE;
        boolean escapeUnicode = this == HTML;
        char prev = '\u0000';
        int flushIndex = 0;
        int n = text.length();
        boolean escaped = false;
        int i = 0;
        while (i < n) {
            int end;
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                if (i > flushIndex) {
                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                }
                flushIndex = i + 1;
                ++i;
                continue;
            }
            if (!(escaped || c != '*' && c != '`' || i >= n - 1)) {
                if ((i == 0 || text.charAt(i - 1) == '\n') && StringsKt.regionMatches((String)text, (int)i, (String)"```", (int)0, (int)3, (boolean)false) && (end = StringsKt.indexOf$default((CharSequence)text, (String)"\n```", (int)(i + 3), (boolean)false, (int)4, null)) != -1) {
                    int nextLineStart = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)i, (boolean)false, (int)4, null) + 1;
                    if (i > flushIndex) {
                        com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i - 1, escapeUnicode, false, 64, null);
                    }
                    sb.append("\n");
                    if (html) {
                        sb.append("<pre>\n");
                    }
                    TextFormat.Companion.appendEscapedText(sb, text, html, nextLineStart, end + 1, escapeUnicode, false);
                    if (html) {
                        sb.append("</pre>\n");
                    }
                    flushIndex = i = end + 4 < n && text.charAt(end + 4) == '\n' ? end + 5 : end + 4;
                    continue;
                }
                if (!Character.isLetterOrDigit(prev) && !Character.isWhitespace(text.charAt(i + 1))) {
                    end = StringsKt.indexOf$default((CharSequence)text, (char)c, (int)(i + 1), (boolean)false, (int)4, null);
                    boolean bold = false;
                    if (end == i + 1 && c == '*') {
                        int end2 = StringsKt.indexOf$default((CharSequence)text, (char)'*', (int)(end + 1), (boolean)false, (int)4, null);
                        if (end2 == end + 1) {
                            if ((end2 = StringsKt.indexOf$default((CharSequence)text, (String)"***", (int)(end2 + 1), (boolean)false, (int)4, null)) != -1) {
                                if (i > flushIndex) {
                                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                                }
                                if (html) {
                                    sb.append("<b><i>");
                                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, i + 3, end2, escapeUnicode, false, 64, null);
                                    sb.append("</i></b>");
                                } else {
                                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, false, i + 3, end2, escapeUnicode, false, 64, null);
                                }
                                flushIndex = end2 + 3;
                                i = flushIndex - 1;
                            }
                            ++i;
                            continue;
                        }
                        if (end2 != -1 && end2 > end + 1 && end2 < n - 1 && text.charAt(end2 + 1) == '*') {
                            end = end2;
                            bold = true;
                        }
                    }
                    if (!(end == -1 || end != n - 1 && Character.isLetter(text.charAt(end + 1)))) {
                        if (i > flushIndex) {
                            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                        }
                        if (bold) {
                            ++i;
                        }
                        if (html) {
                            String tag = bold ? "b" : (c == '*' ? "i" : "code");
                            sb.append('<').append(tag).append('>');
                            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, i + 1, end, escapeUnicode, false, 64, null);
                            sb.append('<').append('/').append(tag).append('>');
                        } else {
                            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, false, i + 1, end, escapeUnicode, false, 64, null);
                        }
                        flushIndex = end + 1;
                        if (bold) {
                            ++flushIndex;
                        }
                        i = flushIndex - 1;
                    }
                }
            } else if (html && c == 'h' && i < n - 1 && text.charAt(i + 1) == 't' && (StringsKt.startsWith$default((String)text, (String)HTTP_PREFIX, (int)i, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)text, (String)HTTPS_PREFIX, (int)i, (boolean)false, (int)4, null)) && !Character.isLetterOrDigit(prev)) {
                int length = StringsKt.startsWith$default((String)text, (String)HTTP_PREFIX, (int)i, (boolean)false, (int)4, null) ? 7 : 8;
                int end2 = Companion.findUrlEnd(text, i);
                if (end2 > i + length) {
                    String url;
                    if (i > flushIndex) {
                        com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, flushIndex, i, escapeUnicode, false, 64, null);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)text.substring(i, end2), (String)"substring(...)");
                    sb.append(A_HREF_PREFIX);
                    sb.append(url);
                    sb.append('\"').append('>');
                    sb.append(url);
                    sb.append("</a>");
                    flushIndex = end2;
                    i = flushIndex - 1;
                }
            } else if (c == '\n' && escaped) {
                ++flushIndex;
            } else if (!(c != '~' || escaped || i >= n - 4 || text.charAt(i + 1) != '~' || text.charAt(i + 2) == '~' || Character.isWhitespace(text.charAt(i + 2)) || Character.isLetterOrDigit(prev) || (end = StringsKt.indexOf$default((CharSequence)text, (String)"~~", (int)(i + 2), (boolean)false, (int)4, null)) == -1 || end != n - 2 && Character.isLetter(text.charAt(end + 2)))) {
                if (i > flushIndex) {
                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                }
                if (html) {
                    sb.append("<s>");
                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, i + 2, end, escapeUnicode, false, 64, null);
                    sb.append("</s>");
                } else {
                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, false, i + 2, end, escapeUnicode, false, 64, null);
                }
                flushIndex = end + 2;
                i = flushIndex - 1;
            }
            prev = c;
            escaped = false;
            ++i;
        }
        if (flushIndex < n) {
            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, n, escapeUnicode, false, 64, null);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static TextFormat[] values() {
        return (TextFormat[])$VALUES.clone();
    }

    public static TextFormat valueOf(String value) {
        return Enum.valueOf(TextFormat.class, value);
    }

    @NotNull
    public static EnumEntries<TextFormat> getEntries() {
        return $ENTRIES;
    }

    static {
        RAW = new TextFormat();
        TEXT = new TextFormat();
        HTML = new TextFormat();
        HTML_WITH_UNICODE = new TextFormat();
        $VALUES = textFormatArray = new TextFormat[]{TextFormat.RAW, TextFormat.TEXT, TextFormat.HTML, TextFormat.HTML_WITH_UNICODE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002JF\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/TextFormat$Companion;", "", "<init>", "()V", "HTTP_PREFIX", "", "HTTPS_PREFIX", "A_HREF_PREFIX", "findUrlEnd", "", "text", "start", "terminatesUrl", "", "c", "", "textToRaw", "message", "removeNumericEntities", "html", "appendEscapedText", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "end", "escapeUnicode", "newlinesAsBr", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final int findUrlEnd(@NotNull String text, int start) {
            char d;
            int end;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int length = StringsKt.startsWith$default((String)text, (String)TextFormat.HTTP_PREFIX, (int)start, (boolean)false, (int)4, null) ? 7 : 8;
            int n = text.length();
            for (end = start + length; !(end >= n || this.terminatesUrl(d = text.charAt(end)) || d == ')' && start > 0 && text.charAt(start - 1) == '('); ++end) {
            }
            char last = text.charAt(end - 1);
            switch (last) {
                case '!': 
                case ')': 
                case ',': 
                case '.': {
                    --end;
                }
            }
            return end;
        }

        private final boolean terminatesUrl(char c) {
            boolean bl;
            block1: {
                char c2;
                block0: {
                    c2 = c;
                    boolean bl2 = 'a' <= c2 ? c2 < '{' : false;
                    if (!bl2) break block0;
                    bl = false;
                    break block1;
                }
                bl = ('A' <= c2 ? c2 < '[' : false) ? false : (('0' <= c2 ? c2 < ':' : false) ? false : c2 != '-' && c2 != '_' && c2 != '.' && c2 != '*' && c2 != '+' && c2 != '%' && c2 != '/' && c2 != '#' && c2 != ':' && c2 != '@' && c2 != '!' && c2 != '$' && c2 != '&' && c2 != '\'' && c2 != '~' && c2 != '[' && c2 != ']' && c2 != '(' && c2 != ')' && c2 != ';' && c2 != '?' && c2 != '=' && c2 != ',');
            }
            return bl;
        }

        private final String textToRaw(String message2) {
            boolean mustEscape = false;
            int n = message2.length();
            block6: for (int i = 0; i < n; ++i) {
                char c = message2.charAt(i);
                switch (c) {
                    case '*': 
                    case '\\': 
                    case '`': {
                        mustEscape = true;
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if (!mustEscape) {
                return message2;
            }
            StringBuilder sb = new StringBuilder(message2.length() * 2);
            for (int i = 0; i < n; ++i) {
                char c = message2.charAt(i);
                switch (c) {
                    case '*': 
                    case '\\': 
                    case '`': {
                        sb.append('\\');
                    }
                }
                sb.append(c);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String removeNumericEntities(String html) {
            if (!StringsKt.contains$default((CharSequence)html, (CharSequence)"&#", (boolean)false, (int)2, null)) {
                return html;
            }
            StringBuilder sb = new StringBuilder(html.length());
            int i = 0;
            int n = html.length();
            while (i < n) {
                int end;
                char c = html.charAt(i);
                if (c == '&' && i < n - 1 && html.charAt(i + 1) == '#' && (end = StringsKt.indexOf$default((CharSequence)html, (char)';', (int)(i + 2), (boolean)false, (int)4, null)) != -1) {
                    Intrinsics.checkNotNullExpressionValue((Object)html.substring(i + 2, end), (String)"substring(...)");
                    try {
                        String decimal;
                        c = (char)Integer.parseInt(decimal);
                        sb.append(c);
                        i = end;
                        ++i;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sb.append(c);
                ++i;
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void appendEscapedText(StringBuilder sb, String text, boolean html, int start, int end, boolean escapeUnicode, boolean newlinesAsBr) {
            if (html) {
                block5: for (int i = start; i < end; ++i) {
                    char c = text.charAt(i);
                    switch (c) {
                        case '<': {
                            StringBuilder stringBuilder = sb.append("&lt;");
                            continue block5;
                        }
                        case '&': {
                            StringBuilder stringBuilder = sb.append("&amp;");
                            continue block5;
                        }
                        case '\n': {
                            StringBuilder stringBuilder;
                            if (newlinesAsBr) {
                                stringBuilder = sb.append("<br/>\n");
                                continue block5;
                            }
                            stringBuilder = sb.append("\n");
                            continue block5;
                        }
                        default: {
                            StringBuilder stringBuilder;
                            if (c > '\u00ff' && escapeUnicode) {
                                if (c == '\u200b') continue block5;
                                sb.append("&#");
                                sb.append(Integer.toString(c));
                                stringBuilder = sb.append(';');
                                continue block5;
                            }
                            stringBuilder = c == '\u00a0' ? sb.append("&nbsp;") : sb.append(c);
                        }
                    }
                }
            } else {
                for (int i = start; i < end; ++i) {
                    char c = text.charAt(i);
                    if (c == '\u200b') continue;
                    sb.append(c);
                }
            }
        }

        static /* synthetic */ void appendEscapedText$default(Companion companion, StringBuilder stringBuilder, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3, int n3, Object object) {
            if ((n3 & 0x40) != 0) {
                bl3 = true;
            }
            companion.appendEscapedText(stringBuilder, string, bl, n, n2, bl2, bl3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextFormat.values().length];
            try {
                nArray[TextFormat.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextFormat.TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextFormat.HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextFormat.HTML_WITH_UNICODE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

