/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AppIndexingApiDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaPsiScanner {
    private static final Implementation URL_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, Scope.MANIFEST_SCOPE);
    private static final Implementation APP_INDEXING_API_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.MANIFEST), new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE});
    public static final Issue ISSUE_URL_ERROR = Issue.create((String)"GoogleAppIndexingUrlError", (String)"URL not supported by app for Firebase App Indexing", (String)"Ensure the URL is supported by your app, to get installs and traffic to your app from Google Search.", (Category)Category.USABILITY, (int)5, (Severity)Severity.ERROR, (Implementation)URL_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING = Issue.create((String)"GoogleAppIndexingWarning", (String)"Missing support for Firebase App Indexing", (String)"Adds URLs to get your app into the Google index, to get installs and traffic to your app from Google Search.", (Category)Category.USABILITY, (int)5, (Severity)Severity.WARNING, (Implementation)URL_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING_API = Issue.create((String)"GoogleAppIndexingApiWarning", (String)"Missing support for Firebase App Indexing Api", (String)"Adds URLs to get your app into the Google index, to get installs and traffic to your app from Google Search.", (Category)Category.USABILITY, (int)5, (Severity)Severity.WARNING, (Implementation)APP_INDEXING_API_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio").setEnabledByDefault(false);
    private static final String[] PATH_ATTR_LIST = new String[]{"pathPrefix", "path"};
    private static final String SCHEME_MISSING = "android:scheme is missing";
    private static final String HOST_MISSING = "android:host is missing";
    private static final String DATA_MISSING = "Missing data element";
    private static final String URL_MISSING = "Missing URL for the intent filter";
    private static final String NOT_BROWSABLE = "Activity supporting ACTION_VIEW is not set as BROWSABLE";
    private static final String ILLEGAL_NUMBER = "android:port is not a legal number";
    private static final String APP_INDEX_START = "start";
    private static final String APP_INDEX_END = "end";
    private static final String APP_INDEX_VIEW = "view";
    private static final String APP_INDEX_VIEW_END = "viewEnd";
    private static final String CLIENT_CONNECT = "connect";
    private static final String CLIENT_DISCONNECT = "disconnect";
    private static final String ADD_API = "addApi";
    private static final String APP_INDEXING_API_CLASS = "com.google.android.gms.appindexing.AppIndexApi";
    private static final String GOOGLE_API_CLIENT_CLASS = "com.google.android.gms.common.api.GoogleApiClient";
    private static final String GOOGLE_API_CLIENT_BUILDER_CLASS = "com.google.android.gms.common.api.GoogleApiClient.Builder";
    private static final String API_CLASS = "com.google.android.gms.appindexing.AppIndex";

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("application");
    }

    public void visitElement(XmlContext context, Element application) {
        List<Element> activities = AppIndexingApiDetector.extractChildrenByName(application, "activity");
        boolean applicationHasActionView = false;
        for (Element activity : activities) {
            Attr exported;
            List<Element> intents = AppIndexingApiDetector.extractChildrenByName(activity, "intent-filter");
            boolean activityHasActionView = false;
            for (Element intent : intents) {
                boolean actionView = AppIndexingApiDetector.hasActionView(intent);
                if (actionView) {
                    activityHasActionView = true;
                }
                AppIndexingApiDetector.visitIntent(context, intent);
            }
            if (!activityHasActionView) continue;
            applicationHasActionView = true;
            if (!activity.hasAttributeNS("http://schemas.android.com/apk/res/android", "exported") || (exported = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported")).getValue().equals("true")) continue;
            context.report(ISSUE_URL_ERROR, (Node)activity, context.getLocation((Node)activity), "Activity supporting ACTION_VIEW is not exported");
        }
        if (!applicationHasActionView && !context.getProject().isLibrary()) {
            context.report(ISSUE_APP_INDEXING, (Node)application, context.getLocation((Node)application), "App is not indexable by Google Search; consider adding at least one Activity with an ACTION-VIEW intent filter. See issue explanation for more details.");
        }
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.app.Activity");
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        if (declaration.getName() == null) {
            return;
        }
        if (!context.getEvaluator().extendsClass(declaration, "android.app.Activity", true)) {
            return;
        }
        declaration.accept((PsiElementVisitor)new MethodVisitor(context, declaration));
    }

    private static Set<String> getActivitiesToCheck(Context context) {
        HashSet activitiesToCheck = Sets.newHashSet();
        List manifestFiles = context.getProject().getManifestFiles();
        XmlParser xmlParser = context.getDriver().getClient().getXmlParser();
        if (xmlParser != null) {
            for (File manifest : manifestFiles) {
                XmlContext xmlContext = new XmlContext(context.getDriver(), context.getProject(), null, manifest, null, xmlParser);
                Document doc = xmlParser.parseXml(xmlContext);
                if (doc == null) continue;
                List children = LintUtils.getChildren((Node)doc);
                for (Element child : children) {
                    if (!child.getNodeName().equals("manifest")) continue;
                    List<Element> apps = AppIndexingApiDetector.extractChildrenByName(child, "application");
                    for (Element app : apps) {
                        List<Element> acts = AppIndexingApiDetector.extractChildrenByName(app, "activity");
                        for (Element act : acts) {
                            List<Element> intents = AppIndexingApiDetector.extractChildrenByName(act, "intent-filter");
                            for (Element intent : intents) {
                                String pkg;
                                List<Element> data = AppIndexingApiDetector.extractChildrenByName(intent, "data");
                                if (data.isEmpty() || !act.hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) continue;
                                Attr attr = act.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                                String activityName = attr.getValue();
                                int dotIndex = activityName.indexOf(46);
                                if (dotIndex <= 0 && (pkg = context.getMainProject().getPackage()) != null) {
                                    activityName = dotIndex == 0 ? pkg + activityName : pkg + '.' + activityName;
                                }
                                activitiesToCheck.add(activityName);
                            }
                        }
                    }
                }
            }
        }
        return activitiesToCheck;
    }

    private static void visitIntent(XmlContext context, Element intent) {
        boolean actionView = AppIndexingApiDetector.hasActionView(intent);
        boolean browsable = AppIndexingApiDetector.isBrowsable(intent);
        boolean isHttp = false;
        boolean hasScheme = false;
        boolean hasHost = false;
        boolean hasPort = false;
        boolean hasPath = false;
        boolean hasMimeType = false;
        Element firstData = null;
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "data");
        for (Element data : children) {
            if (firstData == null) {
                firstData = data;
            }
            if (AppIndexingApiDetector.isHttpSchema(data)) {
                isHttp = true;
            }
            AppIndexingApiDetector.checkSingleData(context, data);
            for (String name : PATH_ATTR_LIST) {
                if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name)) continue;
                hasPath = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme")) {
                hasScheme = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) {
                hasHost = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
                hasPort = true;
            }
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", "mimeType")) continue;
            hasMimeType = true;
        }
        if ((hasPath || hasHost || hasPort) && !hasScheme) {
            context.report(ISSUE_URL_ERROR, (Node)firstData, context.getLocation((Node)firstData), SCHEME_MISSING);
        }
        if ((hasPath || hasPort) && !hasHost) {
            context.report(ISSUE_URL_ERROR, (Node)firstData, context.getLocation((Node)firstData), HOST_MISSING);
        }
        if (actionView && browsable) {
            if (firstData == null) {
                context.report(ISSUE_URL_ERROR, (Node)intent, context.getLocation((Node)intent), DATA_MISSING);
            } else if (!hasScheme && !hasMimeType) {
                context.report(ISSUE_URL_ERROR, (Node)firstData, context.getLocation((Node)firstData), URL_MISSING);
            }
        }
        if (actionView && isHttp && !browsable) {
            context.report(ISSUE_APP_INDEXING, (Node)intent, context.getLocation((Node)intent), NOT_BROWSABLE);
        }
        if (actionView && !hasScheme) {
            context.report(ISSUE_APP_INDEXING, (Node)intent, context.getLocation((Node)intent), "Missing URL");
        }
    }

    private static boolean hasActionView(Element intent) {
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "action");
        for (Element action : children) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue().equals("android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBrowsable(Element intent) {
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "category");
        for (Element e : children) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue().equals("android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private static boolean isHttpSchema(Element data) {
        String value;
        return data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme") && ((value = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "scheme").getValue()).equalsIgnoreCase("http") || value.equalsIgnoreCase("https"));
    }

    private static void checkSingleData(XmlContext context, Element data) {
        for (String name : PATH_ATTR_LIST) {
            Attr attr;
            String path;
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name) || (path = AppIndexingApiDetector.replaceUrlWithValue(context, (attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", name)).getValue())).startsWith("/") || path.startsWith("@")) continue;
            context.report(ISSUE_URL_ERROR, (Node)attr, context.getLocation((Node)attr), "android:" + name + " attribute should start with '/', but it is : " + path);
        }
        if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
            Attr attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "port");
            try {
                String port = AppIndexingApiDetector.replaceUrlWithValue(context, attr.getValue());
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                context.report(ISSUE_URL_ERROR, (Node)attr, context.getLocation((Node)attr), ILLEGAL_NUMBER);
            }
        }
        NamedNodeMap attrs = data.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            Node item = attrs.item(i);
            if (item.getNodeType() != 2 || !(attr = (Attr)attrs.item(i)).getValue().isEmpty()) continue;
            context.report(ISSUE_URL_ERROR, (Node)attr, context.getLocation((Node)attr), attr.getName() + " cannot be empty");
        }
    }

    private static String replaceUrlWithValue(XmlContext context, String str) {
        Project project = context.getProject();
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return str;
        }
        ResourceUrl style = ResourceUrl.parse((String)str);
        if (style == null || style.type != ResourceType.STRING || style.framework) {
            return str;
        }
        AbstractResourceRepository resources = client.getResourceRepository(project, true, true);
        if (resources == null) {
            return str;
        }
        List items = resources.getResourceItem(ResourceType.STRING, style.name);
        if (items == null || items.isEmpty()) {
            return str;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
        if (resourceValue == null) {
            return str;
        }
        return resourceValue.getValue() == null ? str : resourceValue.getValue();
    }

    private static boolean hasFirstArgument(PsiExpression argument, List<PsiMethodCallExpression> list) {
        for (PsiMethodCallExpression call : list) {
            PsiExpression argument2;
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            if (expressions.length <= 0 || !argument.textMatches((PsiElement)(argument2 = expressions[0]))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOperand(PsiExpression operand, List<PsiMethodCallExpression> list) {
        for (PsiMethodCallExpression method : list) {
            PsiElement operand2 = method.getMethodExpression().getQualifier();
            if (operand2 == null || !operand.textMatches(operand2)) continue;
            return true;
        }
        return false;
    }

    private static List<Element> extractChildrenByName(Element node, String name) {
        ArrayList result = Lists.newArrayList();
        List children = LintUtils.getChildren((Node)node);
        for (Element child : children) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result;
    }

    static class MethodVisitor
    extends JavaRecursiveElementVisitor {
        private final JavaContext mContext;
        private final PsiClass mCls;
        private final List<PsiMethodCallExpression> mStartMethods;
        private final List<PsiMethodCallExpression> mEndMethods;
        private final List<PsiMethodCallExpression> mConnectMethods;
        private final List<PsiMethodCallExpression> mDisconnectMethods;
        private boolean mHasAddAppIndexApi;

        MethodVisitor(JavaContext context, PsiClass cls) {
            this.mCls = cls;
            this.mContext = context;
            this.mStartMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mEndMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mConnectMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mDisconnectMethods = Lists.newArrayListWithExpectedSize((int)2);
        }

        public void visitClass(PsiClass aClass) {
            if (aClass == this.mCls) {
                super.visitClass(aClass);
                this.report();
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            PsiElement resolved;
            PsiExpression[] args;
            super.visitMethodCallExpression(node);
            String methodName = node.getMethodExpression().getReferenceName();
            if (methodName == null) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            if (methodName.equals(AppIndexingApiDetector.APP_INDEX_START)) {
                if (evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mStartMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.APP_INDEX_END)) {
                if (evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mEndMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.APP_INDEX_VIEW)) {
                if (evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mStartMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.APP_INDEX_VIEW_END)) {
                if (evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mEndMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.CLIENT_CONNECT)) {
                if (evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) {
                    this.mConnectMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.CLIENT_DISCONNECT)) {
                if (evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) {
                    this.mDisconnectMethods.add(node);
                }
            } else if (methodName.equals(AppIndexingApiDetector.ADD_API) && evaluator.isMemberInClass((PsiMember)node.resolveMethod(), AppIndexingApiDetector.GOOGLE_API_CLIENT_BUILDER_CLASS) && (args = node.getArgumentList().getExpressions()).length > 0 && (resolved = evaluator.resolve((PsiElement)args[0])) instanceof PsiField && evaluator.isMemberInClass((PsiMember)((PsiField)resolved), AppIndexingApiDetector.API_CLASS)) {
                this.mHasAddAppIndexApi = true;
            }
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
        }

        private void report() {
            String message;
            PsiExpression[] expressions;
            Set activitiesToCheck = AppIndexingApiDetector.getActivitiesToCheck((Context)this.mContext);
            boolean hasIntent = activitiesToCheck.contains(this.mCls.getQualifiedName());
            if (!hasIntent) {
                for (PsiMethodCallExpression call : this.mStartMethods) {
                    this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)call, this.mContext.getNameLocation((PsiElement)call), "Missing support for Firebase App Indexing in the manifest");
                }
                for (PsiMethodCallExpression call : this.mEndMethods) {
                    this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)call, this.mContext.getNameLocation((PsiElement)call), "Missing support for Firebase App Indexing in the manifest");
                }
                return;
            }
            if (this.mStartMethods.isEmpty() && this.mEndMethods.isEmpty()) {
                this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)this.mCls, this.mContext.getNameLocation((PsiElement)this.mCls), "Missing support for Firebase App Indexing API");
                return;
            }
            for (PsiMethodCallExpression startNode : this.mStartMethods) {
                expressions = startNode.getArgumentList().getExpressions();
                if (expressions.length == 0) continue;
                PsiExpression startClient = expressions[0];
                if (!this.mHasAddAppIndexApi) {
                    message = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", startClient.getText());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)startClient, this.mContext.getLocation((PsiElement)startClient), message);
                }
                if (!AppIndexingApiDetector.hasOperand(startClient, this.mConnectMethods)) {
                    message = String.format("GoogleApiClient `%1$s` is not connected", startClient.getText());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)startClient, this.mContext.getLocation((PsiElement)startClient), message);
                }
                if (AppIndexingApiDetector.hasFirstArgument(startClient, this.mEndMethods)) continue;
                this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)startNode, this.mContext.getNameLocation((PsiElement)startNode), "Missing corresponding `AppIndex.AppIndexApi.end` method");
            }
            for (PsiMethodCallExpression endNode : this.mEndMethods) {
                expressions = endNode.getArgumentList().getExpressions();
                if (expressions.length == 0) continue;
                PsiExpression endClient = expressions[0];
                if (!this.mHasAddAppIndexApi) {
                    message = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", endClient.getText());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)endClient, this.mContext.getLocation((PsiElement)endClient), message);
                }
                if (!AppIndexingApiDetector.hasOperand(endClient, this.mDisconnectMethods)) {
                    message = String.format("GoogleApiClient `%1$s` is not disconnected", endClient.getText());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)endClient, this.mContext.getLocation((PsiElement)endClient), message);
                }
                if (AppIndexingApiDetector.hasFirstArgument(endClient, this.mStartMethods)) continue;
                this.mContext.report(ISSUE_APP_INDEXING_API, (PsiElement)endNode, this.mContext.getNameLocation((PsiElement)endNode), "Missing corresponding `AppIndex.AppIndexApi.start` method");
            }
        }
    }

    public static enum IssueType {
        SCHEME_MISSING("android:scheme is missing"),
        HOST_MISSING("android:host is missing"),
        DATA_MISSING("Missing data element"),
        URL_MISSING("Missing URL for the intent filter"),
        NOT_BROWSABLE("Activity supporting ACTION_VIEW is not set as BROWSABLE"),
        ILLEGAL_NUMBER("android:port is not a legal number"),
        EMPTY_FIELD("cannot be empty"),
        MISSING_SLASH("attribute should start with '/'"),
        UNKNOWN("unknown error type");

        private final String message;

        private IssueType(String str) {
            this.message = str;
        }

        public static IssueType parse(String str) {
            for (IssueType type : IssueType.values()) {
                if (!str.contains(type.message)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

