/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public abstract class LintInspectionBridge {
    private Map<String, MavenCoordinates> jarToGroup;

    public abstract void report(Issue var1, PsiElement var2, PsiElement var3, String var4);

    public abstract boolean isTestSource();

    public abstract Dependencies getDependencies();

    public MavenCoordinates getLibrary(PsiElement element) {
        String jarFile = this.getEvaluator().findJarPath(element);
        if (jarFile != null) {
            MavenCoordinates coordinates;
            if (this.jarToGroup == null) {
                this.jarToGroup = Maps.newHashMap();
            }
            if ((coordinates = this.jarToGroup.get(jarFile)) == null) {
                int index;
                Library library = this.findOwnerLibrary(jarFile);
                if (library != null) {
                    coordinates = library.getResolvedCoordinates();
                }
                if (coordinates == null && (index = jarFile.indexOf("exploded-aar")) != -1) {
                    block0: for (int i = index += 13; i < jarFile.length(); ++i) {
                        char c = jarFile.charAt(i);
                        if (c != '/' && c != File.separatorChar) continue;
                        String groupId = jarFile.substring(index, i);
                        for (int j = ++i; j < jarFile.length(); ++j) {
                            c = jarFile.charAt(j);
                            if (c != '/' && c != File.separatorChar) continue;
                            String artifactId = jarFile.substring(i, j);
                            coordinates = new MyMavenCoordinates(groupId, artifactId);
                            break block0;
                        }
                        break;
                    }
                }
                if (coordinates == null) {
                    coordinates = MyMavenCoordinates.NONE;
                }
                this.jarToGroup.put(jarFile, coordinates);
            }
            return coordinates == MyMavenCoordinates.NONE ? null : coordinates;
        }
        return null;
    }

    public Library findOwnerLibrary(String jarFile) {
        Dependencies dependencies = this.getDependencies();
        if (dependencies != null) {
            Library match = LintInspectionBridge.findOwnerLibrary(dependencies.getLibraries(), jarFile);
            if (match != null) {
                return match;
            }
            match = LintInspectionBridge.findOwnerJavaLibrary(dependencies.getJavaLibraries(), jarFile);
            if (match != null) {
                return match;
            }
        }
        return null;
    }

    private static Library findOwnerJavaLibrary(Collection<? extends JavaLibrary> dependencies, String jarFile) {
        for (JavaLibrary javaLibrary : dependencies) {
            if (jarFile.equals(javaLibrary.getJarFile().getPath())) {
                return javaLibrary;
            }
            Library match = LintInspectionBridge.findOwnerJavaLibrary(javaLibrary.getDependencies(), jarFile);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static Library findOwnerLibrary(Collection<? extends AndroidLibrary> dependencies, String jarFile) {
        for (AndroidLibrary androidLibrary : dependencies) {
            if (jarFile.equals(androidLibrary.getJarFile().getPath())) {
                return androidLibrary;
            }
            for (File jar : androidLibrary.getLocalJars()) {
                if (!jarFile.equals(jar.getPath())) continue;
                return androidLibrary;
            }
            Library match = LintInspectionBridge.findOwnerLibrary(androidLibrary.getLibraryDependencies(), jarFile);
            if (match != null) {
                return match;
            }
            match = LintInspectionBridge.findOwnerJavaLibrary(androidLibrary.getJavaDependencies(), jarFile);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public abstract JavaEvaluator getEvaluator();

    private static class MyMavenCoordinates
    implements MavenCoordinates {
        private static final MyMavenCoordinates NONE = new MyMavenCoordinates("", "");
        private final String groupId;
        private final String artifactId;

        public MyMavenCoordinates(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return "";
        }

        public String getPackaging() {
            return "";
        }

        public String getClassifier() {
            return "";
        }

        public String getVersionlessId() {
            return this.groupId + ':' + this.artifactId;
        }
    }
}

