/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.ArrayList;
import java.util.List;

public class NonInternationalizedSmsDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"UnlocalizedSms", (String)"SMS phone number missing country code", (String)"SMS destination numbers must start with a country code or the application code must ensure that the SMS is only sent when the user is in the same country as the receiver.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(NonInternationalizedSmsDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> getApplicableMethodNames() {
        ArrayList<String> methodNames = new ArrayList<String>(2);
        methodNames.add("sendTextMessage");
        methodNames.add("sendMultipartTextMessage");
        return methodNames;
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        if (call.getMethodExpression().getQualifier() == null) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 5) {
            return;
        }
        PsiExpression destinationAddress = args[0];
        if (!(destinationAddress instanceof PsiLiteral)) {
            return;
        }
        Object literal = ((PsiLiteral)destinationAddress).getValue();
        if (!(literal instanceof String)) {
            return;
        }
        String number = (String)literal;
        if (number.startsWith("+")) {
            return;
        }
        context.report(ISSUE, (PsiElement)call, context.getLocation((PsiElement)destinationAddress), "To make sure the SMS can be sent by all users, please start the SMS number with a + and a country code or restrict the code invocation to people in the country you are targeting.");
    }
}

