/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

public class AddJavascriptInterfaceDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"AddJavascriptInterface", (String)"addJavascriptInterface Called", (String)"For applications built for API levels below 17, `WebView#addJavascriptInterface` presents a security hazard as JavaScript on the target web page has the ability to use reflection to access the injected object's public fields and thus manipulate the host application in unintended ways.", (Category)Category.SECURITY, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(AddJavascriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://labs.mwrinfosecurity.com/blog/2013/09/24/webview-addjavascriptinterface-remote-code-execution/");
    private static final String WEB_VIEW = "android.webkit.WebView";
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        if (context.getMainProject().getMinSdk() >= 17) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.methodMatches(method, WEB_VIEW, true, new String[]{"java.lang.Object", "java.lang.String"})) {
            return;
        }
        String message = "`WebView.addJavascriptInterface` should not be called with minSdkVersion < 17 for security reasons: JavaScript can use reflection to manipulate application";
        context.report(ISSUE, (UElement)node, context.getNameLocation((UElement)node), message);
    }
}

