/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.java.JavaUAssertExpression;

public class AssertDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"Assert", (String)"Assertions", (String)"Assertions are not checked at runtime. There are ways to request that they be used by Dalvik (`adb shell setprop debug.assert 1`), but note that this is not implemented in ART (the newer runtime), and even in Dalvik the property is ignored in many places and can not be relied upon. Instead, perform conditional checking inside `if (BuildConfig.DEBUG) { }` blocks. That constant is a static final boolean which is true in debug builds and false in release builds, and the Java compiler completely removes all code inside the if-body from the app.\n\nFor example, you can replace `assert speed > 0` with `if (BuildConfig.DEBUG && !(speed > 0)) { throw new AssertionError() }`.\n\n(Note: This lint check does not flag assertions purely asserting nullness or non-nullness; these are typically more intended for tools usage than runtime checks.)", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://code.google.com/p/android/issues/detail?id=65183");

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UCallExpression.class);
    }

    public UElementHandler createUastHandler(final JavaContext context) {
        if (!context.getMainProject().isAndroidProject()) {
            return null;
        }
        return new UElementHandler(){

            public void visitCallExpression(UCallExpression node) {
                if (node instanceof JavaUAssertExpression) {
                    JavaUAssertExpression assertion = (JavaUAssertExpression)node;
                    AssertDetector.checkAssertion(assertion, context);
                }
            }
        };
    }

    private static void checkAssertion(JavaUAssertExpression node, JavaContext context) {
        Object value;
        UExpression condition = node.getCondition();
        if (condition instanceof ULiteralExpression ? Boolean.TRUE.equals(value = ((ULiteralExpression)condition).getValue()) : AssertDetector.isNullCheck(condition)) {
            return;
        }
        String message = "Assertions are unreliable in Dalvik and unimplemented in ART. Use `BuildConfig.DEBUG` conditional checks instead.";
        PsiElement firstChild = node.getPsi().getFirstChild();
        Location location = firstChild instanceof PsiKeyword && "assert".equals(firstChild.getText()) ? context.getLocation(firstChild) : context.getLocation((UElement)node);
        context.report(ISSUE, (UElement)node, location, message);
    }

    private static boolean isNullCheck(UExpression expression) {
        if (expression instanceof UParenthesizedExpression) {
            expression = ((UParenthesizedExpression)expression).getExpression();
        }
        if (expression instanceof UBinaryExpression) {
            UBinaryExpression binExp = (UBinaryExpression)expression;
            UExpression lOperand = binExp.getLeftOperand();
            UExpression rOperand = binExp.getRightOperand();
            return UastLiteralUtils.isNullLiteral((UElement)lOperand) || UastLiteralUtils.isNullLiteral((UElement)rOperand) || AssertDetector.isNullCheck(lOperand) && AssertDetector.isNullCheck(rOperand);
        }
        if (expression instanceof UPolyadicExpression) {
            UPolyadicExpression polyadicExpression = (UPolyadicExpression)expression;
            for (UExpression operand : polyadicExpression.getOperands()) {
                if (AssertDetector.isNullCheck(operand)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

