/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastLiteralUtils;

public class SdCardDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"SdCardPath", (String)"Hardcoded reference to `/sdcard`", (String)"Your code should not reference the `/sdcard` path directly; instead use `Environment.getExternalStorageDirectory().getPath()`.\n\nSimilarly, do not reference the `/data/data/` path directly; it can vary in multi-user scenarios. Instead, use `Context.getFilesDir().getPath()`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(SdCardDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/topics/data/data-storage.html#filesExternal");

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(ULiteralExpression.class);
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new StringChecker(context);
    }

    private static class StringChecker
    extends UElementHandler {
        private final JavaContext context;

        public StringChecker(JavaContext context) {
            this.context = context;
        }

        public void visitLiteralExpression(ULiteralExpression node) {
            String s = UastLiteralUtils.getValueIfStringLiteral((UElement)node);
            if (s != null && !s.isEmpty()) {
                char c = s.charAt(0);
                if (c != '/' && c != 'f') {
                    return;
                }
                if (s.startsWith("/sdcard") || s.startsWith("/mnt/sdcard/") || s.startsWith("/system/media/sdcard") || s.startsWith("file://sdcard/") || s.startsWith("file:///sdcard/")) {
                    String message = "Do not hardcode \"/sdcard/\"; use `Environment.getExternalStorageDirectory().getPath()` instead";
                    Location location = this.context.getLocation((UElement)node);
                    this.context.report(ISSUE, (UElement)node, location, message);
                } else if (s.startsWith("/data/data/") || s.startsWith("/data/user/")) {
                    String message = "Do not hardcode \"`/data/`\"; use `Context.getFilesDir().getPath()` instead";
                    Location location = this.context.getLocation((UElement)node);
                    this.context.report(ISSUE, (UElement)node, location, message);
                }
            }
        }
    }
}

